/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * reference: eiifie paxis2 https://www.shadertoy.com/view/XlSGDc
 * paxis idea from dila originally at https://www.shadertoy.com/view/Xlj3DK

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_octahedron.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 OctahedronIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		REAL4 a;
		REAL colorAdd = 0.0f;
		REAL b = 1.0f;
		REAL d;
		REAL limitA = fractal->transformCommon.offset0;
		REAL limitB = fractal->transformCommon.offsetA0;

		for (int i = 0; i < fractal->transformCommon.int3X; i++)
		{
			REAL sizer1 = fractal->transformCommon.scale1 * b;
			a = fabs(z);
			z.x -= sign(z.x) * max(1.0f * sign(a.x - max(a.y, a.z)), limitA) * sizer1;
			z.y -= sign(z.y) * max(1.0f * sign(a.y - max(a.z, a.x)), limitA) * sizer1;
			z.z -= sign(z.z) * max(1.0f * sign(a.z - max(a.x, a.y)), limitA) * sizer1;
			b *= fractal->transformCommon.scale05;
		}

		d = length(z) - fractal->transformCommon.minR2p25;
		for (int i = 0; i < fractal->transformCommon.int3Y; i++)
		{
			REAL sizer2 = fractal->transformCommon.scaleA1 * b;
			a = fabs(z);
			z.x -= sign(z.x) * max(1.0f * sign(a.x - min(a.y, a.z)), limitB) * sizer2;
			z.y -= sign(z.y) * max(1.0f * sign(a.y - min(a.z, a.x)), limitB) * sizer2;
			z.z -= sign(z.z) * max(1.0f * sign(a.z - min(a.x, a.y)), limitB) * sizer2;
			b *= fractal->transformCommon.minR05;
			colorAdd += dot(z, z);
		}
		z *= fractal->transformCommon.scaleC1;
		aux->DE *= fractal->transformCommon.scaleC1;
		a = fabs(z);

		REAL d2;

		if (!fractal->transformCommon.functionEnabledFalse)
			d2 = max(a.x, max(a.y, a.z)) - b * fractal->transformCommon.scaleD1;
		else
			d2 = length(a) - b * fractal->transformCommon.scaleD1;

		d2 = max(d2, -d) / fabs(aux->DE);

		if (!fractal->transformCommon.functionEnabledAFalse)
			aux->dist = d2;
		else
			aux->dist = min(aux->dist, d2);

		// aux->color
		if (fractal->foldColor.auxColorEnabledFalse)
		{
			colorAdd = fractal->foldColor.difs0000.x * colorAdd;
			colorAdd += fractal->foldColor.difs0000.y * max(a.x, max(a.y, a.z));
			colorAdd += fractal->foldColor.difs0000.z * length(a);
			colorAdd += fractal->foldColor.difs0000.w * d;
			aux->color += colorAdd * 100.0f;
		}
	}
	return z;
}