/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_he extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "שעון גריניץ׳‏",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "שעון אפיה (חורף)",
               "",
               "שעון אפיה (קיץ)",
               "",
               "שעון אפיה",
               "",
            };
        final String[] Cook = new String[] {
               "שעון איי קוק (חורף)",
               "",
               "שעון איי קוק (מחצית הקיץ)",
               "",
               "שעון איי קוק",
               "",
            };
        final String[] Cuba = new String[] {
               "שעון קובה (חורף)",
               "CST",
               "שעון קובה (קיץ)",
               "CDT",
               "שעון קובה",
               "CT",
            };
        final String[] Fiji = new String[] {
               "שעון פיג׳י (חורף)",
               "",
               "שעון פיג׳י (קיץ)",
               "",
               "שעון פיג׳י",
               "",
            };
        final String[] Gulf = new String[] {
               "שעון מדינות המפרץ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "שעון חובד (חורף)",
               "",
               "שעון חובד (קיץ)",
               "",
               "שעון חובד",
               "",
            };
        final String[] Iran = new String[] {
               "שעון איראן (חורף)",
               "",
               "שעון איראן (קיץ)",
               "",
               "שעון איראן",
               "",
            };
        final String[] Niue = new String[] {
               "שעון ניואה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "שעון אומסק (חורף)",
               "",
               "שעון אומסק (קיץ)",
               "",
               "שעון אומסק",
               "",
            };
        final String[] Peru = new String[] {
               "שעון פרו (חורף)",
               "",
               "שעון פרו (קיץ)",
               "",
               "שעון פרו",
               "",
            };
        final String[] Truk = new String[] {
               "שעון צ׳וק",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "שעון האי וייק",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "שעון צ׳ילה (חורף)",
               "",
               "שעון צ׳ילה (קיץ)",
               "",
               "שעון צ׳ילה",
               "",
            };
        final String[] China = new String[] {
               "שעון סין (חורף)",
               "CST",
               "שעון סין (קיץ)",
               "CDT",
               "שעון סין",
               "CT",
            };
        final String[] Cocos = new String[] {
               "שעון איי קוקוס",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "שעון דיוויס",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "שעון הודו",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "שעון יפן (חורף)",
               "JST",
               "שעון יפן (קיץ)",
               "JDT",
               "שעון יפן",
               "JT",
            };
        final String[] Korea = new String[] {
               "שעון קוריאה (חורף)",
               "KST",
               "שעון קוריאה (קיץ)",
               "KST",
               "שעון קוריאה",
               "KST",
            };
        final String[] Nauru = new String[] {
               "שעון נאורו",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "שעון נפאל",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "שעון פלאו",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "שעון סמואה (חורף)",
               "SST",
               "שעון סמואה (קיץ)",
               "SST",
               "שעון סמואה",
               "SST",
            };
        final String[] Syowa = new String[] {
               "שעון סייווה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "שעון טונגה (חורף)",
               "",
               "שעון טונגה (קיץ)",
               "",
               "שעון טונגה",
               "",
            };
        final String[] Yukon = new String[] {
               "שעון יוקון",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "שעון אלסקה (חורף)",
               "AKST",
               "שעון אלסקה (קיץ)",
               "AKDT",
               "שעון אלסקה",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "שעון אמזונס (חורף)",
               "",
               "שעון אמזונס (קיץ)",
               "",
               "שעון אמזונס",
               "",
            };
        final String[] Azores = new String[] {
               "שעון האיים האזוריים (חורף)",
               "",
               "שעון האיים האזוריים (קיץ)",
               "",
               "שעון האיים האזוריים",
               "",
            };
        final String[] Bhutan = new String[] {
               "שעון בהוטן",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "שעון ברוניי דארוסלאם",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "שעון אי הפסחא (חורף)",
               "",
               "שעון אי הפסחא (קיץ)",
               "",
               "שעון אי הפסחא",
               "",
            };
        final String[] Guyana = new String[] {
               "שעון גיאנה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "שעון האיים האלאוטיים הוואי (חורף)",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "שעון ישראל (חורף)",
               "IST",
               "שעון ישראל (קיץ)",
               "IDT",
               "שעון ישראל",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "שעון קוסראה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "שעון מאוסון",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "שעון מוסקבה (חורף)",
               "MSK",
               "שעון מוסקבה (קיץ)",
               "MSK",
               "שעון מוסקבה",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "שעון פונאפי",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "שעון רגיל סמרה",
               "",
               "שעון קיץ סמרה",
               "",
               "שעון סמרה",
               "",
            };
        final String[] Tahiti = new String[] {
               "שעון טהיטי",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "שעון טאיפיי (חורף)",
               "CST",
               "שעון טאיפיי (קיץ)",
               "CDT",
               "שעון טאיפיי",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "שעון טובאלו",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "שעון ווסטוק",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "שעון וואליס ופוטונה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "שעון חצי האי ערב (חורף)",
               "",
               "שעון חצי האי ערב (קיץ)",
               "",
               "שעון חצי האי ערב",
               "",
            };
        final String[] Armenia = new String[] {
               "שעון ארמניה (חורף)",
               "",
               "שעון ארמניה (קיץ)",
               "",
               "שעון ארמניה",
               "",
            };
        final String[] Bolivia = new String[] {
               "שעון בוליביה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "שעון צ׳טהאם (חורף)",
               "",
               "שעון צ׳טהאם (קיץ)",
               "",
               "שעון צ׳טהאם",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "זמן אוניברסלי מתואם",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "שעון אקוודור",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "שעון איי גמבייה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "שעון גאורגיה (חורף)",
               "",
               "שעון גאורגיה (קיץ)",
               "",
               "שעון גאורגיה",
               "",
            };
        final String[] Irkutsk = new String[] {
               "שעון אירקוטסק (חורף)",
               "",
               "שעון אירקוסטק (קיץ)",
               "",
               "שעון אירקוטסק",
               "",
            };
        final String[] Magadan = new String[] {
               "שעון מגדן (חורף)",
               "",
               "שעון מגדן (קיץ)",
               "",
               "שעון מגדן",
               "",
            };
        final String[] Myanmar = new String[] {
               "שעון מיאנמר",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "שעון האי נורפוק (חורף)",
               "",
               "שעון האי נורפוק (קיץ)",
               "",
               "שעון האי נורפוק",
               "",
            };
        final String[] Noronha = new String[] {
               "שעון פרננדו די נורוניה (חורף)",
               "",
               "שעון פרננדו די נורוניה (קיץ)",
               "",
               "שעון פרננדו די נורוניה",
               "",
            };
        final String[] Reunion = new String[] {
               "שעון ראוניון",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "שעון רות׳רה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "שעון איי שלמה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "שעון טוקלאו",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "שעון אורוגוואי (חורף)",
               "",
               "שעון אורוגוואי (קיץ)",
               "",
               "שעון אורוגוואי",
               "",
            };
        final String[] Vanuatu = new String[] {
               "שעון ונואטו (חורף)",
               "",
               "שעון ונואטו (קיץ)",
               "",
               "שעון ונואטו",
               "",
            };
        final String[] Yakutsk = new String[] {
               "שעון יקוטסק (חורף)",
               "",
               "שעון יקוטסק (קיץ)",
               "",
               "שעון יקוטסק",
               "",
            };
        final String[] Atlantic = new String[] {
               "שעון האוקיינוס האטלנטי (חורף)",
               "AST",
               "שעון האוקיינוס האטלנטי (קיץ)",
               "AST",
               "שעון האוקיינוס האטלנטי",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "שעון ברזיליה (חורף)",
               "",
               "שעון ברזיליה (קיץ)",
               "",
               "שעון ברזיליה",
               "",
            };
        final String[] Chamorro = new String[] {
               "שעון צ׳אמורו",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "שעון קולומביה (חורף)",
               "",
               "שעון קולומביה (קיץ)",
               "",
               "שעון קולומביה",
               "",
            };
        final String[] Falkland = new String[] {
               "שעון איי פוקלנד (חורף)",
               "",
               "שעון איי פוקלנד (קיץ)",
               "",
               "שעון איי פוקלנד",
               "",
            };
        final String[] Malaysia = new String[] {
               "שעון מלזיה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "שעון האיים המלדיביים",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "שעון אולאן באטור (חורף)",
               "",
               "שעון אולאן באטור (קיץ)",
               "",
               "שעון אולאן באטור",
               "",
            };
        final String[] Pakistan = new String[] {
               "שעון פקיסטן (חורף)",
               "PKT",
               "שעון פקיסטן (קיץ)",
               "PKST",
               "שעון פקיסטן",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "שעון פרגוואי (חורף)",
               "",
               "שעון פרגוואי (קיץ)",
               "",
               "שעון פרגוואי",
               "",
            };
        final String[] Pitcairn = new String[] {
               "שעון פיטקרן",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "שעון סורינאם",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "שעון ארגנטינה (חורף)",
               "",
               "שעון ארגנטינה (קיץ)",
               "",
               "שעון ארגנטינה",
               "",
            };
        final String[] Christmas = new String[] {
               "שעון האי כריסטמס",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "שעון איי גלאפגוס",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "שעון הונג קונג (חורף)",
               "HKT",
               "שעון הונג קונג (קיץ)",
               "HKST",
               "שעון הונג קונג",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "שעון הודו-סין",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "שעון רגיל פטרופבלובסק-קמצ׳טסקי",
               "",
               "שעון קיץ פטרופבלובסק-קמצ׳טסקי",
               "",
               "שעון פטרופבלובסק-קמצ׳טסקי",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "שעון קירגיזסטן",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "שעון אי הלורד האו (חורף)",
               "",
               "שעון אי הלורד האו (קיץ)",
               "",
               "שעון אי הלורד האו",
               "",
            };
        final String[] Marquesas = new String[] {
               "שעון איי מרקיז",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "שעון מאוריציוס (חורף)",
               "",
               "שעון מאוריציוס (קיץ)",
               "",
               "שעון מאוריציוס",
               "",
            };
        final String[] Singapore = new String[] {
               "שעון סינגפור",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "שעון ונצואלה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "שעון אזרבייג׳ן (חורף)",
               "",
               "שעון אזרבייג׳ן (קיץ)",
               "",
               "שעון אזרבייג׳ן",
               "",
            };
        final String[] Bangladesh = new String[] {
               "שעון בנגלדש (חורף)",
               "",
               "שעון בנגלדש (קיץ)",
               "",
               "שעון בנגלדש",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "שעון כף ורדה (חורף)",
               "",
               "שעון כף ורדה (קיץ)",
               "",
               "שעון כף ורדה",
               "",
            };
        final String[] East_Timor = new String[] {
               "שעון מזרח טימור",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "שעון קזחסטן",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "שעון איי סיישל",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "שעון טג׳יקיסטן",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "שעון אוזבקיסטן (חורף)",
               "",
               "שעון אוזבקיסטן (קיץ)",
               "",
               "שעון אוזבקיסטן",
               "",
            };
        final String[] Afghanistan = new String[] {
               "שעון אפגניסטן",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "שעון קרסנויארסק (חורף)",
               "",
               "שעון קרסנויארסק (קיץ)",
               "",
               "שעון קרסנויארסק",
               "",
            };
        final String[] New_Zealand = new String[] {
               "שעון ניו זילנד (חורף)",
               "NZST",
               "שעון ניו זילנד (קיץ)",
               "NZDT",
               "שעון ניו זילנד",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "שעון הפיליפינים (חורף)",
               "PST",
               "שעון הפיליפינים (קיץ)",
               "PDT",
               "שעון הפיליפינים",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "שעון ולדיווסטוק (חורף)",
               "",
               "שעון ולדיווסטוק (קיץ)",
               "",
               "שעון ולדיווסטוק",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "שעון האוקיינוס ההודי",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "שעון איי ליין",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "שעון ניופאונדלנד (חורף)",
               "NST",
               "שעון ניופאונדלנד (קיץ)",
               "NDT",
               "שעון ניופאונדלנד",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "שעון טורקמניסטן (חורף)",
               "",
               "שעון טורקמניסטן (קיץ)",
               "",
               "שעון טורקמניסטן",
               "",
            };
        final String[] French_Guiana = new String[] {
               "שעון גיאנה הצרפתית",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "שעון קלדוניה החדשה (חורף)",
               "",
               "שעון קלדוניה החדשה (קיץ)",
               "",
               "שעון קלדוניה החדשה",
               "",
            };
        final String[] South_Georgia = new String[] {
               "שעון דרום ג׳ורג׳יה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "שעון יקטרינבורג (חורף)",
               "",
               "שעון יקטרינבורג (קיץ)",
               "",
               "שעון יקטרינבורג",
               "",
            };
        final String[] Africa_Central = new String[] {
               "שעון מרכז אפריקה",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "שעון מזרח אפריקה",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "שעון מערב אפריקה",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "שעון דומון ד׳אורוויל",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "שעון מרכז אירופה (חורף)",
               "CET",
               "שעון מרכז אירופה (קיץ)",
               "CEST",
               "שעון מרכז אירופה",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "שעון מזרח אירופה (חורף)",
               "EET",
               "שעון מזרח אירופה (קיץ)",
               "EEST",
               "שעון מזרח אירופה",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "שעון מערב אירופה (חורף)",
               "WET",
               "שעון מערב אירופה (קיץ)",
               "WEST",
               "שעון מערב אירופה",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "שעון מערב מקסיקו (חורף)",
               "MST",
               "שעון מערב מקסיקו (קיץ)",
               "MDT",
               "שעון מערב מקסיקו",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "שעון דרום אפריקה",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "שעון מרכז ארה״ב (חורף)",
               "CST",
               "שעון מרכז ארה״ב (קיץ)",
               "CDT",
               "שעון מרכז ארה״ב",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "שעון החוף המזרחי (חורף)",
               "EST",
               "שעון החוף המזרחי (קיץ)",
               "EST",
               "שעון החוף המזרחי",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "שעון מערב ארה״ב (חורף)",
               "PST",
               "שעון מערב ארה״ב (קיץ)",
               "PDT",
               "שעון מערב ארה״ב",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "שעון הארצות הדרומיות והאנטארקטיות של צרפת",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "שעון איי גילברט",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "שעון האיים האלאוטיים הוואי (חורף)",
               "HST",
               "שעון האיים האלאוטיים הוואי (קיץ)",
               "HDT",
               "שעון האיים האלאוטיים הוואי",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "שעון איי פיניקס",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "שעון סנט פייר ומיקלון (חורף)",
               "",
               "שעון סנט פייר ומיקלון (קיץ)",
               "",
               "שעון סנט פייר ומיקלון",
               "",
            };
        final String[] America_Mountain = new String[] {
               "שעון אזור ההרים בארה״ב (חורף)",
               "MST",
               "שעון אזור ההרים בארה״ב (קיץ)",
               "MST",
               "שעון אזור ההרים בארה״ב",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "שעון איי מרשל",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "שעון פפואה גיניאה החדשה",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "שעון מרכז אוסטרליה (חורף)",
               "ACST",
               "שעון מרכז אוסטרליה (קיץ)",
               "ACDT",
               "שעון מרכז אוסטרליה",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "שעון מזרח אוסטרליה (חורף)",
               "AEST",
               "שעון מזרח אוסטרליה (קיץ)",
               "AEDT",
               "שעון מזרח אוסטרליה",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "שעון מערב אוסטרליה (חורף)",
               "AWST",
               "שעון מערב אוסטרליה (קיץ)",
               "AWDT",
               "שעון מערב אוסטרליה",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "שעון מרכז אינדונזיה",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "שעון מזרח אינדונזיה",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "שעון מערב אינדונזיה",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "שעון מרכז-מערב אוסטרליה (חורף)",
               "",
               "שעון מרכז-מערב אוסטרליה (קיץ)",
               "",
               "שעון מרכז-מערב אוסטרליה",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "זמן אוניברסלי מתואם",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ אירלנד",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "זמן אוניברסלי מתואם",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "זמן אוניברסלי מתואם",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "זמן אוניברסלי מתואם",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "זמן אוניברסלי מתואם",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "זמן אוניברסלי מתואם",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ אירלנד",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "שעון גריניץ׳‏",
                    "GMT",
                    "שעון קיץ בריטניה",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "עדן" },
            { "timezone.excity.Asia/Baku", "באקו" },
            { "timezone.excity.Asia/Dili", "דילי" },
            { "timezone.excity.Asia/Gaza", "עזה" },
            { "timezone.excity.Asia/Hovd", "חובד" },
            { "timezone.excity.Asia/Omsk", "אומסק" },
            { "timezone.excity.Asia/Oral", "אורל" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "עמאן" },
            { "timezone.excity.Asia/Aqtau", "אקטאו" },
            { "timezone.excity.Asia/Chita", "צ׳יטה" },
            { "timezone.excity.Asia/Dhaka", "דאקה" },
            { "timezone.excity.Asia/Dubai", "דובאי" },
            { "timezone.excity.Asia/Kabul", "קאבול" },
            { "timezone.excity.Asia/Macau", "מקאו" },
            { "timezone.excity.Asia/Qatar", "קטאר" },
            { "timezone.excity.Asia/Seoul", "סיאול" },
            { "timezone.excity.Asia/Tokyo", "טוקיו" },
            { "timezone.excity.Asia/Tomsk", "טומסק" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ג׳ובה" },
            { "timezone.excity.Africa/Lome", "לומה" },
            { "timezone.excity.Asia/Almaty", "אלמאטי" },
            { "timezone.excity.Asia/Anadyr", "אנדיר" },
            { "timezone.excity.Asia/Aqtobe", "אקטובה" },
            { "timezone.excity.Asia/Atyrau", "אטיראו" },
            { "timezone.excity.Asia/Beirut", "ביירות" },
            { "timezone.excity.Asia/Brunei", "ברוניי" },
            { "timezone.excity.Asia/Hebron", "חברון" },
            { "timezone.excity.Asia/Kuwait", "כווית" },
            { "timezone.excity.Asia/Manila", "מנילה" },
            { "timezone.excity.Asia/Muscat", "מוסקט" },
            { "timezone.excity.Asia/Riyadh", "ריאד" },
            { "timezone.excity.Asia/Saigon", "הו צ׳י מין סיטי" },
            { "timezone.excity.Asia/Taipei", "טאיפיי" },
            { "timezone.excity.Asia/Tehran", "טהרן" },
            { "timezone.excity.Asia/Urumqi", "אורומקי" },
            { "timezone.excity.Etc/Unknown", "עיר לא ידועה" },
            { "timezone.excity.Europe/Kiev", "קייב" },
            { "timezone.excity.Europe/Oslo", "אוסלו" },
            { "timezone.excity.Europe/Riga", "ריגה" },
            { "timezone.excity.Europe/Rome", "רומא" },
            { "timezone.excity.Indian/Mahe", "מהא" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "אקרה" },
            { "timezone.excity.Africa/Cairo", "קהיר" },
            { "timezone.excity.Africa/Ceuta", "סאוטה" },
            { "timezone.excity.Africa/Dakar", "דקאר" },
            { "timezone.excity.Africa/Lagos", "לאגוס" },
            { "timezone.excity.Africa/Tunis", "תוניס" },
            { "timezone.excity.America/Adak", "אדאק" },
            { "timezone.excity.America/Lima", "לימה" },
            { "timezone.excity.America/Nome", "נום" },
            { "timezone.excity.Asia/Baghdad", "בגדד" },
            { "timezone.excity.Asia/Bahrain", "בחריין" },
            { "timezone.excity.Asia/Bangkok", "בנגקוק" },
            { "timezone.excity.Asia/Barnaul", "ברנאול" },
            { "timezone.excity.Asia/Bishkek", "בישקק" },
            { "timezone.excity.Asia/Colombo", "קולומבו" },
            { "timezone.excity.Asia/Irkutsk", "אירקוטסק" },
            { "timezone.excity.Asia/Jakarta", "ג׳קרטה" },
            { "timezone.excity.Asia/Karachi", "קראצ׳י" },
            { "timezone.excity.Asia/Kuching", "קוצ׳ינג" },
            { "timezone.excity.Asia/Magadan", "מגדן" },
            { "timezone.excity.Asia/Nicosia", "ניקוסיה" },
            { "timezone.excity.Asia/Rangoon", "רנגון" },
            { "timezone.excity.Asia/Tbilisi", "טביליסי" },
            { "timezone.excity.Asia/Thimphu", "טהימפהו" },
            { "timezone.excity.Asia/Yakutsk", "יקוטסק" },
            { "timezone.excity.Asia/Yerevan", "ירוואן" },
            { "timezone.excity.Europe/Kirov", "קירוב" },
            { "timezone.excity.Europe/Malta", "מלטה" },
            { "timezone.excity.Europe/Minsk", "מינסק" },
            { "timezone.excity.Europe/Paris", "פריז" },
            { "timezone.excity.Europe/Sofia", "סופיה" },
            { "timezone.excity.Europe/Vaduz", "ואדוץ" },
            { "timezone.excity.Indian/Cocos", "קוקוס" },
            { "timezone.excity.Pacific/Apia", "אפיה" },
            { "timezone.excity.Pacific/Fiji", "פיג׳י" },
            { "timezone.excity.Pacific/Guam", "גואם" },
            { "timezone.excity.Pacific/Niue", "ניואה" },
            { "timezone.excity.Pacific/Truk", "צ׳וק" },
            { "timezone.excity.Pacific/Wake", "וייק" },
            { "timezone.excity.Africa/Asmera", "אסמרה" },
            { "timezone.excity.Africa/Bamako", "במאקו" },
            { "timezone.excity.Africa/Bangui", "בנגואי" },
            { "timezone.excity.Africa/Banjul", "בנג׳ול" },
            { "timezone.excity.Africa/Bissau", "ביסאו" },
            { "timezone.excity.Africa/Douala", "דואלה" },
            { "timezone.excity.Africa/Harare", "הרארה" },
            { "timezone.excity.Africa/Kigali", "קיגלי" },
            { "timezone.excity.Africa/Luanda", "לואנדה" },
            { "timezone.excity.Africa/Lusaka", "לוסקה" },
            { "timezone.excity.Africa/Malabo", "מלבו" },
            { "timezone.excity.Africa/Maputo", "מאפוטו" },
            { "timezone.excity.Africa/Maseru", "מסרו" },
            { "timezone.excity.Africa/Niamey", "ניאמיי" },
            { "timezone.excity.America/Aruba", "ארובה" },
            { "timezone.excity.America/Bahia", "באהיה" },
            { "timezone.excity.America/Belem", "בלם" },
            { "timezone.excity.America/Boise", "בויסי" },
            { "timezone.excity.America/Jujuy", "חוחוי" },
            { "timezone.excity.America/Sitka", "סיטקה" },
            { "timezone.excity.America/Thule", "תולה" },
            { "timezone.excity.Asia/Ashgabat", "אשגבט" },
            { "timezone.excity.Asia/Calcutta", "קולקטה" },
            { "timezone.excity.Asia/Damascus", "דמשק" },
            { "timezone.excity.Asia/Dushanbe", "דושנבה" },
            { "timezone.excity.Asia/Jayapura", "ג׳איאפורה" },
            { "timezone.excity.Asia/Katmandu", "קטמנדו" },
            { "timezone.excity.Asia/Khandyga", "חנדיגה" },
            { "timezone.excity.Asia/Makassar", "מאקאסאר" },
            { "timezone.excity.Asia/Qostanay", "קוסטנאי" },
            { "timezone.excity.Asia/Sakhalin", "סחלין" },
            { "timezone.excity.Asia/Shanghai", "שנחאי" },
            { "timezone.excity.Asia/Tashkent", "טשקנט" },
            { "timezone.excity.Asia/Ust-Nera", "אוסט-נרה" },
            { "timezone.excity.Europe/Athens", "אתונה" },
            { "timezone.excity.Europe/Berlin", "ברלין" },
            { "timezone.excity.Europe/Dublin", "דבלין" },
            { "timezone.excity.Europe/Jersey", "ג׳רזי" },
            { "timezone.excity.Europe/Lisbon", "ליסבון" },
            { "timezone.excity.Europe/London", "לונדון" },
            { "timezone.excity.Europe/Madrid", "מדריד" },
            { "timezone.excity.Europe/Monaco", "מונקו" },
            { "timezone.excity.Europe/Moscow", "מוסקבה" },
            { "timezone.excity.Europe/Prague", "פראג" },
            { "timezone.excity.Europe/Samara", "סמרה" },
            { "timezone.excity.Europe/Skopje", "סקופיה" },
            { "timezone.excity.Europe/Tirane", "טירנה" },
            { "timezone.excity.Europe/Vienna", "וינה" },
            { "timezone.excity.Europe/Warsaw", "ורשה" },
            { "timezone.excity.Europe/Zagreb", "זאגרב" },
            { "timezone.excity.Europe/Zurich", "ציריך" },
            { "timezone.excity.Indian/Chagos", "צ׳אגוס" },
            { "timezone.excity.Indian/Comoro", "קומורו" },
            { "timezone.excity.Pacific/Efate", "אפטה" },
            { "timezone.excity.Pacific/Nauru", "נאורו" },
            { "timezone.excity.Pacific/Palau", "פלאו" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "אביג׳אן" },
            { "timezone.excity.Africa/Algiers", "אלג׳יר" },
            { "timezone.excity.Africa/Conakry", "קונאקרי" },
            { "timezone.excity.Africa/Kampala", "קמפאלה" },
            { "timezone.excity.Africa/Mbabane", "מבבנה" },
            { "timezone.excity.Africa/Nairobi", "ניירובי" },
            { "timezone.excity.Africa/Tripoli", "טריפולי" },
            { "timezone.excity.America/Belize", "בליז" },
            { "timezone.excity.America/Bogota", "בוגוטה" },
            { "timezone.excity.America/Cancun", "קנקון" },
            { "timezone.excity.America/Cayman", "קיימן" },
            { "timezone.excity.America/Cuiaba", "קויאבה" },
            { "timezone.excity.America/Dawson", "דוסון" },
            { "timezone.excity.America/Denver", "דנוור" },
            { "timezone.excity.America/Guyana", "גיאנה" },
            { "timezone.excity.America/Havana", "הוואנה" },
            { "timezone.excity.America/Inuvik", "אינוויק" },
            { "timezone.excity.America/Juneau", "ג׳ונו" },
            { "timezone.excity.America/La_Paz", "לה פאס" },
            { "timezone.excity.America/Maceio", "מסייאו" },
            { "timezone.excity.America/Manaus", "מנאוס" },
            { "timezone.excity.America/Merida", "מרידה" },
            { "timezone.excity.America/Nassau", "נסאו" },
            { "timezone.excity.America/Panama", "פנמה" },
            { "timezone.excity.America/Recife", "רסיפה" },
            { "timezone.excity.America/Regina", "רג׳ינה" },
            { "timezone.excity.Asia/Famagusta", "פמגוסטה" },
            { "timezone.excity.Asia/Hong_Kong", "הונג קונג" },
            { "timezone.excity.Asia/Jerusalem", "ירושלים" },
            { "timezone.excity.Asia/Kamchatka", "קמצ׳טקה" },
            { "timezone.excity.Asia/Pontianak", "פונטיאנק" },
            { "timezone.excity.Asia/Pyongyang", "פיונגיאנג" },
            { "timezone.excity.Asia/Qyzylorda", "קיזילורדה" },
            { "timezone.excity.Asia/Samarkand", "סמרקנד" },
            { "timezone.excity.Asia/Singapore", "סינגפור" },
            { "timezone.excity.Asia/Vientiane", "ויינטיאן" },
            { "timezone.excity.Europe/Andorra", "אנדורה" },
            { "timezone.excity.Europe/Saratov", "סראטוב" },
            { "timezone.excity.Europe/Tallinn", "טאלין" },
            { "timezone.excity.Europe/Vatican", "הוותיקן" },
            { "timezone.excity.Europe/Vilnius", "וילנה" },
            { "timezone.excity.Indian/Mayotte", "מאיוט" },
            { "timezone.excity.Indian/Reunion", "ראוניון" },
            { "timezone.excity.Pacific/Easter", "אי הפסחא" },
            { "timezone.excity.Pacific/Kosrae", "קוסרה" },
            { "timezone.excity.Pacific/Majuro", "מאג׳ורו" },
            { "timezone.excity.Pacific/Midway", "מידוויי" },
            { "timezone.excity.Pacific/Noumea", "נומאה" },
            { "timezone.excity.Pacific/Ponape", "פונפיי" },
            { "timezone.excity.Pacific/Saipan", "סאיפאן" },
            { "timezone.excity.Pacific/Tahiti", "טהיטי" },
            { "timezone.excity.Pacific/Tarawa", "טאראווה" },
            { "timezone.excity.Pacific/Wallis", "ווליס" },
            { "timezone.excity.Africa/Blantyre", "בלנטיר" },
            { "timezone.excity.Africa/Djibouti", "ג׳יבוטי" },
            { "timezone.excity.Africa/El_Aaiun", "אל עיון" },
            { "timezone.excity.Africa/Freetown", "פריטאון" },
            { "timezone.excity.Africa/Gaborone", "גבורונה" },
            { "timezone.excity.Africa/Khartoum", "חרטום" },
            { "timezone.excity.Africa/Kinshasa", "קינשסה" },
            { "timezone.excity.Africa/Monrovia", "מונרוביה" },
            { "timezone.excity.Africa/Ndjamena", "נג׳מנה" },
            { "timezone.excity.Africa/Sao_Tome", "סאו טומה" },
            { "timezone.excity.Africa/Windhoek", "וינדהוק" },
            { "timezone.excity.America/Antigua", "אנטיגואה" },
            { "timezone.excity.America/Caracas", "קראקס" },
            { "timezone.excity.America/Cayenne", "קאיין" },
            { "timezone.excity.America/Chicago", "שיקגו" },
            { "timezone.excity.America/Cordoba", "קורדובה" },
            { "timezone.excity.America/Creston", "קרסטון" },
            { "timezone.excity.America/Curacao", "קוראסאו" },
            { "timezone.excity.America/Detroit", "דטרויט" },
            { "timezone.excity.America/Godthab", "נואוק" },
            { "timezone.excity.America/Grenada", "גרנדה" },
            { "timezone.excity.America/Halifax", "הליפקס" },
            { "timezone.excity.America/Iqaluit", "איקלואיט" },
            { "timezone.excity.America/Jamaica", "ג׳מייקה" },
            { "timezone.excity.America/Managua", "מנגואה" },
            { "timezone.excity.America/Marigot", "מריגו" },
            { "timezone.excity.America/Mendoza", "מנדוזה" },
            { "timezone.excity.America/Moncton", "מונקטון" },
            { "timezone.excity.America/Noronha", "נורוניה" },
            { "timezone.excity.America/Ojinaga", "אוג׳ינאגה" },
            { "timezone.excity.America/Phoenix", "פיניקס" },
            { "timezone.excity.America/Tijuana", "טיחואנה" },
            { "timezone.excity.America/Toronto", "טורונטו" },
            { "timezone.excity.America/Tortola", "טורטולה" },
            { "timezone.excity.America/Yakutat", "יקוטאט" },
            { "timezone.excity.Asia/Phnom_Penh", "פנום פן" },
            { "timezone.excity.Atlantic/Azores", "האיים האזוריים" },
            { "timezone.excity.Atlantic/Canary", "האיים הקנריים" },
            { "timezone.excity.Atlantic/Faeroe", "פארו" },
            { "timezone.excity.Australia/Eucla", "יוקלה" },
            { "timezone.excity.Australia/Perth", "פרת׳" },
            { "timezone.excity.Europe/Belgrade", "בלגרד" },
            { "timezone.excity.Europe/Brussels", "בריסל" },
            { "timezone.excity.Europe/Budapest", "בודפשט" },
            { "timezone.excity.Europe/Busingen", "ביזינגן" },
            { "timezone.excity.Europe/Chisinau", "קישינב" },
            { "timezone.excity.Europe/Guernsey", "גרנזי" },
            { "timezone.excity.Europe/Helsinki", "הלסינקי" },
            { "timezone.excity.Europe/Istanbul", "איסטנבול" },
            { "timezone.excity.Europe/Sarajevo", "סרייבו" },
            { "timezone.excity.Indian/Maldives", "האיים המלדיביים" },
            { "timezone.excity.Pacific/Chatham", "צ׳אטהאם" },
            { "timezone.excity.Pacific/Fakaofo", "פקאופו" },
            { "timezone.excity.Pacific/Gambier", "איי גמבייה" },
            { "timezone.excity.Pacific/Norfolk", "נורפוק" },
            { "timezone.excity.Africa/Bujumbura", "בוג׳ומבורה" },
            { "timezone.excity.Africa/Mogadishu", "מוגדישו" },
            { "timezone.excity.America/Anguilla", "אנגווילה" },
            { "timezone.excity.America/Asuncion", "אסונסיון" },
            { "timezone.excity.America/Barbados", "ברבדוס" },
            { "timezone.excity.America/Dominica", "דומיניקה" },
            { "timezone.excity.America/Edmonton", "אדמונטון" },
            { "timezone.excity.America/Eirunepe", "אירונפי" },
            { "timezone.excity.America/Mazatlan", "מזטלן" },
            { "timezone.excity.America/Miquelon", "מיקלון" },
            { "timezone.excity.America/New_York", "ניו יורק" },
            { "timezone.excity.America/Resolute", "רזולוט" },
            { "timezone.excity.America/Santarem", "סנטרם" },
            { "timezone.excity.America/Santiago", "סנטיאגו" },
            { "timezone.excity.America/St_Johns", "סנט ג׳ונס" },
            { "timezone.excity.America/St_Kitts", "סנט קיטס" },
            { "timezone.excity.America/St_Lucia", "סנט לוסיה" },
            { "timezone.excity.America/Winnipeg", "וויניפג" },
            { "timezone.excity.Antarctica/Casey", "קייסי" },
            { "timezone.excity.Antarctica/Davis", "דיוויס" },
            { "timezone.excity.Antarctica/Syowa", "סייווה" },
            { "timezone.excity.Antarctica/Troll", "טרול" },
            { "timezone.excity.Asia/Krasnoyarsk", "קרסנויארסק" },
            { "timezone.excity.Asia/Novosibirsk", "נובוסיבירסק" },
            { "timezone.excity.Asia/Ulaanbaatar", "אולאן באטור" },
            { "timezone.excity.Asia/Vladivostok", "ולדיווסטוק" },
            { "timezone.excity.Atlantic/Bermuda", "ברמודה" },
            { "timezone.excity.Atlantic/Madeira", "מדיירה" },
            { "timezone.excity.Atlantic/Stanley", "סטנלי" },
            { "timezone.excity.Australia/Darwin", "דרווין" },
            { "timezone.excity.Australia/Hobart", "הוברט" },
            { "timezone.excity.Australia/Sydney", "סידני" },
            { "timezone.excity.Europe/Amsterdam", "אמסטרדם" },
            { "timezone.excity.Europe/Astrakhan", "אסטרחן" },
            { "timezone.excity.Europe/Bucharest", "בוקרשט" },
            { "timezone.excity.Europe/Gibraltar", "גיברלטר" },
            { "timezone.excity.Europe/Ljubljana", "לובליאנה" },
            { "timezone.excity.Europe/Mariehamn", "מרייהאמן" },
            { "timezone.excity.Europe/Podgorica", "פודגוריצה" },
            { "timezone.excity.Europe/Stockholm", "שטוקהולם" },
            { "timezone.excity.Europe/Ulyanovsk", "אוליאנובסק" },
            { "timezone.excity.Europe/Volgograd", "וולגוגרד" },
            { "timezone.excity.Indian/Christmas", "האי כריסטמס" },
            { "timezone.excity.Indian/Kerguelen", "קרגוולן" },
            { "timezone.excity.Indian/Mauritius", "מאוריציוס" },
            { "timezone.excity.Pacific/Auckland", "אוקלנד" },
            { "timezone.excity.Pacific/Funafuti", "פונפוטי" },
            { "timezone.excity.Pacific/Honolulu", "הונולולו" },
            { "timezone.excity.Pacific/Pitcairn", "פיטקרן" },
            { "timezone.excity.Africa/Casablanca", "קזבלנקה" },
            { "timezone.excity.Africa/Libreville", "ליברוויל" },
            { "timezone.excity.Africa/Lubumbashi", "לובומבאשי" },
            { "timezone.excity.Africa/Nouakchott", "נואקצ׳וט" },
            { "timezone.excity.Africa/Porto-Novo", "פורטו נובו" },
            { "timezone.excity.America/Anchorage", "אנקורג׳" },
            { "timezone.excity.America/Araguaina", "אראגואינה" },
            { "timezone.excity.America/Boa_Vista", "בואה ויסטה" },
            { "timezone.excity.America/Catamarca", "קטמרקה" },
            { "timezone.excity.America/Chihuahua", "צ׳יוואווה" },
            { "timezone.excity.America/Coyhaique", "קויאיקה" },
            { "timezone.excity.America/Fortaleza", "פורטאלזה" },
            { "timezone.excity.America/Glace_Bay", "גלייס ביי" },
            { "timezone.excity.America/Goose_Bay", "גוס ביי" },
            { "timezone.excity.America/Guatemala", "גואטמלה" },
            { "timezone.excity.America/Guayaquil", "גואיאקיל" },
            { "timezone.excity.America/Matamoros", "מטמורוס" },
            { "timezone.excity.America/Menominee", "מנומיני" },
            { "timezone.excity.America/Monterrey", "מונטריי" },
            { "timezone.excity.America/Sao_Paulo", "סאו פאולו" },
            { "timezone.excity.America/St_Thomas", "סנט תומאס" },
            { "timezone.excity.America/Vancouver", "ונקובר" },
            { "timezone.excity.Antarctica/Mawson", "מוסון" },
            { "timezone.excity.Antarctica/Palmer", "פאלמר" },
            { "timezone.excity.Antarctica/Vostok", "ווסטוק" },
            { "timezone.excity.Asia/Kuala_Lumpur", "קואלה לומפור" },
            { "timezone.excity.Asia/Novokuznetsk", "נובוקוזנטסק" },
            { "timezone.excity.Europe/Bratislava", "ברטיסלבה" },
            { "timezone.excity.Europe/Copenhagen", "קופנהגן" },
            { "timezone.excity.Europe/Luxembourg", "לוקסמבורג" },
            { "timezone.excity.Europe/San_Marino", "סן מרינו" },
            { "timezone.excity.Europe/Simferopol", "סימפרופול" },
            { "timezone.excity.Pacific/Enderbury", "קנטון" },
            { "timezone.excity.Pacific/Galapagos", "גלפאגוס" },
            { "timezone.excity.Pacific/Kwajalein", "קוואג׳ליין" },
            { "timezone.excity.Pacific/Marquesas", "איי מרקיז" },
            { "timezone.excity.Pacific/Pago_Pago", "פאגו פאגו" },
            { "timezone.excity.Pacific/Rarotonga", "רארוטונגה" },
            { "timezone.excity.Pacific/Tongatapu", "טונגטאפו" },
            { "timezone.excity.Africa/Addis_Ababa", "אדיס אבבה" },
            { "timezone.excity.Africa/Brazzaville", "ברזוויל" },
            { "timezone.excity.Africa/Ouagadougou", "וואגאדוגו" },
            { "timezone.excity.America/Costa_Rica", "קוסטה ריקה" },
            { "timezone.excity.America/Grand_Turk", "גרנד טורק" },
            { "timezone.excity.America/Guadeloupe", "גואדלופ" },
            { "timezone.excity.America/Hermosillo", "הרמוסיו" },
            { "timezone.excity.America/Kralendijk", "קרלנדייק" },
            { "timezone.excity.America/Louisville", "לואיוויל" },
            { "timezone.excity.America/Martinique", "מרטיניק" },
            { "timezone.excity.America/Metlakatla", "מטלקטלה" },
            { "timezone.excity.America/Montevideo", "מונטווידאו" },
            { "timezone.excity.America/Montserrat", "מונסראט" },
            { "timezone.excity.America/Paramaribo", "פרמריבו" },
            { "timezone.excity.America/Rio_Branco", "ריו ברנקו" },
            { "timezone.excity.America/St_Vincent", "סנט וינסנט" },
            { "timezone.excity.America/Whitehorse", "ווייטהורס" },
            { "timezone.excity.Antarctica/McMurdo", "מק-מרדו" },
            { "timezone.excity.Antarctica/Rothera", "רות׳רה" },
            { "timezone.excity.Asia/Srednekolymsk", "סרדנייקולימסק" },
            { "timezone.excity.Asia/Yekaterinburg", "יקטרינבורג" },
            { "timezone.excity.Atlantic/Reykjavik", "רייקיאוויק" },
            { "timezone.excity.Atlantic/St_Helena", "סנט הלנה" },
            { "timezone.excity.Australia/Adelaide", "אדלייד" },
            { "timezone.excity.Australia/Brisbane", "בריסביין" },
            { "timezone.excity.Australia/Lindeman", "לינדמן" },
            { "timezone.excity.Europe/Isle_of_Man", "האי מאן" },
            { "timezone.excity.Europe/Kaliningrad", "קלינינגרד" },
            { "timezone.excity.Pacific/Kiritimati", "קיריטימאטי" },
            { "timezone.excity.Africa/Johannesburg", "יוהנסבורג" },
            { "timezone.excity.America/El_Salvador", "אל סלבדור" },
            { "timezone.excity.America/Fort_Nelson", "פורט נלסון" },
            { "timezone.excity.America/Los_Angeles", "לוס אנג׳לס" },
            { "timezone.excity.America/Mexico_City", "מקסיקו סיטי" },
            { "timezone.excity.America/Porto_Velho", "פורטו וליו" },
            { "timezone.excity.America/Puerto_Rico", "פוארטו ריקו" },
            { "timezone.excity.America/Tegucigalpa", "טגוסיגלפה" },
            { "timezone.excity.Arctic/Longyearbyen", "לונגיירבין" },
            { "timezone.excity.Atlantic/Cape_Verde", "כף ורדה" },
            { "timezone.excity.Australia/Lord_Howe", "אי הלורד האו" },
            { "timezone.excity.Australia/Melbourne", "מלבורן" },
            { "timezone.excity.Indian/Antananarivo", "אנטננריבו" },
            { "timezone.excity.Pacific/Guadalcanal", "גוודלקנאל" },
            { "timezone.excity.Africa/Dar_es_Salaam", "דאר א-סלאם" },
            { "timezone.excity.America/Blanc-Sablon", "בלאן-סבלון" },
            { "timezone.excity.America/Buenos_Aires", "בואנוס איירס" },
            { "timezone.excity.America/Campo_Grande", "קמפו גרנדה" },
            { "timezone.excity.America/Danmarkshavn", "דנמרקסהוון" },
            { "timezone.excity.America/Dawson_Creek", "דוסון קריק" },
            { "timezone.excity.America/Indiana/Knox", "נוקס, אינדיאנה" },
            { "timezone.excity.America/Indianapolis", "אינדיאנפוליס" },
            { "timezone.excity.America/Punta_Arenas", "פונטה ארנס" },
            { "timezone.excity.America/Rankin_Inlet", "רנקין אינלט" },
            { "timezone.excity.America/Scoresbysund", "סקורסביסונד" },
            { "timezone.excity.Antarctica/Macquarie", "מקווארי" },
            { "timezone.excity.Pacific/Bougainville", "בוגנוויל" },
            { "timezone.excity.Pacific/Port_Moresby", "פורט מורסבי" },
            { "timezone.excity.America/Cambridge_Bay", "קיימברידג׳ ביי" },
            { "timezone.excity.America/Ciudad_Juarez", "סיודד חוארס" },
            { "timezone.excity.America/Coral_Harbour", "אטיקוקן" },
            { "timezone.excity.America/Indiana/Vevay", "ויוואיי, אינדיאנה" },
            { "timezone.excity.America/Lower_Princes", "לואוור פרינסס קוורטר" },
            { "timezone.excity.America/Port_of_Spain", "פורט אוף ספיין" },
            { "timezone.excity.America/Santo_Domingo", "סנטו דומינגו" },
            { "timezone.excity.America/St_Barthelemy", "סנט ברתלמי" },
            { "timezone.excity.America/Swift_Current", "סוויפט קרנט" },
            { "timezone.excity.Australia/Broken_Hill", "ברוקן היל" },
            { "timezone.excity.America/Bahia_Banderas", "באהיה בנדרס" },
            { "timezone.excity.America/Port-au-Prince", "פורט או פראנס" },
            { "timezone.excity.Atlantic/South_Georgia", "דרום ג׳ורג׳יה" },
            { "timezone.excity.America/Argentina/Salta", "סלטה" },
            { "timezone.excity.America/Indiana/Marengo", "מרנגו, אינדיאנה" },
            { "timezone.excity.America/Indiana/Winamac", "וינמאק, אינדיאנה" },
            { "timezone.excity.America/Argentina/Tucuman", "טוקומן" },
            { "timezone.excity.America/Argentina/Ushuaia", "אושוואיה" },
            { "timezone.excity.America/Indiana/Tell_City", "טל סיטי, אינדיאנה" },
            { "timezone.excity.America/Indiana/Vincennes", "וינסנס, אינדיאנה" },
            { "timezone.excity.Antarctica/DumontDUrville", "דומון ד׳אורוויל" },
            { "timezone.excity.America/Argentina/La_Rioja", "לה ריוחה" },
            { "timezone.excity.America/Argentina/San_Juan", "סן חואן" },
            { "timezone.excity.America/Argentina/San_Luis", "סן לואיס" },
            { "timezone.excity.America/Indiana/Petersburg", "פיטרסבורג, אינדיאנה" },
            { "timezone.excity.America/Kentucky/Monticello", "מונטיצ׳לו, קנטאקי" },
            { "timezone.excity.America/North_Dakota/Beulah", "ביולה, דקוטה הצפונית" },
            { "timezone.excity.America/North_Dakota/Center", "סנטר, דקוטה הצפונית" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ריו גאייגוס" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ניו סיילם, דקוטה הצפונית" },
        };
        return data;
    }
}
