/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.jetbrains.localization.GnuGetTextBundle;
import com.jetbrains.localization.psi.impl.LocalePsiElement;
import com.jetbrains.localization.validation.LocaleAnnotator;

public class LocaleStringConstantAnnotator
extends LocaleAnnotator {
    @Override
    public void visitStringLiteral(LocalePsiElement node) {
        String text = node.getText();
        String msg = "";
        boolean ok = true;
        int index = 0;
        if (text.length() == 0) {
            return;
        }
        char first_quote = text.charAt(index);
        if (++index >= text.length()) {
            msg = GnuGetTextBundle.message("inspection.message.missing.closing.quote", Character.valueOf(first_quote));
            ok = false;
        } else {
            index = text.length() - 1;
            while (text.charAt(index) == '\n') {
                --index;
            }
            if (text.charAt(index) != first_quote) {
                msg = GnuGetTextBundle.message("inspection.message.missing.closing.quote", Character.valueOf(first_quote));
                ok = false;
            }
        }
        if (!ok) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, msg).create();
        }
    }
}

