/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file;

import com.intellij.ide.fileTemplates.DefaultCreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.NotebookMetadataLanguageProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/JupyterCreateFromTemplateHandler;", "Lcom/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler;", "<init>", "()V", "handlesTemplate", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "createFromTemplate", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "fileName", "", "templateText", "props", "", "", "intellij.jupyter.core"})
public final class JupyterCreateFromTemplateHandler
extends DefaultCreateFromTemplateHandler {
    public boolean handlesTemplate(@NotNull FileTemplate template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        FileType fileType2 = fileType;
        return Intrinsics.areEqual((Object)JupyterFileType.INSTANCE, (Object)fileType2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PsiElement createFromTemplate(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull String fileName, @NotNull FileTemplate template, @NotNull String templateText, @NotNull Map<String, Object> props) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)templateText, (String)"templateText");
        Intrinsics.checkNotNullParameter(props, (String)"props");
        String fileNameWithExtension = this.checkAppendExtension(fileName, template);
        directory.checkCreateFile(fileNameWithExtension);
        JupyterNotebookBase notebook = JupyterFileUtils.INSTANCE.readNotebook(templateText);
        try {
            VirtualFile virtualFile2 = directory.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            NotebookMetadataLanguageProvider.Utils.INSTANCE.setNotebookLanguage(virtualFile2, notebook.getLanguage());
            virtualFile = directory.getVirtualFile().createChildData((Object)this, fileNameWithExtension);
        }
        finally {
            VirtualFile virtualFile3 = directory.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
            NotebookMetadataLanguageProvider.Utils.INSTANCE.setNotebookLanguage(virtualFile3, null);
        }
        VirtualFile virtualFile4 = virtualFile;
        Intrinsics.checkNotNull((Object)virtualFile4);
        VirtualFile newFile = virtualFile4;
        VirtualFileUtil.writeText((VirtualFile)newFile, (String)templateText);
        BackedNotebookVirtualFile.Companion.createWithNotebook(newFile, notebook);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(newFile);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile createdPsiFile = psiFile;
        return (PsiElement)createdPsiFile;
    }
}

