/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorRunActionsHandlerKt;
import com.intellij.jupyter.core.jupyter.actions.JupyterExecutionData;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterClearOutputsAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterClearOutputsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterClearOutputsAction.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterClearOutputsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1872#2,3:37\n*S KotlinDebug\n*F\n+ 1 JupyterClearOutputsAction.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterClearOutputsAction\n*L\n24#1:37,3\n*E\n"})
public final class JupyterClearOutputsAction
extends JupyterEditorActionBase {
    private JupyterClearOutputsAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JupyterExecutionData jupyterExecutionData = JupyterEditorRunActionsHandlerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData executionData = jupyterExecutionData;
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext2);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        BackedNotebookVirtualFile jupyterFile = executionData.getNotebookVirtualFile();
        JupyterInlayProgressStatusManager service = JupyterInlayProgressStatusManager.Companion.getInstance(project2);
        WriteAction.run(() -> JupyterClearOutputsAction.actionPerformed$lambda$1(editor, jupyterFile, service));
    }

    /*
     * WARNING - void declaration
     */
    private static final void actionPerformed$lambda$1(EditorImpl $editor, BackedNotebookVirtualFile $jupyterFile, JupyterInlayProgressStatusManager $service) {
        void $this$forEachIndexed$iv;
        List<NotebookIntervalPointer> cellPointers = NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)$editor);
        JupyterNotebook notebook = $jupyterFile.getNotebook();
        Iterable iterable = notebook.computeCells();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cell;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JupyterCell jupyterCell = (JupyterCell)item$iv;
            int index = n;
            boolean bl = false;
            NotebookIntervalPointer cellPointer = cellPointers.get(index);
            if (cell.getCellType() != JupyterCellType.CODE && cell.getCellType() != JupyterCellType.SQL) continue;
            cell.setOutputs(null);
            cell.setExecutionCount(null);
            cell.setExecutionStartTime(null);
            $service.clearStatusForCell(cellPointer, $jupyterFile);
            JupyterListenersKt.outputUpdated(notebook, cellPointer);
        }
    }
}

