/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.auth.notebook;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.auth.notebook.JupyterNoteAuthUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNotebookAuthDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "location", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;)V", "urlString", "", "passwordOrTokenField", "Ljavax/swing/JPasswordField;", "value", "", "rememberPasswordOrToken", "getRememberPasswordOrToken", "()Z", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "getPasswordOrToken", "Lcom/intellij/credentialStore/OneTimeString;", "intellij.jupyter.core"})
public final class JupyterNotebookAuthDialog
extends DialogWrapper {
    @NotNull
    private final String urlString;
    private JPasswordField passwordOrTokenField;
    private boolean rememberPasswordOrToken;

    public JupyterNotebookAuthDialog(@Nullable Project project, @NotNull JupyterConnectionParameters.Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(project);
        String string = JupyterNoteAuthUtils.INSTANCE.uriOfUnmanagedNotebookServer$intellij_jupyter_core(location).toASCIIString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCIIString(...)");
        this.urlString = string;
        this.rememberPasswordOrToken = PasswordSafe.Companion.getInstance().isRememberPasswordByDefault();
        this.setTitle(JupyterBundle.message("Jupyter.login.dialog.title", new Object[0]));
        this.init();
    }

    public final boolean getRememberPasswordOrToken() {
        return this.rememberPasswordOrToken;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> JupyterNotebookAuthDialog.createCenterPanel$lambda$4(this, arg_0));
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.getOKAction().isEnabled()) {
            PasswordSafe.Companion.getInstance().setRememberPasswordByDefault(this.rememberPasswordOrToken);
        }
    }

    @NotNull
    public final OneTimeString getPasswordOrToken() {
        JPasswordField jPasswordField = this.passwordOrTokenField;
        if (jPasswordField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"passwordOrTokenField");
            jPasswordField = null;
        }
        char[] cArray = jPasswordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        return new OneTimeString(cArray, 0, 0, false, 14, null);
    }

    private static final Unit createCenterPanel$lambda$4$lambda$0(JupyterNotebookAuthDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{this$0.urlString};
        $this$row.label(JupyterBundle.message("Jupyter.login.dialog.header", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$lambda$1(JupyterNotebookAuthDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.passwordOrTokenField = (JPasswordField)$this$row.passwordField().align((Align)AlignX.FILL.INSTANCE).focused().getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$lambda$3$lambda$2(JupyterNotebookAuthDialog this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.rememberPasswordOrToken = it.isSelected();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4$lambda$3(JupyterNotebookAuthDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.selected((Cell)$this$row.checkBox(JupyterBundle.message("Jupyter.login.dialog.remember", new Object[0])), (boolean)this$0.rememberPasswordOrToken).onChanged(arg_0 -> JupyterNotebookAuthDialog.createCenterPanel$lambda$4$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4(JupyterNotebookAuthDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterNotebookAuthDialog.createCenterPanel$lambda$4$lambda$0(this$0, arg_0), (int)1, null);
        $this$panel.row(JupyterBundle.message("Jupyter.login.dialog.password.or.token.label", new Object[0]), arg_0 -> JupyterNotebookAuthDialog.createCenterPanel$lambda$4$lambda$1(this$0, arg_0));
        if (!PasswordSafe.Companion.getInstance().isMemoryOnly()) {
            $this$panel.row("", arg_0 -> JupyterNotebookAuthDialog.createCenterPanel$lambda$4$lambda$3(this$0, arg_0));
        }
        return Unit.INSTANCE;
    }
}

