/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.management;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.management.DiscoveredServer;
import com.intellij.jupyter.core.jupyter.connections.management.JupyterServerListener;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartFMap;
import com.intellij.util.messages.Topic;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\u000b2\u0014\b\u0004\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rH\u0082\bJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$State;", "kotlin.jvm.PlatformType", "updateAndNotify", "", "block", "Lkotlin/Function1;", "getServersByDirectory", "", "Ljava/nio/file/Path;", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;", "Listener", "State", "OwnListener", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRunningServersDirectoryMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,196:1\n14#2:197\n*S KotlinDebug\n*F\n+ 1 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper\n*L\n188#1:197\n*E\n"})
public final class JupyterRunningServersDirectoryMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<State> state;
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final Topic<Listener> TOPIC;

    private JupyterRunningServersDirectoryMapper(Project project) {
        this.project = project;
        SmartFMap smartFMap = SmartFMap.emptyMap();
        Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"emptyMap(...)");
        SmartFMap smartFMap2 = SmartFMap.emptyMap();
        Intrinsics.checkNotNullExpressionValue((Object)smartFMap2, (String)"emptyMap(...)");
        this.state = new AtomicReference<State>(new State((SmartFMap<Path, JupyterConnectionParameters.Location>)smartFMap, (SmartFMap<JupyterServerExecution, Path>)smartFMap2));
    }

    private final void updateAndNotify(Function1<? super State, State> block) {
        State state;
        boolean $i$f$updateAndNotify = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        State old2 = (State)this.state.getAndUpdate(new UnaryOperator((Ref.ObjectRef<State>)objectRef, block){
            final /* synthetic */ Ref.ObjectRef<State> $new;
            final /* synthetic */ Function1<State, State> $block;
            {
                this.$new = $new;
                this.$block = $block;
            }

            public final State apply(State old2) {
                State state;
                Intrinsics.checkNotNull((Object)old2);
                this.$new.element = this.$block.invoke((Object)old2);
                if (this.$new.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                    state = null;
                } else {
                    state = (State)this.$new.element;
                }
                return state;
            }
        });
        SmartFMap<Path, JupyterConnectionParameters.Location> smartFMap = old2.getLocationByDirectory();
        if (objectRef.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"new");
            state = null;
        } else {
            state = (State)objectRef.element;
        }
        if (!Intrinsics.areEqual(smartFMap, state.getLocationByDirectory())) {
            State state2;
            Listener listener = (Listener)this.project.getMessageBus().syncPublisher(TOPIC);
            Set set = old2.getLocationByDirectory().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            if (objectRef.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                state2 = null;
            } else {
                state2 = (State)objectRef.element;
            }
            Set set2 = state2.getLocationByDirectory().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
            listener.connectionParametersByDirectoryChanged(set, set2);
        }
    }

    @NotNull
    public final Map<Path, JupyterConnectionParameters.Location> getServersByDirectory() {
        return (Map)this.state.get().getLocationByDirectory();
    }

    @JvmStatic
    @NotNull
    public static final JupyterRunningServersDirectoryMapper instance(@NotNull Project project) {
        return Companion.instance(project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JupyterRunningServersDirectoryMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Topic topic = Topic.create((String)Listener.class.getName(), Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$Listener;", "instance", "Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterRunningServersDirectoryMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,196:1\n31#2,2:197\n*S KotlinDebug\n*F\n+ 1 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$Companion\n*L\n194#1:197,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterRunningServersDirectoryMapper instance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterRunningServersDirectoryMapper> serviceClass$iv = JupyterRunningServersDirectoryMapper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterRunningServersDirectoryMapper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$Listener;", "", "connectionParametersByDirectoryChanged", "", "old", "", "Ljava/nio/file/Path;", "new", "intellij.jupyter.core"})
    public static interface Listener {
        public void connectionParametersByDirectoryChanged(@NotNull Set<? extends Path> var1, @NotNull Set<? extends Path> var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$OwnListener;", "Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterServerListener;", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "managedServerStarted", "", "jupyterServerExecution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "targetedServerPath", "Ljava/nio/file/Path;", "serverPath", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$ServerPath$Targeted;", "managedServerStopped", "discovered", "connections", "", "Lcom/intellij/jupyter/core/jupyter/connections/management/DiscoveredServer;", "shutdown", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterRunningServersDirectoryMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$OwnListener\n+ 2 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper\n*L\n1#1,196:1\n40#2,10:197\n40#2,10:207\n*S KotlinDebug\n*F\n+ 1 JupyterRunningServersDirectoryMapper.kt\ncom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$OwnListener\n*L\n68#1:197,10\n106#1:207,10\n*E\n"})
    private static final class OwnListener
    implements JupyterServerListener,
    JupyterServerExecution.Listener {
        @NotNull
        private final Project project;

        public OwnListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void managedServerStarted(@NotNull JupyterServerExecution jupyterServerExecution, @NotNull JupyterConnectionParameters connectionParameters) {
            State state;
            Path path;
            Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
            Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
            JupyterConnectionParameters.ServerPath serverPath = connectionParameters.getServerPath();
            if (serverPath instanceof JupyterConnectionParameters.ServerPath.Local) {
                path = ((JupyterConnectionParameters.ServerPath.Local)serverPath).getPath();
            } else if (serverPath instanceof JupyterConnectionParameters.ServerPath.Targeted) {
                path = this.targetedServerPath(connectionParameters, (JupyterConnectionParameters.ServerPath.Targeted)serverPath);
            } else {
                if (serverPath == null) {
                    Attachment[] attachmentArray = new Attachment[]{new Attachment("connectionParameters.txt", connectionParameters.toString())};
                    throw new RuntimeExceptionWithAttachments("Received connection parameters without the server path", attachmentArray);
                }
                throw new NoWhenBranchMatchedException();
            }
            Path path2 = path;
            JupyterRunningServersDirectoryMapper this_$iv = Companion.instance(this.project);
            boolean $i$f$updateAndNotify = false;
            Ref.ObjectRef new$iv = new Ref.ObjectRef();
            State old$iv = (State)this_$iv.state.getAndUpdate(new UnaryOperator(new$iv, path2, connectionParameters, jupyterServerExecution){
                final /* synthetic */ Ref.ObjectRef $new;
                final /* synthetic */ Path $path$inlined;
                final /* synthetic */ JupyterConnectionParameters $connectionParameters$inlined;
                final /* synthetic */ JupyterServerExecution $jupyterServerExecution$inlined;
                {
                    this.$new = $new;
                    this.$path$inlined = path;
                    this.$connectionParameters$inlined = jupyterConnectionParameters;
                    this.$jupyterServerExecution$inlined = jupyterServerExecution;
                }

                /*
                 * WARNING - void declaration
                 */
                public final State apply(State old2) {
                    State state;
                    void oldState;
                    Intrinsics.checkNotNull((Object)old2);
                    State state2 = old2;
                    Ref.ObjectRef objectRef = this.$new;
                    boolean bl = false;
                    SmartFMap smartFMap = oldState.getLocationByDirectory().plus((Object)this.$path$inlined, (Object)this.$connectionParameters$inlined.getLocation());
                    Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"plus(...)");
                    SmartFMap smartFMap2 = oldState.getDirectoryByExecution().plus((Object)this.$jupyterServerExecution$inlined, (Object)this.$path$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)smartFMap2, (String)"plus(...)");
                    objectRef.element = new State((SmartFMap<Path, JupyterConnectionParameters.Location>)smartFMap, (SmartFMap<JupyterServerExecution, Path>)smartFMap2);
                    if (this.$new.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                        state = null;
                    } else {
                        state = (State)this.$new.element;
                    }
                    return state;
                }
            });
            SmartFMap<Path, JupyterConnectionParameters.Location> smartFMap = old$iv.getLocationByDirectory();
            if (new$iv.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                state = null;
            } else {
                state = (State)new$iv.element;
            }
            if (!Intrinsics.areEqual(smartFMap, state.getLocationByDirectory())) {
                State state2;
                Listener listener = (Listener)this_$iv.project.getMessageBus().syncPublisher(TOPIC);
                Set set = old$iv.getLocationByDirectory().keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                if (new$iv.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                    state2 = null;
                } else {
                    state2 = (State)new$iv.element;
                }
                Set set2 = state2.getLocationByDirectory().keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
                listener.connectionParametersByDirectoryChanged(set, set2);
            }
        }

        private final Path targetedServerPath(JupyterConnectionParameters connectionParameters, JupyterConnectionParameters.ServerPath.Targeted serverPath) {
            Path path;
            JupyterConnectionParameters.Ownership o = connectionParameters.getOwnership();
            if (Intrinsics.areEqual((Object)o, (Object)JupyterConnectionParameters.Ownership.NotStartedManaged.INSTANCE) || Intrinsics.areEqual((Object)o, (Object)JupyterConnectionParameters.Ownership.Unmanaged.INSTANCE)) {
                Attachment[] attachmentArray = new Attachment[]{new Attachment("connectionParameters.txt", connectionParameters.toString())};
                throw new RuntimeExceptionWithAttachments("Broken invariant: just started run-targeted managed server has wrong ownership " + o, attachmentArray);
            }
            if (o instanceof JupyterConnectionParameters.Ownership.StartedManaged) {
                block8: {
                    TargetEnvironment targetEnvironment = ((JupyterConnectionParameters.Ownership.StartedManaged)o).getTargetEnv();
                    if (targetEnvironment == null) {
                        Attachment[] attachmentArray = new Attachment[]{new Attachment("connectionParameters.txt", connectionParameters.toString())};
                        throw new RuntimeExceptionWithAttachments("Broken invariant: just started run-targeted managed server has no target environment", attachmentArray);
                    }
                    TargetEnvironment targetEnv = targetEnvironment;
                    if (!Intrinsics.areEqual((Object)targetEnv.getRequest().getConfiguration(), (Object)serverPath.getTargetEnvConf())) {
                        Attachment[] attachmentArray = new Attachment[]{new Attachment("connectionParameters.txt", connectionParameters.toString()), new Attachment("targetEnvRequest.txt", targetEnv.getRequest().toString())};
                        throw new RuntimeExceptionWithAttachments("Broken invariant: inconsistency of run target configurations", attachmentArray);
                    }
                    for (TargetEnvironment.UploadableVolume volume : (Iterable)targetEnv.getUploadVolumes().values()) {
                        boolean bl = false;
                        path = Intrinsics.areEqual((Object)volume.getTargetRoot(), (Object)serverPath.getPath()) ? volume.getLocalRoot() : null;
                        if (path == null) {
                            continue;
                        }
                        break block8;
                    }
                    path = null;
                }
                if (path == null) {
                    throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return path;
        }

        @Override
        public void managedServerStopped(@NotNull JupyterServerExecution jupyterServerExecution) {
            State state;
            Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
            JupyterRunningServersDirectoryMapper this_$iv = Companion.instance(this.project);
            boolean $i$f$updateAndNotify = false;
            Ref.ObjectRef new$iv = new Ref.ObjectRef();
            State old$iv = (State)this_$iv.state.getAndUpdate(new UnaryOperator(new$iv, jupyterServerExecution){
                final /* synthetic */ Ref.ObjectRef $new;
                final /* synthetic */ JupyterServerExecution $jupyterServerExecution$inlined;
                {
                    this.$new = $new;
                    this.$jupyterServerExecution$inlined = jupyterServerExecution;
                }

                /*
                 * WARNING - void declaration
                 */
                public final State apply(State old2) {
                    State state;
                    void oldState;
                    Intrinsics.checkNotNull((Object)old2);
                    State state2 = old2;
                    Ref.ObjectRef objectRef = this.$new;
                    boolean bl = false;
                    Path path = (Path)oldState.getDirectoryByExecution().get((Object)this.$jupyterServerExecution$inlined);
                    if (path != null) {
                        SmartFMap smartFMap = oldState.getDirectoryByExecution().minus((Object)this.$jupyterServerExecution$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"minus(...)");
                        SmartFMap smartFMap2 = smartFMap;
                        SmartFMap smartFMap3 = oldState.getLocationByDirectory().minus((Object)path);
                        Intrinsics.checkNotNullExpressionValue((Object)smartFMap3, (String)"minus(...)");
                        SmartFMap smartFMap4 = smartFMap3;
                        v2 = new State((SmartFMap<Path, JupyterConnectionParameters.Location>)smartFMap4, (SmartFMap<JupyterServerExecution, Path>)smartFMap2);
                    } else {
                        v2 = objectRef.element = state2;
                    }
                    if (this.$new.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                        state = null;
                    } else {
                        state = (State)this.$new.element;
                    }
                    return state;
                }
            });
            SmartFMap<Path, JupyterConnectionParameters.Location> smartFMap = old$iv.getLocationByDirectory();
            if (new$iv.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                state = null;
            } else {
                state = (State)new$iv.element;
            }
            if (!Intrinsics.areEqual(smartFMap, state.getLocationByDirectory())) {
                State state2;
                Listener listener = (Listener)this_$iv.project.getMessageBus().syncPublisher(TOPIC);
                Set set = old$iv.getLocationByDirectory().keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                if (new$iv.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                    state2 = null;
                } else {
                    state2 = (State)new$iv.element;
                }
                Set set2 = state2.getLocationByDirectory().keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
                listener.connectionParametersByDirectoryChanged(set, set2);
            }
        }

        @Override
        public void discovered(@NotNull Set<DiscoveredServer> connections) {
            Intrinsics.checkNotNullParameter(connections, (String)"connections");
            for (DiscoveredServer discoveredServer : connections) {
                BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.forProject(this.project), (CoroutineContext)((CoroutineContext)new CoroutineName(discoveredServer.toString())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(discoveredServer, this, null){
                    int label;
                    final /* synthetic */ DiscoveredServer $discoveredServer;
                    final /* synthetic */ OwnListener this$0;
                    {
                        this.$discoveredServer = $discoveredServer;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Ref.BooleanRef retry;
                                ResultKt.throwOnFailure((Object)object);
                                JupyterConnectionParameters.Location location = null;
                                JupyterConnectionParameters.ServerPath p = this.$discoveredServer.getServerPath();
                                if (!(p instanceof JupyterConnectionParameters.ServerPath.Local)) {
                                    if (p instanceof JupyterConnectionParameters.ServerPath.Targeted) {
                                        return Unit.INSTANCE;
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                Path path = ((JupyterConnectionParameters.ServerPath.Local)p).getPath();
                                location = new JupyterConnectionParameters.Location.Direct(this.$discoveredServer.getTargetUri());
                                do {
                                    State state;
                                    State state2;
                                    void location2;
                                    void this_$iv;
                                    retry = new Ref.BooleanRef();
                                    JupyterRunningServersDirectoryMapper jupyterRunningServersDirectoryMapper = JupyterRunningServersDirectoryMapper.Companion.instance(OwnListener.access$getProject$p(this.this$0));
                                    DiscoveredServer discoveredServer = this.$discoveredServer;
                                    boolean $i$f$updateAndNotify = false;
                                    Ref.ObjectRef new$iv = new Ref.ObjectRef();
                                    State old$iv = (State)JupyterRunningServersDirectoryMapper.access$getState$p((JupyterRunningServersDirectoryMapper)this_$iv).getAndUpdate(new UnaryOperator(new$iv, path, (JupyterConnectionParameters.Location)location2, discoveredServer, retry){
                                        final /* synthetic */ Ref.ObjectRef $new;
                                        final /* synthetic */ Path $path$inlined;
                                        final /* synthetic */ JupyterConnectionParameters.Location $location$inlined;
                                        final /* synthetic */ DiscoveredServer $discoveredServer$inlined;
                                        final /* synthetic */ Ref.BooleanRef $retry$inlined;
                                        {
                                            this.$new = $new;
                                            this.$path$inlined = path;
                                            this.$location$inlined = location;
                                            this.$discoveredServer$inlined = discoveredServer;
                                            this.$retry$inlined = booleanRef;
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final State apply(State old2) {
                                            State state;
                                            State state2;
                                            URI uRI;
                                            void oldState;
                                            JupyterConnectionParameters.Location oldLocation;
                                            Intrinsics.checkNotNull((Object)old2);
                                            State state3 = old2;
                                            Ref.ObjectRef objectRef = this.$new;
                                            boolean bl = false;
                                            JupyterConnectionParameters.Location location = oldLocation = (JupyterConnectionParameters.Location)oldState.getLocationByDirectory().get((Object)this.$path$inlined);
                                            URI uRI2 = uRI = location != null ? location.getUri() : null;
                                            if (uRI == null) {
                                                SmartFMap smartFMap = oldState.getLocationByDirectory().plus((Object)this.$path$inlined, (Object)this.$location$inlined);
                                                Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"plus(...)");
                                                state2 = State.copy$default((State)oldState, smartFMap, null, 2, null);
                                            } else if (Intrinsics.areEqual((Object)uRI, (Object)this.$discoveredServer$inlined.getTargetUri())) {
                                                state2 = oldState;
                                            } else {
                                                JupyterRunningServersDirectoryMapper.access$getLOG$cp().info("Server running on " + this.$path$inlined + " changed URL: " + oldLocation + " -> " + this.$location$inlined);
                                                this.$retry$inlined.element = true;
                                                SmartFMap smartFMap = oldState.getLocationByDirectory().minus((Object)this.$path$inlined);
                                                Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"minus(...)");
                                                state2 = State.copy$default((State)oldState, smartFMap, null, 2, null);
                                            }
                                            objectRef.element = state2;
                                            if (this.$new.element == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                                                state = null;
                                            } else {
                                                state = (State)this.$new.element;
                                            }
                                            return state;
                                        }
                                    });
                                    SmartFMap<Path, JupyterConnectionParameters.Location> smartFMap = old$iv.getLocationByDirectory();
                                    if (new$iv.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                                        state2 = null;
                                    } else {
                                        state2 = (State)new$iv.element;
                                    }
                                    if (Intrinsics.areEqual(smartFMap, state2.getLocationByDirectory())) continue;
                                    Listener listener = (Listener)JupyterRunningServersDirectoryMapper.access$getProject$p((JupyterRunningServersDirectoryMapper)this_$iv).getMessageBus().syncPublisher(JupyterRunningServersDirectoryMapper.TOPIC);
                                    Set set = old$iv.getLocationByDirectory().keySet();
                                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                                    if (new$iv.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                                        state = null;
                                    } else {
                                        state = (State)new$iv.element;
                                    }
                                    Set set2 = state.getLocationByDirectory().keySet();
                                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
                                    listener.connectionParametersByDirectoryChanged(set, set2);
                                } while (retry.element);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }

        @Override
        public void shutdown(@NotNull Set<DiscoveredServer> connections) {
            Intrinsics.checkNotNullParameter(connections, (String)"connections");
            for (DiscoveredServer shutdownServer : connections) {
                BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.forProject(this.project), (CoroutineContext)((CoroutineContext)new CoroutineName(shutdownServer.toString())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(shutdownServer, this, null){
                    int label;
                    final /* synthetic */ DiscoveredServer $shutdownServer;
                    final /* synthetic */ OwnListener this$0;
                    {
                        this.$shutdownServer = $shutdownServer;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                State state;
                                ResultKt.throwOnFailure((Object)object);
                                JupyterConnectionParameters.ServerPath p = this.$shutdownServer.getServerPath();
                                if (!(p instanceof JupyterConnectionParameters.ServerPath.Local)) {
                                    if (p instanceof JupyterConnectionParameters.ServerPath.Targeted) {
                                        return Unit.INSTANCE;
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                Path path = ((JupyterConnectionParameters.ServerPath.Local)p).getPath();
                                JupyterRunningServersDirectoryMapper this_$iv = JupyterRunningServersDirectoryMapper.Companion.instance(OwnListener.access$getProject$p(this.this$0));
                                boolean $i$f$updateAndNotify = false;
                                Ref.ObjectRef new$iv = new Ref.ObjectRef();
                                State old$iv = (State)JupyterRunningServersDirectoryMapper.access$getState$p(this_$iv).getAndUpdate(new UnaryOperator(new$iv, path){
                                    final /* synthetic */ Ref.ObjectRef $new;
                                    final /* synthetic */ Path $path$inlined;
                                    {
                                        this.$new = $new;
                                        this.$path$inlined = path;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final State apply(State old2) {
                                        State state;
                                        State state2;
                                        void oldState;
                                        Intrinsics.checkNotNull((Object)old2);
                                        State state3 = old2;
                                        Ref.ObjectRef objectRef = this.$new;
                                        boolean bl = false;
                                        JupyterConnectionParameters.Location oldLocation = (JupyterConnectionParameters.Location)oldState.getLocationByDirectory().get((Object)this.$path$inlined);
                                        if (oldLocation != null) {
                                            SmartFMap smartFMap = oldState.getLocationByDirectory().minus((Object)this.$path$inlined);
                                            Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"minus(...)");
                                            state2 = State.copy$default((State)oldState, smartFMap, null, 2, null);
                                        } else {
                                            state2 = oldState;
                                        }
                                        objectRef.element = state2;
                                        if (this.$new.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                                            state = null;
                                        } else {
                                            state = (State)this.$new.element;
                                        }
                                        return state;
                                    }
                                });
                                SmartFMap<Path, JupyterConnectionParameters.Location> smartFMap = old$iv.getLocationByDirectory();
                                if (new$iv.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                                    state = null;
                                } else {
                                    state = (State)new$iv.element;
                                }
                                if (!Intrinsics.areEqual(smartFMap, state.getLocationByDirectory())) {
                                    State state2;
                                    Listener listener = (Listener)JupyterRunningServersDirectoryMapper.access$getProject$p(this_$iv).getMessageBus().syncPublisher(JupyterRunningServersDirectoryMapper.TOPIC);
                                    Set set = old$iv.getLocationByDirectory().keySet();
                                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                                    if (new$iv.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"new");
                                        state2 = null;
                                    } else {
                                        state2 = (State)new$iv.element;
                                    }
                                    Set set2 = state2.getLocationByDirectory().keySet();
                                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
                                    listener.connectionParametersByDirectoryChanged(set, set2);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }

        public static final /* synthetic */ Project access$getProject$p(OwnListener $this) {
            return $this.project;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J5\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/management/JupyterRunningServersDirectoryMapper$State;", "", "locationByDirectory", "Lcom/intellij/util/SmartFMap;", "Ljava/nio/file/Path;", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;", "directoryByExecution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "<init>", "(Lcom/intellij/util/SmartFMap;Lcom/intellij/util/SmartFMap;)V", "getLocationByDirectory", "()Lcom/intellij/util/SmartFMap;", "getDirectoryByExecution", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.jupyter.core"})
    private static final class State {
        @NotNull
        private final SmartFMap<Path, JupyterConnectionParameters.Location> locationByDirectory;
        @NotNull
        private final SmartFMap<JupyterServerExecution, Path> directoryByExecution;

        public State(@NotNull SmartFMap<Path, JupyterConnectionParameters.Location> locationByDirectory, @NotNull SmartFMap<JupyterServerExecution, Path> directoryByExecution) {
            Intrinsics.checkNotNullParameter(locationByDirectory, (String)"locationByDirectory");
            Intrinsics.checkNotNullParameter(directoryByExecution, (String)"directoryByExecution");
            this.locationByDirectory = locationByDirectory;
            this.directoryByExecution = directoryByExecution;
        }

        @NotNull
        public final SmartFMap<Path, JupyterConnectionParameters.Location> getLocationByDirectory() {
            return this.locationByDirectory;
        }

        @NotNull
        public final SmartFMap<JupyterServerExecution, Path> getDirectoryByExecution() {
            return this.directoryByExecution;
        }

        @NotNull
        public final SmartFMap<Path, JupyterConnectionParameters.Location> component1() {
            return this.locationByDirectory;
        }

        @NotNull
        public final SmartFMap<JupyterServerExecution, Path> component2() {
            return this.directoryByExecution;
        }

        @NotNull
        public final State copy(@NotNull SmartFMap<Path, JupyterConnectionParameters.Location> locationByDirectory, @NotNull SmartFMap<JupyterServerExecution, Path> directoryByExecution) {
            Intrinsics.checkNotNullParameter(locationByDirectory, (String)"locationByDirectory");
            Intrinsics.checkNotNullParameter(directoryByExecution, (String)"directoryByExecution");
            return new State(locationByDirectory, directoryByExecution);
        }

        public static /* synthetic */ State copy$default(State state, SmartFMap smartFMap, SmartFMap smartFMap2, int n, Object object) {
            if ((n & 1) != 0) {
                smartFMap = state.locationByDirectory;
            }
            if ((n & 2) != 0) {
                smartFMap2 = state.directoryByExecution;
            }
            return state.copy(smartFMap, smartFMap2);
        }

        @NotNull
        public String toString() {
            return "State(locationByDirectory=" + this.locationByDirectory + ", directoryByExecution=" + this.directoryByExecution + ")";
        }

        public int hashCode() {
            int result2 = this.locationByDirectory.hashCode();
            result2 = result2 * 31 + this.directoryByExecution.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.locationByDirectory, state.locationByDirectory)) {
                return false;
            }
            return Intrinsics.areEqual(this.directoryByExecution, state.directoryByExecution);
        }
    }
}

