/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.execution;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterRemoteServersSettingsListener;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.execution.JupyterRunningNotebookTracker;
import com.intellij.jupyter.core.jupyter.execution.SessionPoller;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 .2\u00020\u0001:\u0005*+,-.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0007J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0001H\u0007J\u0006\u0010#\u001a\u00020\u001fJ\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "observedServers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/URI;", "Lcom/intellij/jupyter/core/jupyter/execution/SessionPoller;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootsBackref", "job", "Lkotlinx/coroutines/CompletableJob;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "backgroundSessionUpdateIntervalMillis", "", "getBackgroundSessionUpdateIntervalMillis", "()J", "setBackgroundSessionUpdateIntervalMillis", "(J)V", "getRoot", "uri", "isRunning", "", "file", "path", "", "dispose", "", "reset", "disable", "testDisposable", "refresh", "doReset", "terminal", "createOrTick", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "removeIfPresent", "RuntimeServiceListener", "RemoteServersSettingsListener", "ManagedServerListener", "Listener", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRunningNotebookTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1863#2,2:348\n*S KotlinDebug\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker\n*L\n106#1:348,2\n*E\n"})
public final class JupyterRunningNotebookTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<URI, SessionPoller> observedServers = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<URI, VirtualFile> roots = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<VirtualFile, URI> rootsBackref = new ConcurrentHashMap();
    @NotNull
    private volatile CompletableJob job = JobKt.Job$default(null, (int)1, null);
    private volatile long backgroundSessionUpdateIntervalMillis = 30000L;
    public static final long DEFAULT_BACKGROUND_SESSION_UPDATE_INTERVAL_MILLIS = 30000L;

    private final CoroutineContext getCoroutineContext() {
        CoroutineContext coroutineContext = this.job.plus((CoroutineContext)Dispatchers.getIO());
        String string = JupyterRunningNotebookTracker.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return coroutineContext.plus((CoroutineContext)new CoroutineName(string));
    }

    public final long getBackgroundSessionUpdateIntervalMillis() {
        return this.backgroundSessionUpdateIntervalMillis;
    }

    public final void setBackgroundSessionUpdateIntervalMillis(long l) {
        this.backgroundSessionUpdateIntervalMillis = l;
    }

    @Nullable
    public final VirtualFile getRoot(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.roots.get(uri);
    }

    public final boolean isRunning(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl2 = bl = !(file instanceof BackedVirtualFile);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object currentPath = string;
        for (VirtualFile parentFile : SequencesKt.generateSequence((Object)file.getParent(), (Function1)isRunning.1.INSTANCE)) {
            URI uri = this.rootsBackref.get(parentFile);
            if (uri != null) {
                return this.isRunning(uri, (String)currentPath);
            }
            currentPath = parentFile.getName() + "/" + (String)currentPath;
        }
        return false;
    }

    public final boolean isRunning(@NotNull URI uri, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = this.observedServers.get(uri);
        return object != null && (object = ((SessionPoller)object).getSessions()) != null ? object.contains(path) : false;
    }

    public void dispose() {
        this.doReset(true);
    }

    @TestOnly
    public final void reset() {
        this.doReset(false);
    }

    @TestOnly
    public final void disable(@NotNull Disposable testDisposable) {
        Intrinsics.checkNotNullParameter((Object)testDisposable, (String)"testDisposable");
        Disposer.register((Disposable)testDisposable, () -> JupyterRunningNotebookTracker.disable$lambda$0(this));
        JobKt.cancel$default((Job)((Job)this.job), (String)"Disabled in test", null, (int)2, null);
    }

    public final void refresh() {
        Collection<SessionPoller> collection = this.observedServers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SessionPoller it = (SessionPoller)element$iv;
            boolean bl = false;
            it.startOrTick();
        }
    }

    private final void doReset(boolean terminal) {
        Set set = this.observedServers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        CompletableJob completableJob = CollectionsKt.toList((Iterable)set).iterator();
        while (completableJob.hasNext()) {
            URI uri = (URI)completableJob.next();
            Intrinsics.checkNotNull((Object)uri);
            this.removeIfPresent(uri);
        }
        this.roots.clear();
        this.rootsBackref.clear();
        CompletableJob it = completableJob = this.job;
        boolean bl = false;
        if (!terminal) {
            this.job = JobKt.Job$default(null, (int)1, null);
        }
        Job.DefaultImpls.cancel$default((Job)((Job)it), null, (int)1, null);
    }

    private final void createOrTick(JupyterConnectionParameters connectionParameters) {
        SessionPoller sessionPoller2 = new SessionPoller(this.getCoroutineContext(), connectionParameters, (Function0<Long>)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((JupyterRunningNotebookTracker)this.receiver).getBackgroundSessionUpdateIntervalMillis();
            }

            public void set(Object value) {
                ((JupyterRunningNotebookTracker)this.receiver).setBackgroundSessionUpdateIntervalMillis(((Number)value).longValue());
            }
        }));
        SessionPoller sessionPoller3 = this.observedServers.putIfAbsent(connectionParameters.getLocation().getUri(), sessionPoller2);
        if (sessionPoller3 == null) {
            sessionPoller3 = sessionPoller2;
        }
        sessionPoller3.startOrTick();
    }

    private final void removeIfPresent(URI uri) {
        block0: {
            SessionPoller sessionPoller2 = this.observedServers.remove(uri);
            if (sessionPoller2 == null) break block0;
            sessionPoller2.stop();
        }
    }

    private static final void disable$lambda$0(JupyterRunningNotebookTracker this$0) {
        this$0.reset();
    }

    @NotNull
    public static final JupyterRunningNotebookTracker getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Companion;", "", "<init>", "()V", "DEFAULT_BACKGROUND_SESSION_UPDATE_INTERVAL_MILLIS", "", "instance", "Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker;", "getInstance$annotations", "getInstance", "()Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterRunningNotebookTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,347:1\n40#2,3:348\n*S KotlinDebug\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Companion\n*L\n222#1:348,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterRunningNotebookTracker getInstance() {
            boolean $i$f$service = false;
            Class<JupyterRunningNotebookTracker> serviceClass$iv = JupyterRunningNotebookTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JupyterRunningNotebookTracker)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Listener;", "", "sessionStarted", "", "connParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "path", "", "sessionStopped", "Companion", "intellij.jupyter.core"})
    public static interface Listener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @NotNull
        public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.TO_CHILDREN);

        public void sessionStarted(@NotNull JupyterConnectionParameters var1, @NotNull String var2);

        public void sessionStopped(@NotNull JupyterConnectionParameters var1, @NotNull String var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Listener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Listener;", "kotlin.jvm.PlatformType", "intellij.jupyter.core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$ManagedServerListener;", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution$Listener;", "<init>", "()V", "executionToConnectionParameters", "", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "managedServerStarted", "", "jupyterServerExecution", "connectionParameters", "managedServerStopped", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterRunningNotebookTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$ManagedServerListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,347:1\n1#2:348\n*E\n"})
    private static final class ManagedServerListener
    implements JupyterServerExecution.Listener {
        @NotNull
        private final Map<JupyterServerExecution, JupyterConnectionParameters> executionToConnectionParameters = new ConcurrentHashMap();

        @Override
        public void managedServerStarted(@NotNull JupyterServerExecution jupyterServerExecution, @NotNull JupyterConnectionParameters connectionParameters) {
            Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
            Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
            this.executionToConnectionParameters.put(jupyterServerExecution, connectionParameters);
            Companion.getInstance().createOrTick(connectionParameters);
        }

        @Override
        public void managedServerStopped(@NotNull JupyterServerExecution jupyterServerExecution) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
                Object object = this.executionToConnectionParameters.get(jupyterServerExecution);
                if (object == null || (object = ((JupyterConnectionParameters)object).getLocation()) == null || (object = object.getUri()) == null) break block0;
                Object object2 = object;
                JupyterRunningNotebookTracker jupyterRunningNotebookTracker = Companion.getInstance();
                Object p0 = object2;
                boolean $i$f$managedServerStopped$stub_for_inlining = false;
                boolean bl = false;
                jupyterRunningNotebookTracker.removeIfPresent((URI)p0);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$RemoteServersSettingsListener;", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterRemoteServersSettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "changed", "", "oldSettings", "", "", "Lcom/intellij/jupyter/core/jupyter/connections/settings/ConfiguredServerJupyterModuleConnectionSettings;", "newSettings", "intellij.jupyter.core"})
    private static final class RemoteServersSettingsListener
    implements JupyterRemoteServersSettingsListener {
        public RemoteServersSettingsListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        }

        @Override
        public void changed(@NotNull Map<String, ConfiguredServerJupyterModuleConnectionSettings> oldSettings, @NotNull Map<String, ConfiguredServerJupyterModuleConnectionSettings> newSettings) {
            ConfiguredServerJupyterModuleConnectionSettings settings;
            String key;
            Intrinsics.checkNotNullParameter(oldSettings, (String)"oldSettings");
            Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
            JupyterRunningNotebookTracker service = Companion.getInstance();
            for (Map.Entry<String, ConfiguredServerJupyterModuleConnectionSettings> entry : oldSettings.entrySet()) {
                key = entry.getKey();
                settings = entry.getValue();
                if (newSettings.containsKey(key)) continue;
                service.removeIfPresent(settings.getUri());
            }
            for (Map.Entry<String, ConfiguredServerJupyterModuleConnectionSettings> entry : newSettings.entrySet()) {
                key = entry.getKey();
                settings = entry.getValue();
                if (oldSettings.containsKey(key)) continue;
                service.createOrTick(new JupyterConnectionParameters(new JupyterConnectionParameters.Location.Direct(settings.getUri()), false, null, settings.getAuthHandler(), null, null, null, 102, null));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$RuntimeServiceListener;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/notebook/JupyterRuntimeService$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionCreated", "", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "sessionDeleted", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterRunningNotebookTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$RuntimeServiceListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,347:1\n1#2:348\n1104#3,3:349\n*S KotlinDebug\n*F\n+ 1 JupyterRunningNotebookTracker.kt\ncom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$RuntimeServiceListener\n*L\n145#1:349,3\n*E\n"})
    private static final class RuntimeServiceListener
    implements JupyterRuntimeService.Listener {
        public RuntimeServiceListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sessionCreated(@NotNull JupyterNotebookSession session) {
            void $this$count$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            JupyterRunningNotebookTracker tracker = Companion.getInstance();
            JupyterConnectionParameters connectionParameters = session.getJupyterServer().getConnectionParameters();
            URI uri = connectionParameters.getLocation().getUri();
            boolean bl2 = bl = !StringsKt.contains$default((CharSequence)session.getPathFromRoot(), (char)'\\', (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JupyterRunningNotebookTracker$RuntimeServiceListener$sessionCreated$22 = false;
                String $i$a$-assert-JupyterRunningNotebookTracker$RuntimeServiceListener$sessionCreated$22 = session.getPathFromRoot();
                throw new AssertionError((Object)$i$a$-assert-JupyterRunningNotebookTracker$RuntimeServiceListener$sessionCreated$22);
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile = session.getVirtualFile();
            CharSequence $i$a$-assert-JupyterRunningNotebookTracker$RuntimeServiceListener$sessionCreated$22 = session.getPathFromRoot();
            Sequence sequence = SequencesKt.generateSequence((Object)(backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getOriginFile() : null), (Function1)sessionCreated.rootFile.1.INSTANCE);
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl3 = false;
                if (!(it == '/')) continue;
                ++count$iv;
            }
            int n = count$iv;
            VirtualFile rootFile2 = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.drop((Sequence)sequence, (int)(n + 1)));
            if (rootFile2 != null) {
                ((Map)tracker.roots).put(uri, rootFile2);
                ((Map)tracker.rootsBackref).put(rootFile2, uri);
            }
            tracker.createOrTick(connectionParameters);
        }

        @Override
        public void sessionDeleted(@NotNull JupyterNotebookSession session) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                SessionPoller sessionPoller2 = (SessionPoller)Companion.getInstance().observedServers.get(session.getJupyterServer().getConnectionParameters().getLocation().getUri());
                if (sessionPoller2 == null) break block0;
                sessionPoller2.startOrTick();
            }
        }
    }
}

