/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.jupyter.core.editor.markdown.Heading;
import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.jupyter.helper.OtherKt;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureItemPresentation;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewModel;
import com.intellij.navigation.ItemPresentation;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010,\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "model", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;)V", "mdParser", "Lorg/intellij/markdown/parser/MarkdownParser;", "rootPresentation", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureItemPresentation;", "parentStack", "", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "settingsInstance", "Lcom/intellij/jupyter/core/editor/settings/JupyterDSSettings;", "headingTypes", "", "Lorg/intellij/markdown/IElementType;", "", "getChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "handleHeading", "", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "headingInfo", "Lcom/intellij/jupyter/core/editor/markdown/Heading;", "rootChildren", "handleCodeCell", "getHeadingInfo", "", "extractMarkdownHeadingInfo", "extractCodeHeadingInfo", "extractTextContent", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "collectTextNodes", "isRunningNow", "", "isHeading", "getHeadingLevel", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getValue", "", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewRoot.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,144:1\n1863#2,2:145\n774#2:149\n865#2,2:150\n1368#2:152\n1454#2,5:153\n1368#2:158\n1454#2,5:159\n37#3,2:147\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewRoot.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot\n*L\n47#1:145,2\n122#1:149\n122#1:150,2\n123#1:152\n123#1:153,5\n130#1:158\n130#1:159,5\n51#1:147,2\n*E\n"})
public final class JupyterStructureViewRoot
implements StructureViewTreeElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterFile psiFile;
    @NotNull
    private final JupyterStructureViewModel model;
    @NotNull
    private final MarkdownParser mdParser;
    @NotNull
    private final JupyterStructureItemPresentation rootPresentation;
    @NotNull
    private final List<JupyterStructureViewCellElement> parentStack;
    @NotNull
    private final JupyterDSSettings settingsInstance;
    @NotNull
    private final Map<IElementType, Integer> headingTypes;
    private static final int CODE_CELL_HEADING_LEVEL = 7;
    @NotNull
    private static final String CODE_CELL_HEADING_PREFIX = "# ";
    @NotNull
    private static final Regex HTML_TAG_REGEX = new Regex("<[^>]*>");

    public JupyterStructureViewRoot(@NotNull JupyterFile psiFile, @NotNull JupyterStructureViewModel model) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.psiFile = psiFile;
        this.model = model;
        this.mdParser = new MarkdownParser((MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, false, 7, null));
        this.rootPresentation = new JupyterStructureItemPresentation(this.psiFile.getName(), null, null, 0);
        this.parentStack = new ArrayList();
        this.settingsInstance = JupyterDSSettings.Companion.getInstance();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)1), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)2), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)3), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)4), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)5), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)6), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_1, (Object)1), TuplesKt.to((Object)MarkdownElementTypes.SETEXT_2, (Object)2)};
        this.headingTypes = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public TreeElement[] getChildren() {
        List rootChildren = new ArrayList();
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        if (!NotebookCellLines.Companion.hasSupport(document)) {
            return new TreeElement[0];
        }
        Document document2 = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getFileDocument(...)");
        List intervals = NotebookCellLines.Companion.get(document2).getIntervals();
        for (NotebookCellLines.Interval interval : intervals) {
            List<Heading> headingInfos = this.getHeadingInfo(interval);
            Iterable $this$forEach$iv = headingInfos;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Heading headingInfo = (Heading)element$iv;
                boolean bl = false;
                this.handleHeading(interval, headingInfo, rootChildren);
            }
            if (OtherKt.toJupyterCellType(interval.getType()) != JupyterCellType.CODE) continue;
            this.handleCodeCell(interval);
        }
        Collection $this$toTypedArray$iv = rootChildren;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TreeElement[0]);
    }

    private final void handleHeading(NotebookCellLines.Interval cell, Heading headingInfo, List<JupyterStructureViewCellElement> rootChildren) {
        JupyterStructureViewCellElement element = new JupyterStructureViewCellElement(cell, headingInfo.getHeader(), headingInfo.getLevel(), null, this.model);
        if (this.isRunningNow(cell)) {
            element.markAsExecuting();
        }
        while (!((Collection)this.parentStack).isEmpty() && ((JupyterStructureViewCellElement)CollectionsKt.last(this.parentStack)).getLevel() >= headingInfo.getLevel()) {
            this.parentStack.remove(this.parentStack.size() - 1);
        }
        boolean bl = !((Collection)this.parentStack).isEmpty() ? ((JupyterStructureViewCellElement)CollectionsKt.last(this.parentStack)).addChild((TreeElement)element) : rootChildren.add(element);
        this.model.setIntervalToComponent(cell, element);
        this.parentStack.add(element);
    }

    private final void handleCodeCell(NotebookCellLines.Interval cell) {
        JupyterStructureViewCellElement jupyterStructureViewCellElement = (JupyterStructureViewCellElement)CollectionsKt.lastOrNull(this.parentStack);
        if (jupyterStructureViewCellElement == null) {
            return;
        }
        JupyterStructureViewCellElement closestHeading = jupyterStructureViewCellElement;
        closestHeading.associateInterval(cell);
        this.model.setIntervalToComponent(cell, closestHeading);
        if (this.isRunningNow(cell)) {
            closestHeading.markAsExecuting();
        }
    }

    private final List<Heading> getHeadingInfo(NotebookCellLines.Interval cell) {
        return switch (WhenMappings.$EnumSwitchMapping$0[OtherKt.toJupyterCellType(cell.getType()).ordinal()]) {
            case 1 -> {
                Heading heading;
                Heading v0 = heading = this.extractCodeHeadingInfo(cell);
                if (v0 == null) {
                    yield CollectionsKt.emptyList();
                }
                yield CollectionsKt.listOf((Object)v0);
            }
            case 2 -> this.extractMarkdownHeadingInfo(cell);
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<Heading> extractMarkdownHeadingInfo(NotebookCellLines.Interval cell) {
        IElementType iElementType = new IElementType("ROOT");
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        ASTNode parsedTree = MarkdownParser.parse$default((MarkdownParser)this.mdParser, (IElementType)iElementType, (String)cell.getContentText(document), (boolean)false, (int)4, null);
        List headings = new ArrayList();
        for (ASTNode node : parsedTree.getChildren()) {
            if (!this.isHeading(node)) continue;
            String title = this.extractTextContent(node, cell);
            headings.add(new Heading(this.getHeadingLevel(node), title));
        }
        return headings;
    }

    private final Heading extractCodeHeadingInfo(NotebookCellLines.Interval cell) {
        Heading heading;
        if (!this.settingsInstance.getShowPythonCellsInStructure()) {
            return null;
        }
        Document document = this.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        String source = cell.getContentText(document);
        String string = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)source));
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return null;
        }
        String firstLine = string;
        if (StringsKt.startsWith$default((String)firstLine, (String)CODE_CELL_HEADING_PREFIX, (boolean)false, (int)2, null)) {
            String title = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)firstLine, (CharSequence)CODE_CELL_HEADING_PREFIX))).toString();
            int ordinal = cell.getOrdinal() + 1;
            String header = ordinal + ". " + title;
            heading = new Heading(7, header);
        } else {
            heading = null;
        }
        return heading;
    }

    /*
     * WARNING - void declaration
     */
    private final String extractTextContent(ASTNode node, NotebookCellLines.Interval cell) {
        void $this$flatMapTo$iv$iv;
        ASTNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"ATX_HEADER"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectTextNodes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, arg_0 -> JupyterStructureViewRoot.extractTextContent$lambda$3(cell, this, arg_0), (int)30, null);
        Regex regex = HTML_TAG_REGEX;
        object = "";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, (String)object))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> collectTextNodes(ASTNode node) {
        List list;
        if (Intrinsics.areEqual((Object)node.getType().getName(), (Object)"TEXT")) {
            list = CollectionsKt.listOf((Object)node);
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = node.getChildren();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ASTNode it = (ASTNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.collectTextNodes(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final boolean isRunningNow(NotebookCellLines.Interval cell) {
        Integer n = this.model.retrieveExecutingCellOrdinal();
        return n != null && cell.getOrdinal() == n.intValue();
    }

    private final boolean isHeading(ASTNode node) {
        return this.headingTypes.containsKey(node.getType());
    }

    private final int getHeadingLevel(ASTNode node) {
        Integer n = this.headingTypes.get(node.getType());
        if (n == null) {
            throw new IllegalStateException("Node is not a heading".toString());
        }
        return n;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)this.rootPresentation;
    }

    @NotNull
    public Object getValue() {
        String string = this.psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final CharSequence extractTextContent$lambda$3(NotebookCellLines.Interval $cell, JupyterStructureViewRoot this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Document document = this$0.psiFile.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        return StringsKt.trim((CharSequence)ASTUtilKt.getTextInNode((ASTNode)it, (CharSequence)$cell.getContentText(document)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewRoot$Companion;", "", "<init>", "()V", "CODE_CELL_HEADING_LEVEL", "", "CODE_CELL_HEADING_PREFIX", "", "HTML_TAG_REGEX", "Lkotlin/text/Regex;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

