/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramNode<T>
extends UserDataHolder,
Iconable {
    @NotNull
    public static final Key<Boolean> SELECTED_NODE_KEY = Key.create((String)"SELECTED_NODE_KEY");

    @NotNull
    public T getIdentifyingElement();

    @NotNull
    public DiagramProvider<T> getProvider();

    @Nullable
    @Nls
    public String getTooltip();

    @NotNull
    default public List<NodeLabel> getLabels() {
        List<NodeLabel> list = Collections.emptyList();
        if (list == null) {
            DiagramNode.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public Icon getIcon();

    @Nullable
    default public Icon getIcon(int ignoredFlags) {
        return this.getIcon();
    }

    @Nullable
    default public SimpleColoredText getIconAsText() {
        return null;
    }

    @Nullable
    default public SimpleColoredText getPresentableTitle() {
        DiagramElementManager<T> elementManager = this.getProvider().getElementManager();
        T element = this.getIdentifyingElement();
        String presentableName = elementManager.getElementTitle(element);
        int textStyle = elementManager instanceof AbstractDiagramElementManager ? ((AbstractDiagramElementManager)elementManager).getTitleAttributes(element) : 0;
        return presentableName != null ? new SimpleColoredText(presentableName, new SimpleTextAttributes(textStyle, null)) : null;
    }

    @Nullable
    default public Color getFileTabForeground() {
        return null;
    }

    @Nullable
    default public VisibilityLevel getVisibilityLevel() {
        return null;
    }

    @Nullable
    default public String getQualifiedName() {
        return this.getProvider().getVfsResolver().getQualifiedName(this.getIdentifyingElement());
    }

    default public void precachePresentation() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramNode", "getLabels"));
    }
}

