/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u000e\u001a\u00020\nH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u0013\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/microservices/url/UrlPath;", "", "segments", "", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "UrlPath", "(Ljava/util/List;)V", "getSegments", "()Ljava/util/List;", "getPresentation", "", "pathVariableRenderer", "Lcom/intellij/microservices/url/UrlPath$PathSegmentRenderer;", "toStringWithStars", "toString", "canBePrefixFor", "", "another", "commonLength", "", "isCompatibleWith", "equals", "other", "hashCode", "PathSegment", "PathSegmentRenderer", "Companion", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n360#2,7:338\n1734#2,3:346\n1#3:345\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath\n*L\n153#1:338,7\n183#1:346,3\n*E\n"})
public final class UrlPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathSegment> segments;
    @NotNull
    private static final UrlPath EMPTY = new UrlPath(CollectionsKt.listOf((Object)new PathSegment.Exact("")));
    @NotNull
    private static final String STAR = "*";
    @NotNull
    private static final String UNKNOWN = "<???>";
    @NotNull
    public static final String UNKNOWN_URL_PATH_SEGMENT_PRESENTATION = "${..}";
    @JvmField
    @NotNull
    public static final PathSegmentRenderer DEFAULT_PATH_VARIABLE_PRESENTATION = new PathSegmentRenderer(){

        public String visitVariable(PathSegment.Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return "*";
        }
    };
    @JvmField
    @NotNull
    public static final PathSegmentRenderer FULL_PATH_VARIABLE_PRESENTATION = new PathSegmentRenderer(){

        public String visitVariable(PathSegment.Variable variable) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            boolean bl = false;
            CharSequence charSequence = variable.getVariableName();
            if (charSequence == null || charSequence.length() == 0) {
                v0 = stringBuilder2.append("*");
            } else {
                stringBuilder2.append("{");
                stringBuilder2.append(variable.getVariableName());
                v0 = stringBuilder2.append("}");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    };

    public UrlPath(@NotNull List<? extends PathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
    }

    @NotNull
    public final List<PathSegment> getSegments() {
        return this.segments;
    }

    @NlsSafe
    @NotNull
    public final String getPresentation() {
        return this.getPresentation(DEFAULT_PATH_VARIABLE_PRESENTATION);
    }

    @NlsSafe
    @NotNull
    public final String getPresentation(@NotNull PathSegmentRenderer pathVariableRenderer) {
        Intrinsics.checkNotNullParameter((Object)pathVariableRenderer, (String)"pathVariableRenderer");
        return CollectionsKt.joinToString$default((Iterable)this.segments, (CharSequence)"/", null, null, (int)0, null, arg_0 -> UrlPath.Q(pathVariableRenderer, arg_0), (int)30, null);
    }

    @NotNull
    public final String toStringWithStars() {
        return CollectionsKt.joinToString$default((Iterable)this.segments, (CharSequence)"/", null, null, (int)0, null, UrlPath::Q, (int)30, null);
    }

    @NotNull
    public String toString() {
        return "UrlPath(" + this.toStringWithStars() + ")";
    }

    public final boolean canBePrefixFor(@NotNull UrlPath another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return this.commonLength(another) == this.segments.size();
    }

    public final int commonLength(@NotNull UrlPath another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return UrlPath.Q(another, this.segments, 0, 0);
    }

    public final boolean isCompatibleWith(@NotNull UrlPath another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return UrlPath.Q(this.segments, another.segments);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.url.UrlPath");
        UrlPath cfr_ignored_0 = (UrlPath)other;
        return Intrinsics.areEqual(this.segments, ((UrlPath)other).segments);
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    private static final CharSequence Q(PathSegmentRenderer pathSegmentRenderer, PathSegment pathSegment) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"segment");
        return pathSegmentRenderer.patternMatch(pathSegment);
    }

    private static final CharSequence Q(PathSegment pathSegment) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"it");
        PathSegment pathSegment2 = pathSegment;
        if (pathSegment2 instanceof PathSegment.Exact) {
            charSequence = ((PathSegment.Exact)pathSegment).getValue();
        } else if (pathSegment2 instanceof PathSegment.Variable) {
            charSequence = STAR;
        } else if (pathSegment2 instanceof PathSegment.Composite) {
            charSequence = STAR;
        } else if (Intrinsics.areEqual((Object)pathSegment2, (Object)PathSegment.Undefined.INSTANCE)) {
            charSequence = UNKNOWN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }

    private static final int Q(UrlPath urlPath, List<? extends PathSegment> list, int n2, int n3) {
        while (UtilKt.headTailOrNull(list) != null) {
            PathSegment pathSegment;
            int n4;
            Pair pair;
            PathSegment pathSegment2 = (PathSegment)pair.component1();
            List list2 = (List)pair.component2();
            List<PathSegment> list3 = urlPath.segments.subList(n2, urlPath.segments.size());
            if (pathSegment2 instanceof PathSegment.Exact) {
                int n5;
                int n6;
                int n7;
                Object object;
                block12: {
                    object = list3;
                    n7 = 0;
                    n6 = 0;
                    Iterator<PathSegment> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        PathSegment pathSegment3;
                        PathSegment pathSegment4 = pathSegment3 = iterator.next();
                        boolean bl = false;
                        if (pathSegment4 instanceof PathSegment.Exact) {
                            n5 = n6;
                            break block12;
                        }
                        ++n6;
                    }
                    n5 = -1;
                }
                object = n5;
                n7 = ((Number)object).intValue();
                n6 = 0;
                Object object2 = n7 != -1 ? object : null;
                if (object2 == null) {
                    return n3;
                }
                int n8 = (Integer)object2;
                PathSegment pathSegment5 = list3.get(n8);
                Intrinsics.checkNotNull((Object)pathSegment5, (String)"null cannot be cast to non-null type com.intellij.microservices.url.UrlPath.PathSegment.Exact");
                PathSegment.Exact exact = (PathSegment.Exact)pathSegment5;
                if (Intrinsics.areEqual((Object)exact, (Object)pathSegment2)) {
                    n4 = n2 + n8 + 1;
                    n7 = n3 + 1;
                    list = list2;
                    n2 = n4;
                    n3 = n7;
                    continue;
                }
                if (((CharSequence)((PathSegment.Exact)pathSegment2).getValue()).length() == 0) {
                    n4 = n2;
                    n7 = n3 + 1;
                    list = list2;
                    n2 = n4;
                    n3 = n7;
                    continue;
                }
                Object object3 = CollectionsKt.firstOrNull(list3);
                PathSegment.Variable variable = object3 instanceof PathSegment.Variable ? (PathSegment.Variable)object3 : null;
                boolean bl = variable != null ? variable.accepts(((PathSegment.Exact)pathSegment2).getValue()) : false;
                if (bl) {
                    n4 = n2 + 1;
                    n7 = n3 + 1;
                    list = list2;
                    n2 = n4;
                    n3 = n7;
                    continue;
                }
                if (CollectionsKt.firstOrNull(list3) instanceof PathSegment.Undefined) {
                    n4 = n2 + 1;
                    n7 = n3 + 1;
                    list = list2;
                    n2 = n4;
                    n3 = n7;
                    continue;
                }
                return n3;
            }
            if ((PathSegment)CollectionsKt.firstOrNull(list3) == null) {
                return n3;
            }
            if (!(pathSegment instanceof PathSegment.Exact)) {
                int n9 = n2 + 1;
                n4 = n3 + 1;
                list = list2;
                n2 = n9;
                n3 = n4;
                continue;
            }
            int n10 = n2;
            n4 = n3 + 1;
            list = list2;
            n2 = n10;
            n3 = n4;
        }
        return n3;
    }

    private static final boolean Q(PathSegment pathSegment) {
        return pathSegment instanceof PathSegment.Exact && Intrinsics.areEqual((Object)((PathSegment.Exact)pathSegment).getValue(), (Object)"");
    }

    private static final boolean Q(List<? extends PathSegment> list) {
        boolean bl;
        block3: {
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t2 : iterable) {
                    PathSegment pathSegment = (PathSegment)t2;
                    boolean bl3 = false;
                    if (UrlPath.Q(pathSegment) || pathSegment instanceof PathSegment.Undefined) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return !bl;
    }

    private static final boolean Q(List<? extends PathSegment> list, List<? extends PathSegment> list2) {
        block19: {
            while (true) {
                Pair pair;
                Pair pair2;
                if (list.isEmpty() && !UrlPath.Q(list2)) {
                    return true;
                }
                if (list2.isEmpty() && !UrlPath.Q(list)) {
                    return true;
                }
                if (list.isEmpty() && list2.isEmpty()) {
                    return true;
                }
                if (UtilKt.headTailOrNull(list) == null) {
                    return false;
                }
                PathSegment pathSegment = (PathSegment)pair2.component1();
                List list3 = (List)pair2.component2();
                if (UtilKt.headTailOrNull(list2) == null) {
                    return false;
                }
                PathSegment pathSegment2 = (PathSegment)pair.component1();
                List<? extends PathSegment> list4 = (List<? extends PathSegment>)pair.component2();
                if (UrlPath.Q(pathSegment)) {
                    List<? extends PathSegment> list5 = UrlPath.Q(pathSegment2) ? list4 : list2;
                    list = list3;
                    list2 = list5;
                    continue;
                }
                if (UrlPath.Q(pathSegment2)) {
                    list = UrlPath.Q(pathSegment) ? list3 : list;
                    list2 = list4;
                    continue;
                }
                if (pathSegment instanceof PathSegment.Undefined && pathSegment2 instanceof PathSegment.Undefined) {
                    list = list3;
                    list2 = list4;
                    continue;
                }
                if (pathSegment instanceof PathSegment.Undefined && UrlPath.Q(list3) || pathSegment2 instanceof PathSegment.Undefined && UrlPath.Q(list4)) {
                    list = list3;
                    list2 = list4;
                    continue;
                }
                if (pathSegment instanceof PathSegment.Undefined && !UrlPath.Q(list3)) {
                    return true;
                }
                if (pathSegment2 instanceof PathSegment.Undefined && !UrlPath.Q(list4)) {
                    return true;
                }
                if (pathSegment instanceof PathSegment.Variable && pathSegment2 instanceof PathSegment.Variable) {
                    list = list3;
                    list2 = list4;
                    continue;
                }
                if (pathSegment instanceof PathSegment.Variable && pathSegment2 instanceof PathSegment.Exact) {
                    if (((PathSegment.Variable)pathSegment).accepts(((PathSegment.Exact)pathSegment2).getValue())) {
                        list = list3;
                        list2 = list4;
                        continue;
                    }
                    return false;
                }
                if (pathSegment instanceof PathSegment.Exact && pathSegment2 instanceof PathSegment.Variable) {
                    if (((PathSegment.Variable)pathSegment2).accepts(((PathSegment.Exact)pathSegment).getValue())) {
                        list = list3;
                        list2 = list4;
                        continue;
                    }
                    return false;
                }
                if (pathSegment instanceof PathSegment.Exact && pathSegment2 instanceof PathSegment.Exact) {
                    if (Intrinsics.areEqual((Object)((PathSegment.Exact)pathSegment).getValue(), (Object)((PathSegment.Exact)pathSegment2).getValue())) {
                        list = list3;
                        list2 = list4;
                        continue;
                    }
                    return false;
                }
                if (!(pathSegment instanceof PathSegment.Composite) || !(pathSegment2 instanceof PathSegment.Composite)) break block19;
                if (!new UrlPath(((PathSegment.Composite)pathSegment).getSegments()).isCompatibleWith(new UrlPath(((PathSegment.Composite)pathSegment2).getSegments()))) break;
                list = list3;
                list2 = list4;
            }
            return false;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final UrlPath fromExactString(@NotNull String string) {
        return Companion.fromExactString(string);
    }

    @JvmStatic
    @NotNull
    public static final Sequence<UrlPath> combinations(@NotNull UrlPath urlPath) {
        return Companion.combinations(urlPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/url/UrlPath$Companion;", "", "UrlPath$Companion", "()V", "EMPTY", "Lcom/intellij/microservices/url/UrlPath;", "getEMPTY", "()Lcom/intellij/microservices/url/UrlPath;", "STAR", "", "UNKNOWN", "UNKNOWN_URL_PATH_SEGMENT_PRESENTATION", "DEFAULT_PATH_VARIABLE_PRESENTATION", "Lcom/intellij/microservices/url/UrlPath$PathSegmentRenderer;", "FULL_PATH_VARIABLE_PRESENTATION", "fromExactString", "string", "combinations", "Lkotlin/sequences/Sequence;", "urlPath", "intellij.microservices"})
    @SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,337:1\n1557#2:338\n1628#2,3:339\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath$Companion\n*L\n254#1:338\n254#1:339,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UrlPath getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        @NotNull
        public final UrlPath fromExactString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Object object = new String[]{"/"};
            object = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            Object object2 = object;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            boolean bl2 = false;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                String string2 = (String)t2;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new PathSegment.Exact(string2));
            }
            List list = (List)collection;
            return new UrlPath(list);
        }

        @JvmStatic
        @NotNull
        public final Sequence<UrlPath> combinations(@NotNull UrlPath urlPath) {
            Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super UrlPath>, Continuation<? super Unit>, Object>(urlPath, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ UrlPath $urlPath;
                {
                    this.$urlPath = $urlPath;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = (SequenceScope)this.L$0;
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.yield((Object)this.$urlPath, (Continuation)this);
                            if (v0 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            var2_3 = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            v1 = (PathSegment)CollectionsKt.firstOrNull(this.$urlPath.getSegments());
                            v2 = v1 != null ? v1.isEmpty() : false;
                            if (v2) {
                                this.L$0 = var2_3;
                                this.label = 2;
                                v3 = var2_3.yield((Object)new UrlPath(this.$urlPath.getSegments().subList(1, this.$urlPath.getSegments().size())), (Continuation)this);
                                if (v3 == var12_2) {
                                    return var12_2;
                                }
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            var2_3 = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl29:
                            // 2 sources

                            var5_4 = this.$urlPath.getSegments();
                            var6_5 = 0;
                            var7_6 = 0;
                            var8_7 = var5_4.iterator();
                            while (var8_7.hasNext()) {
                                var10_9 = var9_8 = var8_7.next();
                                var11_10 = false;
                                if (!Intrinsics.areEqual((Object)var10_9, (Object)PathSegment.Undefined.INSTANCE)) ** GOTO lbl39
                                v4 = var7_6;
                                ** GOTO lbl42
lbl39:
                                // 1 sources

                                ++var7_6;
                            }
                            v4 = -1;
lbl42:
                            // 2 sources

                            var5_4 = Boxing.boxInt((int)v4);
                            var6_5 = ((Number)var5_4).intValue();
                            var7_6 = 0;
                            v5 = var6_5 != -1 != false ? var5_4 : null;
                            if (v5 == null) {
                                return Unit.INSTANCE;
                            }
                            var3_11 = v5.intValue();
                            var4_12 = this.$urlPath.getSegments().subList(0, var3_11);
                            var5_4 = this.$urlPath.getSegments().subList(var3_11 + 1, this.$urlPath.getSegments().size());
                            this.L$0 = null;
                            this.label = 3;
                            v6 = var2_3.yieldAll(UrlPath.Companion.combinations(new UrlPath(CollectionsKt.plus((Collection)var4_12, (Iterable)var5_4))), (Continuation)this);
                            if (v6 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl60
                        }
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl60:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super UrlPath> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment;", "", "UrlPath$PathSegment", "()V", "valueIfExact", "", "getValueIfExact", "()Ljava/lang/String;", "isEmpty", "", "Exact", "Variable", "Composite", "Undefined", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Exact;", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Undefined;", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Variable;", "intellij.microservices"})
    public static abstract class PathSegment {
        private PathSegment() {
        }

        @Nullable
        public final String getValueIfExact() {
            Exact exact = this instanceof Exact ? (Exact)this : null;
            return exact != null ? exact.getValue() : null;
        }

        public final boolean isEmpty() {
            String string = this.getValueIfExact();
            return string != null ? ((CharSequence)string).length() == 0 : false;
        }

        public /* synthetic */ PathSegment(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "segments", "", "UrlPath$PathSegment$Composite", "(Ljava/util/List;)V", "getSegments", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.microservices"})
        public static final class Composite
        extends PathSegment {
            @NotNull
            private final List<PathSegment> segments;

            public Composite(@NotNull List<? extends PathSegment> segments) {
                Intrinsics.checkNotNullParameter(segments, (String)"segments");
                super(null);
                this.segments = segments;
            }

            @NotNull
            public final List<PathSegment> getSegments() {
                return this.segments;
            }

            public boolean equals(@Nullable Object other) {
                Composite composite = other instanceof Composite ? (Composite)other : null;
                return Intrinsics.areEqual(composite != null ? composite.segments : null, this.segments);
            }

            public int hashCode() {
                return ((Object)this.segments).hashCode();
            }

            @NotNull
            public String toString() {
                return "PathSegment.Composite(" + this.segments + ")";
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Exact;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "value", "", "UrlPath$PathSegment$Exact", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.microservices"})
        public static final class Exact
        extends PathSegment {
            @NotNull
            private final String value;

            public Exact(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public boolean equals(@Nullable Object other) {
                Exact exact = other instanceof Exact ? (Exact)other : null;
                return Intrinsics.areEqual((Object)(exact != null ? exact.value : null), (Object)this.value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            @NotNull
            public String toString() {
                return "PathSegment.Exact(" + this.value + ")";
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Undefined;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "UrlPath$PathSegment$Undefined", "()V", "intellij.microservices"})
        public static final class Undefined
        extends PathSegment {
            @NotNull
            public static final Undefined INSTANCE = new Undefined();

            private Undefined() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0003R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Variable;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "variableName", "", "regex", "UrlPath$PathSegment$Variable", "(Ljava/lang/String;Ljava/lang/String;)V", "getVariableName", "()Ljava/lang/String;", "getRegex", "equals", "", "other", "", "hashCode", "", "toString", "accepts", "value", "intellij.microservices"})
        public static final class Variable
        extends PathSegment {
            @Nullable
            private final String variableName;
            @Nullable
            private final String regex;

            public Variable(@Nullable String variableName, @Nullable String regex) {
                super(null);
                this.variableName = variableName;
                this.regex = regex;
            }

            public /* synthetic */ Variable(String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @Nullable
            public final String getVariableName() {
                return this.variableName;
            }

            @Nullable
            public final String getRegex() {
                return this.regex;
            }

            public boolean equals(@Nullable Object other) {
                Variable variable = other instanceof Variable ? (Variable)other : null;
                return Intrinsics.areEqual((Object)(variable != null ? variable.variableName : null), (Object)this.variableName);
            }

            public int hashCode() {
                String string = this.variableName;
                return string != null ? string.hashCode() : 0;
            }

            @NotNull
            public String toString() {
                return "PathSegment.Variable({" + this.variableName + "})";
            }

            public final boolean accepts(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegmentRenderer;", "", "visitExact", "", "exact", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Exact;", "visitVariable", "variable", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Variable;", "visitUndefined", "visitComposite", "composite", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "patternMatch", "segment", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "intellij.microservices"})
    public static interface PathSegmentRenderer {
        @NotNull
        default public String visitExact(@NotNull PathSegment.Exact exact) {
            Intrinsics.checkNotNullParameter((Object)exact, (String)"exact");
            return exact.getValue();
        }

        @NotNull
        default public String visitVariable(@NotNull PathSegment.Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return UrlPath.STAR;
        }

        @NotNull
        default public String visitUndefined() {
            return UrlPath.UNKNOWN_URL_PATH_SEGMENT_PRESENTATION;
        }

        @NotNull
        default public String visitComposite(@NotNull PathSegment.Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
            return CollectionsKt.joinToString$default((Iterable)composite.getSegments(), (CharSequence)"", null, null, (int)0, null, arg_0 -> PathSegmentRenderer.Q(this, arg_0), (int)30, null);
        }

        @NotNull
        default public String patternMatch(@NotNull PathSegment segment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            PathSegment pathSegment = segment;
            if (pathSegment instanceof PathSegment.Exact) {
                string = this.visitExact((PathSegment.Exact)segment);
            } else if (pathSegment instanceof PathSegment.Variable) {
                string = this.visitVariable((PathSegment.Variable)segment);
            } else if (pathSegment instanceof PathSegment.Composite) {
                string = this.visitComposite((PathSegment.Composite)segment);
            } else if (Intrinsics.areEqual((Object)pathSegment, (Object)PathSegment.Undefined.INSTANCE)) {
                string = this.visitUndefined();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private static CharSequence Q(PathSegmentRenderer pathSegmentRenderer, PathSegment pathSegment) {
            Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"s");
            return pathSegmentRenderer.patternMatch(pathSegment);
        }
    }
}

