/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.BaseIndex;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexedFileContentLoader;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.IndexedFilesCollectorKt;
import com.intellij.indexing.shared.generator.IndexedFilesCollectorParameters;
import com.intellij.indexing.shared.generator.IndexedFilesHashingTask;
import com.intellij.indexing.shared.generator.IndexedFilesReporter;
import com.intellij.indexing.shared.generator.IndexesExporterBasesLoaderKt;
import com.intellij.indexing.shared.generator.SharedIndexBase;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lcom/intellij/indexing/shared/generator/IndexedFilesCollectorParameters;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "reporter", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "useBaseIndex", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generator/IndexedFilesCollectorParameters;Lcom/intellij/indexing/shared/generator/ErrorsCollector;Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;Z)V", "collectFilesForIndexing", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "fileContentLoader", "Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;", "processDuplicateHashes", "files", "processBaseSharedIndex", "collectAllFilesForIndexing", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexedFilesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedFilesCollector.kt\ncom/intellij/indexing/shared/generator/IndexedFilesCollector\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,145:1\n126#2:146\n153#2,3:147\n17#3,6:150\n17#3,6:156\n1498#4:162\n1528#4,3:163\n1531#4,3:173\n1246#4,4:178\n1454#4,5:189\n381#5,7:166\n462#5:176\n412#5:177\n535#5:182\n520#5,6:183\n487#5,7:194\n13#6,8:201\n13#6,8:209\n*S KotlinDebug\n*F\n+ 1 IndexedFilesCollector.kt\ncom/intellij/indexing/shared/generator/IndexedFilesCollector\n*L\n43#1:146\n43#1:147,3\n54#1:150,6\n62#1:156,6\n82#1:162\n82#1:163,3\n82#1:173,3\n82#1:178,4\n84#1:189,5\n82#1:166,7\n82#1:176\n82#1:177\n83#1:182\n83#1:183,6\n94#1:194,7\n100#1:201,8\n121#1:209,8\n*E\n"})
public final class IndexedFilesCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final IndexedFilesCollectorParameters parameters;
    @NotNull
    private final ErrorsCollector errorsCollector;
    @Nullable
    private final IndexedFilesReporter reporter;
    private final boolean useBaseIndex;

    public IndexedFilesCollector(@NotNull Project project, @NotNull IndexedFilesCollectorParameters parameters, @NotNull ErrorsCollector errorsCollector, @Nullable IndexedFilesReporter reporter, boolean useBaseIndex) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.project = project;
        this.parameters = parameters;
        this.errorsCollector = errorsCollector;
        this.reporter = reporter;
        this.useBaseIndex = useBaseIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<HashedIndexedFiles, Integer> collectFilesForIndexing(@NotNull ProgressIndicator indicator, @NotNull IndexedFileContentLoader fileContentLoader) {
        int knownHashSize;
        Object indexesFiles;
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)fileContentLoader, (String)"fileContentLoader");
            Instant startCollecting = Instant.now();
            Map<IndexableFilesIterator, Set<VirtualFile>> providerToFiles = this.collectAllFilesForIndexing(indicator);
            Duration timeCollecting = Duration.between(startCollecting, Instant.now());
            Map<IndexableFilesIterator, Set<VirtualFile>> map = providerToFiles;
            Logger logger = IndexedFilesCollectorKt.access$getLOG$p();
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Set)it.getValue()).size());
            }
            logger.info("All files for indexing (" + CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)) + " in " + providerToFiles.size() + " providers) have been collected in " + StringUtil.formatDuration((Duration)timeCollecting));
            Instant startFiltering = Instant.now();
            indexesFiles = null;
            indexesFiles = new IndexedFilesHashingTask(this.project, this.parameters, fileContentLoader, this.errorsCollector).computeFileHashes(indicator, providerToFiles);
            Duration timeFiltering = Duration.between(startFiltering, Instant.now());
            IndexedFilesCollectorKt.access$getLOG$p().info("File filtering and content hashing have been finished in " + StringUtil.formatDuration((Duration)timeFiltering));
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            indexesFiles = this.processDuplicateHashes((HashedIndexedFiles)indexesFiles, indicator);
            long duplicateHashesTime = System.currentTimeMillis() - start$iv;
            IndexedFilesCollectorKt.access$getLOG$p().info("Precessing of duplicate hashes took " + StringUtil.formatDuration((long)duplicateHashesTime));
            knownHashSize = 0;
            if (this.useBaseIndex) {
                boolean $i$f$measureTimeMillis2 = false;
                long start$iv2 = System.currentTimeMillis();
                boolean bl2 = false;
                Pair<HashedIndexedFiles, Integer> it = this.processBaseSharedIndex((HashedIndexedFiles)indexesFiles, indicator);
                boolean bl3 = false;
                indexesFiles = it.getFirst();
                knownHashSize = ((Number)it.getSecond()).intValue();
                long basesTime = System.currentTimeMillis() - start$iv2;
                IndexedFilesCollectorKt.access$getLOG$p().info("Precessing of base shared indexes took " + StringUtil.formatDuration((long)basesTime));
            }
            IndexedFilesReporter indexedFilesReporter = this.reporter;
            if (indexedFilesReporter != null) {
                indexedFilesReporter.dumpEmptyFiles((HashedIndexedFiles)indexesFiles, indicator);
            }
            IndexedFilesReporter indexedFilesReporter2 = this.reporter;
            if (indexedFilesReporter2 != null) {
                indexedFilesReporter2.dumpProjectRoots(this.project, indicator);
            }
            IndexedFilesReporter indexedFilesReporter3 = this.reporter;
            if (indexedFilesReporter3 == null) break block4;
            indexedFilesReporter3.dumpFilesForIndex(this.project, (HashedIndexedFiles)indexesFiles, indicator);
        }
        return TuplesKt.to((Object)indexesFiles, (Object)(knownHashSize + ((HashedIndexedFiles)indexesFiles).getAllHashes().size()));
    }

    /*
     * WARNING - void declaration
     */
    private final HashedIndexedFiles processDuplicateHashes(HashedIndexedFiles files, ProgressIndicator indicator) {
        void $this$filterKeys$iv;
        HashSet it;
        Map<VirtualFile, IndexedFileHash> $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        Map hashToFiles;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map.Entry it2;
        Object object2;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        if (this.reporter == null && !this.parameters.getExcludeFilesWithHashCollision()) {
            return files;
        }
        Object $this$groupBy$iv = files.getHashes().entrySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object3;
            Map.Entry it22 = (Map.Entry)t;
            boolean $i$a$-groupBy-IndexedFilesCollector$processDuplicateHashes$hashToFiles$332 = false;
            key$iv$iv = (IndexedFileHash)it22.getValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            Map.Entry $i$a$-groupBy-IndexedFilesCollector$processDuplicateHashes$hashToFiles$332 = (Map.Entry)t;
            object2 = list$iv$iv;
            boolean bl = false;
            object2.add((VirtualFile)it2.getKey());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it3;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object2 = map;
            boolean bl22 = false;
            object = CollectionsKt.toHashSet((Iterable)((Iterable)it3.getValue()));
            object2.put(k, object);
        }
        Map $this$filter$iv = hashToFiles = destination$iv$iv;
        boolean $i$f$filter232 = false;
        destination$iv$iv = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it2 = element$iv$iv = iterator.next();
            boolean bl3 = false;
            if (!(((HashSet)it2.getValue()).size() >= 2)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map filesToSkip = destination$iv$iv2;
        Iterable $i$f$filter232 = filesToSkip.values();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        Iterator<Object> iterator2 = $this$flatMapTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            it = (HashSet)t;
            boolean bl4 = false;
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet ignoredFiles = (HashSet)destination$iv;
        IndexedFilesReporter indexedFilesReporter = this.reporter;
        if (indexedFilesReporter != null) {
            indexedFilesReporter.dumpHashCollisionFiles(filesToSkip, indicator);
        }
        IndexedFilesCollectorKt.access$getLOG$p().info("Found " + ignoredFiles.size() + " files with same hashes using " + filesToSkip.size() + " unique hashes");
        if (!this.parameters.getExcludeFilesWithHashCollision()) {
            return files;
        }
        $this$flatMapTo$iv = files.getHashes();
        object = files.getByProvider();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            it = (VirtualFile)entry.getKey();
            boolean bl5 = false;
            if (!(!ignoredFiles.contains(it))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        List<SharedIndexContentHash> list = files.getUsedHashes();
        List<SharedIndexBase> list2 = files.getUsedBases();
        Map map = result$iv;
        Object object4 = object;
        return new HashedIndexedFiles((Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>>)object4, map, list2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<HashedIndexedFiles, Integer> processBaseSharedIndex(HashedIndexedFiles files, ProgressIndicator indicator) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            BaseIndex baseIndex = this.parameters.getBase();
            if (baseIndex == null) {
                throw new IllegalStateException();
            }
            BaseIndex baseIndex2 = baseIndex;
            Path path = baseIndex2.getPath();
            if (path == null) {
                throw new IllegalStateException();
            }
            Path baseIndexPath = path;
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
            Intrinsics.checkNotNullExpressionValue((Object)sharedIndexInfrastructureVersion, (String)"getIdeVersion(...)");
            SharedIndexInfrastructureVersion ideVersion = sharedIndexInfrastructureVersion;
            SharedIndexBase baseSharedIndex = IndexesExporterBasesLoaderKt.loadSharedIndexAsBase(baseIndexPath, ideVersion, this.parameters.getTempDir());
            IndexedFilesCollectorKt.access$getLOG$p().info("Loaded base shared index: " + baseSharedIndex + " to process already indexed file hashes");
            HashedIndexedFiles deltaToBeIndexed = new HashedIndexedFiles(files.getByProvider(), baseSharedIndex.keepOnlyUnknownHashes(files.getHashes()), CollectionsKt.plus((Collection)files.getUsedBases(), (Object)baseSharedIndex), files.getUsedHashes());
            IndexedFilesCollectorKt.access$getLOG$p().info("Using " + deltaToBeIndexed.getUsedBases() + " as base");
            Pair pair = TuplesKt.to((Object)deltaToBeIndexed, (Object)baseSharedIndex.getKnownHashCount());
            return pair;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<IndexableFilesIterator, Set<VirtualFile>> collectAllFilesForIndexing(ProgressIndicator indicator) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(true);
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.collecting.files.to.index", (Object[])new Object[0]));
            HashMap providerToFiles = new HashMap();
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
            Intrinsics.checkNotNullExpressionValue((Object)indexableFilesDeduplicateFilter, (String)"create(...)");
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter2 = indexableFilesDeduplicateFilter;
            List<IndexableFilesIterator> roots = this.parameters.getIndexableFilesIterators();
            for (IndexableFilesIterator root : roots) {
                indicator.setText2(root.getRootsScanningProgressText());
                HashSet providerFiles = new HashSet();
                root.iterateFiles(this.project, arg_0 -> IndexedFilesCollector.collectAllFilesForIndexing$lambda$12$lambda$11(providerFiles, arg_0), (VirtualFileFilter)indexableFilesDeduplicateFilter2);
                ((Map)providerToFiles).put(root, providerFiles);
            }
            Map map = providerToFiles;
            return map;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    private static final boolean collectAllFilesForIndexing$lambda$12$lambda$11(HashSet $providerFiles, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isDirectory()) {
            ((Collection)$providerFiles).add(file);
        }
        return true;
    }
}

