/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.references;

import com.intellij.httpClient.http.request.environment.HttpClientCustomVariable;
import com.intellij.httpClient.http.request.environment.HttpClientCustomVariableDeclarationProviders;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentFileNames;
import com.intellij.httpClient.http.request.microservices.endpoints.EmbeddedHttpClientEditor;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.psi.HttpVariableBase;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public final class HttpRequestPsiReferencesUtil {
    private HttpRequestPsiReferencesUtil() {
    }

    public static ResolveResult @NotNull [] getResolveResults(@NotNull Project project, PsiFile containingFile, String name, @NotNull PsiElement context) {
        String selectedEnvironment;
        if (project == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(1);
        }
        if (EmbeddedHttpClientEditor.isInEmbeddedHttpClientEditor((PsiElement)containingFile)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                HttpRequestPsiReferencesUtil.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (StringUtil.isEmpty((String)name)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                HttpRequestPsiReferencesUtil.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ArrayList<ResolveResult> resultFromEnv = new ArrayList<ResolveResult>();
        String string = selectedEnvironment = containingFile.getVirtualFile() != null ? HttpClientSelectedEnvironments.getInstance(project).get(containingFile.getVirtualFile()) : null;
        if (selectedEnvironment != null && !HttpClientSelectedEnvironments.isSelectBeforeRun(selectedEnvironment)) {
            HttpClientEnvironmentsProvider.EnvironmentDescriptor environment = HttpClientEnvironmentsProvider.INSTANCE.getByName(containingFile, selectedEnvironment);
            if (environment != null) {
                HttpRequestPsiReferencesUtil.addVariableDefinitions(name, environment, resultFromEnv);
            }
        } else if (containingFile.getVirtualFile() != null) {
            Iterator<HttpClientEnvironmentsProvider.EnvironmentDescriptor> defaultEnvironment;
            String defaultEnv = HttpRequestEnvironment.getDefaultEnvName(project);
            if (StringUtil.isNotEmpty((String)defaultEnv) && (defaultEnvironment = HttpClientEnvironmentsProvider.INSTANCE.getByName(containingFile, defaultEnv)) != null) {
                HttpRequestPsiReferencesUtil.addVariableDefinitions(name, defaultEnvironment, resultFromEnv);
            }
            for (HttpClientEnvironmentsProvider.EnvironmentDescriptor environment : HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(containingFile).asList()) {
                if (StringUtil.equals((CharSequence)environment.getName(), (CharSequence)defaultEnv)) continue;
                HttpRequestPsiReferencesUtil.addVariableDefinitions(name, environment, resultFromEnv);
            }
        }
        ArrayList<ResolveResult> resultFromScripts = new ArrayList<ResolveResult>();
        for (HttpClientCustomVariable variable : HttpClientCustomVariableDeclarationProviders.getAllCustomDeclarationForContext(name, context)) {
            resultFromScripts.add((ResolveResult)new PsiElementResolveResult(variable.getDeclaration()));
        }
        ArrayList<Object> resultFromFile = new ArrayList<Object>();
        List<HttpFileVariable> fileVariables = HttpClientFileVariableStorage.Companion.findVariableIn(containingFile, name);
        for (HttpFileVariable fileVariable : fileVariables) {
            resultFromFile.add(new PsiElementResolveResult((PsiElement)fileVariable));
        }
        if (!resultFromFile.isEmpty()) {
            if (HttpRequestPsiReferencesUtil.isReferencesOwnDeclaration(context) && !resultFromEnv.isEmpty()) {
                resultFromEnv.addAll(resultFromScripts);
                return HttpRequestPsiReferencesUtil.toArray(resultFromEnv);
            }
            resultFromFile.addAll(resultFromScripts);
            ResolveResult[] resolveResultArray = resultFromFile.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                HttpRequestPsiReferencesUtil.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        if (!resultFromEnv.isEmpty()) {
            resultFromEnv.addAll(resultFromScripts);
            ResolveResult[] resolveResultArray = resultFromEnv.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                HttpRequestPsiReferencesUtil.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        return HttpRequestPsiReferencesUtil.toArray(resultFromScripts);
    }

    private static boolean isReferencesOwnDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(6);
        }
        if (!(element instanceof HttpVariable)) {
            return false;
        }
        HttpVariable variable = (HttpVariable)element;
        HttpFileVariable fileDeclaration = (HttpFileVariable)PsiTreeUtil.getParentOfType((PsiElement)variable, HttpFileVariable.class);
        if (fileDeclaration == null) {
            return false;
        }
        return fileDeclaration.getName() != null && StringUtil.equals((CharSequence)fileDeclaration.getName(), (CharSequence)variable.getName());
    }

    private static ResolveResult @NotNull [] toArray(@NotNull List<ResolveResult> results) {
        if (results == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(7);
        }
        ResolveResult[] resolveResultArray = !results.isEmpty() ? results.toArray(ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    private static void addVariableDefinitions(@NotNull String name, @NotNull HttpClientEnvironmentsProvider.EnvironmentDescriptor environment, @NotNull List<ResolveResult> result2) {
        if (name == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(11);
        }
        ArrayList<JsonProperty> values = new ArrayList<JsonProperty>();
        for (Pair<PsiFile, Set<String>> fileAndVariables : environment.getFilesContent()) {
            JsonFile jsonFile;
            JsonValue root;
            JsonObject environmentObj;
            JsonProperty property;
            PsiFile file = (PsiFile)fileAndVariables.getFirst();
            Set variables2 = (Set)fileAndVariables.getSecond();
            if (!variables2.contains(name) || !(file instanceof JsonFile) || (property = (environmentObj = (root = (jsonFile = (JsonFile)file).getTopLevelValue()) instanceof JsonObject ? (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)((JsonObject)root), (String)environment.getName(), JsonObject.class) : null) != null ? environmentObj.findProperty(name) : null) == null) continue;
            values.add(property);
        }
        boolean hasPrivate = ContainerUtil.exists(values, value2 -> HttpRequestEnvironmentFileNames.isPrivateEnvFile(value2.getContainingFile().getName()));
        for (JsonProperty property : values) {
            if (hasPrivate && !HttpRequestEnvironmentFileNames.isPrivateEnvFile(property.getContainingFile().getName())) continue;
            result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)property));
        }
    }

    public static boolean doesVariableReferenceToElement(HttpVariableBase variable, @NotNull PsiElement element) {
        HttpFileVariable fileVariable;
        JsonProperty property;
        if (element == null) {
            HttpRequestPsiReferencesUtil.$$$reportNull$$$0(12);
        }
        if (element instanceof JsonProperty && StringUtil.equals((CharSequence)(property = (JsonProperty)element).getName(), (CharSequence)variable.getName()) && element.isValid() && element.isPhysical()) {
            if (variable.getName() != null && !HttpClientFileVariableStorage.Companion.findVariableIn(variable.getContainingFile(), variable.getName()).isEmpty() && !HttpRequestPsiReferencesUtil.isReferencesOwnDeclaration((PsiElement)variable)) {
                return false;
            }
            PsiFile file = element.getContainingFile();
            return file != null && HttpRequestEnvironmentFileNames.isHttpRequestEnvFile(file.getVirtualFile());
        }
        if (element instanceof HttpFileVariable && StringUtil.equals((CharSequence)(fileVariable = (HttpFileVariable)element).getName(), (CharSequence)variable.getName())) {
            if (!HttpRequestPsiReferencesUtil.isReferencesOwnDeclaration((PsiElement)variable)) {
                return variable.getContainingFile() == fileVariable.getContainingFile();
            }
            return variable.resolve() == element;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/psi/references/HttpRequestPsiReferencesUtil";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/psi/references/HttpRequestPsiReferencesUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferencesOwnDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVariableDefinitions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doesVariableReferenceToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

