/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpFileRuntimeConfigurationProducer
extends HttpRequestRuntimeConfigurationProducer {
    protected boolean setupConfigurationFromContext(@NotNull HttpRequestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile containingFile;
        if (configuration == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((containingFile = (PsiFile)context.getDataContext().getData(CommonDataKeys.PSI_FILE)) instanceof HttpRequestPsiFile) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
            if (virtualFile == null) {
                return false;
            }
            sourceElement.set((Object)containingFile);
            HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
            settings.setFilePath(virtualFile.getFileSystem().getProtocol().equals("jar") ? virtualFile.getUrl() : virtualFile.getPath());
            settings.setRunType(HttpRequestRunType.ALL_IN_FILE);
            configuration.setName(configuration.suggestedName());
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(@NotNull HttpRequestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement location;
        if (configuration == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((location = context.getPsiLocation()) != null && location.getContainingFile() instanceof HttpRequestPsiFile) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)location);
            if (location instanceof HttpRequestPsiFile) {
                return HttpFileRuntimeConfigurationProducer.isConfigurationFromFile(configuration, virtualFile);
            }
            HttpClientExecutionBlock executionElement = HttpFileRuntimeConfigurationProducer.findHttpExecutionElement(location);
            return HttpFileRuntimeConfigurationProducer.isConfigurationFromFile(configuration, virtualFile) && (executionElement == null || HttpFileRuntimeConfigurationProducer.getExecutionIndex(executionElement) == -1);
        }
        return false;
    }

    @Override
    protected boolean checkExistingConfiguration(@Nullable RunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (context == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (configuration instanceof HttpRequestRunConfiguration) {
            HttpRequestRunConfiguration runConfiguration = (HttpRequestRunConfiguration)configuration;
            Location location = context.getLocation();
            if (runConfiguration.getSettings().isDefaultEnvironment() && location != null && HttpFileRuntimeConfigurationProducer.isConfigurationFromFile(runConfiguration, location.getVirtualFile())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isConfigurationFromFile(@NotNull HttpRequestRunConfiguration configuration, @Nullable VirtualFile virtualFile) {
        if (configuration == null) {
            HttpFileRuntimeConfigurationProducer.$$$reportNull$$$0(6);
        }
        HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
        return virtualFile != null && FileUtil.pathsEqual((String)settings.getFilePath(), (String)virtualFile.getPath()) && HttpRequestRunType.ALL_IN_FILE.equals((Object)settings.getRunType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpFileRuntimeConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExistingConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

