/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.test;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.httpClient.http.request.HttpRequestNameSupport;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiFileIdentifiersScope;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpIncludeFilePath;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRunBlock;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0000\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0010H\u0002\u001a \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"LOCATION_TEST_SCHEME", "", "LOCATION_REQUEST_PROTOCOL", "LOCATION_REQUEST_SEPARATOR", "getTestLocationHint", "fileUrl", "line", "", "parseTestLocation", "Lcom/intellij/execution/Location;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "location", "getRequestLocationHint", "element", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "getRunLocationHint", "Lcom/intellij/httpClient/http/request/psi/HttpRunBlock;", "getHttpLocationHint", "Lcom/intellij/httpClient/http/request/psi/HttpRequestCompositeElement;", "parseRequestLocation", "getRunName", "intellij.restClient"})
@JvmName(name="HttpClientTestLocations")
@SourceDebugExtension(value={"SMAP\nHttpClientTestLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientTestLocations.kt\ncom/intellij/httpClient/http/request/run/test/HttpClientTestLocations\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n170#2,6:108\n1#3:114\n*S KotlinDebug\n*F\n+ 1 HttpClientTestLocations.kt\ncom/intellij/httpClient/http/request/run/test/HttpClientTestLocations\n*L\n45#1:108,6\n*E\n"})
public final class HttpClientTestLocations {
    @NotNull
    private static final String LOCATION_TEST_SCHEME = "http-client-test";
    @NotNull
    private static final String LOCATION_REQUEST_PROTOCOL = "http-client";
    @NotNull
    private static final String LOCATION_REQUEST_SEPARATOR = "?|_____id______|=";

    @NotNull
    public static final String getTestLocationHint(@NotNull String fileUrl, int line) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return "http-client-test://" + fileUrl + ":" + line;
    }

    private static final Location<PsiElement> parseTestLocation(Project project, String location) {
        int n;
        Object $this$indexOfLast$iv;
        block6: {
            $this$indexOfLast$iv = location;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == ':')) continue;
                    n = index$iv;
                    break block6;
                } while (0 <= n2);
            }
            n = -1;
        }
        $this$indexOfLast$iv = n;
        int it = ((Number)$this$indexOfLast$iv).intValue();
        boolean bl = false;
        Object object = it != -1 ? $this$indexOfLast$iv : null;
        if (object == null) {
            return null;
        }
        int indexOfLast = (Integer)object;
        String string = location.substring(0, indexOfLast);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String fileUrl = string;
        String string2 = location.substring(indexOfLast + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Integer n3 = StringsKt.toIntOrNull((String)string2);
        if (n3 == null) {
            return null;
        }
        int lineNumber = n3;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileUrl);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        return (Location)new Location<PsiElement>(file, project, vFile, lineNumber){
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $vFile;
            final /* synthetic */ int $lineNumber;
            {
                this.$file = $file;
                this.$project = $project;
                this.$vFile = $vFile;
                this.$lineNumber = $lineNumber;
            }

            public PsiElement getPsiElement() {
                return (PsiElement)this.$file;
            }

            public Project getProject() {
                return this.$project;
            }

            public <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> ancestorClass, boolean strict) {
                return CollectionsKt.emptyList().iterator();
            }

            public Module getModule() {
                return null;
            }

            public OpenFileDescriptor getOpenFileDescriptor() {
                return new OpenFileDescriptor(this.$project, this.$vFile, this.$lineNumber, 0);
            }
        };
    }

    @Nullable
    public static final String getRequestLocationHint(@NotNull SmartPsiElementPointer<HttpRequest> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return HttpClientTestLocations.getHttpLocationHint(element);
    }

    @Nullable
    public static final String getRunLocationHint(@NotNull SmartPsiElementPointer<HttpRunBlock> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return HttpClientTestLocations.getHttpLocationHint(element);
    }

    private static final String getHttpLocationHint(SmartPsiElementPointer<? extends HttpRequestCompositeElement> element) {
        return (String)ActionsKt.runReadAction(() -> HttpClientTestLocations.getHttpLocationHint$lambda$2(element));
    }

    private static final Location<PsiElement> parseRequestLocation(Project project, String location) {
        PsiLocation psiLocation;
        HttpClientExecutionBlock request;
        String[] stringArray = new String[]{LOCATION_REQUEST_SEPARATOR};
        List split = StringsKt.split$default((CharSequence)location, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() != 2) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)split.get(0));
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
        HttpRequestPsiFile httpRequestPsiFile = psiFile instanceof HttpRequestPsiFile ? (HttpRequestPsiFile)psiFile : null;
        if (httpRequestPsiFile == null) {
            return null;
        }
        HttpRequestPsiFile file = httpRequestPsiFile;
        HttpRequestPsiFileIdentifiersScope scope = new HttpRequestPsiFileIdentifiersScope((PsiFile)file);
        HttpClientExecutionBlock httpClientExecutionBlock = request = scope.resolveExecutionBlock((String)split.get(1));
        if (httpClientExecutionBlock != null) {
            HttpClientExecutionBlock it = httpClientExecutionBlock;
            boolean bl = false;
            psiLocation = new PsiLocation((PsiElement)it);
        } else {
            psiLocation = null;
        }
        return (Location)psiLocation;
    }

    @NotNull
    public static final String getRunName(@NotNull SmartPsiElementPointer<HttpRunBlock> element) {
        HttpIncludeFilePath filePath;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        HttpRunBlock httpRunBlock = (HttpRunBlock)element.getElement();
        HttpIncludeFilePath httpIncludeFilePath = filePath = httpRunBlock != null ? httpRunBlock.getIncludeFilePath() : null;
        if (filePath != null) {
            String string = filePath.getPresentablePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentablePath(...)");
            return string;
        }
        Object object = (HttpRunBlock)element.getElement();
        if (object == null || (object = object.getRequestName()) == null || (object = object.getName()) == null) {
            object = "";
        }
        return object;
    }

    private static final String getHttpLocationHint$lambda$2(SmartPsiElementPointer $element) {
        VirtualFile virtualFile = $element.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = virtualFile2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        String url = string;
        HttpRequestCompositeElement httpRequestCompositeElement = (HttpRequestCompositeElement)$element.getElement();
        if (httpRequestCompositeElement == null) {
            return null;
        }
        HttpRequestCompositeElement compositeElement = httpRequestCompositeElement;
        HttpClientExecutionBlock httpClientExecutionBlock = (HttpClientExecutionBlock)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)compositeElement), HttpClientExecutionBlock.class);
        if (httpClientExecutionBlock == null) {
            return null;
        }
        HttpClientExecutionBlock parent = httpClientExecutionBlock;
        String name = HttpRequestNameSupport.getUniqueName(parent);
        return "http-client://" + url + LOCATION_REQUEST_SEPARATOR + name;
    }

    public static final /* synthetic */ Location access$parseRequestLocation(Project project, String location) {
        return HttpClientTestLocations.parseRequestLocation(project, location);
    }

    public static final /* synthetic */ Location access$parseTestLocation(Project project, String location) {
        return HttpClientTestLocations.parseTestLocation(project, location);
    }
}

