/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.builtins.sort.SortComparator;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.ForEachIndexCallNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.array.JSArrayDeleteRangeNode;
import com.oracle.truffle.js.nodes.array.JSArrayFirstElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayLastElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayToDenseObjectArrayNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.array.JSSetLengthNode;
import com.oracle.truffle.js.nodes.array.TestArrayNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSMapObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ArrayPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayPrototypeBuiltins();

    protected ArrayPrototypeBuiltins() {
        super(JSArray.PROTOTYPE_NAME, ArrayPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayPrototype builtinEnum) {
        switch (builtinEnum) {
            case push: {
                return ArrayPrototypeBuiltinsFactory.JSArrayPushNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case pop: {
                return ArrayPrototypeBuiltinsFactory.JSArrayPopNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case slice: {
                return ArrayPrototypeBuiltinsFactory.JSArraySliceNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case shift: {
                return ArrayPrototypeBuiltinsFactory.JSArrayShiftNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case unshift: {
                return ArrayPrototypeBuiltinsFactory.JSArrayUnshiftNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case toString: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToStringNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case concat: {
                return ArrayPrototypeBuiltinsFactory.JSArrayConcatNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case indexOf: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case lastIndexOf: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case join: {
                return ArrayPrototypeBuiltinsFactory.JSArrayJoinNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toLocaleString: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToLocaleStringNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case splice: {
                return ArrayPrototypeBuiltinsFactory.JSArraySpliceNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case every: {
                return ArrayPrototypeBuiltinsFactory.JSArrayEveryNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case filter: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFilterNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case forEach: {
                return ArrayPrototypeBuiltinsFactory.JSArrayForEachNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case some: {
                return ArrayPrototypeBuiltinsFactory.JSArraySomeNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case map: {
                return ArrayPrototypeBuiltinsFactory.JSArrayMapNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case sort: {
                return ArrayPrototypeBuiltinsFactory.JSArraySortNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case reduce: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case reduceRight: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case reverse: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReverseNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case find: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case findIndex: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, false, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case findLast: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case findLastIndex: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, false, true, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case fill: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFillNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case copyWithin: {
                return ArrayPrototypeBuiltinsFactory.JSArrayCopyWithinNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case keys: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIteratorNodeGen.create(context, builtin, 1, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case values: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIteratorNodeGen.create(context, builtin, 2, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case entries: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIteratorNodeGen.create(context, builtin, 3, ArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case includes: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIncludesNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case flatMap: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFlatMapNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case flat: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFlatNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case at: {
                return ArrayPrototypeBuiltinsFactory.JSArrayAtNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case group: {
                return ArrayPrototypeBuiltinsFactory.JSArrayGroupNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case groupToMap: {
                return ArrayPrototypeBuiltinsFactory.JSArrayGroupToMapNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case toReversed: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToReversedNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case toSorted: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToSortedNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case toSpliced: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToSplicedNodeGen.create(context, builtin, ArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case with: {
                return ArrayPrototypeBuiltinsFactory.JSArrayWithNodeGen.create(context, builtin, false, ArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayPrototype implements BuiltinEnum<ArrayPrototype>
    {
        push(1),
        pop(0),
        slice(2),
        shift(0),
        unshift(1),
        toString(0),
        concat(1),
        indexOf(1),
        lastIndexOf(1),
        join(1),
        toLocaleString(0),
        splice(2),
        every(1),
        filter(1),
        forEach(1),
        some(1),
        map(1),
        sort(1),
        reduce(1),
        reduceRight(1),
        reverse(0),
        find(1),
        findIndex(1),
        fill(1),
        copyWithin(2),
        keys(0),
        values(0),
        entries(0),
        includes(1),
        flat(0),
        flatMap(1),
        at(1),
        group(1),
        groupToMap(1),
        findLast(1),
        findLastIndex(1),
        toReversed(0),
        toSorted(1),
        toSpliced(2),
        with(2);

        private final int length;

        private ArrayPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(find, new ArrayPrototype[]{findIndex, fill, copyWithin, keys, values, entries}).contains(this)) {
                return 6;
            }
            if (this == includes) {
                return 7;
            }
            if (EnumSet.of(flat, flatMap).contains(this)) {
                return 10;
            }
            if (this == at) {
                return 13;
            }
            if (EnumSet.of(group, new ArrayPrototype[]{groupToMap, findLast, findLastIndex, toReversed, toSorted, toSpliced, with}).contains(this)) {
                return 14;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    public static abstract class JSArrayPushNode
    extends JSArrayOperation {
        public JSArrayPushNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length == 0"})
        protected Object pushArrayNone(JSDynamicObject thisObject, Object[] args) {
            long len = this.getLength(thisObject);
            this.setLength((Object)thisObject, len);
            if (len >= Integer.MAX_VALUE) {
                return (double)len;
            }
            return (int)len;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length == 1"}, rewriteOn={SlowPathException.class})
        protected int pushArraySingle(JSDynamicObject thisObject, Object[] args) throws SlowPathException {
            long len = this.getLength(thisObject);
            if (len >= Integer.MAX_VALUE) {
                throw JSNodeUtil.slowPathException();
            }
            int iLen = (int)len;
            this.write((Object)thisObject, iLen, args[0]);
            int newLength = iLen + 1;
            this.setLength((Object)thisObject, newLength);
            return newLength;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length == 1"})
        protected double pushArraySingleLong(JSDynamicObject thisObject, Object[] args) {
            long len = this.getLength(thisObject);
            this.checkLength(args, len);
            this.write((Object)thisObject, len, args[0]);
            long newLength = len + 1L;
            this.setLength((Object)thisObject, newLength);
            return newLength;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length >= 2"}, rewriteOn={SlowPathException.class})
        protected int pushArrayAll(JSDynamicObject thisObject, Object[] args) throws SlowPathException {
            long len = this.getLength(thisObject);
            if (len + (long)args.length >= Integer.MAX_VALUE) {
                throw JSNodeUtil.slowPathException();
            }
            int ilen = (int)len;
            for (int i = 0; i < args.length; ++i) {
                this.write((Object)thisObject, ilen + i, args[i]);
            }
            this.setLength((Object)thisObject, ilen + args.length);
            return ilen + args.length;
        }

        @Specialization(guards={"isJSArray(thisObject)", "args.length >= 2"})
        protected double pushArrayAllLong(JSDynamicObject thisObject, Object[] args) {
            long len = this.getLength(thisObject);
            this.checkLength(args, len);
            for (int i = 0; i < args.length; ++i) {
                this.write((Object)thisObject, len + (long)i, args[i]);
            }
            this.setLength((Object)thisObject, len + (long)args.length);
            return (double)len + (double)args.length;
        }

        @Specialization(guards={"!isJSArray(thisObject)"})
        protected double pushProperty(Object thisObject, Object[] args) {
            Object thisObj = this.toObject(thisObject);
            long len = this.getLength(thisObj);
            this.checkLength(args, len);
            for (int i = 0; i < args.length; ++i) {
                this.write(thisObj, len + (long)i, args[i]);
            }
            long newLength = len + (long)args.length;
            this.setLength(thisObj, newLength);
            return newLength;
        }

        private void checkLength(Object[] args, long len) {
            if ((double)(len + (long)args.length) > JSRuntime.MAX_SAFE_INTEGER) {
                this.errorBranch.enter();
                JSArrayPushNode.throwLengthError();
            }
        }
    }

    public static abstract class JSArrayPopNode
    extends JSArrayOperation {
        public JSArrayPopNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object popGeneric(Object thisObj, @Cached(value="create(getContext())") DeleteAndSetLengthNode deleteAndSetLength, @Cached InlinedConditionProfile lengthIsZero) {
            Object thisObject = this.toObject(thisObj);
            long length2 = this.getLength(thisObject);
            if (lengthIsZero.profile(this, length2 > 0L)) {
                long newLength = length2 - 1L;
                Object result2 = this.read(thisObject, newLength);
                deleteAndSetLength.executeVoid(thisObject, newLength);
                return result2;
            }
            assert (length2 == 0L);
            this.setLength(thisObject, 0);
            return Undefined.instance;
        }
    }

    public static abstract class JSArraySliceNode
    extends ArrayForEachIndexCallOperation {
        public JSArraySliceNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object sliceGeneric(Object thisObj, Object begin2, Object end, @Cached JSToIntegerAsLongNode toIntegerAsLong, @Cached InlinedConditionProfile sizeIsZero, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2) {
            Object thisArrayObj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(thisArrayObj);
            long startPos = begin2 != Undefined.instance ? JSRuntime.getOffset(toIntegerAsLong.executeLong(begin2), len, (Node)this, offsetProfile1) : 0L;
            long endPos = end == Undefined.instance ? len : JSRuntime.getOffset(toIntegerAsLong.executeLong(end), len, (Node)this, offsetProfile2);
            long size = startPos <= endPos ? endPos - startPos : 0L;
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisArrayObj, size);
            if (sizeIsZero.profile(this, size > 0L)) {
                if (this.isTypedArrayImplementation) {
                    this.checkHasDetachedBuffer((JSDynamicObject)thisObj);
                }
                this.forEachIndexCall(thisArrayObj, null, startPos, startPos, endPos, resultArray);
            }
            if (!this.isTypedArrayImplementation) {
                this.setLength(resultArray, size);
            }
            return resultArray;
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private WriteElementNode writeOwnNode;
                {
                    this.writeOwnNode = WriteElementNode.create(this.getContext(), true, true);
                }

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    long startIndex = (Long)callbackResult;
                    this.writeOwnNode.executeWithTargetAndIndexAndValue(currentResult, index - startIndex, value2);
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }

        @Override
        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return null;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSArrayShiftNode
    extends JSArrayOperation {
        public JSArrayShiftNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static boolean isSparseArray(JSDynamicObject thisObj) {
            return JSAbstractArray.arrayGetArrayType(thisObj) instanceof SparseArray;
        }

        protected static boolean isArrayWithoutHolesAndNotSealed(JSDynamicObject thisObj, IsArrayNode isArrayNode, TestArrayNode hasHolesNode, TestArrayNode isSealedNode) {
            boolean isArray = isArrayNode.execute(thisObj);
            return isArray && !hasHolesNode.executeBoolean(thisObj) && !isSealedNode.executeBoolean(thisObj);
        }

        @Specialization(guards={"isArrayWithoutHolesAndNotSealed(thisObj, isArrayNode, hasHolesNode, isSealedNode)"}, limit="1")
        protected Object shiftWithoutHoles(JSDynamicObject thisObj, @Cached.Shared(value="isArray") @Cached(value="createIsArray()") IsArrayNode isArrayNode, @Cached.Shared(value="hasHoles") @Cached(value="createHasHoles()") TestArrayNode hasHolesNode, @Cached.Shared(value="isSealed") @Cached(value="createIsSealed()") TestArrayNode isSealedNode, @Cached InlinedExactClassProfile arrayTypeProfile, @Cached.Shared(value="lengthIsZero") @Cached InlinedConditionProfile lengthIsZero, @Cached @Cached.Exclusive InlinedConditionProfile lengthLargerOne) {
            long len = this.getLength(thisObj);
            if (lengthIsZero.profile(this, len == 0L)) {
                this.setLength((Object)thisObj, 0);
                return Undefined.instance;
            }
            Object firstElement = this.read((Object)thisObj, 0);
            if (lengthLargerOne.profile(this, len > 1L)) {
                ScriptArray array = arrayTypeProfile.profile(this, JSAbstractArray.arrayGetArrayType(thisObj));
                JSAbstractArray.arraySetArrayType(thisObj, array.shiftRange(thisObj, 1L));
            }
            this.setLength((Object)thisObj, len - 1L);
            return firstElement;
        }

        protected static boolean isArrayWithHolesOrSealed(JSDynamicObject thisObj, IsArrayNode isArrayNode, TestArrayNode hasHolesNode, TestArrayNode isSealedNode) {
            boolean isArray = isArrayNode.execute(thisObj);
            return isArray && (hasHolesNode.executeBoolean(thisObj) || isSealedNode.executeBoolean(thisObj)) && !JSArrayShiftNode.isSparseArray(thisObj);
        }

        @Specialization(guards={"isArrayWithHolesOrSealed(thisObj, isArrayNode, hasHolesNode, isSealedNode)"}, limit="1")
        protected Object shiftWithHoles(JSDynamicObject thisObj, @Cached.Shared(value="isArray") @Cached(value="createIsArray()") IsArrayNode isArrayNode, @Cached.Shared(value="hasHoles") @Cached(value="createHasHoles()") TestArrayNode hasHolesNode, @Cached.Shared(value="isSealed") @Cached(value="createIsSealed()") TestArrayNode isSealedNode, @Cached.Shared(value="deleteProperty") @Cached(value="create(THROW_ERROR, getContext())") DeletePropertyNode deletePropertyNode, @Cached.Shared(value="lengthIsZero") @Cached InlinedConditionProfile lengthIsZero) {
            long len = this.getLength(thisObj);
            if (lengthIsZero.profile(this, len > 0L)) {
                Object firstElement = this.read((Object)thisObj, 0);
                for (long i = 0L; i < len - 1L; ++i) {
                    if (this.hasProperty((Object)thisObj, i + 1L)) {
                        this.write((Object)thisObj, i, this.read((Object)thisObj, i + 1L));
                        continue;
                    }
                    deletePropertyNode.executeEvaluated(thisObj, i);
                }
                deletePropertyNode.executeEvaluated(thisObj, len - 1L);
                this.setLength((Object)thisObj, len - 1L);
                this.reportLoopCount(len - 1L);
                return firstElement;
            }
            this.setLength((Object)thisObj, 0);
            return Undefined.instance;
        }

        @Specialization(guards={"isArrayNode.execute(thisObj)", "isSparseArray(thisObj)"}, limit="1")
        protected Object shiftSparse(JSDynamicObject thisObj, @Cached.Shared(value="isArray") @Cached(value="createIsArray()") IsArrayNode isArrayNode, @Cached.Shared(value="deleteProperty") @Cached(value="create(THROW_ERROR, getContext())") DeletePropertyNode deletePropertyNode, @Cached.Shared(value="lengthIsZero") @Cached InlinedConditionProfile lengthIsZero, @Cached(value="create(getContext())") JSArrayFirstElementIndexNode firstElementIndexNode, @Cached(value="create(getContext())") JSArrayLastElementIndexNode lastElementIndexNode) {
            long len = this.getLength(thisObj);
            if (lengthIsZero.profile(this, len > 0L)) {
                Object firstElement = this.read((Object)thisObj, 0);
                long count = 0L;
                long i = firstElementIndexNode.executeLong(thisObj, len);
                while (i <= lastElementIndexNode.executeLong(thisObj, len)) {
                    if (i > 0L) {
                        this.write((Object)thisObj, i - 1L, this.read((Object)thisObj, i));
                    }
                    if (!this.hasProperty((Object)thisObj, i + 1L)) {
                        deletePropertyNode.executeEvaluated(thisObj, i);
                    }
                    ++count;
                    i = this.nextElementIndex(thisObj, i, len);
                }
                this.setLength((Object)thisObj, len - 1L);
                this.reportLoopCount(count);
                return firstElement;
            }
            this.setLength((Object)thisObj, 0);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSArray(thisObj)", "!isForeignObject(thisObj)"})
        protected Object shiftGeneric(Object thisObj, @Cached.Shared(value="deleteProperty") @Cached(value="create(THROW_ERROR, getContext())") DeletePropertyNode deleteNode, @Cached.Shared(value="lengthIsZero") @Cached InlinedConditionProfile lengthIsZero) {
            Object thisJSObj = this.toObject(thisObj);
            long len = this.getLength(thisJSObj);
            if (lengthIsZero.profile(this, len == 0L)) {
                this.setLength(thisJSObj, 0);
                return Undefined.instance;
            }
            Object firstObj = this.read(thisJSObj, 0);
            for (long i = 1L; i < len; ++i) {
                if (this.hasProperty(thisJSObj, i)) {
                    this.write(thisJSObj, i - 1L, this.read(thisObj, i));
                    continue;
                }
                deleteNode.executeEvaluated(thisJSObj, i - 1L);
            }
            deleteNode.executeEvaluated(thisJSObj, len - 1L);
            this.setLength(thisJSObj, len - 1L);
            this.reportLoopCount(len);
            return firstObj;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignObject(thisObj)"})
        protected Object shiftForeign(Object thisObj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary arrays, @Cached.Shared(value="lengthIsZero") @Cached InlinedConditionProfile lengthIsZero) {
            long len = JSInteropUtil.getArraySize(thisObj, arrays, this);
            if (lengthIsZero.profile(this, len == 0L)) {
                return Undefined.instance;
            }
            try {
                Object firstObj = arrays.readArrayElement(thisObj, 0L);
                for (long i = 1L; i < len; ++i) {
                    Object val = arrays.readArrayElement(thisObj, i);
                    arrays.writeArrayElement(thisObj, i - 1L, val);
                }
                arrays.removeArrayElement(thisObj, len - 1L);
                this.reportLoopCount(len);
                return firstObj;
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "shift", this);
            }
        }
    }

    public static abstract class JSArrayUnshiftNode
    extends JSArrayOperation {
        @Node.Child
        protected IsArrayNode isArrayNode = IsArrayNode.createIsArray();
        @Node.Child
        protected TestArrayNode hasHolesNode = TestArrayNode.createHasHoles();

        public JSArrayUnshiftNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean isFastPath(Object thisObj) {
            boolean isArray = this.isArrayNode.execute(thisObj);
            return isArray && !this.hasHolesNode.executeBoolean((JSDynamicObject)thisObj);
        }

        private long unshiftHoleless(JSDynamicObject thisObj, Object[] args) {
            long len = this.getLength(thisObj);
            if (this.getContext().getEcmaScriptVersion() <= 5 || args.length > 0) {
                for (long l = len - 1L; l >= 0L; --l) {
                    this.write((Object)thisObj, l + (long)args.length, this.read((Object)thisObj, l));
                }
                for (int i = 0; i < args.length; ++i) {
                    this.write((Object)thisObj, i, args[i]);
                }
                this.reportLoopCount(len + (long)args.length);
            }
            long newLen = len + (long)args.length;
            this.setLength((Object)thisObj, newLen);
            return newLen;
        }

        @Specialization(guards={"isFastPath(thisObj)"}, rewriteOn={UnexpectedResultException.class})
        protected int unshiftInt(JSDynamicObject thisObj, Object[] args) throws UnexpectedResultException {
            long newLen = this.unshiftHoleless(thisObj, args);
            if (JSRuntime.longIsRepresentableAsInt(newLen)) {
                return (int)newLen;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(newLen);
        }

        @Specialization(guards={"isFastPath(thisObj)"}, replaces={"unshiftInt"})
        protected double unshiftDouble(JSDynamicObject thisObj, Object[] args) {
            return this.unshiftHoleless(thisObj, args);
        }

        @Specialization(guards={"!isFastPath(thisObjParam)"})
        protected double unshiftHoles(Object thisObjParam, Object[] args, @Cached(value="create(THROW_ERROR, getContext())") DeletePropertyNode deletePropertyNode, @Cached(value="create(getContext())") JSArrayLastElementIndexNode lastElementIndexNode, @Cached(value="create(getContext())") JSArrayFirstElementIndexNode firstElementIndexNode) {
            Object thisObj = this.toObject(thisObjParam);
            long len = this.getLength(thisObj);
            if (this.getContext().getEcmaScriptVersion() <= 5 || args.length > 0) {
                if ((long)args.length + len > JSRuntime.MAX_SAFE_INTEGER_LONG) {
                    this.errorBranch.enter();
                    JSArrayUnshiftNode.throwLengthError();
                }
                long lastIdx = lastElementIndexNode.executeLong(thisObj, len);
                long firstIdx = firstElementIndexNode.executeLong(thisObj, len);
                long count = 0L;
                long i = lastIdx;
                while (i >= firstIdx) {
                    ++count;
                    if (this.hasProperty(thisObj, i)) {
                        this.write(thisObj, i + (long)args.length, this.read(thisObj, i));
                        if (args.length > 0 && i >= (long)args.length && !this.hasProperty(thisObj, i - (long)args.length)) {
                            deletePropertyNode.executeEvaluated(thisObj, i);
                        }
                    }
                    i = this.previousElementIndex(thisObj, i);
                }
                for (int i2 = 0; i2 < args.length; ++i2) {
                    this.write(thisObj, i2, args[i2]);
                }
                this.reportLoopCount(count + (long)args.length);
            }
            long newLen = len + (long)args.length;
            this.setLength(thisObj, newLen);
            return newLen;
        }
    }

    public static abstract class JSArrayToStringNode
    extends BasicArrayOperation {
        @Node.Child
        private PropertyNode joinPropertyNode;
        @Node.Child
        private PropertyNode toStringPropertyNode;
        @Node.Child
        private JSFunctionCallNode callJoinNode;
        @Node.Child
        private JSFunctionCallNode callToStringNode;
        @Node.Child
        private ForeignObjectPrototypeNode foreignObjectPrototypeNode;
        @Node.Child
        private InteropLibrary interopLibrary;
        @Node.Child
        private ImportValueNode importValueNode;
        @CompilerDirectives.CompilationFinal
        private Class<?> hostLanguageClass;

        public JSArrayToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.joinPropertyNode = PropertyNode.createProperty(context, null, Strings.JOIN);
        }

        private Object getJoinProperty(Object target) {
            return this.joinPropertyNode.executeWithTarget(target);
        }

        private Object getToStringProperty(Object target) {
            if (this.toStringPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringPropertyNode = this.insert(PropertyNode.createProperty(this.getContext(), null, Strings.TO_STRING));
            }
            return this.toStringPropertyNode.executeWithTarget(target);
        }

        private Object callJoin(Object target, Object function) {
            if (this.callJoinNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callJoinNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.callJoinNode.executeCall(JSArguments.createZeroArg(target, function));
        }

        private Object callToString(Object target, Object function) {
            if (this.callToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callToStringNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.callToStringNode.executeCall(JSArguments.createZeroArg(target, function));
        }

        private JSDynamicObject getForeignObjectPrototype(Object truffleObject) {
            assert (JSRuntime.isForeignObject(truffleObject));
            if (this.foreignObjectPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignObjectPrototypeNode = this.insert(ForeignObjectPrototypeNode.create());
            }
            return this.foreignObjectPrototypeNode.execute(truffleObject);
        }

        private InteropLibrary getInterop() {
            if (this.interopLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            return this.interopLibrary;
        }

        private Object importValue(Object value2) {
            if (this.importValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.importValueNode = this.insert(ImportValueNode.create());
            }
            return this.importValueNode.executeWithTarget(value2);
        }

        private Object toStringForeign(Object arrayObj) {
            Object join;
            InteropLibrary interop = this.getInterop();
            if (this.shouldTryOwnJoin(arrayObj) && interop.isMemberInvocable(arrayObj, Strings.JOIN_JLS)) {
                Object result2;
                block8: {
                    try {
                        try {
                            result2 = interop.invokeMember(arrayObj, Strings.JOIN_JLS, new Object[0]);
                        }
                        catch (AbstractTruffleException e) {
                            if (InteropLibrary.getUncached(e).getExceptionType(e) == ExceptionType.RUNTIME_ERROR) {
                                result2 = null;
                                break block8;
                            }
                            throw e;
                        }
                    }
                    catch (InteropException e) {
                        result2 = null;
                    }
                }
                if (result2 != null) {
                    return this.importValue(result2);
                }
            }
            if (this.isCallable(join = this.getJoinProperty(this.getForeignObjectPrototype(arrayObj)))) {
                return this.callJoin(arrayObj, join);
            }
            Object toString = this.getToStringProperty(this.getRealm().getObjectPrototype());
            return this.callToString(arrayObj, toString);
        }

        private boolean shouldTryOwnJoin(Object arrayObj) {
            InteropLibrary interop = this.getInterop();
            try {
                return !interop.hasLanguage(arrayObj) || interop.getLanguage(arrayObj) == this.getHostLanguageClass();
            }
            catch (UnsupportedMessageException umex) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        private Class<?> getHostLanguageClass() {
            if (this.hostLanguageClass == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                try {
                    this.hostLanguageClass = InteropLibrary.getUncached().getLanguage(this.getRealm().getEnv().asGuestValue(new Object()));
                }
                catch (UnsupportedMessageException umex) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                catch (UnsupportedOperationException uoex) {
                    this.hostLanguageClass = Object.class;
                }
            }
            return this.hostLanguageClass;
        }

        @Specialization
        protected Object toString(Object thisObj, @Cached InlinedConditionProfile isJSObjectProfile) {
            Object arrayObj = this.toObject(thisObj);
            if (isJSObjectProfile.profile(this, JSObject.isJSObject(arrayObj))) {
                Object join = this.getJoinProperty(arrayObj);
                if (this.isCallable(join)) {
                    return this.callJoin(arrayObj, join);
                }
                return JSObject.defaultToString((JSDynamicObject)arrayObj);
            }
            return this.toStringForeign(arrayObj);
        }
    }

    public static abstract class JSArrayConcatNode
    extends JSArrayOperation {
        @Node.Child
        private JSToBooleanNode toBooleanNode;
        @Node.Child
        private JSArrayFirstElementIndexNode firstElementIndexNode;
        @Node.Child
        private JSArrayLastElementIndexNode lastElementIndexNode;
        @Node.Child
        private PropertyGetNode getSpreadableNode;
        @Node.Child
        private JSIsArrayNode isArrayNode;
        private final ConditionProfile isFirstSpreadable = ConditionProfile.create();
        private final ConditionProfile hasFirstElements = ConditionProfile.create();
        private final ConditionProfile isSecondSpreadable = ConditionProfile.create();
        private final ConditionProfile hasSecondElements = ConditionProfile.create();
        private final ConditionProfile lengthErrorProfile = ConditionProfile.create();
        private final ConditionProfile hasMultipleArgs = ConditionProfile.create();
        private final ConditionProfile hasOneArg = ConditionProfile.create();
        private final ConditionProfile optimizationsObservable = ConditionProfile.create();
        private final ConditionProfile hasFirstOneElement = ConditionProfile.create();
        private final ConditionProfile hasSecondOneElement = ConditionProfile.create();

        public JSArrayConcatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected boolean toBoolean(Object target) {
            if (this.toBooleanNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBooleanNode = this.insert(JSToBooleanNode.create());
            }
            return this.toBooleanNode.executeBoolean(target);
        }

        @Specialization
        protected JSDynamicObject concat(Object thisObj, Object[] args) {
            Object thisJSObj = this.toObject(thisObj);
            JSDynamicObject retObj = (JSDynamicObject)this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, 0L);
            long n = this.concatElementIntl(retObj, thisJSObj, 0L, this.isFirstSpreadable, this.hasFirstElements, this.hasFirstOneElement);
            long resultLen = this.concatIntl(retObj, n, args);
            this.setLength((Object)retObj, resultLen);
            return retObj;
        }

        private long concatIntl(JSDynamicObject retObj, long initialLength, Object[] args) {
            long n = initialLength;
            if (this.hasOneArg.profile(args.length == 1)) {
                n = this.concatElementIntl(retObj, args[0], n, this.isSecondSpreadable, this.hasSecondElements, this.hasSecondOneElement);
            } else if (this.hasMultipleArgs.profile(args.length > 1)) {
                for (int i = 0; i < args.length; ++i) {
                    n = this.concatElementIntl(retObj, args[i], n, this.isSecondSpreadable, this.hasSecondElements, this.hasSecondOneElement);
                }
            }
            return n;
        }

        private long concatElementIntl(JSDynamicObject retObj, Object el, long n, ConditionProfile isSpreadable, ConditionProfile hasElements, ConditionProfile hasOneElement) {
            if (isSpreadable.profile(this.isConcatSpreadable(el))) {
                long len2 = this.getLength(el);
                if (hasElements.profile(len2 > 0L)) {
                    return this.concatSpreadable(retObj, n, el, len2, hasOneElement);
                }
            } else {
                if (this.lengthErrorProfile.profile((double)n > JSRuntime.MAX_SAFE_INTEGER)) {
                    this.errorBranch.enter();
                    JSArrayConcatNode.throwLengthError();
                }
                this.writeOwn((Object)retObj, n, el);
                return n + 1L;
            }
            return n;
        }

        private long concatSpreadable(JSDynamicObject retObj, long n, Object elObj, long len2, ConditionProfile hasOneElement) {
            block4: {
                block5: {
                    block3: {
                        if (this.lengthErrorProfile.profile((double)(n + len2) > JSRuntime.MAX_SAFE_INTEGER)) {
                            this.errorBranch.enter();
                            JSArrayConcatNode.throwLengthError();
                        }
                        if (!this.optimizationsObservable.profile(JSProxy.isJSProxy(elObj) || !JSDynamicObject.isJSDynamicObject(elObj))) break block3;
                        for (long k = 0L; k < len2; ++k) {
                            if (!this.hasProperty(elObj, k)) continue;
                            this.writeOwn((Object)retObj, n + k, this.read(elObj, k));
                        }
                        break block4;
                    }
                    if (!hasOneElement.profile(len2 == 1L)) break block5;
                    if (!this.hasProperty(elObj, 0L)) break block4;
                    this.writeOwn((Object)retObj, n, this.read(elObj, 0));
                    break block4;
                }
                long k = this.firstElementIndex((JSDynamicObject)elObj, len2);
                long lastI = this.lastElementIndex((JSDynamicObject)elObj, len2);
                while (k <= lastI) {
                    this.writeOwn((Object)retObj, n + k, this.read(elObj, k));
                    k = this.nextElementIndex(elObj, k, len2);
                }
            }
            return n + len2;
        }

        private boolean isConcatSpreadable(Object el) {
            JSObject obj;
            Object spreadable;
            if (el instanceof JSObject && (spreadable = this.getSpreadableProperty(obj = (JSObject)el)) != Undefined.instance) {
                return this.toBoolean(spreadable);
            }
            return this.isArray(el);
        }

        private boolean isArray(Object object) {
            if (this.isArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isArrayNode = this.insert(JSIsArrayNode.createIsArrayLike());
            }
            return this.isArrayNode.execute(object);
        }

        private Object getSpreadableProperty(Object obj) {
            if (this.getSpreadableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSpreadableNode = this.insert(PropertyGetNode.create(Symbol.SYMBOL_IS_CONCAT_SPREADABLE, false, this.getContext()));
            }
            return this.getSpreadableNode.getValue(obj);
        }

        private long firstElementIndex(JSDynamicObject target, long length2) {
            if (this.firstElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.firstElementIndexNode = this.insert(JSArrayFirstElementIndexNode.create(this.getContext()));
            }
            return this.firstElementIndexNode.executeLong(target, length2);
        }

        private long lastElementIndex(JSDynamicObject target, long length2) {
            if (this.lastElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lastElementIndexNode = this.insert(JSArrayLastElementIndexNode.create(this.getContext()));
            }
            return this.lastElementIndexNode.executeLong(target, length2);
        }
    }

    public static abstract class JSArrayIndexOfNode
    extends ArrayForEachIndexCallOperation {
        private final boolean isForward;

        public JSArrayIndexOfNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isForward) {
            super(context, builtin, isTypedArrayImplementation);
            this.isForward = isForward;
        }

        @Specialization
        protected Object indexOf(Object thisObj, Object[] args, @Cached InlinedBranchProfile arrayWithContentBranch, @Cached JSToIntegerAsLongNode toInteger) {
            long fromIndexValue;
            Object thisJSObject = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(thisJSObject);
            if (len == 0L) {
                return -1;
            }
            arrayWithContentBranch.enter(this);
            Object searchElement = JSRuntime.getArgOrUndefined(args, 0);
            Object fromIndex = JSRuntime.getArgOrUndefined(args, 1);
            long l = fromIndexValue = this.isForward() ? JSArrayIndexOfNode.calcFromIndexForward(args, len, fromIndex, toInteger) : JSArrayIndexOfNode.calcFromIndexBackward(args, len, fromIndex, toInteger);
            if (fromIndexValue < 0L) {
                return -1;
            }
            return this.forEachIndexCall(thisJSObject, Undefined.instance, searchElement, fromIndexValue, len, -1);
        }

        private static long calcFromIndexForward(Object[] args, long len, Object fromIndex, JSToIntegerAsLongNode toInteger) {
            if (args.length <= 1) {
                return 0L;
            }
            long fromIndexValue = toInteger.executeLong(fromIndex);
            if (fromIndexValue > len) {
                return -1L;
            }
            if (fromIndexValue < 0L) {
                fromIndexValue = (fromIndexValue += len) < 0L ? 0L : fromIndexValue;
            }
            return fromIndexValue;
        }

        private static long calcFromIndexBackward(Object[] args, long len, Object fromIndex, JSToIntegerAsLongNode toInteger) {
            if (args.length <= 1) {
                return len - 1L;
            }
            long fromIndexInt = toInteger.executeLong(fromIndex);
            if (fromIndexInt >= 0L) {
                return Math.min(fromIndexInt, len - 1L);
            }
            return fromIndexInt + len;
        }

        @Override
        protected boolean isForward() {
            return this.isForward;
        }

        @Override
        protected boolean shouldCheckHasProperty() {
            return true;
        }

        @Override
        protected final ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSIdenticalNode doIdenticalNode = JSIdenticalNode.createStrictEqualityComparison();
                @Node.Child
                protected LongToIntOrDoubleNode indexToNumber = LongToIntOrDoubleNode.create();

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    return this.doIdenticalNode.executeBoolean(value2, callbackResult) ? ForEachIndexCallNode.MaybeResult.returnResult(this.boxIndex(index)) : ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }

                private Number boxIndex(long index) {
                    return this.indexToNumber.fromIndex(null, index);
                }
            };
        }

        @Override
        protected final ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return null;
        }
    }

    public static abstract class JSArrayJoinNode
    extends JSArrayOperation {
        @Node.Child
        private JSToStringNode separatorToStringNode;
        @Node.Child
        private JSToStringNode elementToStringNode = JSToStringNode.create();
        @Node.Child
        private TruffleString.ConcatNode stringConcatNode;
        @Node.Child
        private InteropLibrary interopLibrary;
        private final StringBuilderProfile stringBuilderProfile;
        @Node.Child
        private TruffleStringBuilder.AppendStringNode appendStringNode;
        @Node.Child
        private TruffleStringBuilder.ToStringNode builderToStringNode;

        public JSArrayJoinNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected TruffleString join(Object thisObj, Object joinStr, @Cached InlinedConditionProfile separatorNotEmpty, @Cached InlinedConditionProfile isZero, @Cached InlinedConditionProfile isOne, @Cached InlinedConditionProfile isTwo, @Cached InlinedConditionProfile isSparse, @Cached InlinedBranchProfile growProfile, @Cached InlinedBranchProfile stackGrowProfile) {
            Object thisJSObject = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObject);
            TruffleString joinSeparator = joinStr == Undefined.instance ? Strings.COMMA : this.getSeparatorToString().executeString(joinStr);
            JSRealm realm = this.getRealm();
            if (!realm.joinStackPush(thisObj, this, stackGrowProfile)) {
                return Strings.EMPTY_STRING;
            }
            try {
                if (isZero.profile(this, length2 == 0L)) {
                    TruffleString truffleString = Strings.EMPTY_STRING;
                    return truffleString;
                }
                if (isOne.profile(this, length2 == 1L)) {
                    TruffleString truffleString = this.joinOne(thisJSObject);
                    return truffleString;
                }
                boolean appendSep = separatorNotEmpty.profile(this, Strings.length(joinSeparator) > 0);
                if (isTwo.profile(this, length2 == 2L)) {
                    TruffleString truffleString = this.joinTwo(thisJSObject, joinSeparator, appendSep);
                    return truffleString;
                }
                if (isSparse.profile(this, JSArray.isJSArray(thisJSObject) && JSAbstractArray.arrayGetArrayType((JSDynamicObject)thisJSObject) instanceof SparseArray)) {
                    TruffleString truffleString = this.joinSparse(thisJSObject, length2, joinSeparator, appendSep, this, growProfile);
                    return truffleString;
                }
                TruffleString truffleString = this.joinLoop(thisJSObject, length2, joinSeparator, appendSep);
                return truffleString;
            }
            finally {
                realm.joinStackPop();
            }
        }

        private JSToStringNode getSeparatorToString() {
            if (this.separatorToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.separatorToStringNode = this.insert(JSToStringNode.create());
            }
            return this.separatorToStringNode;
        }

        private TruffleString concat(TruffleString a, TruffleString b) {
            if (this.stringConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringConcatNode = this.insert(TruffleString.ConcatNode.create());
            }
            return Strings.concat(this.stringConcatNode, a, b);
        }

        private void append(TruffleStringBuilder sb, TruffleString s) {
            if (this.appendStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendStringNode = this.insert(TruffleStringBuilder.AppendStringNode.create());
            }
            this.stringBuilderProfile.append(this.appendStringNode, sb, s);
        }

        private TruffleString builderToString(TruffleStringBuilder sb) {
            if (this.builderToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.builderToStringNode = this.insert(TruffleStringBuilder.ToStringNode.create());
            }
            return StringBuilderProfile.toString(this.builderToStringNode, sb);
        }

        private TruffleString joinOne(Object thisObject) {
            Object value2 = this.read(thisObject, 0);
            return this.toStringOrEmpty(value2);
        }

        private TruffleString joinTwo(Object thisObject, TruffleString joinSeparator, boolean appendSep) {
            TruffleString first = this.toStringOrEmpty(this.read(thisObject, 0));
            TruffleString second = this.toStringOrEmpty(this.read(thisObject, 1));
            long resultLength = (long)Strings.length(first) + (appendSep ? (long)Strings.length(joinSeparator) : 0L) + (long)Strings.length(second);
            if (resultLength > (long)this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            TruffleString res = first;
            if (appendSep) {
                res = this.concat(res, joinSeparator);
            }
            return this.concat(res, second);
        }

        private TruffleString joinLoop(Object thisJSObject, long length2, TruffleString joinSeparator, boolean appendSep) {
            TruffleStringBuilder sb = this.stringBuilderProfile.newStringBuilder();
            long i = 0L;
            while (i < length2) {
                if (appendSep && i != 0L) {
                    this.append(sb, joinSeparator);
                }
                Object value2 = this.read(thisJSObject, i);
                TruffleString str = this.toStringOrEmpty(value2);
                this.append(sb, str);
                if (appendSep) {
                    ++i;
                    continue;
                }
                i = this.nextElementIndex(thisJSObject, i, length2);
            }
            return this.builderToString(sb);
        }

        private TruffleString toStringOrEmpty(Object value2) {
            if (this.isValidEntry(value2)) {
                return this.elementToStringNode.executeString(value2);
            }
            return Strings.EMPTY_STRING;
        }

        private boolean isValidEntry(Object value2) {
            return value2 != Undefined.instance && value2 != Null.instance && !this.isForeignNull(value2);
        }

        private boolean isForeignNull(Object value2) {
            if (value2 instanceof JSDynamicObject) {
                return false;
            }
            if (value2 instanceof TruffleObject) {
                if (this.interopLibrary == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.interopLibrary = this.insert(InteropLibrary.getFactory().createDispatched(5));
                }
                return this.interopLibrary.isNull(value2);
            }
            return false;
        }

        private TruffleString joinSparse(Object thisObject, long length2, TruffleString joinSeparator, boolean appendSep, Node node, InlinedBranchProfile growProfile) {
            SimpleArrayList<Object> converted = SimpleArrayList.create(length2);
            long calculatedLength = 0L;
            long i = 0L;
            while (i < length2) {
                TruffleString string;
                int stringLength;
                Object value2 = this.read(thisObject, i);
                if (this.isValidEntry(value2) && (stringLength = Strings.length(string = this.elementToStringNode.executeString(value2))) > 0) {
                    calculatedLength += (long)stringLength;
                    converted.add(i, node, growProfile);
                    converted.add(string, node, growProfile);
                }
                i = this.nextElementIndex(thisObject, i, length2);
            }
            if (appendSep) {
                calculatedLength += (length2 - 1L) * (long)Strings.length(joinSeparator);
            }
            if (calculatedLength > (long)this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            assert (calculatedLength <= Integer.MAX_VALUE);
            TruffleStringBuilder sb = this.stringBuilderProfile.newStringBuilder((int)calculatedLength);
            long lastIndex = 0L;
            for (int j = 0; j < converted.size(); j += 2) {
                long index = (Long)converted.get(j);
                Object value3 = converted.get(j + 1);
                if (appendSep) {
                    for (long k = lastIndex; k < index; ++k) {
                        this.append(sb, joinSeparator);
                    }
                }
                this.append(sb, (TruffleString)value3);
                lastIndex = index;
            }
            if (appendSep) {
                for (long k = lastIndex; k < length2 - 1L; ++k) {
                    this.append(sb, joinSeparator);
                }
            }
            assert ((long)StringBuilderProfile.length(sb) == calculatedLength);
            return this.builderToString(sb);
        }
    }

    public static abstract class JSArrayToLocaleStringNode
    extends JSArrayOperation {
        private final boolean passArguments;
        private final StringBuilderProfile stringBuilderProfile;
        @Node.Child
        private PropertyGetNode getToLocaleStringNode;
        @Node.Child
        private JSFunctionCallNode callToLocaleStringNode;

        public JSArrayToLocaleStringNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
            this.passArguments = context.isOptionIntl402() && !context.isOptionV8CompatibilityMode();
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected TruffleString toLocaleString(VirtualFrame frame, Object thisObj, @Cached JSToStringNode toStringNode, @Cached TruffleStringBuilder.AppendCharUTF16Node appendCharNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode builderToStringNode, @Cached InlinedBranchProfile stackGrowProfile) {
            Object arrayObj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(arrayObj);
            if (len == 0L) {
                return Strings.EMPTY_STRING;
            }
            JSRealm realm = this.getRealm();
            if (!realm.joinStackPush(thisObj, this, stackGrowProfile)) {
                return Strings.EMPTY_STRING;
            }
            try {
                Object[] userArguments;
                if (this.passArguments) {
                    Object[] args = frame.getArguments();
                    int argc = JSArguments.getUserArgumentCount(args);
                    JSDynamicObject locales = argc > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                    JSDynamicObject options = argc > 1 ? JSArguments.getUserArgument(args, 1) : Undefined.instance;
                    userArguments = new Object[]{locales, options};
                } else {
                    userArguments = JSArguments.EMPTY_ARGUMENTS_ARRAY;
                }
                TruffleStringBuilder sb = this.stringBuilderProfile.newStringBuilder();
                for (long k = 0L; k < len; ++k) {
                    Object nextElement;
                    if (k > 0L) {
                        this.stringBuilderProfile.append(appendCharNode, sb, ',');
                    }
                    if ((nextElement = this.read(arrayObj, k)) == Null.instance || nextElement == Undefined.instance) continue;
                    Object result2 = this.callToLocaleString(nextElement, userArguments);
                    TruffleString resultString = toStringNode.executeString(result2);
                    this.stringBuilderProfile.append(appendStringNode, sb, resultString);
                }
                TruffleString truffleString = StringBuilderProfile.toString(builderToStringNode, sb);
                return truffleString;
            }
            finally {
                realm.joinStackPop();
            }
        }

        private Object callToLocaleString(Object nextElement, Object[] userArguments) {
            if (this.getToLocaleStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getToLocaleStringNode = this.insert(PropertyGetNode.create(Strings.TO_LOCALE_STRING, false, this.getContext()));
                this.callToLocaleStringNode = this.insert(JSFunctionCallNode.createCall());
            }
            Object toLocaleString = this.getToLocaleStringNode.getValue(nextElement);
            return this.callToLocaleStringNode.executeCall(JSArguments.create(nextElement, toLocaleString, userArguments));
        }
    }

    public static abstract class JSArraySpliceNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;
        private final BranchProfile branchA = BranchProfile.create();
        private final BranchProfile branchB = BranchProfile.create();
        private final BranchProfile needMoveDeleteBranch = BranchProfile.create();
        @Node.Child
        private InteropLibrary arrayInterop;

        public JSArraySpliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.deletePropertyNode = DeletePropertyNode.create(true, context);
        }

        @Specialization
        protected JSDynamicObject splice(Object thisArg, Object[] args, @Cached SpliceJSArrayNode spliceJSArray, @Cached InlinedBranchProfile branchDelete, @Cached InlinedBranchProfile objectBranch, @Cached InlinedConditionProfile argsLength0Profile, @Cached InlinedConditionProfile argsLength1Profile, @Cached InlinedConditionProfile offsetProfile, @Cached InlinedBranchProfile needInsertBranch) {
            long actualDeleteCount;
            long insertCount;
            Object thisObj = this.toObject(thisArg);
            long len = this.getLength(thisObj);
            long actualStart = JSRuntime.getOffset(this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 0)), len, (Node)this, offsetProfile);
            if (argsLength0Profile.profile(this, args.length == 0)) {
                insertCount = 0L;
                actualDeleteCount = 0L;
            } else if (argsLength1Profile.profile(this, args.length == 1)) {
                insertCount = 0L;
                actualDeleteCount = len - actualStart;
            } else {
                assert (args.length >= 2);
                insertCount = args.length - 2;
                long deleteCount = this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 1));
                actualDeleteCount = Math.min(Math.max(deleteCount, 0L), len - actualStart);
            }
            if (len + insertCount - actualDeleteCount > JSRuntime.MAX_SAFE_INTEGER_LONG) {
                this.errorBranch.enter();
                JSArraySpliceNode.throwLengthError();
            }
            JSDynamicObject aObj = (JSDynamicObject)this.getArraySpeciesConstructorNode().createEmptyContainer(thisObj, actualDeleteCount);
            if (actualDeleteCount > 0L) {
                branchDelete.enter(this);
                this.spliceRead(thisObj, actualStart, actualDeleteCount, aObj, len);
            }
            this.setLength((Object)aObj, actualDeleteCount);
            long itemCount = insertCount;
            boolean isJSArray = JSArray.isJSArray(thisObj);
            if (isJSArray) {
                JSArrayObject dynObj = (JSArrayObject)thisObj;
                ScriptArray arrayType = JSAbstractArray.arrayGetArrayType(dynObj);
                spliceJSArray.execute(dynObj, len, actualStart, actualDeleteCount, itemCount, arrayType, this);
            } else if (JSDynamicObject.isJSDynamicObject(thisObj)) {
                objectBranch.enter(this);
                this.spliceJSObject(thisObj, len, actualStart, actualDeleteCount, itemCount);
            } else {
                this.spliceForeignArray(thisObj, len, actualStart, actualDeleteCount, itemCount);
            }
            if (itemCount > 0L) {
                needInsertBranch.enter(this);
                this.spliceInsert(thisObj, actualStart, args);
            }
            long newLength = len - actualDeleteCount + itemCount;
            this.setLength(thisObj, newLength);
            this.reportLoopCount(len);
            return aObj;
        }

        final boolean mustUseElementwise(JSDynamicObject obj, long expectedLength, ScriptArray array, GetPrototypeNode getPrototypeNode) {
            return array instanceof SparseArray || array.isLengthNotWritable() || getPrototypeNode.execute(obj) != this.getRealm().getArrayPrototype() || !this.getContext().getArrayPrototypeNoElementsAssumption().isValid() || !this.getContext().getFastArrayAssumption().isValid() && JSSlowArray.isJSSlowArray(obj) || array.length(obj) != expectedLength;
        }

        private void spliceRead(Object thisObj, long actualStart, long actualDeleteCount, JSDynamicObject aObj, long length2) {
            long kPlusStart = actualStart;
            if (!this.hasProperty(thisObj, kPlusStart)) {
                kPlusStart = this.nextElementIndex(thisObj, kPlusStart, length2);
            }
            while (kPlusStart < actualDeleteCount + actualStart) {
                Object fromValue = this.read(thisObj, kPlusStart);
                this.writeOwn((Object)aObj, kPlusStart - actualStart, fromValue);
                kPlusStart = this.nextElementIndex(thisObj, kPlusStart, length2);
            }
        }

        private void spliceInsert(Object thisObj, long actualStart, Object[] args) {
            int itemOffset = 2;
            for (int i = 2; i < args.length; ++i) {
                this.write(thisObj, actualStart + (long)i - 2L, args[i]);
            }
        }

        private void spliceJSObject(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            if (itemCount < actualDeleteCount) {
                this.branchA.enter();
                this.spliceJSObjectShrink(thisObj, len, actualStart, actualDeleteCount, itemCount);
            } else if (itemCount > actualDeleteCount) {
                this.branchB.enter();
                this.spliceJSObjectMove(thisObj, len, actualStart, actualDeleteCount, itemCount);
            }
        }

        private void spliceJSObjectMove(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            for (long k = len - actualDeleteCount; k > actualStart; --k) {
                this.spliceMoveValue(thisObj, k + actualDeleteCount - 1L, k + itemCount - 1L);
            }
        }

        private void spliceJSObjectShrink(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            long k;
            for (k = actualStart; k < len - actualDeleteCount; ++k) {
                this.spliceMoveValue(thisObj, k + actualDeleteCount, k + itemCount);
            }
            for (k = len; k > len - actualDeleteCount + itemCount; --k) {
                this.deletePropertyNode.executeEvaluated(thisObj, k - 1L);
            }
        }

        private void spliceMoveValue(Object thisObj, long fromIndex, long toIndex) {
            if (this.hasProperty(thisObj, fromIndex)) {
                Object val = this.read(thisObj, fromIndex);
                this.write(thisObj, toIndex, val);
            } else {
                this.needMoveDeleteBranch.enter();
                this.deletePropertyNode.executeEvaluated(thisObj, toIndex);
            }
        }

        final void spliceJSArrayElementwise(JSDynamicObject thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            assert (JSArray.isJSArray(thisObj));
            if (itemCount < actualDeleteCount) {
                this.branchA.enter();
                this.spliceJSArrayElementwiseWalkUp(thisObj, len, actualStart, actualDeleteCount, itemCount);
            } else if (itemCount > actualDeleteCount) {
                this.branchB.enter();
                this.spliceJSArrayElementwiseWalkDown(thisObj, len, actualStart, actualDeleteCount, itemCount);
            }
        }

        private void spliceJSArrayElementwiseWalkDown(JSDynamicObject thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            long k = len - 1L;
            long delta = itemCount - actualDeleteCount;
            while (k > actualStart + actualDeleteCount - 1L) {
                this.spliceMoveValue(thisObj, k, k + delta);
                if (k - delta > actualStart + actualDeleteCount - 1L && !this.hasProperty((Object)thisObj, k - delta)) {
                    this.deletePropertyNode.executeEvaluated(thisObj, k);
                }
                k = this.previousElementIndex(thisObj, k);
            }
        }

        private void spliceJSArrayElementwiseWalkUp(JSDynamicObject thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            long k = actualStart + actualDeleteCount;
            long delta = itemCount - actualDeleteCount;
            while (k < len) {
                this.spliceMoveValue(thisObj, k, k + delta);
                if (k - delta < len && !this.hasProperty((Object)thisObj, k - delta)) {
                    this.deletePropertyNode.executeEvaluated(thisObj, k);
                }
                k = this.nextElementIndex(thisObj, k, len);
            }
            k = len - 1L;
            while (k >= len + delta) {
                this.deletePropertyNode.executeEvaluated(thisObj, k);
                k = this.previousElementIndex(thisObj, k);
            }
        }

        final void spliceJSArrayBlockwise(JSDynamicObject thisObj, long actualStart, long actualDeleteCount, long itemCount, ScriptArray array) {
            assert (JSArray.isJSArray(thisObj));
            if (itemCount < actualDeleteCount) {
                this.branchA.enter();
                JSAbstractArray.arraySetArrayType(thisObj, array.removeRange(thisObj, actualStart + itemCount, actualStart + actualDeleteCount, this.errorBranch));
            } else if (itemCount > actualDeleteCount) {
                this.branchB.enter();
                JSAbstractArray.arraySetArrayType(thisObj, array.addRange(thisObj, actualStart, (int)(itemCount - actualDeleteCount)));
            }
        }

        private void spliceForeignArray(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount) {
            InteropLibrary arrays = this.arrayInterop;
            if (arrays == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayInterop = arrays = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            try {
                if (itemCount < actualDeleteCount) {
                    this.branchA.enter();
                    JSArraySpliceNode.spliceForeignArrayShrink(thisObj, len, actualStart, actualDeleteCount, itemCount, arrays);
                } else if (itemCount > actualDeleteCount) {
                    this.branchB.enter();
                    JSArraySpliceNode.spliceForeignArrayMove(thisObj, len, actualStart, actualDeleteCount, itemCount, arrays);
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(thisObj, e, "splice", this);
            }
        }

        private static void spliceForeignArrayMove(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount, InteropLibrary arrays) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            for (long k = len - actualDeleteCount; k > actualStart; --k) {
                JSArraySpliceNode.spliceForeignMoveValue(thisObj, k + actualDeleteCount - 1L, k + itemCount - 1L, arrays);
            }
        }

        private static void spliceForeignArrayShrink(Object thisObj, long len, long actualStart, long actualDeleteCount, long itemCount, InteropLibrary arrays) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            long k;
            for (k = actualStart; k < len - actualDeleteCount; ++k) {
                JSArraySpliceNode.spliceForeignMoveValue(thisObj, k + actualDeleteCount, k + itemCount, arrays);
            }
            for (k = len; k > len - actualDeleteCount + itemCount; --k) {
                arrays.removeArrayElement(thisObj, k - 1L);
            }
        }

        private static void spliceForeignMoveValue(Object thisObj, long fromIndex, long toIndex, InteropLibrary arrays) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            Object val = arrays.readArrayElement(thisObj, fromIndex);
            arrays.writeArrayElement(thisObj, toIndex, val);
        }

        static abstract class SpliceJSArrayNode
        extends JavaScriptBaseNode {
            SpliceJSArrayNode() {
            }

            abstract void execute(JSDynamicObject var1, long var2, long var4, long var6, long var8, ScriptArray var10, JSArraySpliceNode var11);

            @Specialization(guards={"cachedArrayType.isInstance(arrayType)"}, limit="5")
            static void doCached(JSDynamicObject array, long len, long actualStart, long actualDeleteCount, long itemCount, ScriptArray arrayType, JSArraySpliceNode parent, @Cached(value="arrayType") ScriptArray cachedArrayType, @Bind(value="this") Node node, @Cached @Cached.Shared(value="getPrototype") GetPrototypeNode getPrototypeNode, @Cached @Cached.Shared(value="useElementwise") InlinedConditionProfile arrayElementwise) {
                if (arrayElementwise.profile(node, parent.mustUseElementwise(array, len, cachedArrayType.cast(arrayType), getPrototypeNode))) {
                    parent.spliceJSArrayElementwise(array, len, actualStart, actualDeleteCount, itemCount);
                } else {
                    parent.spliceJSArrayBlockwise(array, actualStart, actualDeleteCount, itemCount, cachedArrayType.cast(arrayType));
                }
            }

            @Specialization(replaces={"doCached"})
            static void doUncached(JSDynamicObject array, long len, long actualStart, long actualDeleteCount, long itemCount, ScriptArray arrayType, JSArraySpliceNode parent, @Bind(value="this") Node node, @Cached @Cached.Shared(value="getPrototype") GetPrototypeNode getPrototypeNode, @Cached @Cached.Shared(value="useElementwise") InlinedConditionProfile arrayElementwise) {
                if (arrayElementwise.profile(node, parent.mustUseElementwise(array, len, arrayType, getPrototypeNode))) {
                    parent.spliceJSArrayElementwise(array, len, actualStart, actualDeleteCount, itemCount);
                } else {
                    parent.spliceJSArrayBlockwise(array, actualStart, actualDeleteCount, itemCount, arrayType);
                }
            }
        }
    }

    public static abstract class JSArrayEveryNode
    extends ArrayForEachIndexCallOperation {
        public JSArrayEveryNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected boolean every(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return (Boolean)this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length2, true);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    return this.toBooleanNode.executeBoolean(callbackResult) ? ForEachIndexCallNode.MaybeResult.continueResult(currentResult) : ForEachIndexCallNode.MaybeResult.returnResult(false);
                }
            };
        }
    }

    public static abstract class JSArrayFilterNode
    extends ArrayForEachIndexCallOperation {
        private final ValueProfile arrayTypeProfile = ValueProfile.createClassProfile();
        private final ValueProfile resultArrayTypeProfile = ValueProfile.createClassProfile();

        public JSArrayFilterNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected JSDynamicObject filter(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            JSDynamicObject resultArray = this.isTypedArrayImplementation ? JSArray.createEmpty(this.getContext(), this.getRealm(), 0) : (JSDynamicObject)this.getArraySpeciesConstructorNode().arraySpeciesCreate(thisJSObj, 0L);
            this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length2, new FilterState(resultArray, 0L));
            if (this.isTypedArrayImplementation) {
                return this.getTypedResult((JSDynamicObject)thisJSObj, resultArray);
            }
            return resultArray;
        }

        private JSTypedArrayObject getTypedResult(JSDynamicObject thisJSObj, JSDynamicObject resultArray) {
            long resultLen = JSAbstractArray.arrayGetLength(resultArray);
            JSTypedArrayObject typedResult = this.getArraySpeciesConstructorNode().typedArraySpeciesCreate(thisJSObj, JSRuntime.longToIntOrDouble(resultLen));
            TypedArray typedArray = this.arrayTypeProfile.profile(JSArrayBufferView.typedArrayGetArrayType(typedResult));
            ScriptArray array = this.resultArrayTypeProfile.profile(JSAbstractArray.arrayGetArrayType(resultArray));
            for (long i = 0L; i < resultLen; ++i) {
                typedArray.setElement(typedResult, i, array.getElement(resultArray, i), true);
                TruffleSafepoint.poll(this);
            }
            return typedResult;
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
                @Node.Child
                private WriteElementNode writeOwnNode = WriteElementNode.create(this.getContext(), true, true);

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    if (this.toBooleanNode.executeBoolean(callbackResult)) {
                        FilterState filterState = (FilterState)currentResult;
                        this.writeOwnNode.executeWithTargetAndIndexAndValue((Object)filterState.resultArray, filterState.toIndex++, value2);
                    }
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }

        static final class FilterState {
            final JSDynamicObject resultArray;
            long toIndex;

            FilterState(JSDynamicObject resultArray, long toIndex) {
                this.resultArray = resultArray;
                this.toIndex = toIndex;
            }
        }
    }

    public static abstract class JSArrayForEachNode
    extends ArrayForEachIndexCallOperation {
        public JSArrayForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object forEach(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObject(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length2, Undefined.instance);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArraySomeNode
    extends ArrayForEachIndexCallOperation {
        public JSArraySomeNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected boolean some(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return (Boolean)this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length2, false);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    return this.toBooleanNode.executeBoolean(callbackResult) ? ForEachIndexCallNode.MaybeResult.returnResult(true) : ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArrayMapNode
    extends ArrayForEachIndexCallOperation {
        public JSArrayMapNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object map(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, length2);
            return this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length2, resultArray);
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                @Node.Child
                private WriteElementNode writeOwnNode;
                {
                    this.writeOwnNode = WriteElementNode.create(this.getContext(), true, true);
                }

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    this.writeOwnNode.executeWithTargetAndIndexAndValue(currentResult, index, callbackResult);
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }
    }

    public static abstract class JSArraySortNode
    extends JSArrayAbstractSortNode {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;
        private final ConditionProfile isSparse = ConditionProfile.create();
        private final BranchProfile hasCompareFnBranch = BranchProfile.create();
        private final BranchProfile noCompareFnBranch = BranchProfile.create();

        public JSArraySortNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization(guards={"!isTypedArrayImplementation", "isJSFastArray(thisObj)"}, assumptions={"getContext().getArrayPrototypeNoElementsAssumption()"})
        protected JSDynamicObject sortArray(JSDynamicObject thisObj, Object compare, @Cached(value="create(getContext())") JSArrayToDenseObjectArrayNode arrayToObjectArrayNode, @Cached(value="create(getContext(), true)") JSArrayDeleteRangeNode arrayDeleteRangeNode) {
            this.checkCompareFunction(compare);
            long len = this.getLength(thisObj);
            if (len < 2L) {
                return thisObj;
            }
            ScriptArray scriptArray = JSAbstractArray.arrayGetArrayType(thisObj);
            Object[] array = arrayToObjectArrayNode.executeObjectArray(thisObj, scriptArray, len);
            JSArraySortNode.sortIntl(this.getComparator(thisObj, compare), array);
            this.reportLoopCount(len);
            for (int i = 0; i < array.length; ++i) {
                this.write((Object)thisObj, i, array[i]);
            }
            if (this.isSparse.profile((long)array.length < len)) {
                arrayDeleteRangeNode.execute(thisObj, scriptArray, array.length, len);
            }
            return thisObj;
        }

        private void delete(Object obj, Object i) {
            if (this.deletePropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                JSContext context = this.getContext();
                this.deletePropertyNode = this.insert(DeletePropertyNode.create(true, context));
            }
            this.deletePropertyNode.executeEvaluated(obj, i);
        }

        @Specialization
        protected Object sort(Object thisObj, Object comparefn, @Cached InlinedConditionProfile isJSObject, @Cached InlinedBranchProfile growProfile) {
            this.checkCompareFunction(comparefn);
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            if (isJSObject.profile(this, JSDynamicObject.isJSDynamicObject(thisJSObj))) {
                return this.sortJSObject(comparefn, (JSDynamicObject)thisJSObj, growProfile);
            }
            return this.sortForeignObject(comparefn, thisJSObj);
        }

        private JSDynamicObject sortJSObject(Object comparefn, JSDynamicObject thisJSObj, InlinedBranchProfile growProfile) {
            long len = this.getLength(thisJSObj);
            if (len == 0L) {
                return thisJSObj;
            }
            Object[] array = JSArraySortNode.jsobjectToArray(thisJSObj, len, true, this, growProfile);
            Comparator<Object> comparator = this.getComparator(thisJSObj, comparefn);
            if (this.isTypedArrayImplementation && comparefn == Undefined.instance) {
                assert (comparator == null);
                JSArraySortNode.prepareForDefaultComparator(array);
            }
            JSArraySortNode.sortIntl(comparator, array);
            this.reportLoopCount(len);
            for (int i = 0; i < array.length; ++i) {
                this.write((Object)thisJSObj, i, array[i]);
            }
            if (this.isSparse.profile((long)array.length < len)) {
                this.deleteGenericElements(thisJSObj, array.length, len);
            }
            return thisJSObj;
        }

        public Object sortForeignObject(Object comparefn, Object thisObj) {
            assert (JSGuards.isForeignObject(thisObj));
            long len = this.getLength(thisObj);
            if (len < 2L) {
                return thisObj;
            }
            if (len >= Integer.MAX_VALUE) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidArrayLength(this);
            }
            Object[] array = this.foreignArrayToObjectArray(thisObj, (int)len);
            Comparator<Object> comparator = this.getComparator(thisObj, comparefn);
            JSArraySortNode.sortIntl(comparator, array);
            this.reportLoopCount(len);
            for (int i = 0; i < array.length; ++i) {
                this.write(thisObj, i, array[i]);
            }
            return thisObj;
        }

        private void checkCompareFunction(Object compare) {
            if (compare != Undefined.instance && !this.isCallable(compare)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("The comparison function must be either a function or undefined");
            }
        }

        private Comparator<Object> getComparator(Object thisObj, Object compare) {
            if (compare == Undefined.instance) {
                this.noCompareFnBranch.enter();
                return this.getDefaultComparator(thisObj);
            }
            assert (this.isCallable(compare));
            this.hasCompareFnBranch.enter();
            return new SortComparator(compare);
        }

        private Comparator<Object> getDefaultComparator(Object thisObj) {
            return SortComparator.getDefaultComparator(thisObj, this.isTypedArrayImplementation);
        }

        private void deleteGenericElements(Object obj, long fromIndex, long toIndex) {
            for (long index = fromIndex; index < toIndex; ++index) {
                this.delete(obj, index);
            }
        }

        private static void prepareForDefaultComparator(Object[] array) {
            boolean needsConversion = false;
            Class<?> clazz = array[0].getClass();
            for (Object element : array) {
                Class<?> c = element.getClass();
                if (clazz == c) continue;
                needsConversion = true;
                break;
            }
            if (needsConversion) {
                for (int i = 0; i < array.length; ++i) {
                    array[i] = JSRuntime.toDouble(array[i]);
                }
            }
        }
    }

    public static abstract class JSArrayReduceNode
    extends ArrayForEachIndexCallOperation {
        private final boolean isForward;
        @Node.Child
        private ForEachIndexCallNode forEachIndexFindInitialNode;

        public JSArrayReduceNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isForward) {
            super(context, builtin, isTypedArrayImplementation);
            this.isForward = isForward;
        }

        @Specialization
        protected Object reduce(Object thisObj, Object callback, Object[] initialValueOpt, @Cached InlinedBranchProfile findInitialValueBranch) {
            long currentIndex;
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object currentValue = initialValueOpt.length > 0 ? initialValueOpt[0] : null;
            long l = currentIndex = this.isForward() ? 0L : length2 - 1L;
            if (currentValue == null) {
                findInitialValueBranch.enter(this);
                Pair<Long, Object> res = this.findInitialValue(thisJSObj, currentIndex, length2);
                currentIndex = res.getFirst() + (long)(this.isForward() ? 1 : -1);
                currentValue = res.getSecond();
            }
            return this.forEachIndexCall(thisJSObj, callbackFn, Undefined.instance, currentIndex, length2, currentValue);
        }

        @Override
        protected boolean isForward() {
            return this.isForward;
        }

        protected final Pair<Long, Object> findInitialValue(Object arrayObj, long fromIndex, long length2) {
            Pair res;
            if (length2 >= 0L && (res = (Pair)this.getForEachIndexFindInitialNode().executeForEachIndex(arrayObj, null, null, fromIndex, length2, null)) != null) {
                return res;
            }
            this.errorBranch.enter();
            throw JSArrayReduceNode.reduceNoInitialValueError();
        }

        private ForEachIndexCallNode getForEachIndexFindInitialNode() {
            if (this.forEachIndexFindInitialNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.forEachIndexFindInitialNode = this.insert(ForEachIndexCallNode.create(this.getContext(), null, new ForEachIndexCallNode.MaybeResultNode(){

                    @Override
                    public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                        return ForEachIndexCallNode.MaybeResult.returnResult(new Pair<Long, Object>(index, value2));
                    }
                }, this.isForward(), this.shouldCheckHasProperty()));
            }
            return this.forEachIndexFindInitialNode;
        }

        @Override
        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return new ArrayForEachIndexCallOperation.DefaultCallbackNode(){

                @Override
                public Object apply(long index, Object value2, Object target, Object callback, Object callbackThisArg, Object currentResult) {
                    return this.callNode.executeCall(JSArguments.create(callbackThisArg, callback, currentResult, value2, this.boxIndex(index), target));
                }
            };
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value2, Object callbackResult, Object currentResult) {
                    return ForEachIndexCallNode.MaybeResult.continueResult(callbackResult);
                }
            };
        }

        @CompilerDirectives.TruffleBoundary
        protected static RuntimeException reduceNoInitialValueError() {
            throw Errors.createTypeError("Reduce of empty array with no initial value");
        }
    }

    public static abstract class JSArrayReverseNode
    extends JSArrayOperation {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;

        public JSArrayReverseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private boolean deleteProperty(Object array, long index) {
            if (this.deletePropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.deletePropertyNode = this.insert(DeletePropertyNode.create(true, this.getContext()));
            }
            return this.deletePropertyNode.executeEvaluated(array, index);
        }

        @Specialization
        protected final Object reverseJSArray(JSArrayObject thisObj, @Cached.Shared @Cached(value="createHasHoles()") TestArrayNode hasHolesNode, @Cached.Shared @Cached InlinedConditionProfile bothExistProfile, @Cached.Shared @Cached InlinedConditionProfile onlyUpperExistsProfile, @Cached.Shared @Cached InlinedConditionProfile onlyLowerExistsProfile) {
            return this.reverse(thisObj, true, hasHolesNode, bothExistProfile, onlyUpperExistsProfile, onlyLowerExistsProfile);
        }

        @Specialization(replaces={"reverseJSArray"})
        protected final Object reverseGeneric(Object thisObj, @Cached.Shared @Cached(value="createHasHoles()") TestArrayNode hasHolesNode, @Cached.Shared @Cached InlinedConditionProfile bothExistProfile, @Cached.Shared @Cached InlinedConditionProfile onlyUpperExistsProfile, @Cached.Shared @Cached InlinedConditionProfile onlyLowerExistsProfile) {
            Object array = this.toObject(thisObj);
            return this.reverse(array, JSArray.isJSArray(array), hasHolesNode, bothExistProfile, onlyUpperExistsProfile, onlyLowerExistsProfile);
        }

        private Object reverse(Object array, boolean isArray, TestArrayNode hasHolesNode, InlinedConditionProfile bothExistProfile, InlinedConditionProfile onlyUpperExistsProfile, InlinedConditionProfile onlyLowerExistsProfile) {
            boolean hasHoles;
            long length2 = this.getLength(array);
            long lower = 0L;
            long upper = length2 - 1L;
            boolean bl = hasHoles = isArray && hasHolesNode.executeBoolean((JSDynamicObject)array);
            while (lower < upper) {
                boolean upperExists;
                boolean lowerExists;
                Object lowerValue = null;
                Object upperValue = null;
                if (this.getContext().getEcmaScriptVersion() < 6) {
                    lowerValue = this.read(array, lower);
                    upperValue = this.read(array, upper);
                    lowerExists = lowerValue != Undefined.instance || this.hasProperty(array, lower);
                    upperExists = upperValue != Undefined.instance || this.hasProperty(array, upper);
                } else {
                    lowerExists = this.hasProperty(array, lower);
                    if (lowerExists) {
                        lowerValue = this.read(array, lower);
                    }
                    if (upperExists = this.hasProperty(array, upper)) {
                        upperValue = this.read(array, upper);
                    }
                }
                if (bothExistProfile.profile(this, lowerExists && upperExists)) {
                    this.write(array, lower, upperValue);
                    this.write(array, upper, lowerValue);
                } else if (onlyUpperExistsProfile.profile(this, !lowerExists && upperExists)) {
                    this.write(array, lower, upperValue);
                    this.deleteProperty(array, upper);
                } else if (onlyLowerExistsProfile.profile(this, lowerExists && !upperExists)) {
                    this.deleteProperty(array, lower);
                    this.write(array, upper, lowerValue);
                } else assert (!lowerExists && !upperExists);
                if (hasHoles) {
                    long nextUpper;
                    long nextLower = this.nextElementIndex(array, lower, length2);
                    if (length2 - nextLower - 1L >= (nextUpper = this.previousElementIndex(array, upper))) {
                        lower = nextLower;
                        upper = length2 - lower - 1L;
                    } else {
                        lower = length2 - nextUpper - 1L;
                        upper = nextUpper;
                    }
                } else {
                    ++lower;
                    --upper;
                }
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(lower);
            return array;
        }
    }

    public static abstract class JSArrayFindNode
    extends JSArrayOperation {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        private final boolean isLast;

        public JSArrayFindNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isLast) {
            super(context, builtin, isTypedArrayImplementation);
            this.isLast = isLast;
        }

        private Object callPredicate(Object function, Object target, Object value2, double index, Object thisObj) {
            return this.callNode.executeCall(JSArguments.create(target, function, value2, index, thisObj));
        }

        @Specialization
        protected Object find(Object thisObj, Object callback, Object thisArg) {
            long idx;
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            long l = idx = this.isLast ? length2 - 1L : 0L;
            while (this.isLast ? idx >= 0L : idx < length2) {
                Object value2 = this.read(thisObj, idx);
                Object callbackResult = this.callPredicate(callbackFn, thisArg, value2, idx, thisJSObj);
                boolean testResult = this.toBooleanNode.executeBoolean(callbackResult);
                if (testResult) {
                    this.reportLoopCount(this.isLast ? length2 - idx - 1L : idx);
                    return value2;
                }
                idx = this.isLast ? idx - 1L : idx + 1L;
            }
            this.reportLoopCount(length2);
            return Undefined.instance;
        }
    }

    public static abstract class JSArrayFindIndexNode
    extends JSArrayOperation {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        private final boolean isLast;

        public JSArrayFindIndexNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation, boolean isLast) {
            super(context, builtin, isTypedArrayImplementation);
            this.isLast = isLast;
        }

        private Object callPredicate(Object function, Object target, Object value2, double index, Object thisObj) {
            return this.callNode.executeCall(JSArguments.create(target, function, value2, index, thisObj));
        }

        @Specialization
        protected Object findIndex(Object thisObj, Object callback, Object thisArg) {
            long idx;
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            long l = idx = this.isLast ? length2 - 1L : 0L;
            while (this.isLast ? idx >= 0L : idx < length2) {
                Object value2 = this.read(thisObj, idx);
                Object callbackResult = this.callPredicate(callbackFn, thisArg, value2, idx, thisJSObj);
                boolean testResult = this.toBooleanNode.executeBoolean(callbackResult);
                if (testResult) {
                    this.reportLoopCount(this.isLast ? length2 - idx - 1L : idx);
                    return JSRuntime.positiveLongToIntOrDouble(idx);
                }
                idx = this.isLast ? idx - 1L : idx + 1L;
            }
            this.reportLoopCount(length2);
            return -1;
        }
    }

    public static abstract class JSArrayFillNode
    extends JSArrayOperationWithToInt {
        public JSArrayFillNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object fill(Object thisObj, Object value2, Object start2, Object end, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(thisJSObj);
            long lStart = JSRuntime.getOffset(this.toIntegerAsLong(start2), len, (Node)this, offsetProfile1);
            long lEnd = end == Undefined.instance ? len : JSRuntime.getOffset(this.toIntegerAsLong(end), len, (Node)this, offsetProfile2);
            for (long idx = lStart; idx < lEnd; ++idx) {
                this.write(thisJSObj, idx, value2);
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(lEnd - lStart);
            return thisJSObj;
        }
    }

    public static abstract class JSArrayCopyWithinNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private DeletePropertyNode deletePropertyNode;

        public JSArrayCopyWithinNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
            this.deletePropertyNode = DeletePropertyNode.create(true, context);
        }

        @Specialization
        protected Object copyWithin(Object thisObj, Object target, Object start2, Object end, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2, @Cached InlinedConditionProfile offsetProfile3) {
            long count;
            Object obj = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(obj);
            long to = JSRuntime.getOffset(this.toIntegerAsLong(target), len, (Node)this, offsetProfile1);
            long from2 = JSRuntime.getOffset(this.toIntegerAsLong(start2), len, (Node)this, offsetProfile2);
            long finalIdx = end == Undefined.instance ? len : JSRuntime.getOffset(this.toIntegerAsLong(end), len, (Node)this, offsetProfile3);
            long expectedCount = count = Math.min(finalIdx - from2, len - to);
            if (count > 0L) {
                long direction;
                if (this.isTypedArrayImplementation) {
                    this.checkHasDetachedBuffer((JSDynamicObject)thisObj);
                }
                if (from2 < to && to < from2 + count) {
                    direction = -1L;
                    from2 = from2 + count - 1L;
                    to = to + count - 1L;
                } else {
                    direction = 1L;
                }
                while (count > 0L) {
                    if (this.isTypedArrayImplementation || this.hasProperty(obj, from2)) {
                        Object fromVal = this.read(obj, from2);
                        this.write(obj, to, fromVal);
                    } else {
                        this.deletePropertyNode.executeEvaluated(obj, to);
                    }
                    from2 += direction;
                    to += direction;
                    --count;
                    TruffleSafepoint.poll(this);
                }
                this.reportLoopCount(expectedCount);
            }
            return obj;
        }
    }

    public static abstract class JSArrayIteratorNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateArrayIteratorNode createArrayIteratorNode;

        public JSArrayIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.createArrayIteratorNode = CreateArrayIteratorNode.create(context, iterationKind);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected JSDynamicObject doJSObject(JSDynamicObject thisObj) {
            return this.createArrayIteratorNode.execute(thisObj);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected JSDynamicObject doNotJSObject(Object thisObj, @Cached JSToObjectNode toObjectNode) {
            return this.createArrayIteratorNode.execute(toObjectNode.execute(thisObj));
        }
    }

    public static abstract class JSArrayIncludesNode
    extends JSArrayOperationWithToInt {
        public JSArrayIncludesNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected boolean includes(Object thisValue, Object searchElement, Object fromIndex, @Cached(value="createSameValueZero()") JSIdenticalNode identicalNode) {
            long k;
            Object thisObj = this.toObjectOrValidateTypedArray(thisValue);
            long len = this.getLength(thisObj);
            if (len == 0L) {
                return false;
            }
            long n = this.toIntegerAsLong(fromIndex);
            if (n >= 0L) {
                k = n;
            } else {
                k = len + n;
                if (k < 0L) {
                    k = 0L;
                }
            }
            if (!identicalNode.executeBoolean(searchElement, searchElement)) {
                return true;
            }
            long startIdx = k;
            while (k < len) {
                Object currentElement = this.read(thisObj, k);
                if (identicalNode.executeBoolean(searchElement, currentElement)) {
                    this.reportLoopCount(k - startIdx);
                    return true;
                }
                ++k;
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(len - startIdx);
            return false;
        }
    }

    public static abstract class JSArrayFlatMapNode
    extends JSArrayOperation {
        public JSArrayFlatMapNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected Object flatMap(Object thisObj, Object callback, Object thisArg, @Cached(value="createFlattenIntoArrayNode(getContext())") FlattenIntoArrayNode flattenIntoArrayNode) {
            Object thisJSObj = this.toObject(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, 0L);
            flattenIntoArrayNode.flatten((JSDynamicObject)resultArray, thisJSObj, length2, 0L, 1L, callbackFn, thisArg);
            return resultArray;
        }

        @NeverDefault
        protected static final FlattenIntoArrayNode createFlattenIntoArrayNode(JSContext context) {
            return ArrayPrototypeBuiltinsFactory.FlattenIntoArrayNodeGen.create(context, true);
        }
    }

    public static abstract class JSArrayFlatNode
    extends JSArrayOperation {
        @Node.Child
        private JSToIntegerAsIntNode toIntegerNode;

        public JSArrayFlatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected Object flat(Object thisObj, Object depth, @Cached(value="createFlattenIntoArrayNode(getContext())") FlattenIntoArrayNode flattenIntoArrayNode) {
            Object thisJSObj = this.toObject(thisObj);
            long length2 = this.getLength(thisJSObj);
            long depthNum = depth == Undefined.instance ? 1L : (long)this.toIntegerAsInt(depth);
            Object resultArray = this.getArraySpeciesConstructorNode().createEmptyContainer(thisJSObj, 0L);
            flattenIntoArrayNode.flatten((JSDynamicObject)resultArray, thisJSObj, length2, 0L, depthNum, null, null);
            return resultArray;
        }

        private int toIntegerAsInt(Object depth) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = this.insert(JSToIntegerAsIntNode.create());
            }
            return this.toIntegerNode.executeInt(depth);
        }

        @NeverDefault
        protected static final FlattenIntoArrayNode createFlattenIntoArrayNode(JSContext context) {
            return ArrayPrototypeBuiltinsFactory.FlattenIntoArrayNodeGen.create(context, false);
        }
    }

    public static abstract class JSArrayAtNode
    extends JSArrayOperationWithToInt {
        public JSArrayAtNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object at(Object thisObj, Object index) {
            Object o = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(o);
            long relativeIndex = this.toIntegerAsLong(index);
            long k = relativeIndex >= 0L ? relativeIndex : length2 + relativeIndex;
            if (k < 0L || k >= length2) {
                return Undefined.instance;
            }
            return this.read(o, k);
        }
    }

    public static abstract class JSArrayGroupNode
    extends JSArrayGroupBaseNode {
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();

        public JSArrayGroupNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object group(Object thisObj, Object callback, Object thisArg) {
            Map<Object, List<Object>> groups = this.collectGroupResults(thisObj, callback, thisArg);
            JSObject obj = JSOrdinary.createWithNullPrototype(this.getContext());
            return this.createGroupResult(obj, groups);
        }

        @Override
        protected final Object toKey(Object callbackResult) {
            return this.toPropertyKeyNode.execute(callbackResult);
        }

        @CompilerDirectives.TruffleBoundary
        protected Object createGroupResult(JSDynamicObject obj, Map<Object, List<Object>> groups) {
            for (Map.Entry<Object, List<Object>> entry : groups.entrySet()) {
                JSArrayObject elements = JSArray.createConstant(this.getContext(), this.getRealm(), entry.getValue().toArray());
                JSObjectUtil.defineDataProperty(this.getContext(), obj, entry.getKey(), elements, JSAttributes.getDefault());
            }
            return obj;
        }
    }

    public static abstract class JSArrayGroupToMapNode
    extends JSArrayGroupBaseNode {
        @Node.Child
        private JSCollectionsNormalizeNode normalizeKeyNode = JSCollectionsNormalizeNode.create();

        public JSArrayGroupToMapNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object groupToMap(Object thisObj, Object callback, Object thisArg) {
            Map<Object, List<Object>> groups = this.collectGroupResults(thisObj, callback, thisArg);
            JSMapObject map2 = JSMap.create(this.getContext(), this.getRealm());
            return this.createGroupResult(map2, groups);
        }

        @Override
        protected final Object toKey(Object callbackResult) {
            return this.normalizeKeyNode.execute(callbackResult);
        }

        @CompilerDirectives.TruffleBoundary
        protected Object createGroupResult(JSMapObject map2, Map<Object, List<Object>> groups) {
            JSHashMap internalMap = JSMap.getInternalMap(map2);
            JSRealm realm = this.getRealm();
            for (Map.Entry<Object, List<Object>> entry : groups.entrySet()) {
                JSArrayObject elements = JSArray.createConstant(this.getContext(), realm, entry.getValue().toArray());
                internalMap.put(entry.getKey(), elements);
            }
            return map2;
        }
    }

    public static abstract class JSArrayToReversedNode
    extends JSArrayOperation {
        public JSArrayToReversedNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        protected Object reverse(Object thisObj) {
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            JSObject result2 = this.createEmpty(thisJSObj, length2);
            for (long i = 0L; i < length2; ++i) {
                Object value2 = this.read(thisJSObj, length2 - 1L - i);
                this.write((Object)result2, i, value2);
            }
            return result2;
        }
    }

    public static abstract class JSArrayToSortedNode
    extends JSArrayAbstractSortNode {
        public JSArrayToSortedNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @Specialization
        public Object toSorted(Object thisObj, Object compare, @Cached InlinedBranchProfile growProfile, @Cached InlinedConditionProfile isJSObject) {
            Object[] array;
            if (compare != Undefined.instance && !this.isCallable(compare)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("The comparison function must be either a function or undefined");
            }
            Object thisJSObj = this.toObjectOrValidateTypedArray(thisObj);
            long length2 = this.getLength(thisJSObj);
            JSObject result2 = this.createEmpty(thisJSObj, length2);
            if (isJSObject.profile(this, JSDynamicObject.isJSDynamicObject(thisJSObj))) {
                array = JSArrayToSortedNode.jsobjectToArray((JSDynamicObject)thisJSObj, length2, false, this, growProfile);
            } else {
                if (length2 >= Integer.MAX_VALUE) {
                    this.errorBranch.enter();
                    throw Errors.createRangeErrorInvalidArrayLength(this);
                }
                array = this.foreignArrayToObjectArray(thisObj, (int)length2);
            }
            Comparator<Object> comparator = compare == Undefined.instance ? (this.isTypedArrayImplementation ? null : JSArray.DEFAULT_JSARRAY_COMPARATOR) : new SortComparator(compare);
            JSArrayToSortedNode.sortIntl(comparator, array);
            assert (length2 == (long)array.length);
            for (int i = 0; i < array.length; ++i) {
                this.write((Object)result2, i, array[i]);
            }
            return result2;
        }
    }

    public static abstract class JSArrayToSplicedNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private InteropLibrary arrayInterop;
        @Node.Child
        private ImportValueNode importValueNode;

        public JSArrayToSplicedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject toSpliced(Object thisArg, Object[] args, @Cached InlinedConditionProfile offsetProfile, @Cached InlinedConditionProfile argsLength0Profile, @Cached InlinedConditionProfile argsLength1Profile, @Cached InlinedBranchProfile objectBranch) {
            long actualDeleteCount;
            long insertCount;
            Object thisObj = this.toObject(thisArg);
            long len = this.getLength(thisObj);
            long actualStart = JSRuntime.getOffset(this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 0)), len, (Node)this, offsetProfile);
            if (argsLength0Profile.profile(this, args.length == 0)) {
                insertCount = 0L;
                actualDeleteCount = 0L;
            } else if (argsLength1Profile.profile(this, args.length == 1)) {
                insertCount = 0L;
                actualDeleteCount = len - actualStart;
            } else {
                assert (args.length >= 2);
                insertCount = args.length - 2;
                long deleteCount = this.toIntegerAsLong(JSRuntime.getArgOrUndefined(args, 1));
                actualDeleteCount = Math.min(Math.max(deleteCount, 0L), len - actualStart);
            }
            long newLen = len + insertCount - actualDeleteCount;
            if (newLen > JSRuntime.MAX_SAFE_INTEGER_LONG) {
                this.errorBranch.enter();
                JSArrayToSplicedNode.throwLengthError();
            }
            JSArrayObject resObj = this.getArraySpeciesConstructorNode().arrayCreate(newLen);
            if (JSDynamicObject.isJSDynamicObject(thisObj)) {
                objectBranch.enter(this);
                this.spliceJSObject(resObj, thisObj, len, actualStart, actualDeleteCount, args);
            } else {
                this.spliceForeignArray(resObj, thisObj, len, actualStart, actualDeleteCount, args);
            }
            this.reportLoopCount(len);
            return resObj;
        }

        private long spliceInsert(JSDynamicObject dstObj, long toIndex, Object[] args) {
            int itemOffset = 2;
            long dstIdx = toIndex;
            for (int argIdx = itemOffset; argIdx < args.length; ++argIdx) {
                this.writeOwn((Object)dstObj, dstIdx++, args[argIdx]);
            }
            return dstIdx;
        }

        private void spliceJSObject(JSArrayObject dstObj, Object srcObj, long len, long actualStart, long actualDeleteCount, Object[] args) {
            long srcIdx;
            long dstIdx = 0L;
            for (srcIdx = 0L; srcIdx < actualStart; ++srcIdx) {
                this.writeOwn((Object)dstObj, dstIdx++, this.read(srcObj, srcIdx));
            }
            dstIdx = this.spliceInsert(dstObj, dstIdx, args);
            for (srcIdx = actualStart + actualDeleteCount; srcIdx < len; ++srcIdx) {
                this.writeOwn((Object)dstObj, dstIdx++, this.read(srcObj, srcIdx));
            }
        }

        private void spliceForeignArray(JSArrayObject dstObj, Object srcObj, long len, long actualStart, long actualDeleteCount, Object[] args) {
            long srcIdx;
            InteropLibrary arrays = this.arrayInterop;
            if (arrays == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayInterop = arrays = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            long dstIdx = 0L;
            for (srcIdx = 0L; srcIdx < actualStart; ++srcIdx) {
                this.spliceForeignMoveValue(dstObj, srcObj, srcIdx, dstIdx++, arrays);
            }
            dstIdx = this.spliceInsert(dstObj, dstIdx, args);
            for (srcIdx = actualStart + actualDeleteCount; srcIdx < len; ++srcIdx) {
                this.spliceForeignMoveValue(dstObj, srcObj, srcIdx, dstIdx++, arrays);
            }
        }

        private void spliceForeignMoveValue(JSArrayObject destObj, Object srcObj, long fromIndex, long toIndex, InteropLibrary arrays) {
            if (this.importValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.importValueNode = this.insert(ImportValueNode.create());
            }
            Object val = JSInteropUtil.readArrayElementOrDefault(srcObj, fromIndex, Undefined.instance, arrays, this.importValueNode, this);
            this.writeOwn((Object)destObj, toIndex, val);
        }
    }

    public static abstract class JSArrayWithNode
    extends JSArrayOperationWithToInt {
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToBigIntNode toBigIntNode;

        public JSArrayWithNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        protected Object toNumber(Object value2) {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode.execute(value2);
        }

        protected Object toBigInt(Object value2) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.execute(value2);
        }

        @Specialization
        protected Object withGeneric(Object thisObj, Object index, Object valueParam) {
            long k;
            Object value2 = valueParam;
            Object array = this.toObjectOrValidateTypedArray(thisObj);
            long len = this.getLength(array);
            long relativeIndex = this.toIntegerAsLong(index);
            long actualIndex = relativeIndex >= 0L ? relativeIndex : len + relativeIndex;
            if (this.isTypedArrayImplementation) {
                value2 = JSArrayBufferView.isJSArrayBufferView(array) && JSArrayBufferView.isBigIntArrayBufferView((JSDynamicObject)array) ? this.toBigInt(value2) : this.toNumber(value2);
            }
            if (actualIndex >= len || actualIndex < 0L) {
                this.errorBranch.enter();
                throw Errors.createRangeError("invalid index");
            }
            JSObject resultArray = this.createEmpty(array, len);
            for (k = 0L; k < len; ++k) {
                Object val = k == actualIndex ? value2 : this.read(array, k);
                this.writeOwn((Object)resultArray, k, val);
                TruffleSafepoint.poll(this);
            }
            this.reportLoopCount(k);
            return resultArray;
        }
    }

    public static abstract class JSArrayGroupBaseNode
    extends JSArrayOperation {
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

        protected JSArrayGroupBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        protected Map<Object, List<Object>> collectGroupResults(Object thisObj, Object callback, Object thisArg) {
            Object thisJSObj = this.toObject(thisObj);
            long length2 = this.getLength(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            Map<Object, List<Object>> groups = JSArrayGroupBaseNode.initGroups();
            for (long k = 0L; k < length2; ++k) {
                Object kValue = this.read(thisObj, k);
                Object key = this.toKey(this.callNode.executeCall(JSArguments.create(thisArg, callbackFn, kValue, k, thisJSObj)));
                JSArrayGroupBaseNode.addValueToKeyedGroup(groups, key, kValue);
            }
            return groups;
        }

        @CompilerDirectives.TruffleBoundary
        private static Map<Object, List<Object>> initGroups() {
            return new LinkedHashMap<Object, List<Object>>();
        }

        @CompilerDirectives.TruffleBoundary
        private static void addValueToKeyedGroup(Map<Object, List<Object>> groups, Object key, Object value2) {
            List<Object> group = groups.get(key);
            if (group == null) {
                group = new ArrayList<Object>();
                groups.put(key, group);
            }
            group.add(value2);
        }

        protected abstract Object toKey(Object var1);
    }

    public static class CreateArrayIteratorNode
    extends JavaScriptBaseNode {
        private final int iterationKind;
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;
        @Node.Child
        private PropertySetNode setIterationKindNode;

        protected CreateArrayIteratorNode(JSContext context, int iterationKind) {
            this.iterationKind = iterationKind;
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSRuntime.ITERATED_OBJECT_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSRuntime.ITERATOR_NEXT_INDEX, context);
            this.setIterationKindNode = PropertySetNode.createSetHidden(JSArray.ARRAY_ITERATION_KIND_ID, context);
        }

        public static CreateArrayIteratorNode create(JSContext context, int iterationKind) {
            return new CreateArrayIteratorNode(context, iterationKind);
        }

        public JSDynamicObject execute(Object array) {
            assert (JSGuards.isJSObject(array) || JSGuards.isForeignObject(array));
            JSObject iterator = this.createObjectNode.execute(this.getRealm().getArrayIteratorPrototype());
            this.setIteratedObjectNode.setValue(iterator, array);
            this.setNextIndexNode.setValue(iterator, 0L);
            this.setIterationKindNode.setValueInt(iterator, this.iterationKind);
            return iterator;
        }
    }

    public static abstract class JSArrayAbstractSortNode
    extends JSArrayOperation {
        @Node.Child
        private InteropLibrary interopNode;
        @Node.Child
        private ImportValueNode importValueNode;

        public JSArrayAbstractSortNode(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        @CompilerDirectives.TruffleBoundary
        protected static Object[] jsobjectToArray(JSDynamicObject thisObj, long len, boolean skipHoles, Node node, InlinedBranchProfile growProfile) {
            SimpleArrayList<Object> list2 = SimpleArrayList.create(len);
            for (long k = 0L; k < len; ++k) {
                if (skipHoles && !JSObject.hasProperty(thisObj, k)) continue;
                list2.add(JSObject.get(thisObj, k), node, growProfile);
            }
            return list2.toArray();
        }

        protected Object[] foreignArrayToObjectArray(Object thisObj, int len) {
            InteropLibrary interop = this.interopNode;
            ImportValueNode importValue = this.importValueNode;
            if (interop == null || importValue == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopNode = interop = this.insert(InteropLibrary.getFactory().createDispatched(5));
                this.importValueNode = importValue = this.insert(ImportValueNode.create());
            }
            Object[] array = new Object[len];
            for (int index = 0; index < len; ++index) {
                array[index] = JSInteropUtil.readArrayElementOrDefault(thisObj, index, Undefined.instance, interop, importValue, this);
            }
            return array;
        }

        @CompilerDirectives.TruffleBoundary
        protected static void sortIntl(Comparator<Object> comparator, Object[] array) {
            try {
                Arrays.sort(array, comparator);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static abstract class FlattenIntoArrayNode
    extends JavaScriptBaseNode {
        protected final JSContext context;
        protected final boolean withMapCallback;
        @Node.Child
        private ForEachIndexCallNode forEachIndexNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;

        protected FlattenIntoArrayNode(JSContext context, boolean withMapCallback) {
            this.context = context;
            this.withMapCallback = withMapCallback;
        }

        @NeverDefault
        public static FlattenIntoArrayNode create(JSContext context, boolean withCallback) {
            return ArrayPrototypeBuiltinsFactory.FlattenIntoArrayNodeGen.create(context, withCallback);
        }

        protected abstract long executeLong(JSDynamicObject var1, Object var2, long var3, long var5, long var7, Object var9, Object var10);

        @Specialization
        protected long flatten(JSDynamicObject target, Object source, long sourceLen, long start2, long depth, Object callback, Object thisArg) {
            boolean callbackUndefined = callback == null;
            FlattenState flattenState = new FlattenState(target, start2, depth, callbackUndefined);
            Object thisJSObj = this.toObject(source);
            this.forEachIndexCall(thisJSObj, callback, thisArg, 0L, sourceLen, flattenState);
            return flattenState.targetIndex;
        }

        protected final Object forEachIndexCall(Object arrayObj, Object callbackObj, Object thisArg, long fromIndex, long length2, Object initialResult) {
            if (this.forEachIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.forEachIndexNode = this.insert(this.makeForEachIndexCallNode());
            }
            return this.forEachIndexNode.executeForEachIndex(arrayObj, callbackObj, thisArg, fromIndex, length2, initialResult);
        }

        private ForEachIndexCallNode makeForEachIndexCallNode() {
            return ForEachIndexCallNode.create(this.context, this.makeCallbackNode(), this.makeMaybeResultNode(), true, true);
        }

        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return this.withMapCallback ? new ArrayForEachIndexCallOperation.DefaultCallbackNode() : null;
        }

        protected final Object toObject(Object target) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(target);
        }

        protected long getLength(Object thisObject) {
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(JSGetLengthNode.create(this.context));
            }
            return this.getLengthNode.executeLong(thisObject);
        }

        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){
                protected final BranchProfile errorBranch = BranchProfile.create();
                @Node.Child
                private WriteElementNode writeOwnNode;
                @Node.Child
                private DirectCallNode innerFlattenCall;
                {
                    this.writeOwnNode = WriteElementNode.create(context, true, true);
                }

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object originalValue, Object callbackResult, Object resultState) {
                    Object value2;
                    boolean shouldFlatten = false;
                    FlattenState state = (FlattenState)resultState;
                    Object object = value2 = state.callbackUndefined ? originalValue : callbackResult;
                    if (state.depth > 0L) {
                        shouldFlatten = JSRuntime.isArray(value2);
                    }
                    if (shouldFlatten) {
                        long elementLen = this.getLength(this.toObject(value2));
                        state.targetIndex = this.makeFlattenCall(state.resultArray, value2, elementLen, state.targetIndex, state.depth - 1L);
                    } else {
                        if (state.targetIndex >= JSRuntime.MAX_SAFE_INTEGER_LONG) {
                            this.errorBranch.enter();
                            throw Errors.createTypeError("Index out of bounds in flatten into array");
                        }
                        this.writeOwnNode.executeWithTargetAndIndexAndValue((Object)state.resultArray, state.targetIndex++, value2);
                    }
                    return ForEachIndexCallNode.MaybeResult.continueResult(resultState);
                }

                private long makeFlattenCall(JSDynamicObject targetArray, Object element, long elementLength, long targetIndex, long depth) {
                    if (this.innerFlattenCall == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        JSFunctionData flattenFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayFlattenIntoArray, c -> FlattenIntoArrayNode.createOrGetFlattenCallFunctionData(c));
                        this.innerFlattenCall = this.insert(DirectCallNode.create(flattenFunctionData.getCallTarget()));
                    }
                    return (Long)this.innerFlattenCall.call(targetArray, element, elementLength, targetIndex, depth);
                }
            };
        }

        private static JSFunctionData createOrGetFlattenCallFunctionData(JSContext context) {
            return JSFunctionData.createCallOnly(context, new InnerFlattenCallNode(context, FlattenIntoArrayNode.create(context, false)).getCallTarget(), 0, Strings.EMPTY_STRING);
        }

        static final class FlattenState {
            final JSDynamicObject resultArray;
            final boolean callbackUndefined;
            final long depth;
            long targetIndex;

            FlattenState(JSDynamicObject result2, long toIndex, long depth, boolean callbackUndefined) {
                this.resultArray = result2;
                this.callbackUndefined = callbackUndefined;
                this.targetIndex = toIndex;
                this.depth = depth;
            }
        }

        private static final class InnerFlattenCallNode
        extends JavaScriptRootNode {
            @Node.Child
            private FlattenIntoArrayNode flattenNode;

            InnerFlattenCallNode(JSContext context, FlattenIntoArrayNode flattenNode) {
                super(context.getLanguage(), null, null);
                this.flattenNode = flattenNode;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                JSDynamicObject resultArray = (JSDynamicObject)arguments[0];
                Object element = arguments[1];
                long elementLen = (Long)arguments[2];
                long targetIndex = (Long)arguments[3];
                long depth = (Long)arguments[4];
                return this.flattenNode.flatten(resultArray, element, elementLen, targetIndex, depth, null, null);
            }
        }
    }

    public static abstract class ArrayForEachIndexCallOperation
    extends JSArrayOperation {
        @Node.Child
        private ForEachIndexCallNode forEachIndexNode;

        public ArrayForEachIndexCallOperation(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        public ArrayForEachIndexCallOperation(JSContext context, JSBuiltin builtin) {
            this(context, builtin, false);
        }

        protected final Object forEachIndexCall(Object arrayObj, Object callbackObj, Object thisArg, long fromIndex, long length2, Object initialResult) {
            if (this.forEachIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.forEachIndexNode = this.insert(this.makeForEachIndexCallNode());
            }
            return this.forEachIndexNode.executeForEachIndex(arrayObj, callbackObj, thisArg, fromIndex, length2, initialResult);
        }

        private ForEachIndexCallNode makeForEachIndexCallNode() {
            return ForEachIndexCallNode.create(this.getContext(), this.makeCallbackNode(), this.makeMaybeResultNode(), this.isForward(), this.shouldCheckHasProperty());
        }

        protected boolean isForward() {
            return true;
        }

        protected boolean shouldCheckHasProperty() {
            return !this.isTypedArrayImplementation;
        }

        protected ForEachIndexCallNode.CallbackNode makeCallbackNode() {
            return new DefaultCallbackNode();
        }

        protected abstract ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode();

        protected static class DefaultCallbackNode
        extends ForEachIndexCallNode.CallbackNode {
            @Node.Child
            protected JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
            @Node.Child
            private LongToIntOrDoubleNode indexToJSNumber = LongToIntOrDoubleNode.create();

            protected DefaultCallbackNode() {
            }

            @Override
            public Object apply(long index, Object value2, Object target, Object callback, Object callbackThisArg, Object currentResult) {
                return this.callNode.executeCall(JSArguments.create(callbackThisArg, callback, value2, this.boxIndex(index), target));
            }

            protected final Number boxIndex(long index) {
                return this.indexToJSNumber.fromIndex(null, index);
            }
        }
    }

    @ImportStatic(value={JSRuntime.class, JSConfig.class})
    protected static abstract class DeleteAndSetLengthNode
    extends JavaScriptBaseNode {
        protected static final boolean THROW_ERROR = true;
        protected final JSContext context;

        protected DeleteAndSetLengthNode(JSContext context) {
            this.context = context;
        }

        public abstract void executeVoid(Object var1, long var2);

        @NeverDefault
        protected final PropertySetNode createSetLengthProperty() {
            return PropertySetNode.create(JSArray.LENGTH, false, this.context, true);
        }

        protected static boolean isArray(JSDynamicObject object) {
            return JSArray.isJSFastArray(object);
        }

        @Specialization(guards={"isArray(object)", "longIsRepresentableAsInt(longLength)"})
        protected static void setArrayLength(JSDynamicObject object, long longLength, @Cached(value="createSetOrDelete(THROW_ERROR)") ArrayLengthNode.ArrayLengthWriteNode arrayLengthWriteNode) {
            arrayLengthWriteNode.executeVoid(object, (int)longLength);
        }

        @Specialization(guards={"isJSObject(object)", "longIsRepresentableAsInt(longLength)"})
        protected static void setIntLength(JSDynamicObject object, long longLength, @Cached.Shared(value="deleteProperty") @Cached(value="create(THROW_ERROR, context)") DeletePropertyNode deletePropertyNode, @Cached.Shared(value="setLengthProperty") @Cached(value="createSetLengthProperty()") PropertySetNode setLengthProperty) {
            int intLength = (int)longLength;
            deletePropertyNode.executeEvaluated(object, intLength);
            setLengthProperty.setValueInt(object, intLength);
        }

        @Specialization(guards={"isJSObject(object)"}, replaces={"setIntLength"})
        protected void setLength(JSDynamicObject object, long longLength, @Cached.Shared(value="deleteProperty") @Cached(value="create(THROW_ERROR, context)") DeletePropertyNode deletePropertyNode, @Cached.Shared(value="setLengthProperty") @Cached(value="createSetLengthProperty()") PropertySetNode setLengthProperty, @Cached(inline=true) LongToIntOrDoubleNode indexToNumber) {
            Number boxedLength = indexToNumber.fromIndex(this, longLength);
            deletePropertyNode.executeEvaluated(object, boxedLength);
            setLengthProperty.setValue(object, boxedLength);
        }

        @Specialization(guards={"!isJSObject(object)"})
        protected static void foreignArray(Object object, long newLength, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary arrays) {
            try {
                arrays.removeArrayElement(object, newLength);
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(object, e, "removeArrayElement", null);
            }
        }
    }

    public static abstract class JSArrayOperationWithToInt
    extends JSArrayOperation {
        @Node.Child
        private JSToIntegerAsLongNode toIntegerAsLongNode;

        public JSArrayOperationWithToInt(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        public JSArrayOperationWithToInt(JSContext context, JSBuiltin builtin) {
            this(context, builtin, false);
        }

        protected long toIntegerAsLong(Object target) {
            if (this.toIntegerAsLongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerAsLongNode = this.insert(JSToIntegerAsLongNode.create());
            }
            return this.toIntegerAsLongNode.executeLong(target);
        }
    }

    public static abstract class JSArrayOperation
    extends BasicArrayOperation {
        protected static final boolean THROW_ERROR = true;
        @Node.Child
        private JSSetLengthNode setLengthNode;
        @Node.Child
        private WriteElementNode writeNode;
        @Node.Child
        private WriteElementNode writeOwnNode;
        @Node.Child
        private ReadElementNode readNode;
        @Node.Child
        private JSHasPropertyNode hasPropertyNode;
        @Node.Child
        private JSArrayNextElementIndexNode nextElementIndexNode;
        @Node.Child
        private JSArrayPreviousElementIndexNode previousElementIndexNode;
        @Node.Child
        private ArrayCreateNode arrayCreateNode;

        public JSArrayOperation(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin, isTypedArrayImplementation);
        }

        public JSArrayOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        protected void setLength(Object thisObject, int length2) {
            this.setLengthIntl(thisObject, length2);
        }

        protected void setLength(Object thisObject, long length2) {
            this.setLengthIntl(thisObject, JSRuntime.longToIntOrDouble(length2));
        }

        protected void setLength(Object thisObject, double length2) {
            this.setLengthIntl(thisObject, length2);
        }

        private void setLengthIntl(Object thisObject, Object length2) {
            assert (!(length2 instanceof Long));
            if (this.setLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLengthNode = this.insert(JSSetLengthNode.create(this.getContext(), true));
            }
            this.setLengthNode.execute(thisObject, length2);
        }

        private ReadElementNode getOrCreateReadNode() {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNode = this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNode;
        }

        protected Object read(Object target, int index) {
            return this.getOrCreateReadNode().executeWithTargetAndIndex(target, index);
        }

        protected Object read(Object target, long index) {
            ReadElementNode read = this.getOrCreateReadNode();
            return read.executeWithTargetAndIndex(target, index);
        }

        private WriteElementNode getOrCreateWriteNode() {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = this.insert(WriteElementNode.create(this.getContext(), true));
            }
            return this.writeNode;
        }

        protected void write(Object target, int index, Object value2) {
            this.getOrCreateWriteNode().executeWithTargetAndIndexAndValue(target, index, value2);
        }

        protected void write(Object target, long index, Object value2) {
            WriteElementNode write = this.getOrCreateWriteNode();
            write.executeWithTargetAndIndexAndValue(target, index, value2);
        }

        private WriteElementNode getOrCreateWriteOwnNode() {
            if (this.writeOwnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeOwnNode = this.insert(WriteElementNode.create(this.getContext(), true, true));
            }
            return this.writeOwnNode;
        }

        protected void writeOwn(Object target, int index, Object value2) {
            this.getOrCreateWriteOwnNode().executeWithTargetAndIndexAndValue(target, index, value2);
        }

        protected void writeOwn(Object target, long index, Object value2) {
            WriteElementNode write = this.getOrCreateWriteOwnNode();
            write.executeWithTargetAndIndexAndValue(target, index, value2);
        }

        private JSHasPropertyNode getOrCreateHasPropertyNode() {
            if (this.hasPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasPropertyNode = this.insert(JSHasPropertyNode.create());
            }
            return this.hasPropertyNode;
        }

        protected boolean hasProperty(Object target, long propertyIdx) {
            return this.getOrCreateHasPropertyNode().executeBoolean(target, propertyIdx);
        }

        protected boolean hasProperty(Object target, Object propertyName) {
            return this.getOrCreateHasPropertyNode().executeBoolean(target, propertyName);
        }

        protected long nextElementIndex(Object target, long currentIndex, long length2) {
            if (this.nextElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nextElementIndexNode = this.insert(JSArrayNextElementIndexNode.create(this.getContext()));
            }
            return this.nextElementIndexNode.executeLong(target, currentIndex, length2);
        }

        protected long previousElementIndex(Object target, long currentIndex) {
            if (this.previousElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.previousElementIndexNode = this.insert(JSArrayPreviousElementIndexNode.create(this.getContext()));
            }
            return this.previousElementIndexNode.executeLong(target, currentIndex);
        }

        protected static final void throwLengthError() {
            throw Errors.createTypeError("length too big");
        }

        protected final JSObject createEmpty(Object thisObj, long length2) {
            if (this.isTypedArrayImplementation) {
                return this.typedArrayCreateSameType((JSDynamicObject)thisObj, length2);
            }
            return this.arrayCreate(length2);
        }

        private JSTypedArrayObject typedArrayCreateSameType(JSDynamicObject thisObj, long length2) {
            JSDynamicObject constr = ArraySpeciesConstructorNode.getDefaultConstructor(this.getRealm(), thisObj);
            return this.getArraySpeciesConstructorNode().typedArrayCreate(constr, length2);
        }

        protected JSArrayObject arrayCreate(long length2) {
            if (this.arrayCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayCreateNode = this.insert(ArrayCreateNode.create(this.getContext()));
            }
            return this.arrayCreateNode.execute(length2);
        }
    }

    protected static class ArraySpeciesConstructorNode
    extends JavaScriptBaseNode {
        private final boolean isTypedArrayImplementation;
        @Node.Child
        private JSFunctionCallNode constructorCall;
        @Node.Child
        private PropertyGetNode getConstructorNode;
        @Node.Child
        private PropertyGetNode getSpeciesNode;
        @Node.Child
        private JSIsArrayNode isArrayNode;
        @Node.Child
        private IsConstructorNode isConstructorNode = IsConstructorNode.create();
        @Node.Child
        private ArrayCreateNode arrayCreateNode;
        private final BranchProfile errorBranch = BranchProfile.create();
        private final BranchProfile arraySpeciesIsArray = BranchProfile.create();
        private final BranchProfile arraySpeciesGetSymbol = BranchProfile.create();
        private final BranchProfile differentRealm = BranchProfile.create();
        private final BranchProfile defaultConstructorBranch = BranchProfile.create();
        private final ConditionProfile arraySpeciesEmpty = ConditionProfile.create();
        private final BranchProfile notAJSObjectBranch = BranchProfile.create();
        private final JSContext context;

        protected ArraySpeciesConstructorNode(JSContext context, boolean isTypedArrayImplementation) {
            this.context = context;
            this.isTypedArrayImplementation = isTypedArrayImplementation;
            this.isArrayNode = JSIsArrayNode.createIsArray();
            this.constructorCall = JSFunctionCallNode.createNew();
        }

        @NeverDefault
        protected static ArraySpeciesConstructorNode create(JSContext context, boolean isTypedArrayImplementation) {
            return new ArraySpeciesConstructorNode(context, isTypedArrayImplementation);
        }

        protected final Object createEmptyContainer(Object thisObj, long size) {
            if (this.isTypedArrayImplementation) {
                return this.typedArraySpeciesCreate(JSRuntime.expectJSObject(thisObj, this.notAJSObjectBranch), JSRuntime.longToIntOrDouble(size));
            }
            return this.arraySpeciesCreate(thisObj, size);
        }

        protected final JSTypedArrayObject typedArraySpeciesCreate(JSDynamicObject thisObj, Object ... args) {
            JSDynamicObject constr = this.speciesConstructor(thisObj, ArraySpeciesConstructorNode.getDefaultConstructor(this.getRealm(), thisObj));
            return this.typedArrayCreate(constr, args);
        }

        public final JSTypedArrayObject typedArrayCreate(JSDynamicObject constr, Object ... args) {
            Object newObject = this.construct(constr, args);
            if (!JSArrayBufferView.isJSArrayBufferView(newObject)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            JSTypedArrayObject newTypedArray = (JSTypedArrayObject)newObject;
            if (JSArrayBufferView.hasDetachedBuffer(newTypedArray, this.context)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            if (args.length == 1 && JSRuntime.isNumber(args[0]) && (double)JSArrayBufferView.typedArrayGetLength(newTypedArray) < JSRuntime.doubleValue((Number)args[0])) {
                this.errorBranch.enter();
                throw Errors.createTypeError("invalid TypedArray created");
            }
            return newTypedArray;
        }

        protected final Object arraySpeciesCreate(Object originalArray, long length2) {
            Object ctor = Undefined.instance;
            if (this.isArray(originalArray)) {
                this.arraySpeciesIsArray.enter();
                ctor = this.getConstructorProperty(originalArray);
                if (ctor instanceof JSObject) {
                    JSRealm ctorRealm;
                    JSRealm thisRealm;
                    JSObject ctorObj = (JSObject)ctor;
                    if (JSFunction.isJSFunction(ctorObj) && JSFunction.isConstructor(ctorObj) && (thisRealm = this.getRealm()) != (ctorRealm = JSFunction.getRealm((JSFunctionObject)ctorObj))) {
                        this.differentRealm.enter();
                        if (ctorRealm.getArrayConstructor() == ctor) {
                            return this.arrayCreate(length2);
                        }
                    }
                    this.arraySpeciesGetSymbol.enter();
                    ctor = this.getSpeciesProperty(ctor);
                    ctor = ctor == Null.instance ? Undefined.instance : ctor;
                }
            }
            if (this.arraySpeciesEmpty.profile(ctor == Undefined.instance)) {
                return this.arrayCreate(length2);
            }
            if (!this.isConstructorNode.executeBoolean(ctor)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAConstructor(ctor, this.context);
            }
            return this.construct((JSDynamicObject)ctor, JSRuntime.longToIntOrDouble(length2));
        }

        protected final boolean isArray(Object thisObj) {
            return this.isArrayNode.execute(thisObj);
        }

        private JSArrayObject arrayCreate(long length2) {
            if (this.arrayCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayCreateNode = this.insert(ArrayCreateNode.create(this.context));
            }
            return this.arrayCreateNode.execute(length2);
        }

        protected Object construct(JSDynamicObject constructor, Object ... userArgs) {
            Object[] args = JSArguments.createInitial(JSFunction.CONSTRUCT, constructor, userArgs.length);
            System.arraycopy(userArgs, 0, args, 2, userArgs.length);
            return this.constructorCall.executeCall(args);
        }

        protected static final JSDynamicObject getDefaultConstructor(JSRealm realm, JSDynamicObject thisObj) {
            assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
            TypedArray arrayType = JSArrayBufferView.typedArrayGetArrayType(thisObj);
            return realm.getArrayBufferViewConstructor(arrayType.getFactory());
        }

        protected final JSDynamicObject speciesConstructor(JSDynamicObject thisObj, JSDynamicObject defaultConstructor) {
            Object c = this.getConstructorProperty(thisObj);
            if (c == Undefined.instance) {
                this.defaultConstructorBranch.enter();
                return defaultConstructor;
            }
            if (!(c instanceof JSObject)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAnObject(c);
            }
            Object speciesConstructor = this.getSpeciesProperty(c);
            if (speciesConstructor == Undefined.instance || speciesConstructor == Null.instance) {
                this.defaultConstructorBranch.enter();
                return defaultConstructor;
            }
            if (!this.isConstructorNode.executeBoolean(speciesConstructor)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAConstructor(speciesConstructor, this.context);
            }
            return (JSDynamicObject)speciesConstructor;
        }

        private Object getConstructorProperty(Object obj) {
            if (this.getConstructorNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getConstructorNode = this.insert(PropertyGetNode.create(JSObject.CONSTRUCTOR, false, this.context));
            }
            return this.getConstructorNode.getValue(obj);
        }

        private Object getSpeciesProperty(Object obj) {
            if (this.getSpeciesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSpeciesNode = this.insert(PropertyGetNode.create(Symbol.SYMBOL_SPECIES, false, this.context));
            }
            return this.getSpeciesNode.getValue(obj);
        }
    }

    public static abstract class BasicArrayOperation
    extends JSBuiltinNode {
        protected final boolean isTypedArrayImplementation;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;
        @Node.Child
        private ArraySpeciesConstructorNode arraySpeciesCreateNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        protected final BranchProfile errorBranch = BranchProfile.create();

        public BasicArrayOperation(JSContext context, JSBuiltin builtin, boolean isTypedArrayImplementation) {
            super(context, builtin);
            this.isTypedArrayImplementation = isTypedArrayImplementation;
        }

        public BasicArrayOperation(JSContext context, JSBuiltin builtin) {
            this(context, builtin, false);
        }

        protected final Object toObject(Object target) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(target);
        }

        protected long getLength(Object thisObject) {
            if (this.isTypedArrayImplementation) {
                return JSArrayBufferView.typedArrayGetLength((JSTypedArrayObject)thisObject);
            }
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(JSGetLengthNode.create(this.getContext()));
            }
            return this.getLengthNode.executeLong(thisObject);
        }

        protected final Object toObjectOrValidateTypedArray(Object thisObj) {
            return this.isTypedArrayImplementation ? this.validateTypedArray(thisObj) : this.toObject(thisObj);
        }

        protected final boolean isCallable(Object callback) {
            if (this.isCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isCallableNode = this.insert(IsCallableNode.create());
            }
            return this.isCallableNode.executeBoolean(callback);
        }

        protected final Object checkCallbackIsFunction(Object callback) {
            if (!this.isCallable(callback)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotAFunction(callback, this);
            }
            return callback;
        }

        protected final ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = this.insert(ArraySpeciesConstructorNode.create(this.getContext(), this.isTypedArrayImplementation));
            }
            return this.arraySpeciesCreateNode;
        }

        protected final void checkHasDetachedBuffer(JSDynamicObject view) {
            if (JSArrayBufferView.hasDetachedBuffer(view, this.getContext())) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }

        protected final JSTypedArrayObject validateTypedArray(Object obj) {
            if (!JSArrayBufferView.isJSArrayBufferView(obj)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            JSTypedArrayObject typedArrayObject = (JSTypedArrayObject)obj;
            if (JSArrayBufferView.hasDetachedBuffer(typedArrayObject, this.getContext())) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            return typedArrayObject;
        }

        protected void reportLoopCount(long count) {
            BasicArrayOperation.reportLoopCount(this, count);
        }

        public static void reportLoopCount(Node node, long count) {
            if (count > 0L) {
                LoopNode.reportLoopCount(node, count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count);
            }
        }
    }
}

