/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class JSGetLengthNode
extends JavaScriptBaseNode {
    private final JSContext context;
    private final boolean toLength;
    @Node.Child
    private JSToUInt32Node toUInt32Node;
    @Node.Child
    private JSToLengthNode toLengthNode;

    protected JSGetLengthNode(JSContext context) {
        this.context = context;
        this.toLength = context.getEcmaScriptVersion() >= 6;
    }

    @NeverDefault
    public static JSGetLengthNode create(JSContext context) {
        return JSGetLengthNodeGen.create(context);
    }

    public abstract Object execute(Object var1);

    public final long executeLong(Object value2) {
        return this.toLengthLong(this.execute(value2));
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    public int getArrayLengthInt(JSArrayObject target, @Cached @Cached.Shared(value="arrayLengthRead") ArrayLengthNode.ArrayLengthReadNode arrayLengthReadNode) throws UnexpectedResultException {
        return arrayLengthReadNode.executeInt(target);
    }

    @Specialization(replaces={"getArrayLengthInt"})
    public double getArrayLength(JSArrayObject target, @Cached @Cached.Shared(value="arrayLengthRead") ArrayLengthNode.ArrayLengthReadNode arrayLengthReadNode) {
        return arrayLengthReadNode.executeDouble(target);
    }

    @Specialization(guards={"!isJSArray(target)"})
    public double getNonArrayLength(JSDynamicObject target, @Cached(value="createLengthProperty()") PropertyGetNode getLengthPropertyNode) {
        return this.toLengthDouble(getLengthPropertyNode.getValue(target));
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!isJSDynamicObject(target)"}, limit="3")
    public double getLengthForeign(Object target, @CachedLibrary(value="target") InteropLibrary interop, @Cached ImportValueNode importValueNode) {
        if (interop.hasArrayElements(target)) {
            return JSInteropUtil.getArraySize(target, interop, this);
        }
        return this.toLengthDouble(JSInteropUtil.readMemberOrDefault(target, JSAbstractArray.LENGTH, 0, interop, importValueNode, this));
    }

    @NeverDefault
    protected PropertyGetNode createLengthProperty() {
        return PropertyGetNode.create(JSArray.LENGTH, this.context);
    }

    private double toUInt32Double(Object target) {
        return JSRuntime.doubleValue(this.getUInt32Node().executeNumber(target));
    }

    private long toUInt32Long(Object target) {
        return JSRuntime.longValue(this.getUInt32Node().executeNumber(target));
    }

    private double toLengthDouble(Object target) {
        if (this.toLength) {
            return this.getToLengthNode().executeLong(target);
        }
        return this.toUInt32Double(target);
    }

    private long toLengthLong(Object target) {
        if (this.toLength) {
            return this.getToLengthNode().executeLong(target);
        }
        return this.toUInt32Long(target);
    }

    private JSToLengthNode getToLengthNode() {
        if (this.toLengthNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toLengthNode = this.insert(JSToLengthNode.create());
        }
        return this.toLengthNode;
    }

    private JSToUInt32Node getUInt32Node() {
        if (this.toUInt32Node == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toUInt32Node = this.insert(JSToUInt32Node.create());
        }
        return this.toUInt32Node;
    }
}

