/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.array.JSSetLengthNodeGen;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class JSSetLengthNode
extends JavaScriptBaseNode {
    private final JSContext context;
    protected final boolean isStrict;

    protected JSSetLengthNode(JSContext context, boolean isStrict) {
        this.context = context;
        this.isStrict = isStrict;
    }

    public static JSSetLengthNode create(JSContext context, boolean strict) {
        return JSSetLengthNodeGen.create(context, strict);
    }

    public abstract Object execute(Object var1, Object var2);

    @NeverDefault
    protected final PropertySetNode createSetLengthProperty() {
        return PropertySetNode.create(JSArray.LENGTH, false, this.context, this.isStrict);
    }

    protected static boolean isArray(Object object) {
        return JSArray.isJSFastArray(object);
    }

    @Specialization(guards={"isArray(object)"})
    protected static int setArrayLength(JSDynamicObject object, int length2, @Cached(value="create(isStrict)") ArrayLengthNode.ArrayLengthWriteNode arrayLengthWriteNode) {
        arrayLengthWriteNode.executeVoid(object, length2);
        return length2;
    }

    @Specialization
    protected static int setIntLength(JSDynamicObject object, int length2, @Cached(value="createSetLengthProperty()") @Cached.Shared(value="setLength") PropertySetNode setLengthProperty) {
        setLengthProperty.setValueInt(object, length2);
        return length2;
    }

    @Specialization(replaces={"setIntLength"})
    protected static Object setLength(JSDynamicObject object, Object length2, @Cached(value="createSetLengthProperty()") @Cached.Shared(value="setLength") PropertySetNode setLengthProperty) {
        setLengthProperty.setValue(object, length2);
        return length2;
    }

    @Specialization(guards={"!isJSDynamicObject(object)"})
    protected static Object setLengthForeign(Object object, Object length2) {
        return length2;
    }
}

