/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.decorators.ApplyDecoratorsToClassDefinitionNode;
import com.oracle.truffle.js.decorators.ApplyDecoratorsToElementDefinition;
import com.oracle.truffle.js.decorators.DecoratorListEvaluationNode;
import com.oracle.truffle.js.nodes.JSFrameSlot;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceElementsNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.ClassElementDefinitionRecord;
import com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import com.oracle.truffle.js.nodes.function.DefineMethodNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.nodes.function.NamedEvaluationTargetNode;
import com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.util.Set;

public final class ClassDefinitionNode
extends NamedEvaluationTargetNode
implements FunctionNameHolder,
ResumableNode.WithObjectState {
    @Node.Children
    private JavaScriptNode[] classDecorators;
    @Node.Children
    private ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes;
    @Node.Children
    private DecoratorListEvaluationNode[] memberDecorators;
    @Node.Children
    private ApplyDecoratorsToElementDefinition[] applyDecoratorsToElementDefinition;
    @Node.Child
    private JavaScriptNode constructorFunctionNode;
    @Node.Child
    private JavaScriptNode classHeritageNode;
    @Node.Child
    private ApplyDecoratorsToClassDefinitionNode decorateClassDefinition;
    @Node.Child
    private JSWriteFrameSlotNode writeClassBindingNode;
    @Node.Child
    private JSWriteFrameSlotNode writeInternalConstructorBrand;
    @Node.Child
    private PropertyGetNode getPrototypeNode;
    @Node.Child
    private CreateMethodPropertyNode setConstructorNode;
    @Node.Child
    private CreateObjectNode.CreateObjectWithPrototypeNode createPrototypeNode;
    @Node.Child
    private DefineMethodNode defineConstructorMethodNode;
    @Node.Child
    private PropertySetNode setElementsNode;
    @Node.Child
    private PropertySetNode setInitializersNode;
    @Node.Child
    private InitializeInstanceElementsNode staticElementsNode;
    @Node.Child
    private PropertySetNode setPrivateBrandNode;
    @Node.Child
    private SetFunctionNameNode setFunctionName;
    @Node.Child
    private IsConstructorNode isConstructorNode;
    @Node.Child
    private JSFunctionCallNode staticExtraInitializersCallNode;
    private final JSContext context;
    private final TruffleString className;
    private final boolean hasName;
    private final int instanceElementCount;
    private final int staticElementCount;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected ClassDefinitionNode(JSContext context, JSFunctionExpressionNode constructorFunctionNode, JavaScriptNode classHeritageNode, ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes, JSWriteFrameSlotNode writeClassBindingNode, JSWriteFrameSlotNode writeInternalConstructorBrand, JavaScriptNode[] classDecorators, DecoratorListEvaluationNode[] memberDecorators, TruffleString className, int instanceElementsCount, int staticElementCount, boolean hasPrivateInstanceMethods, boolean hasInstanceFieldsOrAccessors, int blockScopeSlot) {
        this.context = context;
        this.constructorFunctionNode = constructorFunctionNode;
        this.classHeritageNode = classHeritageNode;
        this.memberNodes = memberNodes;
        this.className = className;
        this.hasName = className != null;
        this.instanceElementCount = instanceElementsCount;
        this.staticElementCount = staticElementCount;
        assert (staticElementCount + instanceElementsCount == memberNodes.length);
        this.writeClassBindingNode = writeClassBindingNode;
        this.writeInternalConstructorBrand = writeInternalConstructorBrand;
        this.getPrototypeNode = PropertyGetNode.create(JSObject.PROTOTYPE, false, context);
        this.setConstructorNode = CreateMethodPropertyNode.create(context, JSObject.CONSTRUCTOR);
        this.createPrototypeNode = CreateObjectNode.createOrdinaryWithPrototype(context);
        this.defineConstructorMethodNode = DefineMethodNode.create(context, constructorFunctionNode, blockScopeSlot);
        this.setElementsNode = hasInstanceFieldsOrAccessors ? PropertySetNode.createSetHidden(JSFunction.CLASS_ELEMENTS_ID, context) : null;
        this.setPrivateBrandNode = hasPrivateInstanceMethods ? PropertySetNode.createSetHidden(JSFunction.PRIVATE_BRAND_ID, context) : null;
        this.setFunctionName = this.hasName ? null : SetFunctionNameNode.create();
        this.isConstructorNode = IsConstructorNode.create();
        this.classDecorators = classDecorators;
        this.memberDecorators = memberDecorators;
        this.setInitializersNode = PropertySetNode.createSetHidden(JSFunction.CLASS_INITIALIZERS_ID, context);
        this.applyDecoratorsToElementDefinition = ClassDefinitionNode.initApplyDecoratorsToElementDefinitionNodes(context, memberNodes, memberDecorators);
        this.staticExtraInitializersCallNode = JSFunctionCallNode.createCall();
    }

    public static ClassDefinitionNode create(JSContext context, JSFunctionExpressionNode constructorFunction, JavaScriptNode classHeritage, ObjectLiteralNode.ObjectLiteralMemberNode[] members, JSWriteFrameSlotNode writeClassBinding, JSWriteFrameSlotNode writeInternalConstructorBrand, TruffleString className, JavaScriptNode[] classDecorators, DecoratorListEvaluationNode[] memberDecorators, int instanceFieldCount, int staticElementCount, boolean hasPrivateInstanceMethods, boolean hasInstanceFieldsOrAccessors, JSFrameSlot blockScopeSlot) {
        return new ClassDefinitionNode(context, constructorFunction, classHeritage, members, writeClassBinding, writeInternalConstructorBrand, classDecorators, memberDecorators, className, instanceFieldCount, staticElementCount, hasPrivateInstanceMethods, hasInstanceFieldsOrAccessors, blockScopeSlot != null ? blockScopeSlot.getIndex() : -1);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeWithName(frame, this.className);
    }

    @Override
    public Object resume(VirtualFrame frame, int stateSlot) {
        Object maybeState = this.getState(frame, stateSlot);
        ClassDefinitionResumptionRecord resumptionRecord = null;
        if (maybeState instanceof ClassDefinitionResumptionRecord) {
            this.resetState(frame, stateSlot);
            resumptionRecord = (ClassDefinitionResumptionRecord)maybeState;
        }
        return this.executeWithName(frame, this.className, resumptionRecord, stateSlot);
    }

    @Override
    public Object executeWithName(VirtualFrame frame, Object name) {
        return this.executeWithName(frame, name, null, -1);
    }

    private Object executeWithName(VirtualFrame frame, Object name, ClassDefinitionResumptionRecord resumptionRecord, int stateSlot) {
        int startIndex;
        int staticElementIndex;
        int instanceElementIndex;
        ClassElementDefinitionRecord[] staticElements;
        ClassElementDefinitionRecord[] instanceElements;
        JSObject constructor;
        JSDynamicObject proto;
        Object[] decorators;
        JSRealm realm = this.getRealm();
        if (resumptionRecord == null) {
            Object protoParent = realm.getObjectPrototype();
            Object constructorParent = realm.getFunctionPrototype();
            if (this.classHeritageNode != null) {
                Object superclass = this.classHeritageNode.execute(frame);
                if (superclass == Null.instance) {
                    protoParent = Null.instance;
                } else {
                    if (!this.isConstructorNode.executeBoolean(superclass)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("not a constructor", (Node)this);
                    }
                    if (JSRuntime.isGenerator(superclass)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("class cannot extend a generator function", (Node)this);
                    }
                    protoParent = this.getPrototypeNode.getValue(superclass);
                    if (protoParent != Null.instance && !JSRuntime.isObject(protoParent)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeError("protoParent is neither Object nor Null", (Node)this);
                    }
                    constructorParent = superclass;
                }
            }
            decorators = this.classDecoratorListEvaluation(frame);
            assert (protoParent == Null.instance || JSRuntime.isObject(protoParent));
            proto = this.createPrototypeNode.execute((JSDynamicObject)protoParent);
            constructor = this.defineConstructorMethodNode.execute(frame, proto, (JSDynamicObject)constructorParent);
            JSFunction.setClassPrototype(constructor, proto);
            if (this.setFunctionName != null && name != null) {
                this.setFunctionName.execute(constructor, name);
            }
            this.setConstructorNode.executeVoid(proto, constructor);
            instanceElements = this.instanceElementCount == 0 ? null : new ClassElementDefinitionRecord[this.instanceElementCount];
            staticElements = this.staticElementCount == 0 ? null : new ClassElementDefinitionRecord[this.staticElementCount];
            instanceElementIndex = 0;
            staticElementIndex = 0;
            startIndex = 0;
        } else {
            proto = resumptionRecord.proto;
            constructor = resumptionRecord.constructor;
            instanceElements = resumptionRecord.instanceElements;
            staticElements = resumptionRecord.staticElements;
            instanceElementIndex = resumptionRecord.instanceElementIndex;
            staticElementIndex = resumptionRecord.staticElementIndex;
            startIndex = resumptionRecord.startIndex;
            decorators = resumptionRecord.decorators;
        }
        return this.defineClassElements(frame, proto, constructor, decorators, instanceElements, staticElements, startIndex, instanceElementIndex, staticElementIndex, stateSlot, realm);
    }

    private Object defineClassElements(VirtualFrame frame, JSDynamicObject proto, JSObject constructor, Object[] decorators, ClassElementDefinitionRecord[] instanceElements, ClassElementDefinitionRecord[] staticElements, int startIndex, int instanceElementIndex, int staticElementIndex, int stateSlot, JSRealm realm) {
        this.initializeMembers(frame, proto, constructor, instanceElements, staticElements, startIndex, instanceElementIndex, staticElementIndex, stateSlot, realm);
        SimpleArrayList<Object> staticExtraInitializers = SimpleArrayList.createEmpty();
        SimpleArrayList<Object> instanceExtraInitializers = SimpleArrayList.createEmpty();
        this.applyDecoratorsAndDefineMethods(frame, instanceElements, instanceExtraInitializers, staticExtraInitializers, staticElements, constructor, proto);
        if (this.setElementsNode != null) {
            this.setElementsNode.setValue(constructor, instanceElements);
        }
        this.setInitializersNode.setValue(constructor, instanceExtraInitializers.toArray());
        if (this.setPrivateBrandNode != null) {
            HiddenKey privateBrand = new HiddenKey("Brand");
            this.setPrivateBrandNode.setValue(constructor, privateBrand);
        }
        if (this.writeInternalConstructorBrand != null) {
            this.writeInternalConstructorBrand.executeWrite(frame, constructor);
        }
        SimpleArrayList<Object> classExtraInitializers = SimpleArrayList.createEmpty();
        Object newConstructor = this.applyDecoratorsToClassDefinition(frame, this.getClassName(), constructor, decorators, classExtraInitializers);
        if (this.writeClassBindingNode != null) {
            this.writeClassBindingNode.executeWrite(frame, newConstructor);
        }
        this.executeStaticExtraInitializers(newConstructor, staticExtraInitializers.toArray());
        if (this.staticElementCount != 0) {
            InitializeInstanceElementsNode initializeStaticElements = this.staticElementsNode;
            if (initializeStaticElements == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.staticElementsNode = initializeStaticElements = this.insert(InitializeInstanceElementsNode.create(this.context));
            }
            initializeStaticElements.executeStaticElements(newConstructor, staticElements);
        }
        this.executeStaticExtraInitializers(newConstructor, classExtraInitializers.toArray());
        return newConstructor;
    }

    private void applyDecoratorsAndDefineMethods(VirtualFrame frame, ClassElementDefinitionRecord[] instanceElements, SimpleArrayList<Object> instanceExtraInitializers, SimpleArrayList<Object> staticExtraInitializers, ClassElementDefinitionRecord[] staticElements, JSDynamicObject constructor, JSDynamicObject proto) {
        this.applyDecoratorsAndDefineMethods(frame, constructor, staticElements, staticExtraInitializers, true);
        this.applyDecoratorsAndDefineMethods(frame, proto, instanceElements, instanceExtraInitializers, false);
        this.applyDecoratorsToElements(frame, constructor, staticElements, staticExtraInitializers, true);
        this.applyDecoratorsToElements(frame, proto, instanceElements, instanceExtraInitializers, false);
    }

    private void executeStaticExtraInitializers(Object target, Object[] initializers) {
        for (Object initializer : initializers) {
            this.staticExtraInitializersCallNode.executeCall(JSArguments.createZeroArg(target, initializer));
        }
    }

    @ExplodeLoop
    private void applyDecoratorsAndDefineMethods(VirtualFrame frame, JSDynamicObject homeObject, ClassElementDefinitionRecord[] elements, SimpleArrayList<Object> extraInitializers, boolean isStatic) {
        if (elements == null) {
            return;
        }
        CompilerAsserts.partialEvaluationConstant(this.memberNodes.length);
        int elementIndex = 0;
        for (int i = 0; i < this.memberNodes.length; ++i) {
            ObjectLiteralNode.ObjectLiteralMemberNode member = this.memberNodes[i];
            if (member.isStatic() != isStatic) continue;
            if (!member.isFieldOrStaticBlock()) {
                ClassElementDefinitionRecord m = elements[elementIndex];
                if (this.applyDecoratorsToElementDefinition != null && this.applyDecoratorsToElementDefinition[i] != null) {
                    this.applyDecoratorsToElementDefinition[i].executeDecorator(frame, homeObject, m, extraInitializers);
                }
                member.defineClassElement(frame, homeObject, m);
            }
            ++elementIndex;
        }
        assert (elementIndex == elements.length);
    }

    @ExplodeLoop
    private void applyDecoratorsToElements(VirtualFrame frame, JSDynamicObject homeObject, ClassElementDefinitionRecord[] elements, SimpleArrayList<Object> extraInitializers, boolean isStatic) {
        if (elements == null) {
            return;
        }
        CompilerAsserts.partialEvaluationConstant(this.memberNodes.length);
        int elementIndex = 0;
        for (int i = 0; i < this.memberNodes.length; ++i) {
            ObjectLiteralNode.ObjectLiteralMemberNode member = this.memberNodes[i];
            if (member.isStatic() != isStatic) continue;
            if (member.isFieldOrStaticBlock()) {
                ClassElementDefinitionRecord f = elements[elementIndex];
                if (this.applyDecoratorsToElementDefinition != null && this.applyDecoratorsToElementDefinition[i] != null) {
                    this.applyDecoratorsToElementDefinition[i].executeDecorator(frame, homeObject, f, extraInitializers);
                }
            }
            ++elementIndex;
        }
        assert (elementIndex == elements.length);
    }

    private static ApplyDecoratorsToElementDefinition[] initApplyDecoratorsToElementDefinitionNodes(JSContext context, ObjectLiteralNode.ObjectLiteralMemberNode[] memberNodes, DecoratorListEvaluationNode[] memberDecorators) {
        CompilerAsserts.neverPartOfCompilation();
        if (memberDecorators == null || memberDecorators.length == 0) {
            return null;
        }
        assert (memberNodes.length == memberDecorators.length);
        int size = memberNodes.length;
        ApplyDecoratorsToElementDefinition[] nodes = new ApplyDecoratorsToElementDefinition[size];
        for (int i = 0; i < size; ++i) {
            if (memberDecorators[i] == null) continue;
            ObjectLiteralNode.ObjectLiteralMemberNode memberNode = memberNodes[i];
            nodes[i] = ApplyDecoratorsToElementDefinition.create(context, memberNode);
        }
        return nodes;
    }

    @ExplodeLoop
    private Object[] classDecoratorListEvaluation(VirtualFrame frame) {
        CompilerAsserts.partialEvaluationConstant(this.classDecorators.length);
        Object[] decorators = new Object[this.classDecorators.length];
        for (int i = 0; i < this.classDecorators.length; ++i) {
            Object maybeDecorator;
            decorators[decorators.length - i - 1] = maybeDecorator = this.classDecorators[i].execute(frame);
        }
        return decorators;
    }

    private Object applyDecoratorsToClassDefinition(VirtualFrame frame, Object name, JSObject constructor, Object[] decorators, SimpleArrayList<Object> classExtraInitializers) {
        if (this.classDecorators.length == 0) {
            return constructor;
        }
        if (this.decorateClassDefinition == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.decorateClassDefinition = this.insert(ApplyDecoratorsToClassDefinitionNode.create(this.context));
        }
        return this.decorateClassDefinition.executeDecorators(frame, name, constructor, decorators, classExtraInitializers);
    }

    @ExplodeLoop
    private void initializeMembers(VirtualFrame frame, JSDynamicObject proto, JSObject constructor, ClassElementDefinitionRecord[] instanceElements, ClassElementDefinitionRecord[] staticElements, int startIndex, int instanceElementsIdx, int staticElementIdx, int stateSlot, JSRealm realm) {
        int i;
        int instanceElementIndex = instanceElementsIdx;
        int staticElementIndex = staticElementIdx;
        Object[] decorators = null;
        try {
            for (i = 0; i < this.memberNodes.length; ++i) {
                if (i < startIndex) continue;
                ObjectLiteralNode.ObjectLiteralMemberNode memberNode = this.memberNodes[i];
                boolean isStatic = memberNode.isStatic();
                JSDynamicObject homeObject = isStatic ? constructor : proto;
                decorators = this.memberDecorators != null && this.memberDecorators[i] != null ? this.memberDecorators[i].execute(frame) : null;
                ClassElementDefinitionRecord classElementDef = memberNode.evaluateClassElementDefinition(frame, homeObject, realm, decorators);
                if (isStatic) {
                    staticElements[staticElementIndex++] = classElementDef;
                    continue;
                }
                instanceElements[instanceElementIndex++] = classElementDef;
            }
        }
        catch (YieldException e) {
            this.setState(frame, stateSlot, new ClassDefinitionResumptionRecord(proto, constructor, instanceElements, staticElements, instanceElementIndex, staticElementIndex, decorators, i));
            throw e;
        }
        assert (instanceElementIndex == this.instanceElementCount && staticElementIndex == this.staticElementCount);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == JSDynamicObject.class;
    }

    @Override
    public TruffleString getFunctionName() {
        return this.hasName ? ((FunctionNameHolder)((Object)this.constructorFunctionNode)).getFunctionName() : Strings.EMPTY_STRING;
    }

    public TruffleString getClassName() {
        return this.hasName ? this.className : Strings.EMPTY_STRING;
    }

    @Override
    public void setFunctionName(TruffleString name) {
        ((FunctionNameHolder)((Object)this.constructorFunctionNode)).setFunctionName(name);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new ClassDefinitionNode(this.context, (JSFunctionExpressionNode)ClassDefinitionNode.cloneUninitialized(this.constructorFunctionNode, materializedTags), ClassDefinitionNode.cloneUninitialized(this.classHeritageNode, materializedTags), ObjectLiteralNode.ObjectLiteralMemberNode.cloneUninitialized(this.memberNodes, materializedTags), ClassDefinitionNode.cloneUninitialized(this.writeClassBindingNode, materializedTags), ClassDefinitionNode.cloneUninitialized(this.writeInternalConstructorBrand, materializedTags), ClassDefinitionNode.cloneUninitialized(this.classDecorators, materializedTags), ClassDefinitionNode.cloneUninitialized(this.memberDecorators, materializedTags), this.className, this.instanceElementCount, this.staticElementCount, this.setPrivateBrandNode != null, this.setElementsNode != null, this.defineConstructorMethodNode.getBlockScopeSlot());
    }

    static class ClassDefinitionResumptionRecord {
        final JSDynamicObject proto;
        final JSObject constructor;
        final ClassElementDefinitionRecord[] instanceElements;
        final ClassElementDefinitionRecord[] staticElements;
        final int instanceElementIndex;
        final int staticElementIndex;
        final int startIndex;
        final Object[] decorators;

        ClassDefinitionResumptionRecord(JSDynamicObject proto, JSObject constructor, ClassElementDefinitionRecord[] instanceFields, ClassElementDefinitionRecord[] staticElements, int instanceElementIndex, int staticElementIndex, Object[] decorators, int startIndex) {
            this.proto = proto;
            this.constructor = constructor;
            this.instanceElements = instanceFields;
            this.staticElements = staticElements;
            this.instanceElementIndex = instanceElementIndex;
            this.staticElementIndex = staticElementIndex;
            this.startIndex = startIndex;
            this.decorators = decorators;
        }
    }
}

