/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalCalendarDateFromFieldsNode
extends JavaScriptBaseNode {
    @Node.Child
    protected PropertyGetNode getDateFromFieldsNode;
    @Node.Child
    protected JSFunctionCallNode callNode;

    protected TemporalCalendarDateFromFieldsNode(JSContext ctx) {
        this.getDateFromFieldsNode = PropertyGetNode.create(TemporalConstants.DATE_FROM_FIELDS, false, ctx);
        this.callNode = JSFunctionCallNode.createCall();
    }

    public abstract JSTemporalPlainDateObject execute(JSDynamicObject var1, JSDynamicObject var2, Object var3);

    @Specialization
    public JSTemporalPlainDateObject toTemporalDate(JSDynamicObject calendar, JSDynamicObject fields, Object options, @Cached InlinedBranchProfile errorBranch) {
        Object dateFromFields = this.getDateFromFieldsNode.getValue(calendar);
        Object date = this.callNode.executeCall(JSArguments.create(calendar, dateFromFields, fields, options));
        return TemporalUtil.requireTemporalDate(date, this, errorBranch);
    }
}

