/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import reactor.core.scheduler.BoundedElasticScheduler;
import reactor.core.scheduler.NonBlocking;
import reactor.core.scheduler.SchedulerTask;
import reactor.core.scheduler.WorkerTask;

public final class ReactorBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder2) {
        builder2.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
        builder2.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "offer");
        builder2.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "take");
        builder2.allowBlockingCallsInside(BoundedElasticScheduler.class.getName() + "$BoundedScheduledExecutorService", "ensureQueueCapacity");
        builder2.allowBlockingCallsInside(SchedulerTask.class.getName(), "dispose");
        builder2.allowBlockingCallsInside(WorkerTask.class.getName(), "dispose");
        builder2.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "processWorkerExit");
        builder2.allowBlockingCallsInside("reactor.core.publisher.ContextPropagation", "<clinit>");
        builder2.allowBlockingCallsInside(FutureTask.class.getName(), "handlePossibleCancellationInterrupt");
    }
}

