/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.loc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.tooltip.ContextualMapping;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTarget;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.base.tooltip.HitShape;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.MathUtil;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PathTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PointTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PolygonTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.RectTargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TargetDetector;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TargetProjection;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TargetPrototype;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0002,-B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\tH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002J&\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010)\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010*\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator;", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "geomKind", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "lookupSpec", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpec;", "contextualMapping", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/ContextualMapping;", "targetPrototypes", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetPrototype;", "(Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpec;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/ContextualMapping;Ljava/util/List;)V", "myCollectingStrategy", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Collector$CollectingStrategy;", "mySimpleGeometry", "", "myTargetDetector", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetDetector;", "myTargets", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Target;", "Lkotlin/collections/ArrayList;", "addLookupResults", "", "collector", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Collector;", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;", "targets", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupResult;", "getClosestTarget", "lookupResults", "getKeyForSingleObjectGeometry", "", "prototype", "processPath", "coord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "target", "resultCollector", "processPoint", "processPolygon", "processRect", "search", "Collector", "Target", "plot-builder"})
public final class LayerTargetLocator
implements GeomTargetLocator {
    @NotNull
    private final GeomKind geomKind;
    @NotNull
    private final GeomTargetLocator.LookupSpec lookupSpec;
    @NotNull
    private final ContextualMapping contextualMapping;
    @NotNull
    private final ArrayList<Target> myTargets;
    @NotNull
    private final TargetDetector myTargetDetector;
    @NotNull
    private final Set<GeomKind> mySimpleGeometry;
    @NotNull
    private final Collector.CollectingStrategy myCollectingStrategy;

    public LayerTargetLocator(@NotNull GeomKind geomKind, @NotNull GeomTargetLocator.LookupSpec lookupSpec, @NotNull ContextualMapping contextualMapping, @NotNull List<TargetPrototype> targetPrototypes) {
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)lookupSpec, (String)"lookupSpec");
        Intrinsics.checkNotNullParameter((Object)contextualMapping, (String)"contextualMapping");
        Intrinsics.checkNotNullParameter(targetPrototypes, (String)"targetPrototypes");
        this.geomKind = geomKind;
        this.lookupSpec = lookupSpec;
        this.contextualMapping = contextualMapping;
        this.myTargets = new ArrayList();
        this.myTargetDetector = new TargetDetector(this.lookupSpec.getLookupSpace(), this.lookupSpec.getLookupStrategy());
        Object object = new GeomKind[]{GeomKind.RECT, GeomKind.POLYGON};
        this.mySimpleGeometry = SetsKt.setOf((Object[])object);
        this.myCollectingStrategy = this.mySimpleGeometry.contains((Object)this.geomKind) ? Collector.CollectingStrategy.REPLACE : (this.lookupSpec.getLookupSpace().isUnivariate() && this.lookupSpec.getLookupStrategy() == GeomTargetLocator.LookupStrategy.NEAREST ? Collector.CollectingStrategy.APPEND_IF_EQUAL : (this.lookupSpec.getLookupSpace().isUnivariate() ? Collector.CollectingStrategy.APPEND : (this.lookupSpec.getLookupStrategy() == GeomTargetLocator.LookupStrategy.HOVER && SetsKt.setOf((Object[])(object = new GeomTargetLocator.LookupSpace[]{GeomTargetLocator.LookupSpace.X, GeomTargetLocator.LookupSpace.Y})).contains((Object)this.lookupSpec.getLookupSpace()) ? Collector.CollectingStrategy.APPEND : (this.lookupSpec.getLookupStrategy() == GeomTargetLocator.LookupStrategy.NONE || this.lookupSpec.getLookupSpace() == GeomTargetLocator.LookupSpace.NONE ? Collector.CollectingStrategy.IGNORE : Collector.CollectingStrategy.REPLACE))));
        for (TargetPrototype prototype : targetPrototypes) {
            this.myTargets.add(new Target(LayerTargetLocator._init_$toProjection(this, prototype), prototype));
        }
    }

    private final void addLookupResults(Collector<GeomTarget> collector, List<GeomTargetLocator.LookupResult> targets) {
        if (collector.size() == 0) {
            return;
        }
        targets.add(new GeomTargetLocator.LookupResult(collector.collection(), Math.max(0.0, collector.getClosestPointChecker().getDistance()), this.geomKind, this.contextualMapping, this.contextualMapping.isCrosshairEnabled()));
    }

    @Override
    @Nullable
    public GeomTargetLocator.LookupResult search(@NotNull DoubleVector coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (this.myTargets.isEmpty()) {
            return null;
        }
        Collector<GeomTarget> polygonCollector = new Collector<GeomTarget>(coord, Collector.CollectingStrategy.REPLACE, this.lookupSpec.getLookupSpace());
        Collector<GeomTarget> rectCollector = new Collector<GeomTarget>(coord, this.myCollectingStrategy, this.lookupSpec.getLookupSpace());
        Collector<GeomTarget> pointCollector = new Collector<GeomTarget>(coord, this.myCollectingStrategy, this.lookupSpec.getLookupSpace());
        Collector<GeomTarget> pathCollector = new Collector<GeomTarget>(coord, this.myCollectingStrategy, this.lookupSpec.getLookupSpace());
        for (Target target : this.myTargets) {
            switch (WhenMappings.$EnumSwitchMapping$0[target.getPrototype().getHitShape$plot_builder().getKind().ordinal()]) {
                case 2: {
                    Intrinsics.checkNotNull((Object)target);
                    this.processRect(coord, target, rectCollector);
                    break;
                }
                case 1: {
                    Intrinsics.checkNotNull((Object)target);
                    this.processPoint(coord, target, pointCollector);
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)target);
                    this.processPath(coord, target, pathCollector);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)target);
                    this.processPolygon(coord, target, polygonCollector);
                }
            }
        }
        ArrayList lookupResults = new ArrayList();
        this.addLookupResults(pathCollector, lookupResults);
        this.addLookupResults(rectCollector, lookupResults);
        this.addLookupResults(pointCollector, lookupResults);
        this.addLookupResults(polygonCollector, lookupResults);
        return this.getClosestTarget(lookupResults);
    }

    private final GeomTargetLocator.LookupResult getClosestTarget(List<? extends GeomTargetLocator.LookupResult> lookupResults) {
        if (lookupResults.isEmpty()) {
            return null;
        }
        GeomTargetLocator.LookupResult closestTargets = lookupResults.get(0);
        if (!(closestTargets.getDistance() >= 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (GeomTargetLocator.LookupResult lookupResult2 : lookupResults) {
            if (!(lookupResult2.getDistance() < closestTargets.getDistance())) continue;
            closestTargets = lookupResult2;
        }
        return closestTargets;
    }

    private final void processRect(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        if (this.myTargetDetector.checkRect(coord, target.getRectProjection(), resultCollector.getClosestPointChecker())) {
            double d;
            DoubleRectangle rect2 = target.getPrototype().getHitShape$plot_builder().getRect();
            double yOffset2 = target.getPrototype().getTooltipKind$plot_builder() == TipLayoutHint.Kind.CURSOR_TOOLTIP ? rect2.getHeight() / 2.0 : (this.lookupSpec.getLookupSpace() == GeomTargetLocator.LookupSpace.Y ? rect2.getHeight() / 2.0 : 0.0);
            switch (WhenMappings.$EnumSwitchMapping$1[this.lookupSpec.getLookupSpace().ordinal()]) {
                case 1: {
                    d = rect2.getWidth() / (double)2;
                    break;
                }
                case 2: {
                    d = rect2.getHeight() / (double)2;
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
            double hintOffset = d;
            resultCollector.collect(target.getPrototype().createGeomTarget$plot_builder(rect2.getOrigin().add(new DoubleVector(rect2.getWidth() / (double)2, yOffset2)), this.getKeyForSingleObjectGeometry(target.getPrototype()), hintOffset));
        }
    }

    private final void processPolygon(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        if (this.myTargetDetector.checkPolygon(coord, target.getPolygonProjection(), resultCollector.getClosestPointChecker())) {
            resultCollector.collect(TargetPrototype.createGeomTarget$plot_builder$default(target.getPrototype(), coord, this.getKeyForSingleObjectGeometry(target.getPrototype()), 0.0, 4, null));
        }
    }

    private final void processPoint(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        if (this.myTargetDetector.checkPoint(coord, target.getPointProjection(), resultCollector.getClosestPointChecker())) {
            resultCollector.collect(target.getPrototype().createGeomTarget$plot_builder(target.getPrototype().getHitShape$plot_builder().getPoint().getCenter(), this.getKeyForSingleObjectGeometry(target.getPrototype()), target.getPrototype().getHitShape$plot_builder().getPoint().getRadius()));
        }
    }

    private final void processPath(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        MathUtil.ClosestPointChecker pointChecker = this.myCollectingStrategy == Collector.CollectingStrategy.APPEND ? new MathUtil.ClosestPointChecker(coord) : resultCollector.getClosestPointChecker();
        Pair<PathTargetProjection.PathPoint, DoubleVector> lookupResult2 = this.myTargetDetector.checkPath(coord, target.getPathProjection(), pointChecker);
        if (lookupResult2 != null) {
            PathTargetProjection.PathPoint hitPoint = (PathTargetProjection.PathPoint)lookupResult2.getFirst();
            DoubleVector doubleVector = (DoubleVector)lookupResult2.getSecond();
            if (doubleVector == null) {
                doubleVector = hitPoint.getOriginalCoord();
            }
            DoubleVector hitCoord = doubleVector;
            resultCollector.collect(TargetPrototype.createGeomTarget$plot_builder$default(target.getPrototype(), hitCoord, hitPoint.getIndex(), 0.0, 4, null));
        }
    }

    private final int getKeyForSingleObjectGeometry(TargetPrototype prototype) {
        return ((Number)prototype.getIndexMapper$plot_builder().invoke((Object)0)).intValue();
    }

    private static final TargetProjection _init_$toProjection(LayerTargetLocator this$0, TargetPrototype prototype) {
        TargetProjection targetProjection;
        switch (WhenMappings.$EnumSwitchMapping$0[prototype.getHitShape$plot_builder().getKind().ordinal()]) {
            case 1: {
                targetProjection = PointTargetProjection.Companion.create(prototype.getHitShape$plot_builder().getPoint().getCenter(), this$0.lookupSpec.getLookupSpace());
                break;
            }
            case 2: {
                targetProjection = RectTargetProjection.Companion.create(prototype.getHitShape$plot_builder().getRect(), this$0.lookupSpec.getLookupSpace());
                break;
            }
            case 3: {
                targetProjection = PolygonTargetProjection.Companion.create(prototype.getHitShape$plot_builder().getPoints(), this$0.lookupSpec.getLookupSpace());
                break;
            }
            case 4: {
                targetProjection = PathTargetProjection.Companion.create(prototype.getHitShape$plot_builder().getPoints(), prototype.getIndexMapper$plot_builder(), this$0.lookupSpec.getLookupSpace());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return targetProjection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0015\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Collector;", "T", "", "cursor", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myStrategy", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Collector$CollectingStrategy;", "lookupSpace", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpace;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Collector$CollectingStrategy;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupSpace;)V", "closestPointChecker", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil$ClosestPointChecker;", "getClosestPointChecker", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/MathUtil$ClosestPointChecker;", "myLastAddedDistance", "", "result", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "add", "", "data", "(Ljava/lang/Object;)V", "collect", "collection", "", "replace", "locationData", "size", "", "CollectingStrategy", "plot-builder"})
    public static final class Collector<T> {
        @NotNull
        private final CollectingStrategy myStrategy;
        @NotNull
        private final ArrayList<T> result;
        @NotNull
        private final MathUtil.ClosestPointChecker closestPointChecker;
        private double myLastAddedDistance;

        public Collector(@NotNull DoubleVector cursor, @NotNull CollectingStrategy myStrategy, @NotNull GeomTargetLocator.LookupSpace lookupSpace) {
            MathUtil.ClosestPointChecker closestPointChecker;
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            Intrinsics.checkNotNullParameter((Object)((Object)myStrategy), (String)"myStrategy");
            Intrinsics.checkNotNullParameter((Object)((Object)lookupSpace), (String)"lookupSpace");
            this.myStrategy = myStrategy;
            this.result = new ArrayList();
            switch (WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()]) {
                case 1: {
                    closestPointChecker = new MathUtil.ClosestPointChecker(new DoubleVector(cursor.getX(), 0.0));
                    break;
                }
                case 2: {
                    closestPointChecker = new MathUtil.ClosestPointChecker(new DoubleVector(0.0, cursor.getY()));
                    break;
                }
                default: {
                    closestPointChecker = new MathUtil.ClosestPointChecker(cursor);
                }
            }
            this.closestPointChecker = closestPointChecker;
            this.myLastAddedDistance = -1.0;
        }

        @NotNull
        public final MathUtil.ClosestPointChecker getClosestPointChecker() {
            return this.closestPointChecker;
        }

        public final void collect(T data) {
            switch (WhenMappings.$EnumSwitchMapping$1[this.myStrategy.ordinal()]) {
                case 1: {
                    this.add(data);
                    break;
                }
                case 2: {
                    this.replace(data);
                    break;
                }
                case 3: {
                    if (this.myLastAddedDistance == this.closestPointChecker.getDistance()) {
                        this.add(data);
                        break;
                    }
                    this.replace(data);
                    break;
                }
                case 4: {
                    return;
                }
            }
        }

        @NotNull
        public final List<T> collection() {
            return this.result;
        }

        public final int size() {
            return this.result.size();
        }

        private final void add(T data) {
            this.result.add(data);
            this.myLastAddedDistance = this.closestPointChecker.getDistance();
        }

        private final void replace(T locationData) {
            this.result.clear();
            this.result.add(locationData);
            this.myLastAddedDistance = this.closestPointChecker.getDistance();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Collector$CollectingStrategy;", "", "(Ljava/lang/String;I)V", "APPEND", "REPLACE", "APPEND_IF_EQUAL", "IGNORE", "plot-builder"})
        public static final class CollectingStrategy
        extends Enum<CollectingStrategy> {
            public static final /* enum */ CollectingStrategy APPEND = new CollectingStrategy();
            public static final /* enum */ CollectingStrategy REPLACE = new CollectingStrategy();
            public static final /* enum */ CollectingStrategy APPEND_IF_EQUAL = new CollectingStrategy();
            public static final /* enum */ CollectingStrategy IGNORE = new CollectingStrategy();
            private static final /* synthetic */ CollectingStrategy[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static CollectingStrategy[] values() {
                return (CollectingStrategy[])$VALUES.clone();
            }

            public static CollectingStrategy valueOf(String value) {
                return Enum.valueOf(CollectingStrategy.class, value);
            }

            @NotNull
            public static EnumEntries<CollectingStrategy> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = collectingStrategyArray = new CollectingStrategy[]{CollectingStrategy.APPEND, CollectingStrategy.REPLACE, CollectingStrategy.APPEND_IF_EQUAL, CollectingStrategy.IGNORE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[GeomTargetLocator.LookupSpace.values().length];
                try {
                    nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.Y.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[CollectingStrategy.values().length];
                try {
                    nArray[CollectingStrategy.APPEND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CollectingStrategy.REPLACE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CollectingStrategy.APPEND_IF_EQUAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CollectingStrategy.IGNORE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/LayerTargetLocator$Target;", "", "targetProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetProjection;", "prototype", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetPrototype;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetProjection;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetPrototype;)V", "pathProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PathTargetProjection;", "getPathProjection", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PathTargetProjection;", "pointProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PointTargetProjection;", "getPointProjection", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PointTargetProjection;", "polygonProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection;", "getPolygonProjection", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/PolygonTargetProjection;", "getPrototype", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TargetPrototype;", "rectProjection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/RectTargetProjection;", "getRectProjection", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/RectTargetProjection;", "plot-builder"})
    public static final class Target {
        @NotNull
        private final TargetProjection targetProjection;
        @NotNull
        private final TargetPrototype prototype;

        public Target(@NotNull TargetProjection targetProjection, @NotNull TargetPrototype prototype) {
            Intrinsics.checkNotNullParameter((Object)targetProjection, (String)"targetProjection");
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            this.targetProjection = targetProjection;
            this.prototype = prototype;
        }

        @NotNull
        public final TargetPrototype getPrototype() {
            return this.prototype;
        }

        @NotNull
        public final PointTargetProjection getPointProjection() {
            TargetProjection targetProjection = this.targetProjection;
            Intrinsics.checkNotNull((Object)targetProjection, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PointTargetProjection");
            return (PointTargetProjection)targetProjection;
        }

        @NotNull
        public final RectTargetProjection getRectProjection() {
            TargetProjection targetProjection = this.targetProjection;
            Intrinsics.checkNotNull((Object)targetProjection, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.RectTargetProjection");
            return (RectTargetProjection)targetProjection;
        }

        @NotNull
        public final PolygonTargetProjection getPolygonProjection() {
            TargetProjection targetProjection = this.targetProjection;
            Intrinsics.checkNotNull((Object)targetProjection, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PolygonTargetProjection");
            return (PolygonTargetProjection)targetProjection;
        }

        @NotNull
        public final PathTargetProjection getPathProjection() {
            TargetProjection targetProjection = this.targetProjection;
            Intrinsics.checkNotNull((Object)targetProjection, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.PathTargetProjection");
            return (PathTargetProjection)targetProjection;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HitShape.Kind.values().length];
            try {
                nArray[HitShape.Kind.POINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HitShape.Kind.RECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HitShape.Kind.POLYGON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HitShape.Kind.PATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GeomTargetLocator.LookupSpace.values().length];
            try {
                nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomTargetLocator.LookupSpace.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

