/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.customization.cadence;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pycharm.pro.customization.cadence.CadenceAdExecutionListenerKt;
import com.intellij.pycharm.pro.customization.cadence.CadenceBundle;
import com.intellij.pycharm.pro.customization.cadence.CadenceNativeAdCollector;
import com.intellij.ui.LicensingFacade;
import com.jetbrains.python.extensions.ModuleExtKt;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/pycharm/pro/customization/cadence/CadenceAdExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "<init>", "()V", "processStartScheduled", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "isCadenceAudience", "", "facade", "Lcom/intellij/ui/LicensingFacade;", "isAdCampaignActive", "areTargetLibrariesRequired", "getRequirements", "", "isTargetLicenseType", "intellij.pycharm.pro.customization"})
@SourceDebugExtension(value={"SMAP\nCadenceAdExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CadenceAdExecutionListener.kt\ncom/intellij/pycharm/pro/customization/cadence/CadenceAdExecutionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1734#2,3:125\n774#2:128\n865#2,2:129\n1863#2,2:131\n*S KotlinDebug\n*F\n+ 1 CadenceAdExecutionListener.kt\ncom/intellij/pycharm/pro/customization/cadence/CadenceAdExecutionListener\n*L\n101#1:125,3\n111#1:128\n111#1:129,2\n112#1:131,2\n*E\n"})
public final class CadenceAdExecutionListener
implements ExecutionListener {
    public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (Registry.Companion.is("cadence.always.show.native.ad")) {
            this.showNotification(project2);
            return;
        }
        if (CadenceAdExecutionListenerKt.access$isCadenceInstalled() || CadenceAdExecutionListenerKt.access$getNotificationShown()) {
            return;
        }
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return;
        }
        LicensingFacade facade = licensingFacade;
        if (this.isCadenceAudience(project2, facade)) {
            this.showNotification(project2);
            CadenceAdExecutionListenerKt.access$setNotificationShown(true);
        }
    }

    private final void showNotification(Project project) {
        CadenceNativeAdCollector.INSTANCE.getNotificationShown().log(project);
        CadenceAdExecutionListenerKt.access$getCADENCE_NOTIFICATION_GROUP().createNotification(CadenceBundle.INSTANCE.message("cadence.native.ad.notification.title", new Object[0]), CadenceBundle.INSTANCE.message("cadence.native.ad.notification.content", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.create((String)CadenceBundle.INSTANCE.message("cadence.native.ad.notification.install.button", new Object[0]), (arg_0, arg_1) -> CadenceAdExecutionListener.showNotification$lambda$2((arg_0, arg_1) -> CadenceAdExecutionListener.showNotification$lambda$1(project, arg_0, arg_1), arg_0, arg_1))).notify(project);
    }

    private final boolean isCadenceAudience(Project project, LicensingFacade facade) {
        return this.isAdCampaignActive() && this.areTargetLibrariesRequired(project) && this.isTargetLicenseType(facade);
    }

    private final boolean isAdCampaignActive() {
        LocalDate currentDate = LocalDate.now();
        return !currentDate.isBefore(CadenceAdExecutionListenerKt.access$getAD_CAMPAIGN_START_DATE$p()) && currentDate.isBefore(CadenceAdExecutionListenerKt.access$getAD_CAMPAIGN_END_DATE$p());
    }

    private final boolean areTargetLibrariesRequired(Project project) {
        boolean bl;
        block3: {
            Set<String> requirements = this.getRequirements(project);
            Iterable $this$all$iv = CadenceAdExecutionListenerKt.access$getTARGET_LIBRARIES$p();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (requirements.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getRequirements(Project project) {
        HashSet<String> result = new HashSet<String>();
        PyPIPackageCache pyPIPackageCache = PyPIPackageCache.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pyPIPackageCache, (String)"getInstance(...)");
        PyPIPackageCache pypiPackages = pyPIPackageCache;
        for (Module module : PyStatisticToolsKt.getModules((Project)project)) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Sdk sdk2;
            if (ModuleExtKt.getSdk((Module)module) == null || !PythonSdkUtil.isPythonSdk((Sdk)sdk2)) continue;
            List list = PyPackageManager.getInstance((Sdk)sdk2).getRequirements(module);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PyRequirement it = (PyRequirement)element$iv$iv;
                boolean bl = false;
                if (!pypiPackages.containsPackage(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyRequirement req = (PyRequirement)element$iv;
                boolean bl = false;
                String string = req.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                result.add(PyStatisticToolsKt.normalizePackageName((String)string));
            }
        }
        return result;
    }

    private final boolean isTargetLicenseType(LicensingFacade facade) {
        String meta = facade.metadata;
        return meta != null && meta.length() > 10 && CadenceAdExecutionListenerKt.access$getTARGET_LICENSE_TYPES$p().contains(Character.valueOf(meta.charAt(10)));
    }

    private static final void showNotification$lambda$1$lambda$0(Project $project, Notification $notification) {
        CadenceNativeAdCollector.INSTANCE.getNotificationInstallClicked().log($project);
        $notification.expire();
    }

    private static final Unit showNotification$lambda$1(Project $project, AnActionEvent anActionEvent, Notification notification) {
        PluginsAdvertiser.installAndEnable$default((Project)$project, (Set)SetsKt.setOf((Object)CadenceAdExecutionListenerKt.access$getCadencePluginId()), (boolean)false, (boolean)false, null, () -> CadenceAdExecutionListener.showNotification$lambda$1$lambda$0($project, notification), (int)28, null);
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

