/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.ConfigurableAwareTableWithCardEditor;
import com.intellij.docker.settings.DockerLinkConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.Column;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DockerLinksEditor
extends ConfigurableAwareTableWithCardEditor<DockerLinkImpl, ColumnBase> {
    private final RemoteServer myServer;

    public DockerLinksEditor(RemoteServer server) {
        super((Column[])new ColumnBase[]{new NameColumn(), new AliasColumn()});
        this.myServer = server;
    }

    @Override
    protected DockerLinkImpl createItem() {
        return new DockerLinkImpl();
    }

    @Override
    protected DockerLinkImpl cloneItem(DockerLinkImpl item) {
        return new DockerLinkImpl(item);
    }

    @Override
    @NotNull
    protected Configurable createItemConfigurable(DockerLinkImpl item) {
        return new DockerLinkConfigurable(item, (RemoteServer<DockerCloudConfiguration>)this.myServer);
    }

    public static abstract class ColumnBase
    extends Column<DockerLinkImpl> {
        public ColumnBase(@Nls String name2) {
            super(name2);
        }
    }

    private static class NameColumn
    extends ColumnBase {
        NameColumn() {
            super(DockerBundle.message("DockerLinksEditor.NameColumn.title", new Object[0]));
        }

        public Object getColumnValue(DockerLinkImpl row) {
            return row.getName();
        }
    }

    private static class AliasColumn
    extends ColumnBase {
        AliasColumn() {
            super(DockerBundle.message("DockerLinksEditor.AliasColumn.title", new Object[0]));
        }

        public Object getColumnValue(DockerLinkImpl row) {
            return row.getAlias();
        }
    }
}

