/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.resourceRoots;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.module.PyRootTypeProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRootProvider
extends PyRootTypeProvider {
    private static final JBColor PROJECT_STRUCTURE_GROUP_COLOR = new JBColor(13532419, 13532419);
    private final MultiMap<ContentEntry, VirtualFilePointer> myResourceRoots = new MultiMap();

    public void reset(@NotNull Disposable disposable, PyContentEntriesEditor editor, @NotNull Module module) {
        if (disposable == null) {
            ResourceRootProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ResourceRootProvider.$$$reportNull$$$0(1);
        }
        this.myResourceRoots.clear();
        MultiMap<String, String> resourcesRoots = this.getResourceRoots(module);
        if (resourcesRoots == null) {
            return;
        }
        for (String contentEntryUrl : resourcesRoots.keySet()) {
            ContentEntry contentEntry = ResourceRootProvider.findContentEntry(contentEntryUrl, editor);
            if (contentEntry == null) continue;
            for (String resourceRoot : resourcesRoots.get((Object)contentEntryUrl)) {
                this.myResourceRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(resourceRoot, disposable, this.DUMMY_LISTENER));
            }
        }
    }

    public void apply(Module module) {
        MultiMap<String, String> resourceRoots = this.getCurrentResourceRoots();
        this.setResourceRoots(resourceRoots, module);
    }

    @Nullable
    public CustomShortcutSet getShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8));
    }

    public boolean isModified(Module module) {
        MultiMap<String, String> roots = this.getResourceRoots(module);
        if (roots != null) {
            MultiMap<String, String> current = this.getCurrentResourceRoots();
            if (!Comparing.haveEqualElements((Collection)roots.keySet(), (Collection)current.keySet())) {
                return true;
            }
            for (String contentEntryUrl : roots.keySet()) {
                if (Comparing.haveEqualElements((Collection)roots.get((Object)contentEntryUrl), (Collection)current.get((Object)contentEntryUrl))) continue;
                return true;
            }
        }
        return false;
    }

    public MultiMap<ContentEntry, VirtualFilePointer> getRoots() {
        return this.myResourceRoots;
    }

    public Icon getIcon() {
        return AllIcons.Modules.ResourcesRoot;
    }

    @NotNull
    public String getName() {
        String string = PythonProBundle.message("python.resources.name");
        if (string == null) {
            ResourceRootProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = PythonProBundle.message("python.resources.description");
        if (string == null) {
            ResourceRootProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getRootsGroupTitle() {
        String string = PythonProBundle.message("python.resources.group.title");
        if (string == null) {
            ResourceRootProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Color getRootsGroupColor() {
        JBColor jBColor = PROJECT_STRUCTURE_GROUP_COLOR;
        if (jBColor == null) {
            ResourceRootProvider.$$$reportNull$$$0(5);
        }
        return jBColor;
    }

    public ContentEntryEditingAction createRootEntryEditingAction(JTree tree, Disposable disposable, PyContentEntriesEditor editor, ModifiableRootModel model) {
        return new PyRootTypeProvider.RootEntryEditingAction((PyRootTypeProvider)this, tree, disposable, editor, model);
    }

    private MultiMap<String, String> getCurrentResourceRoots() {
        MultiMap result = new MultiMap();
        for (ContentEntry entry : this.myResourceRoots.keySet()) {
            ArrayList<String> resourcesRoots = new ArrayList<String>();
            for (VirtualFilePointer filePointer : this.myResourceRoots.get((Object)entry)) {
                resourcesRoots.add(filePointer.getUrl());
            }
            result.put((Object)entry.getUrl(), resourcesRoots);
        }
        return result;
    }

    @NotNull
    public static Set<String> getAllResourceRoots(@NotNull Module module) {
        if (module == null) {
            ResourceRootProvider.$$$reportNull$$$0(6);
        }
        HashSet<String> result = new HashSet<String>();
        ImmutableList rootProviders = FluentIterable.from((Iterable)PyRootTypeProvider.EP_NAME.getExtensionList()).filter(ResourceRootProvider.class).toList();
        for (ResourceRootProvider provider : rootProviders) {
            MultiMap<String, String> roots = provider.getResourceRoots(module);
            if (roots == null) continue;
            result.addAll(roots.values().stream().map(VfsUtilCore::urlToPath).collect(Collectors.toSet()));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            ResourceRootProvider.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @Nullable
    private static ContentEntry findContentEntry(String url, PyContentEntriesEditor editor) {
        for (ContentEntry contentEntry : editor.getContentEntries()) {
            if (!contentEntry.getUrl().equals(url)) continue;
            return contentEntry;
        }
        return null;
    }

    @Nullable
    protected abstract MultiMap<String, String> getResourceRoots(Module var1);

    protected abstract void setResourceRoots(MultiMap<String, String> var1, Module var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/resourceRoots/ResourceRootProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/resourceRoots/ResourceRootProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsGroupTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsGroupColor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllResourceRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

