/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValueBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.EvaluateSessionKt;
import org.jetbrains.wip.JSDebuggerWipBackendBundle;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipObject;
import org.jetbrains.wip.WipObjectKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.runtime.CallArgument;
import org.jetbrains.wip.protocol.runtime.CallFunctionOnResult;
import org.jetbrains.wip.protocol.runtime.GetPropertiesResult;
import org.jetbrains.wip.protocol.runtime.InternalPropertyDescriptor;
import org.jetbrains.wip.protocol.runtime.ObjectPreviewValue;
import org.jetbrains.wip.protocol.runtime.PrivatePropertyDescriptor;
import org.jetbrains.wip.protocol.runtime.PropertyDescriptor;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0014J\b\u0010&\u001a\u00020'H\u0016J$\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020-0)2\u0006\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020/H\u0016J(\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001010)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0016\u0010$\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010!\u00a8\u00068"}, d2={"Lorg/jetbrains/wip/WipObject;", "Lorg/jetbrains/debugger/values/ObjectValueBase;", "Lorg/jetbrains/wip/WipValueManager;", "Lorg/jetbrains/wip/SerializableValue;", "Lorg/jetbrains/debugger/ValueModifier;", "Lorg/jetbrains/debugger/PresentationProvider;", "type", "Lorg/jetbrains/debugger/values/ValueType;", "valueData", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "valueManager", "<init>", "(Lorg/jetbrains/debugger/values/ValueType;Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;Lorg/jetbrains/wip/WipValueManager;)V", "getValueData", "()Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "subtype", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue$Subtype;", "getSubtype", "()Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue$Subtype;", "childrenManager", "Lorg/jetbrains/debugger/VariablesHost;", "getChildrenManager", "()Lorg/jetbrains/debugger/VariablesHost;", "createInternalPropertyValue", "Lorg/jetbrains/debugger/ObjectProperty;", "propertyDescriptor", "Lorg/jetbrains/wip/protocol/runtime/InternalPropertyDescriptor;", "createPrivatePropertyValue", "Lorg/jetbrains/wip/protocol/runtime/PrivatePropertyDescriptor;", "valueModifier", "valueString", "", "getValueString", "()Ljava/lang/String;", "className", "getClassName", "refId", "getRefId", "createCallArgumentParam", "Lorg/jetbrains/wip/protocol/runtime/CallArgument;", "setValue", "Lorg/jetbrains/concurrency/Promise;", "variable", "Lorg/jetbrains/debugger/Variable;", "newValue", "Lorg/jetbrains/debugger/values/Value;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "evaluateGet", "", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "intellij.javascript.wip.backend"})
public class WipObject
extends ObjectValueBase<WipValueManager>
implements SerializableValue,
ValueModifier,
PresentationProvider {
    @NotNull
    private final RemoteObjectValue valueData;
    @NotNull
    private final VariablesHost<WipValueManager> childrenManager;

    public WipObject(@NotNull ValueType type, @NotNull RemoteObjectValue valueData, @NotNull WipValueManager valueManager) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)valueData, (String)"valueData");
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        super(type);
        this.valueData = valueData;
        this.childrenManager = (VariablesHost)new VariablesHost<WipValueManager>(valueManager, this){
            final /* synthetic */ WipValueManager $valueManager;
            final /* synthetic */ WipObject this$0;
            {
                this.$valueManager = $valueManager;
                this.this$0 = $receiver;
                super((ValueManager)$valueManager);
            }

            protected Promise<List<Variable>> load() {
                String objectId = this.this$0.getValueData().getObjectId();
                if (objectId == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(WipObject.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("objectId is null");
                    return Promises.resolvedPromise((Object)CollectionsKt.emptyList());
                }
                Promise ownPropertiesPromise = this.$valueManager.getCommandProcessor().send((Request)RuntimeKt.GetProperties$default(objectId, true, null, true, null, 20, null));
                Promise accessorsPropertiesPromise = this.$valueManager.getCommandProcessor().send((Request)RuntimeKt.GetProperties$default(objectId, false, true, true, null, 16, null));
                Object[] objectArray = new Promise[]{ownPropertiesPromise, accessorsPropertiesPromise};
                Promise promise = Promises.collectResults$default((Collection)CollectionsKt.listOf((Object[])objectArray), (boolean)false, (int)1, null).then(arg_0 -> childrenManager.1.load$lambda$8(arg_0 -> childrenManager.1.load$lambda$7(this, this.$valueManager, this.this$0, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
                return promise;
            }

            /*
             * WARNING - void declaration
             */
            private static final List load$lambda$7(childrenManager.1 this$0, WipValueManager $valueManager, WipObject this$1, List result) {
                Iterable $this$forEach$iv;
                boolean $i$f$forEach;
                ObjectProperty it$iv$iv;
                boolean bl;
                Object it;
                boolean bl2;
                T element$iv$iv;
                T element$iv$iv$iv;
                Iterator<T> iterator;
                boolean $i$f$forEach2;
                void $this$forEach$iv$iv$iv;
                Iterator<T> $this$mapNotNullTo$iv$iv;
                boolean $i$f$mapNotNullTo;
                Collection destination$iv$iv;
                Iterable $this$mapNotNull$iv;
                boolean $i$f$mapNotNull;
                List<Object> properties;
                ObjectProperty property;
                Map map;
                Intrinsics.checkNotNull((Object)result);
                GetPropertiesResult ownProperties = (GetPropertiesResult)result.get(0);
                GetPropertiesResult accessorsProperties = (GetPropertiesResult)result.get(1);
                List symbols = new ArrayList<E>();
                Map $this$load_u24lambda_u247_u24lambda_u246 = map = MapsKt.createMapBuilder();
                boolean bl3 = false;
                for (PropertyDescriptor propertyDescriptor : ownProperties.result()) {
                    Boolean bl4;
                    if (propertyDescriptor.getGet() != null || propertyDescriptor.getSet() != null) continue;
                    property = $valueManager.createProperty(propertyDescriptor, (ValueModifier)this$1);
                    if (propertyDescriptor.getSymbol() == null) {
                        String string = property.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        bl4 = $this$load_u24lambda_u247_u24lambda_u246.put(string, property);
                        continue;
                    }
                    bl4 = symbols.add(property);
                }
                List<PrivatePropertyDescriptor> list = ownProperties.getPrivateProperties();
                if (list != null) {
                    properties = list;
                    boolean bl5 = false;
                    Iterable iterable = properties;
                    $i$f$mapNotNull = false;
                    Iterator<T> iterator2 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach2 = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl2 = false;
                        it = (PrivatePropertyDescriptor)element$iv$iv;
                        boolean bl6 = false;
                        if (this$1.createPrivatePropertyValue((PrivatePropertyDescriptor)it, this$1) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ObjectProperty prop = (ObjectProperty)element$iv;
                        boolean bl7 = false;
                        String string = prop.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        $this$load_u24lambda_u247_u24lambda_u246.put(string, prop);
                    }
                }
                for (PropertyDescriptor propertyDescriptor : accessorsProperties.result()) {
                    Boolean bl8;
                    property = $valueManager.createProperty(propertyDescriptor, (ValueModifier)this$1);
                    if (propertyDescriptor.getSymbol() == null) {
                        String string = property.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        bl8 = $this$load_u24lambda_u247_u24lambda_u246.put(string, property);
                        continue;
                    }
                    bl8 = symbols.add(property);
                }
                List<InternalPropertyDescriptor> list2 = ownProperties.getInternalProperties();
                if (list2 != null) {
                    properties = list2;
                    boolean bl9 = false;
                    $this$forEach$iv = properties;
                    $i$f$mapNotNull = false;
                    $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach2 = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl2 = false;
                        it = (InternalPropertyDescriptor)element$iv$iv;
                        boolean bl10 = false;
                        if (this$1.createInternalPropertyValue((InternalPropertyDescriptor)it) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ObjectProperty prop = (ObjectProperty)element$iv;
                        boolean bl11 = false;
                        String string = prop.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        $this$load_u24lambda_u247_u24lambda_u246.put(string, prop);
                    }
                }
                if ($this$load_u24lambda_u247_u24lambda_u246.containsKey("[[Prototype]]")) {
                    $this$load_u24lambda_u247_u24lambda_u246.remove("__proto__");
                }
                Map properties2 = MapsKt.build((Map)map);
                this$0.updateCacheStamp();
                return CollectionsKt.plus(properties2.values(), (Iterable)symbols);
            }

            private static final List load$lambda$8(Function1 $tmp0, Object p0) {
                return (List)$tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    protected final RemoteObjectValue getValueData() {
        return this.valueData;
    }

    @Nullable
    public final RemoteObjectValue.Subtype getSubtype() {
        return this.valueData.getSubtype();
    }

    @NotNull
    protected VariablesHost<WipValueManager> getChildrenManager() {
        return this.childrenManager;
    }

    @Nullable
    protected ObjectProperty createInternalPropertyValue(@NotNull InternalPropertyDescriptor propertyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        return ((WipValueManager)this.getChildrenManager().valueManager).createProperty(propertyDescriptor);
    }

    @Nullable
    protected ObjectProperty createPrivatePropertyValue(@NotNull PrivatePropertyDescriptor propertyDescriptor, @NotNull ValueModifier valueModifier) {
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkNotNullParameter((Object)valueModifier, (String)"valueModifier");
        return ((WipValueManager)this.getChildrenManager().valueManager).createProperty(propertyDescriptor, valueModifier);
    }

    @Nullable
    public String getValueString() {
        return this.valueData.getDescription();
    }

    @Nullable
    public String getClassName() {
        return this.valueData.getClassName();
    }

    @Override
    @Nullable
    public String getRefId() {
        return this.valueData.getObjectId();
    }

    @Override
    @NotNull
    public CallArgument createCallArgumentParam() {
        return new CallArgument(null, null, this.valueData.getObjectId(), 3, null);
    }

    @NotNull
    public Promise<?> setValue(@NotNull Variable variable, @NotNull Value newValue, @NotNull EvaluateContext evaluateContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        CallArgument[] callArgumentArray = new CallArgument[]{new CallArgument(variable.getName(), null, null, 6, null), EvaluateSessionKt.createCallArgument(newValue)};
        List callArguments = CollectionsKt.listOf((Object[])callArgumentArray);
        WipCommandProcessor wipCommandProcessor = ((WipValueManager)this.getChildrenManager().valueManager).getCommandProcessor();
        CharSequence charSequence = "function(a, b) { this[a] = b; }";
        String string = this.getRefId();
        Intrinsics.checkNotNull((Object)string);
        Promise setValueCallback = wipCommandProcessor.send((Request)RuntimeKt.CallFunctionOn$default(charSequence, string, callArguments, null, null, null, null, null, null, null, null, null, null, 8184, null));
        if (variable instanceof ObjectProperty && ((ObjectProperty)variable).getSetter() != null) {
            return evaluateContext.refreshOnDone(setValueCallback);
        }
        Promise promise = setValueCallback.onSuccess(arg_0 -> WipObject.setValue$lambda$1(arg_0 -> WipObject.setValue$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
        return promise;
    }

    @NotNull
    public Promise<Value> evaluateGet(@NotNull Variable variable, @NotNull EvaluateContext evaluateContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        return ValueModifierUtil.INSTANCE.evaluateGet(variable, (Object)this, evaluateContext, "this");
    }

    @NotNull
    public Promise<Object> setValue(@NotNull Variable variable, @NotNull String newValue, @NotNull EvaluateContext evaluateContext) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        return ValueModifierUtil.INSTANCE.setValue(variable, EvaluateSessionKt.wrapObjectExpression(newValue), evaluateContext, (ValueModifier)this);
    }

    public boolean computePresentation(@NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (this.valueData.type() == RemoteObjectValue.Type.OBJECT) {
            node.setFullValueEvaluator(new XFullValueEvaluator(this){
                final /* synthetic */ WipObject this$0;
                {
                    this.this$0 = $receiver;
                    super("");
                }

                public void startEvaluation(XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                    Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                    String func = "function() { return JSON.stringify(this, null, 2) }";
                    WipCommandProcessor wipCommandProcessor = ((WipValueManager)this.this$0.getChildrenManager().valueManager).getCommandProcessor();
                    CharSequence charSequence = func;
                    String string = this.this$0.getValueData().getObjectId();
                    Intrinsics.checkNotNull((Object)string);
                    wipCommandProcessor.send((Request)RuntimeKt.CallFunctionOn$default(charSequence, string, null, null, true, null, null, null, null, null, null, null, null, 8172, null)).onSuccess(arg_0 -> computePresentation.1.startEvaluation$lambda$1(arg_0 -> computePresentation.1.startEvaluation$lambda$0(callback, arg_0), arg_0));
                }

                private static final Unit startEvaluation$lambda$0(XFullValueEvaluator.XFullValueEvaluationCallback $callback, CallFunctionOnResult it) {
                    RemoteObjectValue result = it.result();
                    Object value = result.value();
                    if (value instanceof String) {
                        $callback.evaluated((String)value);
                    } else {
                        String string = result.getDescription();
                        if (string == null) {
                            String string2 = JSDebuggerWipBackendBundle.message("debugger.presentation.error.cant.evaluate.full.value", new Object[0]);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        }
                        $callback.errorOccurred(string);
                    }
                    return Unit.INSTANCE;
                }

                private static final void startEvaluation$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            });
        }
        ObjectPreviewValue objectPreviewValue = this.valueData.getPreview();
        if (objectPreviewValue == null) {
            return false;
        }
        ObjectPreviewValue preview = objectPreviewValue;
        node.setPresentation(icon, new XValuePresentation(preview){
            final /* synthetic */ ObjectPreviewValue $preview;
            {
                this.$preview = $preview;
            }

            public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                WipObjectKt.access$renderValue(this.$preview, renderer);
            }
        }, true);
        return true;
    }

    private static final Unit setValue$lambda$0(WipObject this$0, CallFunctionOnResult it) {
        ((WipValueManager)this$0.getChildrenManager().valueManager).clearCaches();
        return Unit.INSTANCE;
    }

    private static final void setValue$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

