/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class KarmaServerRestarter {
    private final AtomicInteger myActiveRunners;
    private final AtomicBoolean myConfigChanged;

    public KarmaServerRestarter(@NotNull String configurationFilePath, @NotNull Disposable parentDisposable) {
        if (configurationFilePath == null) {
            KarmaServerRestarter.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            KarmaServerRestarter.$$$reportNull$$$0(1);
        }
        this.myActiveRunners = new AtomicInteger(0);
        this.myConfigChanged = new AtomicBoolean(false);
        File configurationFile = new File(configurationFilePath);
        if (configurationFile.exists()) {
            this.listenForConfigurationFileChanges(configurationFile, parentDisposable);
        }
    }

    private void listenForConfigurationFileChanges(@NotNull File configurationFile, @NotNull Disposable parentDisposable) {
        if (configurationFile == null) {
            KarmaServerRestarter.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            KarmaServerRestarter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(configurationFile);
            if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory() && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null && !Disposer.isDisposed((Disposable)parentDisposable)) {
                document.addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        KarmaServerRestarter.this.myConfigChanged.set(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/karma/server/KarmaServerRestarter$1", "documentChanged"));
                    }
                }, parentDisposable);
            }
        }), ModalityState.any());
    }

    public void onRunnerExecutionStarted(final @NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            KarmaServerRestarter.$$$reportNull$$$0(4);
        }
        this.myActiveRunners.incrementAndGet();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                KarmaServerRestarter.this.myActiveRunners.decrementAndGet();
                processHandler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/KarmaServerRestarter$2", "processTerminated"));
            }
        });
    }

    public boolean isRestartRequired() {
        return this.myActiveRunners.get() == 0 && this.myConfigChanged.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFilePath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerRestarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "listenForConfigurationFileChanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onRunnerExecutionStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

