/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.timeTracking.TasksTimeTrackingBundle;
import com.intellij.tasks.timeTracking.TasksToolWindowPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.regex.Matcher;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class SendTimeTrackingInformationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(TasksToolWindowPanel.class);
    @Nullable
    private final Project myProject;
    private final LocalTask myTask;
    private JRadioButton myFromPreviousPostRadioButton;
    private JRadioButton myTotallyRadioButton;
    private JRadioButton myCustomRadioButton;
    private JTextField myFromPreviousPostTextField;
    private JTextField myTotallyTextField;
    private JTextField myCustomTextField;
    private JTextArea myCommentTextArea;
    private JPanel myPanel;
    private JLabel myTaskNameLabel;

    protected SendTimeTrackingInformationDialog(@Nullable Project project, LocalTask localTask) {
        super(project);
        this.myProject = project;
        this.myTask = localTask;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(TasksTimeTrackingBundle.message("dialog.title.time.tracking", objectArray));
        this.myTaskNameLabel.setText(this.myTask.getPresentableName());
        this.myFromPreviousPostRadioButton.setSelected(true);
        if (this.myTask.getLastPost() == null) {
            this.myFromPreviousPostRadioButton.setVisible(false);
            this.myFromPreviousPostTextField.setVisible(false);
            this.myTotallyRadioButton.setSelected(true);
        }
        this.myFromPreviousPostTextField.setText(SendTimeTrackingInformationDialog.formatDuration(this.myTask.getTimeSpentFromLastPost()));
        this.myTotallyTextField.setText(SendTimeTrackingInformationDialog.formatDuration(this.myTask.getTotalTimeSpent()));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public static String formatDuration(long milliseconds) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        int hours = (int)(milliseconds / 3600000L);
        int minutes = (int)(milliseconds % 3600000L / 60000L);
        String hoursString = hours + "h ";
        String minutesString = minutes + "m";
        return hoursString + minutesString;
    }

    protected void doOKAction() {
        String timeSpentText = this.myFromPreviousPostRadioButton.isSelected() ? this.myFromPreviousPostTextField.getText() : (this.myTotallyRadioButton.isSelected() ? this.myTotallyTextField.getText() : this.myCustomTextField.getText());
        Matcher matcher = TaskRepository.TIME_SPENT_PATTERN.matcher(timeSpentText);
        if (matcher.matches()) {
            TaskRepository repository = this.myTask.getRepository();
            if (repository == null || !repository.isSupported(4)) {
                LOG.error("Time management not supported: " + repository);
                return;
            }
            try {
                repository.updateTimeSpent(this.myTask, timeSpentText, this.myCommentTextArea.getText());
                this.myTask.setLastPost(new Date());
            }
            catch (Exception e1) {
                Messages.showErrorDialog((Project)this.myProject, (String)TasksTimeTrackingBundle.message("dialog.message.html.could.not.send.information.for.br", this.myTask.getPresentableName(), e1.getMessage()), (String)TasksTimeTrackingBundle.message("dialog.title.error", new Object[0]));
                LOG.warn((Throwable)e1);
            }
        }
        super.doOKAction();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String timeSpentText;
        String string = this.myFromPreviousPostRadioButton.isSelected() ? this.myFromPreviousPostTextField.getText() : (timeSpentText = this.myTotallyRadioButton.isSelected() ? this.myTotallyTextField.getText() : this.myCustomTextField.getText());
        if (!TaskRepository.TIME_SPENT_PATTERN.matcher(timeSpentText).matches()) {
            return new ValidationInfo(TasksTimeTrackingBundle.message("dialog.message.time.spent.has.broken.format", new Object[0]));
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "com.intellij.tasks.timeTracking.TasksToolWindowPanel";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JTextField jTextField2;
        JTextField jTextField3;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JTextArea jTextArea;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("issue"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("comment"));
        jBLabel2.setToolTipText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myTaskNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myCommentTextArea = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(5, 0, 5, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myFromPreviousPostRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("from.previous.post"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("custom"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFromPreviousPostTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCustomTextField = jTextField2 = new JTextField();
        jTextField2.setText(DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("0h.0m"));
        jPanel2.add((Component)jTextField2, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTotallyRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("totally"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTotallyTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/TasksTimeTrackingBundle", SendTimeTrackingInformationDialog.class).getString("time.spent"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

