/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.javascript.JSParameterInfoHandlerKt;
import com.intellij.javascript.JSParameterPresentation;
import com.intellij.javascript.JSSignaturePresentation;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentsHolder;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0015J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0019H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u001eH\u0016J\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 2\u0006\u0010!\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0012\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\b\u0010(\u001a\u00020)H\u0014J.\u0010*\u001a\u00020\u00162\u0014\u0010+\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010-\u0012\u0004\u0012\u00020\u000f0,2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J$\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010/\u001a\u000200H\u0002J$\u00108\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010\u0014\u001a\u00020\u00042\f\u00109\u001a\b\u0012\u0004\u0012\u00020302H\u0002J(\u0010:\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010;\u001a\u0004\u0018\u00010\u00042\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002J$\u0010<\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u0012\u001a\u00020\u00132\f\u00109\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u000207022\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u000203H\u0002J\u001a\u0010=\u001a\u0004\u0018\u0001072\u0006\u0010>\u001a\u0002032\b\u0010\u0014\u001a\u0004\u0018\u000103\u00a8\u0006?"}, d2={"Lcom/intellij/javascript/JSParameterInfoHandler;", "Lcom/intellij/lang/parameterInfo/ParameterInfoHandlerWithTabActionSupport;", "Lcom/intellij/lang/javascript/psi/JSArgumentsHolder;", "Lcom/intellij/javascript/JSSignaturePresentation;", "Lcom/intellij/lang/javascript/psi/JSExpression;", "<init>", "()V", "getArgListStopSearchClasses", "", "Ljava/lang/Class;", "findElementForParameterInfo", "context", "Lcom/intellij/lang/parameterInfo/CreateParameterInfoContext;", "fillSignaturesForArgumentList", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "argList", "fillSignaturesForReferenceOrIndexAccessExpression", "parent", "Lcom/intellij/lang/javascript/psi/JSCallLikeExpression;", "methodExpression", "showParameterInfo", "", "element", "findElementForUpdatingParameterInfo", "Lcom/intellij/lang/parameterInfo/UpdateParameterInfoContext;", "updateParameterInfo", "parameterOwner", "updateUI", "signaturePresentation", "Lcom/intellij/lang/parameterInfo/ParameterInfoUIContext;", "getActualParameters", "", "arguments", "(Lcom/intellij/lang/javascript/psi/JSArgumentsHolder;)[Lcom/intellij/lang/javascript/psi/JSExpression;", "getActualParameterDelimiterType", "Lcom/intellij/psi/tree/IElementType;", "getActualParametersRBraceType", "getArgumentListAllowedParentClasses", "getArgumentListClass", "skipTypeScript", "", "doAddSignature", "typedSignatures", "", "", "functionItem", "typeSubstitutor", "Lcom/intellij/lang/javascript/psi/types/JSTypeSubstitutor;", "getResolvedPsiElements", "", "Lcom/intellij/psi/PsiElement;", "deduplicateSignatures", "items", "", "Lcom/intellij/lang/javascript/psi/JSFunctionItem;", "getFunctionItems", "elements", "getTypeSubstitutor", "qualifier", "getElementsWithConstructors", "calculatePossibleFunctionCarefully", "resolveResult", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSParameterInfoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSParameterInfoHandler.kt\ncom/intellij/javascript/JSParameterInfoHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,681:1\n37#2,2:682\n*S KotlinDebug\n*F\n+ 1 JSParameterInfoHandler.kt\ncom/intellij/javascript/JSParameterInfoHandler\n*L\n67#1:682,2\n*E\n"})
public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentsHolder, JSSignaturePresentation, JSExpression> {
    @NotNull
    public Set<Class<?>> getArgListStopSearchClasses() {
        return JSParameterInfoHandlerKt.access$getOurStopSearch$p();
    }

    @Nullable
    public JSArgumentsHolder findElementForParameterInfo(@NotNull CreateParameterInfoContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JSArgumentsHolder argList = JSParameterInfoHandlerKt.findArgumentList(context2.getFile(), context2.getOffset());
        if (argList == null) {
            return null;
        }
        if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
            return null;
        }
        Sequence<JSFunctionType> resultStream = this.fillSignaturesForArgumentList(context2, argList);
        if (resultStream != null) {
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map(resultStream, JSParameterInfoHandler::findElementForParameterInfo$lambda$0));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            context2.setItemsToShow((Object[])thisCollection$iv.toArray(new JSSignaturePresentation[0]));
            return argList;
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    protected Sequence<JSFunctionType> fillSignaturesForArgumentList(@NotNull CreateParameterInfoContext context2, @NotNull JSArgumentsHolder argList) {
        JSFunctionItem implicitFunction;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argList, (String)"argList");
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallLikeExpression)) {
            return null;
        }
        JSExpression methodExpression = JSUtils.unparenthesize(((JSCallLikeExpression)psiElement).getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return this.fillSignaturesForReferenceOrIndexAccessExpression((JSCallLikeExpression)psiElement, methodExpression);
        }
        if (methodExpression instanceof JSSuperExpression || methodExpression instanceof JSThisExpression) {
            PsiReference reference = methodExpression.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement clazz = reference.resolve();
            if (clazz instanceof JSFunction) {
                if (clazz instanceof TypeScriptFunction) {
                    Collection<? extends JSFunctionItem> collection = TypeScriptPsiUtil.getAllOverloadSignatures((JSFunctionItem)clazz);
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllOverloadSignatures(...)");
                    Collection<? extends JSFunctionItem> overloadDeclarations = collection;
                    return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)overloadDeclarations), JSParameterInfoHandler::fillSignaturesForArgumentList$lambda$1);
                }
                Object[] objectArray = new JSFunctionWithSubstitutor[]{new JSFunctionWithSubstitutor((JSFunctionItem)clazz, JSTypeSubstitutor.EMPTY)};
                return SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), JSParameterInfoHandler::fillSignaturesForArgumentList$lambda$2);
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            Object[] reference = new JSFunctionExpression[]{methodExpression};
            return SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])reference), JSParameterInfoHandler::fillSignaturesForArgumentList$lambda$3);
        }
        if ((implicitFunction = JSParameterInfoHandlerKt.getImplicitFunction(methodExpression)) != null) {
            List list = CollectionsKt.listOf((Object)implicitFunction);
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSTypeSubstitutor, (String)"EMPTY");
            return this.deduplicateSignatures(list, jSTypeSubstitutor);
        }
        return null;
    }

    private final Sequence<JSFunctionType> fillSignaturesForReferenceOrIndexAccessExpression(JSCallLikeExpression parent, JSExpression methodExpression) {
        Collection<PsiElement> elements = this.getResolvedPsiElements(methodExpression);
        if (elements.isEmpty()) {
            return null;
        }
        elements = this.getElementsWithConstructors(parent, elements);
        boolean bl = methodExpression instanceof JSQualifiedExpression;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)methodExpression, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSQualifiedExpression");
        JSExpression qualifier = ((JSQualifiedExpression)methodExpression).getQualifier();
        List<JSFunctionItem> items = this.getFunctionItems(methodExpression, elements);
        JSTypeSubstitutor typeSubstitutor = this.getTypeSubstitutor(methodExpression, qualifier, items);
        return this.deduplicateSignatures(items, typeSubstitutor);
    }

    public void showParameterInfo(@NotNull JSArgumentsHolder element, @NotNull CreateParameterInfoContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        context2.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public JSArgumentsHolder findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return JSParameterInfoHandlerKt.findArgumentList(context2.getFile(), context2.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentsHolder parameterOwner, @NotNull UpdateParameterInfoContext context2) {
        Intrinsics.checkNotNullParameter((Object)parameterOwner, (String)"parameterOwner");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int argumentIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context2.getOffset(), (IElementType)parameterOwner.getDelimiter());
        JSExpression[] jSExpressionArray = parameterOwner.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
        JSExpression[] arguments = jSExpressionArray;
        int i = 0;
        while ((double)i < Math.min((double)argumentIndex, (double)arguments.length)) {
            if (arguments[i] instanceof JSSpreadExpression) {
                JSExpression jSExpression = arguments[i];
                Intrinsics.checkNotNull((Object)jSExpression, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSSpreadExpression");
                JSType type = JSResolveUtil.getExpressionJSType(((JSSpreadExpression)jSExpression).getExpression(), true);
                if (type instanceof JSTupleType && ((JSTupleType)type).getMinLength() == ((JSTupleType)type).getMaxLength()) {
                    argumentIndex += ((JSTupleType)type).getMinLength() - 1;
                } else {
                    context2.setCurrentParameter(-1);
                    return;
                }
            }
            ++i;
        }
        context2.setCurrentParameter(argumentIndex);
    }

    public void updateUI(@NotNull JSSignaturePresentation signaturePresentation, @NotNull ParameterInfoUIContext context2) {
        Intrinsics.checkNotNullParameter((Object)signaturePresentation, (String)"signaturePresentation");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List<JSParameterPresentation> params = signaturePresentation.getParameters();
        int currentParameterIndex = context2.getCurrentParameterIndex() >= 0 ? context2.getCurrentParameterIndex() : params.size();
        JSParameterPresentation parameter = signaturePresentation.getParameter(currentParameterIndex);
        String text = signaturePresentation.getText();
        JSParameterPresentation jSParameterPresentation = parameter;
        int highlightStart = jSParameterPresentation != null ? jSParameterPresentation.getTextRangeStart() : 0;
        JSParameterPresentation jSParameterPresentation2 = parameter;
        int highlightEnd = jSParameterPresentation2 != null ? jSParameterPresentation2.getTextRangeEnd() : 0;
        context2.setupUIComponentPresentation(text, highlightStart, highlightEnd, false, false, false, context2.getDefaultParameterColor());
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentsHolder arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        JSExpression[] jSExpressionArray = arguments.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"COMMA");
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"RBRACE");
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        return JSParameterInfoHandlerKt.access$getOurArgumentListAllowedParentClassesSet$p();
    }

    @NotNull
    public Class<JSArgumentsHolder> getArgumentListClass() {
        return JSArgumentsHolder.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private final void doAddSignature(Map<String, JSFunctionType> typedSignatures, JSFunctionType functionItem, JSTypeSubstitutor typeSubstitutor) {
        String typedSignature = JSParameterInfoHandlerKt.access$buildSignature(functionItem, typeSubstitutor).getText();
        if (!typedSignatures.containsKey(typedSignature)) {
            typedSignatures.put(typedSignature, functionItem);
        }
    }

    private final Collection<PsiElement> getResolvedPsiElements(JSExpression methodExpression) {
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] resolveResultArray = ((JSReferenceExpression)methodExpression).multiResolve(true);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult[] resolveResults = resolveResultArray;
            if (resolveResults.length == 0) {
                return CollectionsKt.emptyList();
            }
            List<PsiElement> list = JSResolveResult.toElements(resolveResults, false);
            Intrinsics.checkNotNullExpressionValue(list, (String)"toElements(...)");
            return list;
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            String value;
            List elements = new ArrayList();
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)methodExpression).getIndexExpression();
            Object propertyName = null;
            if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
                propertyName = value;
            }
            if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
                JSExpression jSExpression = indexExpression;
                Intrinsics.checkNotNull((Object)jSExpression);
                propertyName = "[" + jSExpression.getText() + "]";
            }
            if (propertyName != null) {
                JSType qualifierType = JSResolveUtil.getExpressionJSType(((JSIndexedPropertyAccessExpression)methodExpression).getQualifier());
                if ((qualifierType = JSTypeUtils.getValuableType(qualifierType, (PsiElement)methodExpression)) != null) {
                    JSRecordType jSRecordType = qualifierType.asRecordType();
                    Intrinsics.checkNotNullExpressionValue((Object)jSRecordType, (String)"asRecordType(...)");
                    JSRecordType recordType = jSRecordType;
                    JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature((String)propertyName);
                    if (propertySignature != null) {
                        JSRecordType.MemberSource memberSource = propertySignature.getMemberSource();
                        Intrinsics.checkNotNullExpressionValue((Object)memberSource, (String)"getMemberSource(...)");
                        JSRecordType.MemberSource source = memberSource;
                        if (!source.isUnion()) {
                            List<PsiElement> list = source.getAllSourceElements();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSourceElements(...)");
                            elements.addAll((Collection)list);
                        } else if (propertySignature instanceof JSCompositeFunctionPropertySignatureImpl) {
                            for (JSRecordType.PropertySignature part : ((JSCompositeFunctionPropertySignatureImpl)propertySignature).getMembers()) {
                                source = part.getMemberSource();
                                if (source.isUnion()) continue;
                                List<PsiElement> list = source.getAllSourceElements();
                                Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSourceElements(...)");
                                elements.addAll((Collection)list);
                            }
                        }
                    }
                }
            }
            return elements;
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    private final Sequence<JSFunctionType> deduplicateSignatures(List<? extends JSFunctionItem> items, JSTypeSubstitutor typeSubstitutor) {
        Map typedSignatures = new LinkedHashMap(items.size());
        for (JSFunctionItem jSFunctionItem : items) {
            JSFunctionType functionType = JSParameterInfoHandlerKt.mapToFunction(jSFunctionItem, typeSubstitutor);
            this.doAddSignature(typedSignatures, functionType, typeSubstitutor);
        }
        return CollectionsKt.asSequence((Iterable)typedSignatures.values());
    }

    private final List<JSFunctionItem> getFunctionItems(JSExpression methodExpression, Collection<? extends PsiElement> elements) {
        List items = new LinkedList();
        for (PsiElement psiElement : elements) {
            Collection<JSFunctionItem> functionItems;
            PsiElement element2 = psiElement;
            if (element2 instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element2 = ((TypeScriptProxyImplicitElementWithBackingItem)element2).getBackingElement();
            }
            if ((functionItems = this.getFunctionItems(methodExpression, element2)).isEmpty()) continue;
            items.addAll(functionItems);
        }
        if (items.size() == 0) {
            items = JSParameterInfoHandlerKt.access$getImplicitFunctions(methodExpression);
        }
        return items;
    }

    private final JSTypeSubstitutor getTypeSubstitutor(JSExpression methodExpression, JSExpression qualifier, List<? extends JSFunctionItem> items) {
        JSNamespace namespace;
        JSType qualifierType;
        JSFunctionItem firstFunction = (JSFunctionItem)CollectionsKt.firstOrNull(items);
        if (firstFunction instanceof TypeScriptFunction) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(firstFunction, (PsiElement)methodExpression);
            Intrinsics.checkNotNullExpressionValue((Object)jSTypeSubstitutor, (String)"getTypeSubstitutorForMember(...)");
            return jSTypeSubstitutor;
        }
        if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, false)) != null) {
            Object object = ObjectUtils.coalesce((Object)JSTypeWithOuterGenerics.getGenericArguments(namespace), (Object)JSTypeSubstitutor.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
            return (JSTypeSubstitutor)object;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeSubstitutor, (String)"EMPTY");
        return jSTypeSubstitutor;
    }

    private final Collection<PsiElement> getElementsWithConstructors(JSCallLikeExpression parent, Collection<? extends PsiElement> elements) {
        Collection elements2 = elements;
        JSExpression methodExpression = parent.getMethodExpression();
        if (methodExpression == null) {
            return elements2;
        }
        if (parent instanceof JSNewExpression) {
            List newElements2 = new ArrayList(elements2.size());
            for (PsiElement element : elements2) {
                if (element instanceof JSClass) {
                    ResolveResult[] constructorResults;
                    Intrinsics.checkNotNullExpressionValue((Object)JSClassUtils.resolveES6Constructor((JSClass)element, methodExpression), (String)"resolveES6Constructor(...)");
                    for (ResolveResult result2 : constructorResults) {
                        PsiElement resultConstructor = result2.getElement();
                        if (resultConstructor == null) continue;
                        newElements2.add(resultConstructor);
                    }
                    continue;
                }
                newElements2.add(element);
            }
            elements2 = newElements2;
        }
        return elements2;
    }

    private final Collection<JSFunctionItem> getFunctionItems(JSExpression methodExpression, PsiElement element) {
        JSFunctionItem functionItem = this.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
        if (functionItem instanceof TypeScriptFunction) {
            Collection<JSFunctionItem> collection = TypeScriptPsiUtil.getAllOverloadSignatures(functionItem);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllOverloadSignatures(...)");
            return collection;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)functionItem);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createMaybeSingletonList(...)");
        return list;
    }

    @Nullable
    public final JSFunctionItem calculatePossibleFunctionCarefully(@NotNull PsiElement resolveResult, @Nullable PsiElement methodExpression) {
        PsiElement module;
        Intrinsics.checkNotNullParameter((Object)resolveResult, (String)"resolveResult");
        PsiElement resolveResult2 = resolveResult;
        if (resolveResult2 instanceof JSParameter && (module = JSAmdPsiUtil.findReferencedModule((JSParameter)resolveResult2)) != null) {
            resolveResult2 = module;
        }
        return JSPsiImplUtils.calculatePossibleFunction(resolveResult2, methodExpression, false);
    }

    private static final JSSignaturePresentation findElementForParameterInfo$lambda$0(JSFunctionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return JSParameterInfoHandlerKt.buildSignaturePresentation(type);
    }

    private static final JSFunctionType fillSignaturesForArgumentList$lambda$1(JSFunctionItem c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return JSParameterInfoHandlerKt.mapToFunction(c, JSTypeSubstitutor.EMPTY);
    }

    private static final JSFunctionType fillSignaturesForArgumentList$lambda$2(JSFunctionWithSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        return JSParameterInfoHandlerKt.access$mapToFunction(substitutor);
    }

    private static final JSFunctionType fillSignaturesForArgumentList$lambda$3(JSFunctionExpression el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        return JSParameterInfoHandlerKt.mapToFunction(el, JSTypeSubstitutor.EMPTY);
    }
}

