/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryDirectory;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesModelSynchronizer;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.JsEntityHelperKt;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesDirectoryExcludeEntity;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesDirectoryLibraryEntity;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesEntityUtil;
import com.intellij.javascript.nodejs.library.yarn.pnp.workspaceModel.YarnPnpEntityHelperKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0003JP\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014\"\u0010\b\u0001\u0010\u0015*\n\u0012\u0006\b\u0001\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J>\u0010$\u001a\u00020\u001c\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H%0)H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001eH\u0002JD\u0010,\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesModelSynchronizer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "directoryManager", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "MAX_ATTEMPTS", "", "sync", "", "attemptNo", "status", "", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "M", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "type", "current", "", "new", "upToDate", "", "buildActualExcludeEntities", "", "Lcom/intellij/javascript/nodejs/library/node_modules/workspaceModel/NodeModulesDirectoryExcludeEntity$Builder;", "directories", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory;", "buildActualLibraryEntities", "Lcom/intellij/javascript/nodejs/library/node_modules/workspaceModel/NodeModulesDirectoryLibraryEntity$Builder;", "areEntitiesEqual", "W", "entities1", "entities2", "transformToEntityWrapperWithEqualsAndHashcode", "Lkotlin/Function1;", "getWorkspaceModelLibraryEntities", "Lcom/intellij/javascript/nodejs/library/node_modules/workspaceModel/NodeModulesDirectoryLibraryEntity;", "updateEntities", "actualExcludeEntities", "actualLibraryEntities", "description", "initialModCount", "", "startNano", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeModulesDirectoryStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesDirectoryStartupActivity.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesModelSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n1557#2:197\n1628#2,3:198\n774#2:201\n865#2,2:202\n1557#2:204\n1628#2,3:205\n1628#2,3:208\n1628#2,3:211\n*S KotlinDebug\n*F\n+ 1 NodeModulesDirectoryStartupActivity.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesModelSynchronizer\n*L\n60#1:194\n60#1:195,2\n90#1:197\n90#1:198,3\n96#1:201\n96#1:202,2\n96#1:204\n96#1:205,3\n107#1:208,3\n108#1:211,3\n*E\n"})
final class NodeModulesModelSynchronizer {
    @NotNull
    private final Project project;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final NodeModulesDirectoryManager directoryManager;
    @NotNull
    private final VirtualFileUrlManager virtualFileUrlManager;
    private final int MAX_ATTEMPTS;

    public NodeModulesModelSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        NodeModulesDirectoryManager nodeModulesDirectoryManager = NodeModulesDirectoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeModulesDirectoryManager, (String)"getInstance(...)");
        this.directoryManager = nodeModulesDirectoryManager;
        this.virtualFileUrlManager = this.workspaceModel.getVirtualFileUrlManager();
        this.MAX_ATTEMPTS = 10;
    }

    public final void sync() {
        this.sync(0);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    private final void sync(int attemptNo) {
        void $this$filterTo$iv$iv;
        if (attemptNo > this.MAX_ATTEMPTS) {
            NodeModulesDirectoryManager.LOG.info(this.MAX_ATTEMPTS + " sync attempts failed, aborting");
            return;
        }
        if (this.project.isDisposed()) {
            return;
        }
        long initialModCount = this.directoryManager.getNodeModulesDirChangeTracker().getModificationCount();
        long startNano = System.nanoTime();
        List<NodeModulesLibraryDirectory> list = this.directoryManager.buildNodeModulesDirectories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"buildNodeModulesDirectories(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodeModulesLibraryDirectory it = (NodeModulesLibraryDirectory)element$iv$iv;
            boolean bl = false;
            if (!(!it.isForApplicationSourceCode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List directories = (List)destination$iv$iv;
        List<NodeModulesDirectoryExcludeEntity.Builder> actualExcludeEntities = this.buildActualExcludeEntities(directories);
        List<NodeModulesDirectoryExcludeEntity> workspaceModelExcludeEntities = JsEntityHelperKt.getWorkspaceModelExcludeEntities(this.workspaceModel);
        boolean excludeEntitiesUpToDate2 = this.areEntitiesEqual(actualExcludeEntities, workspaceModelExcludeEntities, sync.excludeEntitiesUpToDate.1.INSTANCE);
        List<NodeModulesDirectoryLibraryEntity.Builder> actualLibraryEntities = this.buildActualLibraryEntities(directories);
        List<NodeModulesDirectoryLibraryEntity> workspaceModelLibraryEntities = this.getWorkspaceModelLibraryEntities();
        boolean libraryEntitiesUpToDate2 = this.areEntitiesEqual(actualLibraryEntities, workspaceModelLibraryEntities, sync.libraryEntitiesUpToDate.1.INSTANCE);
        if (!excludeEntitiesUpToDate2 || !libraryEntitiesUpToDate2) {
            String description = this.status("node_modules exclude", (Collection)workspaceModelExcludeEntities, (Collection)actualExcludeEntities, excludeEntitiesUpToDate2) + ", " + this.status("node_modules library", (Collection)workspaceModelLibraryEntities, (Collection)actualLibraryEntities, libraryEntitiesUpToDate2);
            this.updateEntities(attemptNo, actualExcludeEntities, actualLibraryEntities, description, initialModCount, startNano);
        } else if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
            NodeModulesDirectoryManager.LOG.debug("node_modules entities are up-to-date: " + actualExcludeEntities.size() + " excludes, " + actualLibraryEntities.size() + " libraries, done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
        }
    }

    private final <E extends WorkspaceEntity, M extends WorkspaceEntity.Builder<? extends E>> String status(String type, Collection<? extends E> current, Collection<? extends M> collection, boolean upToDate) {
        return type + ": {current=" + current.size() + ", new=" + collection.size() + ", " + (upToDate ? "up-to-date" : "outdated") + "}";
    }

    /*
     * WARNING - void declaration
     */
    private final List<NodeModulesDirectoryExcludeEntity.Builder> buildActualExcludeEntities(List<NodeModulesLibraryDirectory> directories) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = directories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NodeModulesLibraryDirectory nodeModulesLibraryDirectory = (NodeModulesLibraryDirectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it.getNodeModulesDir();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNodeModulesDir(...)");
            collection.add(JsEntityHelperKt.createNodeModulesExcludeEntity(virtualFile, this.virtualFileUrlManager));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NodeModulesDirectoryLibraryEntity.Builder> buildActualLibraryEntities(List<NodeModulesLibraryDirectory> directories) {
        void $this$mapTo$iv$iv;
        NodeModulesLibraryDirectory it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = directories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NodeModulesLibraryDirectory)element$iv$iv;
            boolean bl = false;
            if (!this.directoryManager.isLibraryWithMappings(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (NodeModulesLibraryDirectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SyntheticLibrary syntheticLibrary = it.getLibrary();
            Intrinsics.checkNotNullExpressionValue((Object)syntheticLibrary, (String)"getLibrary(...)");
            collection.add(JsEntityHelperKt.createNodeModulesLibraryEntity(it, syntheticLibrary, this.virtualFileUrlManager));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <W> boolean areEntitiesEqual(List<? extends Object> entities1, List<? extends Object> entities2, Function1<Object, ? extends W> transformToEntityWrapperWithEqualsAndHashcode) {
        void $this$mapTo$iv;
        void $this$mapTo$iv2;
        if (entities1.size() != entities2.size()) {
            return false;
        }
        Iterable iterable = entities1;
        Iterable destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            destination$iv.add(transformToEntityWrapperWithEqualsAndHashcode.invoke(item$iv));
        }
        HashSet wrappers1 = (HashSet)destination$iv;
        destination$iv = entities2;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            destination$iv2.add(transformToEntityWrapperWithEqualsAndHashcode.invoke(item$iv));
        }
        HashSet wrappers2 = (HashSet)destination$iv2;
        return Intrinsics.areEqual((Object)wrappers1, (Object)wrappers2);
    }

    private final List<NodeModulesDirectoryLibraryEntity> getWorkspaceModelLibraryEntities() {
        return SequencesKt.toList((Sequence)this.workspaceModel.getCurrentSnapshot().entities(NodeModulesDirectoryLibraryEntity.class));
    }

    private final void updateEntities(int attemptNo, List<? extends NodeModulesDirectoryExcludeEntity.Builder> actualExcludeEntities, List<? extends NodeModulesDirectoryLibraryEntity.Builder> actualLibraryEntities, String description, long initialModCount, long startNano) {
        MutableEntityStorage excludeEntitiesStorage = YarnPnpEntityHelperKt.createStorageFrom(actualExcludeEntities);
        MutableEntityStorage libraryEntitiesStorage = YarnPnpEntityHelperKt.createStorageFrom(actualLibraryEntities);
        NodeModulesEntityUtil.INSTANCE.invokeUnderWriteAction(this.project, () -> NodeModulesModelSynchronizer.updateEntities$lambda$8(this, description, initialModCount, excludeEntitiesStorage, libraryEntitiesStorage, startNano, actualExcludeEntities, actualLibraryEntities, attemptNo));
    }

    private static final boolean updateEntities$lambda$8$lambda$7$lambda$4(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == NodeModulesDirectoryExcludeEntity.ExcludeEntitySource.INSTANCE;
    }

    private static final boolean updateEntities$lambda$8$lambda$7$lambda$5(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == NodeModulesDirectoryLibraryEntity.LibraryEntitySource.INSTANCE;
    }

    private static final void updateEntities$lambda$8$lambda$7$lambda$6(NodeModulesModelSynchronizer this$0, int $attemptNo) {
        this$0.sync($attemptNo + 1);
    }

    private static final Unit updateEntities$lambda$8$lambda$7(NodeModulesModelSynchronizer this$0, long $initialModCount, MutableEntityStorage $excludeEntitiesStorage, MutableEntityStorage $libraryEntitiesStorage, long $startNano, List $actualExcludeEntities, List $actualLibraryEntities, int $attemptNo, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (this$0.directoryManager.getNodeModulesDirChangeTracker().getModificationCount() == $initialModCount) {
            storage.replaceBySource(NodeModulesModelSynchronizer::updateEntities$lambda$8$lambda$7$lambda$4, (EntityStorage)$excludeEntitiesStorage);
            storage.replaceBySource(NodeModulesModelSynchronizer::updateEntities$lambda$8$lambda$7$lambda$5, (EntityStorage)$libraryEntitiesStorage);
            NodeModulesDirectoryManager.LOG.info("node_modules entities synchronized in " + TimeoutUtil.getDurationMillis((long)$startNano) + " ms, " + $actualExcludeEntities.size() + " excludes, " + $actualLibraryEntities.size() + " libraries");
        } else {
            NodeModulesDirectoryManager.LOG.info("attempt#" + $attemptNo + ": sync failed (initialModCount: " + $initialModCount + ", currentModCount: " + this$0.directoryManager.getNodeModulesDirChangeTracker().getModificationCount() + "), re-scheduling node_modules entities sync");
            ApplicationManager.getApplication().executeOnPooledThread(() -> NodeModulesModelSynchronizer.updateEntities$lambda$8$lambda$7$lambda$6(this$0, $attemptNo));
        }
        return Unit.INSTANCE;
    }

    private static final void updateEntities$lambda$8(NodeModulesModelSynchronizer this$0, String $description, long $initialModCount, MutableEntityStorage $excludeEntitiesStorage, MutableEntityStorage $libraryEntitiesStorage, long $startNano, List $actualExcludeEntities, List $actualLibraryEntities, int $attemptNo) {
        this$0.workspaceModel.updateProjectModel($description, arg_0 -> NodeModulesModelSynchronizer.updateEntities$lambda$8$lambda$7(this$0, $initialModCount, $excludeEntitiesStorage, $libraryEntitiesStorage, $startNano, $actualExcludeEntities, $actualLibraryEntities, $attemptNo, arg_0));
    }
}

