/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfig;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSPathSubstitution;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFrameworkMarkersIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSConfigFinder {
    public static final String BASE_URL = "baseURL";
    public static final String PATHS = "paths";
    public static final String MAPPINGS = "map";
    private static final Key<ParameterizedCachedValue<SystemJSConfig, Collection<JSObjectLiteralExpression>>> CACHED_VALUE_KEY = Key.create((String)"TypeScript.System.JS");
    private static final ParameterizedCachedValueProvider<SystemJSConfig, Collection<JSObjectLiteralExpression>> CACHED_VALUE_PROVIDER = expressions -> {
        SystemJSConfig config = SystemJSConfigFinder.parseConfigImpl(expressions);
        return CachedValueProvider.Result.create((Object)config, (Collection)expressions);
    };

    public Collection<SystemJSConfig> getConfigs(@NotNull PsiElement context2) {
        if (context2 == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(0);
        }
        return this.getConfigsImpl(context2);
    }

    protected Collection<SystemJSConfig> getConfigsImpl(@NotNull PsiElement context2) {
        if (context2 == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)context2.getProject())) {
            return ContainerUtil.emptyList();
        }
        Collection<JSObjectLiteralExpression> literals = SystemJSConfigFinder.getConfigLiterals(context2);
        if (literals.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        MultiMap map2 = MultiMap.createLinkedSet();
        literals.forEach(it -> map2.putValue((Object)it.getContainingFile(), it));
        return map2.entrySet().stream().map(entry -> SystemJSConfigFinder.parseConfig((PsiElement)entry.getKey(), (Collection)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static Collection<JSObjectLiteralExpression> getConfigLiterals(@NotNull PsiElement context2) {
        if (context2 == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(2);
        }
        Collection<JSObjectLiteralExpression> elements = JSFrameworkMarkersIndex.getElements("System.config", JSObjectLiteralExpression.class, context2.getProject(), JSResolveUtil.getResolveScope(context2));
        List list = ContainerUtil.filter(elements, el -> {
            VirtualFile configFile = PsiUtilCore.getVirtualFile((PsiElement)el);
            return configFile != null && !JSLibraryUtil.isProbableLibraryFile(configFile);
        });
        if (list == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static SystemJSConfig parseConfig(PsiElement context2, @NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(4);
        }
        return (SystemJSConfig)CachedValuesManager.getManager((Project)context2.getProject()).getParameterizedCachedValue((UserDataHolder)context2, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, expressions);
    }

    @Nullable
    private static SystemJSConfig parseConfigImpl(@NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(5);
        }
        VirtualFile file = null;
        VirtualFile configFile = null;
        for (JSObjectLiteralExpression expression : expressions) {
            configFile = PsiUtilCore.getVirtualFile((PsiElement)expression);
            if (configFile == null) continue;
            String url = SystemJSConfigFinder.getBaseURL(expression);
            if (url != null) {
                file = SystemJSConfigFinder.getBaseURLFile(configFile.getParent(), url);
                break;
            }
            if (file != null) continue;
            file = SystemJSConfigFinder.getBaseURLFile(configFile.getParent(), null);
        }
        if (file == null || configFile == null) {
            return null;
        }
        final VirtualFile virtualFile = file;
        final VirtualFile virtualConfigFile = configFile;
        final JSModulePathMappings<SystemJSPathSubstitution> substitutions = SystemJSConfigFinder.getAllSubstitutions(expressions);
        if (substitutions.isEmpty()) {
            return null;
        }
        return new SystemJSConfig(){

            @Override
            @NotNull
            public VirtualFile getBaseURL() {
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFile2;
            }

            @Override
            @NotNull
            public VirtualFile rootDirectory() {
                VirtualFile virtualFile2 = virtualConfigFile.getParent();
                if (virtualFile2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return virtualFile2;
            }

            @Override
            public JSModulePathMappings<SystemJSPathSubstitution> getMappings() {
                return substitutions;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBaseURL";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "rootDirectory";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static Collection<SystemJSPathSubstitution> getPathsSubstitutions(@NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(6);
        }
        HashMap<String, String> rawPaths = null;
        for (JSObjectLiteralExpression expression : expressions) {
            Map<String, String> values = SystemJSConfigFinder.getValues(expression, PATHS);
            if (values == null) continue;
            if (rawPaths == null) {
                rawPaths = new HashMap<String, String>();
            }
            rawPaths.putAll(values);
        }
        return SystemJSConfigFinder.convertToSubstitutions(rawPaths, SystemJSPathSubstitution.SystemJSPathSubstitutionType.PATH);
    }

    private static JSModulePathMappings<SystemJSPathSubstitution> getAllSubstitutions(@NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(7);
        }
        ArrayList<SystemJSPathSubstitution> result2 = null;
        JSModulePathMappings<SystemJSPathSubstitution> paths = JSModulePathMappings.build(SystemJSConfigFinder.getPathsSubstitutions(expressions));
        for (JSObjectLiteralExpression expression : expressions) {
            Collection<SystemJSPathSubstitution> substitutions = SystemJSConfigFinder.getAllSubstitutions(paths, expression);
            if (substitutions.isEmpty()) continue;
            if (result2 == null) {
                result2 = new ArrayList<SystemJSPathSubstitution>();
            }
            result2.addAll(substitutions);
        }
        if (result2 == null) {
            return paths;
        }
        result2.addAll(paths.getSubstitutions());
        return JSModulePathMappings.build(result2);
    }

    private static Collection<SystemJSPathSubstitution> getAllSubstitutions(JSModulePathMappings<SystemJSPathSubstitution> paths, @NotNull JSObjectLiteralExpression expression) {
        Collection<SystemJSPathSubstitution> mappings;
        if (expression == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(8);
        }
        Map<String, String> rawMappings = SystemJSConfigFinder.getValues(expression, MAPPINGS);
        if (paths.isEmpty() || rawMappings == null) {
            mappings = SystemJSConfigFinder.convertToSubstitutions(rawMappings, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP);
        } else {
            mappings = new ArrayList<SystemJSPathSubstitution>();
            for (Map.Entry<String, String> entry : rawMappings.entrySet()) {
                String pattern = entry.getKey();
                String mapping = entry.getValue();
                Pair<SystemJSPathSubstitution, String> matchedElement = paths.findMaxElementByPaths(mapping);
                if (matchedElement == null) {
                    mappings.add(new SystemJSPathSubstitution(pattern, mapping, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP));
                    continue;
                }
                String newMapping = SystemJSConfigFinder.getSubstitutedString(mapping, matchedElement);
                mappings.add(new SystemJSPathSubstitution(pattern, newMapping, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP));
            }
        }
        return mappings;
    }

    private static String getSubstitutedString(String stringToProcess, Pair<? extends SystemJSPathSubstitution, String> matchedElement) {
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = StringUtil.nullize((String)((String)matchedElement.getSecond()));
        String pattern = matchedPattern.getPattern();
        String patternExact = matchedStar != null ? pattern.replace("*", matchedStar) : pattern;
        String replaceBy = (String)ContainerUtil.getFirstItem(matchedPattern.getMappings());
        assert (replaceBy != null);
        String replaceByExact = matchedStar != null ? replaceBy.replace("*", matchedStar) : replaceBy;
        return stringToProcess.replace(patternExact, replaceByExact);
    }

    @NotNull
    private static VirtualFile getBaseURLFile(VirtualFile file, @Nullable String baseURL) {
        assert (file != null);
        if (baseURL == null || "/".equals(baseURL) || ".".equals(baseURL)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                SystemJSConfigFinder.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        VirtualFile url = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(file, baseURL);
        VirtualFile virtualFile = url == null ? file : url;
        if (virtualFile == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @Nullable
    private static String getBaseURL(@NotNull JSObjectLiteralExpression expression) {
        JSProperty property;
        if (expression == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(11);
        }
        if ((property = expression.findProperty(BASE_URL)) == null) {
            return null;
        }
        return SystemJSConfigFinder.getPropertyValueAsString(property);
    }

    @Nullable
    private static String getPropertyValueAsString(JSProperty property) {
        JSLiteralExpression expression = property.getLiteralExpressionInitializer();
        if (expression == null) {
            return null;
        }
        String significantValue = expression.getSignificantValue();
        return significantValue == null ? null : StringUtil.unquoteString((String)significantValue);
    }

    @Nullable
    private static Map<String, String> getValues(@NotNull JSObjectLiteralExpression expression, String propertyName) {
        JSProperty paths;
        if (expression == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(12);
        }
        if ((paths = expression.findProperty(propertyName)) == null) {
            return null;
        }
        JSObjectLiteralExpression pathsExpression = paths.getObjectLiteralExpressionInitializer();
        if (pathsExpression == null) {
            return null;
        }
        JSProperty[] properties = pathsExpression.getProperties();
        if (properties.length == 0) {
            return null;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (JSProperty property : properties) {
            String name = property.getName();
            String value = SystemJSConfigFinder.getPropertyValueAsString(property);
            if (StringUtil.isEmptyOrSpaces((String)name) || StringUtil.isEmptyOrSpaces((String)value)) continue;
            result2.put(name, value);
        }
        return result2;
    }

    @NotNull
    private static Collection<SystemJSPathSubstitution> convertToSubstitutions(@Nullable Map<String, String> elements, @NotNull SystemJSPathSubstitution.SystemJSPathSubstitutionType type) {
        if (type == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(13);
        }
        if (elements == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SystemJSConfigFinder.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = ContainerUtil.map(elements.entrySet(), el -> new SystemJSPathSubstitution((String)el.getKey(), (String)el.getValue(), type));
        if (list == null) {
            SystemJSConfigFinder.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigLiterals";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseURLFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToSubstitutions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigs";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfigLiterals";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathsSubstitutions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllSubstitutions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBaseURL";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertToSubstitutions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10, 14, 15 -> new IllegalStateException(string);
        };
    }
}

