/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.navigation.JSDeclarationEvaluator;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.typescript.TypeScriptTargetSorter;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement place, int offset, Editor editor) {
        if (place == null) {
            return null;
        }
        IElementType elementType = place.getNode().getElementType();
        if (elementType instanceof JSElementType && (elementType == JSTokenTypes.BREAK_KEYWORD || elementType == JSTokenTypes.CONTINUE_KEYWORD)) {
            PsiElement[] psiElementArray;
            PsiElement target = JSGotoDeclarationHandler.getBreakOrContinueGotoDeclarationTargets(place.getParent());
            if (target != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = target;
            } else {
                psiElementArray = null;
            }
            return psiElementArray;
        }
        if (DialectDetector.isActionScript(place)) {
            return null;
        }
        PsiElement[] amdModules = JSGotoDeclarationHandler.findAmdModulesFromParameter(place);
        if (amdModules != null) {
            return amdModules;
        }
        if (JSGotoDeclarationHandler.hasReferencedSymbolNavigationTargets(place, offset)) {
            return null;
        }
        PsiElement[] resolveFromLiteral = JSGotoDeclarationHandler.resolveQualifiedNameFromJSLiteral(place, offset);
        if (resolveFromLiteral != null) {
            return resolveFromLiteral;
        }
        Collection<PsiElement> elements = JSGotoDeclarationHandler.getGotoDeclarationTargetsImpl(place);
        if (elements != null && elements.size() == 1 && (amdModules = JSGotoDeclarationHandler.findAmdModulesFromParameter((PsiElement)ContainerUtil.getFirstItem(elements))) != null) {
            return amdModules;
        }
        return elements != null ? elements.toArray(PsiElement.EMPTY_ARRAY) : null;
    }

    private static boolean hasReferencedSymbolNavigationTargets(@NotNull PsiElement place, int offset) {
        if (place == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        return StreamEx.of((Collection)ReferencesKt.referencesAt((PsiFile)place.getContainingFile(), (int)offset)).flatCollection(it -> it.resolveReference()).anyMatch(it -> !SymbolNavigationService.getInstance().getNavigationTargets(place.getProject(), it).isEmpty());
    }

    @Nullable
    private static PsiElement getBreakOrContinueGotoDeclarationTargets(@NotNull PsiElement breakOrContinue) {
        JSStatement loop;
        if (breakOrContinue == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(1);
        }
        if ((loop = JSPsiImplUtils.getBreakOrContinueTarget(breakOrContinue)) == null) {
            return null;
        }
        if (breakOrContinue instanceof JSContinueStatement) {
            return (PsiElement)Objects.requireNonNullElse(loop instanceof JSConditionOwner ? ((JSConditionOwner)((Object)loop)).getCondition() : null, loop);
        }
        if (breakOrContinue instanceof JSBreakStatement) {
            return JSGotoDeclarationHandler.getNextStatementOrSibling((JSStatement)breakOrContinue, loop);
        }
        return null;
    }

    @Nullable
    private static PsiElement getNextStatementOrSibling(@NotNull JSStatement statement, @NotNull JSStatement loop) {
        Instruction instruction;
        if (statement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(2);
        }
        if (loop == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(3);
        }
        if ((instruction = JSControlFlowService.getInstruction(statement)) != null) {
            Collection allSucc = instruction.allSucc();
            return allSucc.size() == 1 ? ((Instruction)allSucc.iterator().next()).getElement() : null;
        }
        JSStatement parent = loop;
        while (parent instanceof JSStatement) {
            PsiElement nextSibling = parent.getNextSibling();
            if (nextSibling != null) {
                return nextSibling;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    private static Collection<PsiElement> getGotoDeclarationTargetsImpl(@NotNull PsiElement sourceElement) {
        ASTNode node;
        if (sourceElement == null) {
            JSGotoDeclarationHandler.$$$reportNull$$$0(4);
        }
        if ((node = sourceElement.getNode()) == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent == null) {
            return null;
        }
        List<PsiElement> declarations = null;
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            declarations = JSDeclarationEvaluator.GO_TO_DECLARATION.getDeclarations(importedBinding);
        } else if (parent instanceof JSPsiReferenceElement) {
            JSPsiReferenceElement referenceElement = (JSPsiReferenceElement)parent;
            declarations = JSDeclarationEvaluator.GO_TO_DECLARATION.getDeclarations(referenceElement);
        }
        return declarations != null ? TypeScriptTargetSorter.toSorted(declarations) : null;
    }

    private static PsiElement @Nullable [] resolveQualifiedNameFromJSLiteral(@Nullable PsiElement sourceElement, int offset) {
        if (!(sourceElement instanceof LeafPsiElement) || ((LeafPsiElement)sourceElement).getElementType() != JSTokenTypes.STRING_LITERAL || !sourceElement.textContains('.')) {
            return null;
        }
        PsiElement literal = sourceElement.getParent();
        if (!(literal instanceof JSLiteralExpression)) {
            return null;
        }
        int offsetInLiteral = offset - literal.getTextRange().getStartOffset();
        PsiReference reference = literal.findReferenceAt(offsetInLiteral);
        if (reference instanceof JSLiteralTextReference) {
            ResolveResult[] results;
            List<PsiElement> elements;
            TextRange rangeInLiteral = reference.getRangeInElement();
            String referenceText = rangeInLiteral.substring(literal.getText());
            int offsetInReferenceText = offsetInLiteral - rangeInLiteral.getStartOffset();
            Object qualifiedName = null;
            int componentStart = 0;
            while (componentStart < referenceText.length()) {
                String component;
                int nextDotOffset = referenceText.indexOf(46, componentStart);
                if (nextDotOffset == -1) {
                    nextDotOffset = referenceText.length();
                }
                if (!BasicJavascriptNamesValidator.isIdentifierName(component = referenceText.substring(componentStart, nextDotOffset))) {
                    return null;
                }
                if (componentStart <= offsetInReferenceText) {
                    qualifiedName = JSQualifiedNameImpl.create(component, (JSQualifiedName)qualifiedName);
                }
                componentStart = nextDotOffset + 1;
            }
            if (qualifiedName != null && !qualifiedName.equals(((JSTextReference)reference).getQualifiedName()) && !(elements = JSResolveResult.toElements(results = ((JSTextReference)reference).doResolveQualifiedName((JSQualifiedName)qualifiedName, false))).isEmpty()) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return null;
    }

    private static PsiElement @Nullable [] findAmdModulesFromParameter(@Nullable PsiElement sourceElement) {
        if (sourceElement instanceof LeafPsiElement && JSKeywordSets.IDENTIFIER_NAMES.contains(((LeafPsiElement)sourceElement).getElementType())) {
            sourceElement = sourceElement.getParent();
        }
        if (!(sourceElement instanceof JSParameter)) {
            return null;
        }
        JSLiteralExpression parameterInitialization = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)sourceElement);
        if (parameterInitialization == null) {
            return null;
        }
        Collection<PsiElement> elements = JSFileReferencesUtil.resolveModuleReferences((PsiElement)parameterInitialization);
        return elements.isEmpty() ? null : elements.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakOrContinue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/navigation/JSGotoDeclarationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReferencedSymbolNavigationTargets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBreakOrContinueGotoDeclarationTargets";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextStatementOrSibling";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGotoDeclarationTargetsImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

