/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface JSRecordType
extends JSType {
    public static final String PRIVATE_NAME_DEPTH_SEPARATOR = "~";

    @NotNull
    public List<TypeMember> getTypeMembers();

    public boolean hasProperty(@NotNull String var1);

    @Nullable
    public PropertySignature findPropertySignature(@NotNull String var1);

    @Nullable
    default public PropertySignature findComputedPropertySignatureByKeyType(@NotNull JSType jsType) {
        if (jsType == null) {
            JSRecordType.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public PropertySignature findPrivatePropertySignature(@NotNull String var1, int var2);

    @Deprecated
    @Nullable
    public IndexSignature findIndexer(@NotNull IndexSignatureKind var1);

    @Nullable
    public IndexSignature findIndexer(@NotNull Class<? extends JSType> var1);

    @NotNull
    public List<IndexSignature> getIndexSignatures();

    @NotNull
    public List<CallSignature> getCallSignatures();

    @NotNull
    public @Unmodifiable Set<String> getPropertyNames();

    @NotNull
    public Collection<PropertySignature> getProperties();

    public boolean hasMembers();

    public boolean hasProperties();

    public boolean hasIndexers();

    public boolean isWeak();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsType", "com/intellij/lang/javascript/psi/JSRecordType", "findComputedPropertySignatureByKeyType"));
    }

    public static interface IndexSignature
    extends TypeMember {
        @NotNull
        public JSType getMemberParameterType();

        @NotNull
        public JSType getMemberType();

        @Override
        @NotNull
        public IndexSignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> var1);

        default public boolean isForComputedProperty() {
            return false;
        }
    }

    @Deprecated
    public static enum IndexSignatureKind {
        STRING,
        NUMERIC,
        UNKNOWN;

    }

    public static interface CallSignature
    extends TypeMember {
        public boolean hasNew();

        @Override
        @Nullable
        default public JSType getKeyType() {
            return null;
        }

        @NotNull
        public JSFunctionType getFunctionType();

        @Override
        @NotNull
        public CallSignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> var1);

        @NotNull
        default public List<JSParameterTypeDecorator> getParameterTypeDecorators() {
            List<JSParameterTypeDecorator> list = this.getFunctionType().getParameters();
            if (list == null) {
                CallSignature.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        default public JSType getReturnType() {
            return this.getFunctionType().getReturnType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSRecordType$CallSignature", "getParameterTypeDecorators"));
        }
    }

    public static interface PropertySignature
    extends TypeMember,
    JSTypeOwner,
    JSConstStatusOwner {
        public static final Map<String, PropertySignature> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());

        @NotNull
        public String getMemberName();

        default public boolean isPrivateName() {
            return false;
        }

        default public int getPrivateNameDepth() {
            return -1;
        }

        default public boolean hasValidName() {
            return true;
        }

        @Override
        @NotNull
        public PropertySignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> var1);

        public boolean isOptional();

        @Nullable
        default public JSType getJSTypeWithOptionality() {
            return this.getJSType();
        }

        @Nullable
        default public JSType getSetterJSType() {
            return this.getJSType();
        }

        @NotNull
        default public JSAttributeList.AccessType getAccessType() {
            JSAttributeList.AccessType accessType = this.isPrivateName() ? JSAttributeList.AccessType.PRIVATE : JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                PropertySignature.$$$reportNull$$$0(0);
            }
            return accessType;
        }

        default public boolean isNumericKey() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSRecordType$PropertySignature", "getAccessType"));
        }
    }

    public static interface ComputedMember
    extends TypeMember {
        @NotNull
        public String getNameRef();

        @Nullable
        public JSType getTypeForComputedName();
    }

    public static interface FunctionMember
    extends TypeMember {
    }

    public static interface TypeMember {
        @Nullable
        public JSType getKeyType();

        @Contract(pure=true)
        public boolean isEquivalentTo(@Nullable TypeMember var1, @Nullable ProcessingContext var2, boolean var3);

        @NotNull
        public MemberSource getMemberSource();

        default public int getMemberHashCode() {
            return this.hashCode();
        }

        @NotNull
        public TypeMember copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> var1);

        public void appendMemberPresentation(@NotNull JSType.TypeTextFormat var1, @NotNull JSTypeTextBuilder var2, @NotNull String var3, char var4);

        public void acceptChildren(@NotNull JSRecursiveTypeVisitor var1);
    }

    public static interface MemberSource {
        default public boolean isEmpty() {
            return false;
        }

        default public boolean isUnion() {
            return this.getSourceKind().isUnion();
        }

        default public boolean isMerged() {
            return this.getSourceKind().isTypeScriptMergedTypeKind();
        }

        default public boolean isReadonly() {
            return this.getSourceKind().isForceReadonly();
        }

        default public boolean isForceReadonly() {
            return this.getSourceKind().isForceReadonly();
        }

        public boolean isOptional();

        default public boolean isForceOptional() {
            return this.getSourceKind().isForceOptional();
        }

        default public boolean isIdentity() {
            return this.getSourceKind() == MemberSourceKind.Identity;
        }

        default public boolean hasSingleDocumentation() {
            return this.getSourceKind().hasSingleDocumentation();
        }

        @Nullable
        public PsiElement getSingleElement();

        @NotNull
        public List<PsiElement> getAllSourceElements();

        @NotNull
        public MemberSource copyWithKind(@NotNull MemberSourceKind var1);

        @NotNull
        public MemberSourceKind getSourceKind();
    }

    public static enum MemberSourceKind {
        Empty,
        Identity,
        Union,
        Intersection,
        MappedNoStatus,
        MappedReadonly,
        MappedMinusReadonly,
        MappedOptional,
        MappedMinusOptional,
        MappedOptionalReadonly,
        MappedOptionalMinusReadonly,
        MappedMinusOptionalReadonly,
        MappedMinusOptionalMinusReadonly,
        CompositeSignature,
        MergedAccessor,
        TypeKey;


        public boolean isUnion() {
            return this == Union;
        }

        public static MemberSourceKind getMappedKind(boolean forceOptional, boolean forceNonOptional, boolean forceReadonly, boolean forceNonReadonly) {
            if (forceOptional) {
                return forceReadonly ? MappedOptionalReadonly : (forceNonReadonly ? MappedOptionalMinusReadonly : MappedOptional);
            }
            if (forceNonOptional) {
                return forceReadonly ? MappedMinusOptionalReadonly : (forceNonReadonly ? MappedMinusOptionalMinusReadonly : MappedMinusOptional);
            }
            return forceReadonly ? MappedReadonly : (forceNonReadonly ? MappedMinusReadonly : MappedNoStatus);
        }

        public boolean isMapped() {
            return this.compareTo(MappedNoStatus) >= 0 && this.compareTo(MappedMinusOptionalMinusReadonly) <= 0;
        }

        public boolean isTypeScriptMergedTypeKind() {
            return this == Union || this == Intersection || this.isMapped();
        }

        public boolean isForceReadonly() {
            return this == MappedReadonly || this == MappedOptionalReadonly || this == MappedMinusOptionalReadonly;
        }

        public boolean isForceOptional() {
            return this == MappedOptional || this == MappedOptionalReadonly || this == MappedOptionalMinusReadonly;
        }

        public boolean isForceNonOptional() {
            return this == MappedMinusOptional || this == MappedMinusOptionalReadonly || this == MappedMinusOptionalMinusReadonly;
        }

        public boolean hasSingleDocumentation() {
            return this == Union || this == Intersection || this == Identity;
        }

        @Nullable
        public String getDescription() {
            if (this.isMapped()) {
                return JavaScriptBundle.message("typescript.types.mapped", new Object[0]);
            }
            if (this == Union) {
                return JavaScriptBundle.message("typescript.types.union", new Object[0]);
            }
            if (this == Intersection) {
                return JavaScriptBundle.message("typescript.types.intersection", new Object[0]);
            }
            if (this == TypeKey) {
                return JavaScriptBundle.message("typescript.types.key", new Object[0]);
            }
            if (this == MergedAccessor) {
                return JavaScriptBundle.message("typescript.types.merged.accessor", new Object[0]);
            }
            return null;
        }
    }
}

