/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.JavaScriptTypeGuard;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeGuardEvaluator {
    public static final JSTypeGuardEvaluator DEFAULT = new JSTypeGuardEvaluator();

    @NotNull
    private static JSTypeGuardEvaluator forElement(@Nullable PsiElement context2) {
        JSTypeGuardEvaluator jSTypeGuardEvaluator = JSDialectSpecificHandlersFactory.forElement(context2).getTypeGuardEvaluator();
        if (jSTypeGuardEvaluator == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(0);
        }
        return jSTypeGuardEvaluator;
    }

    @Contract(value="!null,_,_,_ -> !null")
    @Nullable
    public static JSType applyToExpressionType(@Nullable JSType type, @NotNull JSExpression expression, @Nullable PsiElement resolveResult, @NotNull JSEvaluateContext context2) {
        if (expression == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(2);
        }
        return JSTypeGuardEvaluator.forElement((PsiElement)expression).getGuardedTypeByEvaluateContext(type, context2, resolveResult, (PsiElement)expression);
    }

    @Contract(value="!null,_,_ -> !null")
    @Nullable
    public static JSType applyToResolveResultType(@Nullable JSType type, @NotNull PsiElement resolveResult, @NotNull JSEvaluateContext context2) {
        if (resolveResult == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(4);
        }
        return JSTypeGuardEvaluator.forElement(resolveResult).getGuardedTypeByEvaluateContext(type, context2, resolveResult, resolveResult);
    }

    @Contract(value="!null,_,_,_ -> !null")
    @Nullable
    private JSType getGuardedTypeByEvaluateContext(@Nullable JSType type, @NotNull JSEvaluateContext context2, @Nullable PsiElement resolvedElement, @Nullable PsiElement place) {
        if (context2 == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(5);
        }
        if (resolvedElement != null && (place != null || JSTypeGuardUtil.isAcceptableForTypeGuard(resolvedElement)) && this.shouldGetTypeFromTypeGuard(context2)) {
            JSType guardType;
            PsiElement namedCandidate = resolvedElement;
            if (resolvedElement instanceof TypeScriptMergedTypeImplicitElement) {
                namedCandidate = (PsiElement)ObjectUtils.chooseNotNull((Object)((TypeScriptMergedTypeImplicitElement)resolvedElement).getExplicitElement(), (Object)resolvedElement);
            }
            return (guardType = this.getTypeFromTypeGuard(namedCandidate, place, type, resolvedElement)) == null ? type : guardType;
        }
        return type;
    }

    protected boolean shouldGetTypeFromTypeGuard(@NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(6);
        }
        return context2.isAstAccessAllowedInCurrentFile();
    }

    @Nullable
    protected JSType getTypeFromTypeGuard(@NotNull PsiElement namedElement, @Nullable PsiElement place, @Nullable JSType preprocessedType, @Nullable PsiElement resolvedElement) {
        if (namedElement == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(7);
        }
        if (place != null && JSTypeGuardChecker.isAvailable(place, namedElement)) {
            return this.createGuard(place, preprocessedType, resolvedElement).getNarrowedType();
        }
        return preprocessedType;
    }

    @NotNull
    protected JSTypeGuardChecker createGuard(@NotNull PsiElement place, @Nullable JSType startType, @Nullable PsiElement resolveElement) {
        if (place == null) {
            JSTypeGuardEvaluator.$$$reportNull$$$0(8);
        }
        return new JSTypeGuardChecker(place, startType, false, JavaScriptTypeGuard.useAutoVariableType(place, resolveElement), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeGuardEvaluator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeGuardEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyToExpressionType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyToResolveResultType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGuardedTypeByEvaluateContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldGetTypeFromTypeGuard";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeGuard";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createGuard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

