/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.FunctionDeclarationType;
import com.intellij.lang.javascript.refactoring.extractMethod.JSCodeFragment;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractedFunctionSignatureInfoBuilder;
import com.intellij.lang.javascript.refactoring.extractMethod.JSFunctionInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.extractMethod.JSIntroduceFunctionScopeSelectionPopup;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSExtractFunctionHandler
implements RefactoringActionHandler {
    public static final String DEFAULT_EXTRACTED_NAME = "extracted";
    private static final String DECLARE_AS_ARROW_FUNCTION_PROPERTY_KEY = "js.extract.function.declare.as.arrow.function";
    private static final String TOP_LEVEL_SCOPE_WAS_SELECTED_KEY = "js.extract.function.top.level.scope.was.selected";
    private static final Class[] classTypes = new Class[]{JSObjectLiteralExpression.class, JSClass.class, JSFile.class, JSBlockStatement.class, JSEmbeddedContent.class, TypeScriptModule.class};
    public static final String RET_PREFIX = "__ret";
    public static final String REFACTORING_ID = "refactoring.javascript.extractMethod";
    private static final String VOID_TYPE_NAME = "void";
    private final Function<Editor, JSScopeSelectionUI<IntroductionScope>> myScopeSelectionUICreator;

    @TestOnly
    public JSExtractFunctionHandler(@NotNull JSScopeSelectionUI<IntroductionScope> scopeSelectionUI) {
        if (scopeSelectionUI == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(0);
        }
        this.myScopeSelectionUICreator = __ -> scopeSelectionUI;
    }

    public JSExtractFunctionHandler() {
        this.myScopeSelectionUICreator = ApplicationManager.getApplication().isUnitTestMode() ? e -> JSScopeSelectionUI.syncTestScopeSelector(ContainerUtil::getFirstItem) : JSIntroduceFunctionScopeSelectionPopup::new;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(1);
        }
        if (editor == null || file == null) {
            return;
        }
        this.invokeWithSettings(editor, file, null);
    }

    public void invokeWithSettings(@NotNull Editor editor, @NotNull PsiFile file, @Nullable DefaultJSExtractFunctionSettings explicitSettings) {
        ContextInfo contextInfo;
        AbstractInplaceIntroducer activeIntroducer;
        if (editor == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(3);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file, editor, JavaScriptBundle.message("javascript.refactoring.extract.function.title", new Object[0]))) {
            return;
        }
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        if ((activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor)) != null) {
            IntroductionScope scopeFromInplace;
            activeIntroducer.stopIntroduce(editor);
            contextInfo = this.createContextInfo(editor, file);
            if (contextInfo == null) {
                return;
            }
            IntroductionScope introductionScope = scopeFromInplace = activeIntroducer instanceof JSFunctionInplaceIntroducer ? ((JSFunctionInplaceIntroducer)activeIntroducer).restoreUsedScope(contextInfo.introductionScopes) : null;
            if (scopeFromInplace != null) {
                Pair<JSExpression, TextRange> expression = contextInfo.myCodeFragment.getExpression();
                JSExpression[] occurrences = JSUtils.findExpressionOccurrences(scopeFromInplace.getParent(), expression, true);
                this.performDialogRefactoringWithScope(contextInfo, scopeFromInplace, explicitSettings, occurrences);
                return;
            }
        }
        if ((contextInfo = this.createContextInfo(editor, file)) == null) {
            return;
        }
        this.chooseIntroductionScope((JSSignatureContext)contextInfo, (? super IntroductionScope scope2) -> this.performDialogOrInplaceRefactoringWithScope(contextInfo, (IntroductionScope)scope2, explicitSettings), editor, DEFAULT_EXTRACTED_NAME);
    }

    private void performDialogOrInplaceRefactoringWithScope(@NotNull ContextInfo contextInfo, @NotNull IntroductionScope scope2, @Nullable DefaultJSExtractFunctionSettings explicitSettings) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance().setValue(TOP_LEVEL_SCOPE_WAS_SELECTED_KEY, scope2.isTopLevel());
        Pair<JSExpression, TextRange> expression = contextInfo.myCodeFragment.getExpression();
        JSExpression[] occurrences = JSUtils.findExpressionOccurrences(scope2.getParent(), expression, true);
        boolean isInplaceRefactoring = JSExtractFunctionHandler.shouldPerformInplaceRefactoring(contextInfo);
        Consumer<OccurrencesChooser.ReplaceChoice> callback = choice -> {
            if (isInplaceRefactoring) {
                DefaultJSExtractFunctionSettings inplaceSettings = (DefaultJSExtractFunctionSettings)ObjectUtils.coalesce((Object)explicitSettings, (Object)ExtractFunctionSettings.initial(contextInfo, scope2, choice == OccurrencesChooser.ReplaceChoice.ALL));
                inplaceSettings.setIntroductionScope(scope2);
                JSFunctionInplaceIntroducer inplaceHandler = new JSFunctionInplaceIntroducer(this, inplaceSettings, contextInfo, scope2, (PsiElement[])occurrences);
                if (inplaceHandler.startInplaceIntroduceTemplate()) {
                    return;
                }
            }
            this.performDialogRefactoringWithScope(contextInfo, scope2, explicitSettings, occurrences);
        };
        if (explicitSettings == null && isInplaceRefactoring && contextInfo.isExpression && expression != null) {
            LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>>();
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList((JSExpression)expression.getFirst()));
            if (occurrences.length > 1) {
                occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
            }
            OccurrencesChooser.simpleChooser((Editor)contextInfo.editor).showChooser(occurrencesMap, callback);
        } else {
            OccurrencesChooser.ReplaceChoice choice2 = explicitSettings != null && explicitSettings.isReplaceAllOccurrences() ? OccurrencesChooser.ReplaceChoice.ALL : OccurrencesChooser.ReplaceChoice.NO;
            callback.accept(choice2);
        }
    }

    private void performDialogRefactoringWithScope(@NotNull ContextInfo contextInfo, @NotNull IntroductionScope scope2, @Nullable DefaultJSExtractFunctionSettings explicitSettings, JSExpression @NotNull [] occurrences) {
        JSExtractFunctionSettings settings;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(6);
        }
        if (scope2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(7);
        }
        if (occurrences == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(8);
        }
        if (explicitSettings != null) {
            explicitSettings.setIntroductionScope(scope2);
        }
        if ((settings = explicitSettings) == null) {
            ArrayList<RangeHighlighter> highlighters = null;
            if (occurrences.length > 1) {
                highlighters = HighlightingUtils.highlightOccurrences(contextInfo.project, contextInfo.editor, (PsiElement[])occurrences);
            }
            settings = this.showDialog(contextInfo, this.getSignatureGenerator(), scope2, occurrences);
            if (highlighters != null) {
                for (RangeHighlighter highlighter : highlighters) {
                    HighlightManager.getInstance((Project)contextInfo.project).removeSegmentHighlighter(contextInfo.editor, highlighter);
                }
            }
        }
        if (settings == null) {
            return;
        }
        DefaultJSExtractFunctionSettings finalSettings = settings;
        WriteCommandAction.runWriteCommandAction((Project)scope2.parent.getProject(), (String)JavaScriptBundle.message("javascript.extract.method.title", new Object[0]), null, () -> {
            Result result2 = this.doRefactoring(contextInfo, finalSettings, (PsiElement[])occurrences);
            if (result2 != null) {
                JSExtractFunctionHandler.afterInvoke(contextInfo, result2);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static boolean shouldPerformInplaceRefactoring(@NotNull ContextInfo contextInfo) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(9);
        }
        if (contextInfo.holder != null && (contextInfo.holder.isECMA4 || !contextInfo.holder.hasJSSyntax())) {
            return false;
        }
        return contextInfo.editor.getSettings().isVariableInplaceRenameEnabled() && contextInfo.file.isPhysical();
    }

    @Nullable
    public final ContextInfo createContextInfo(Editor editor, PsiFile file) {
        String controlFlowProblem;
        int endOffset;
        int startOffset = this.getExtractFragmentStartOffset(editor);
        JSCodeFragment codeFragment = this.getCodeFragment(file, startOffset, endOffset = this.getExtractFragmentEndOffset(editor));
        if (codeFragment == null || !JSExtractFunctionHandler.isValidFragment(codeFragment)) {
            JSExtractFunctionHandler.reportProblem(JavaScriptBundle.message("javascript.refactoring.extract.function.bad.selection", new Object[0]), file.getProject(), editor);
            return null;
        }
        HashSet<JSContinueStatement> continueStatements = new HashSet<JSContinueStatement>();
        HashSet<JSReturnStatement> returnStatements = new HashSet<JSReturnStatement>();
        HashSet<JSYieldExpression> yieldExpressions = new HashSet<JSYieldExpression>();
        Pair<JSExpression, TextRange> expression = codeFragment.getExpression();
        if (expression != null) {
            SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)expression.first)).filter(JSYieldExpression.class).addAllTo(yieldExpressions);
        }
        if ((controlFlowProblem = JSExtractFunctionUtil.checkControlFlow(codeFragment, codeFragment.getTextRange(), returnStatements, yieldExpressions, continueStatements)) != null) {
            JSExtractFunctionHandler.reportProblem(controlFlowProblem, file.getProject(), editor);
            return null;
        }
        ContextInfo contextInfo = new ContextInfo(editor, file, codeFragment, this.findBases(codeFragment.getContextElement(), JSExtractFunctionHandler.hasPrivateRefs(codeFragment)), returnStatements, yieldExpressions, continueStatements);
        String problem = contextInfo.getProblem();
        if (problem != null) {
            JSExtractFunctionHandler.reportProblem(problem, file.getProject(), editor);
            return null;
        }
        return contextInfo;
    }

    public static boolean hasPrivateRefs(@NotNull JSCodeFragment codeFragment) {
        if (codeFragment == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(10);
        }
        for (PsiElement element : codeFragment.getStatementElements()) {
            if (!JSExtractFunctionHandler.hasPrivateOrProtectedReference(element)) continue;
            return true;
        }
        Pair<JSExpression, TextRange> expression = codeFragment.getExpression();
        return expression != null && JSExtractFunctionHandler.hasPrivateOrProtectedReference((PsiElement)expression.first);
    }

    private static boolean hasPrivateOrProtectedReference(@Nullable PsiElement e) {
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)e).forceIgnore(Conditions.instanceOf(JSClass.class))).filter(JSReferenceExpression.class).filter(JSExtractFunctionHandler::isPrivateOrProtectedRef).isNotEmpty();
    }

    private static boolean isPrivateOrProtectedRef(JSReferenceExpression el) {
        if (JSUtils.isPrivateNameReference((PsiElement)el)) {
            return true;
        }
        PsiElement resolved = el.resolve();
        if (!(resolved instanceof JSAttributeListOwner)) {
            return false;
        }
        JSAttributeList list = ((JSAttributeListOwner)resolved).getAttributeList();
        if (list == null) {
            return false;
        }
        JSAttributeList.AccessType accessType = list.getAccessType();
        return (accessType == JSAttributeList.AccessType.PRIVATE || accessType == JSAttributeList.AccessType.PROTECTED) && JSResolveUtil.getClassOfContext(resolved) == JSResolveUtil.getClassOfContext((PsiElement)el);
    }

    private static boolean isValidFragment(@NotNull JSCodeFragment codeFragment) {
        Pair<JSExpression, TextRange> expressionDescriptor;
        if (codeFragment == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(11);
        }
        if ((expressionDescriptor = codeFragment.getExpression()) != null) {
            return true;
        }
        return ContainerUtil.count((Iterable)ContainerUtil.notNullize(codeFragment.getStatementElements()), JSStatement.class::isInstance) > 0;
    }

    @Nullable
    protected JSExtractFunctionSettings showDialog(@NotNull ContextInfo ci, @NotNull ExtractedFunctionSignatureGenerator signatureGenerator, @NotNull IntroductionScope scope2, JSExpression @NotNull [] occurrences) {
        if (ci == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(12);
        }
        if (signatureGenerator == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(13);
        }
        if (scope2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(14);
        }
        if (occurrences == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(15);
        }
        JSExtractFunctionDialog dialog = JSExtractFunctionDialog.create(ci, scope2);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog;
    }

    public final void chooseIntroductionScope(JSSignatureContext ci, Consumer<? super IntroductionScope> callback, Editor editor, String name) {
        this.chooseIntroductionScope(ci, callback, this.myScopeSelectionUICreator.apply(editor), name);
    }

    public final void chooseIntroductionScope(@NotNull JSSignatureContext signatureContext, @NotNull Consumer<? super IntroductionScope> callback, @NotNull JSScopeSelectionUI<IntroductionScope> scopeSelectionUi, @NotNull String functionName) {
        if (signatureContext == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(17);
        }
        if (scopeSelectionUi == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(18);
        }
        if (functionName == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(19);
        }
        List<IntroductionScope> introductionScopes = signatureContext.getIntroductionScopes();
        PsiElement anchorElement = signatureContext.getContextElement();
        if (signatureContext.isActionScript()) {
            callback.accept(JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, false));
            return;
        }
        if (introductionScopes.size() == 1) {
            callback.accept(introductionScopes.get(0));
            return;
        }
        if (introductionScopes.size() > 1) {
            ArrayList<IntroductionScope> scopesInList = new ArrayList<IntroductionScope>(introductionScopes);
            Collections.reverse(scopesInList);
            IntroductionScope defaultSuggestedScope = JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, true);
            List presentations = ContainerUtil.mapNotNull(scopesInList, scope2 -> {
                DefaultJSExtractFunctionSettings defaultSettings = new DefaultJSExtractFunctionSettings(functionName, (IntroductionScope)scope2);
                PsiElement anchor = this.findFunctionAnchor(scope2.parent, anchorElement);
                if (anchor == null) {
                    return null;
                }
                int hintPosition = anchor.getTextRange().getStartOffset();
                return new JSScopeSelectionUI.ScopePresentation<IntroductionScope>((IntroductionScope)scope2, this.getSignatureGenerator().fun(defaultSettings, signatureContext), hintPosition);
            });
            scopeSelectionUi.show(defaultSuggestedScope, presentations, callback);
        }
    }

    private static IntroductionScope getDefaultSuggestedScope(List<? extends IntroductionScope> introductionScopes, boolean checkLastSelectedScope) {
        IntroductionScope nearestScope = introductionScopes.get(0);
        boolean insidePackageStatement = PsiTreeUtil.getParentOfType((PsiElement)nearestScope.getParent(), (Class[])new Class[]{JSPackageStatement.class, JSClass.class}) instanceof JSPackageStatement;
        for (IntroductionScope introductionScope : introductionScopes) {
            if (introductionScope.isClassContext()) {
                return introductionScope;
            }
            if (!introductionScope.isTopLevel() || insidePackageStatement || checkLastSelectedScope && !PropertiesComponent.getInstance().getBoolean(TOP_LEVEL_SCOPE_WAS_SELECTED_KEY)) continue;
            return introductionScope;
        }
        return nearestScope;
    }

    private static void reportProblem(@NlsContexts.DialogMessage @NotNull String problem, @NotNull Project project, @Nullable Editor editor) {
        if (problem == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(20);
        }
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(21);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)problem, (String)JavaScriptBundle.message("javascript.refactoring.extract.function.title", new Object[0]), (String)"refactoring.extractFunction");
    }

    @Nullable
    protected PsiElement findStatement(PsiElement elementAt, int start, int end) {
        return PsiTreeUtil.findFirstParent((PsiElement)elementAt, (boolean)false, JSExtractFunctionUtil::isAcceptableStatementLevelElement);
    }

    @NotNull
    public static JSExtractFunctionSettings.ParametersInfo createDefaultParametersInfo(@NotNull IntroductionScope scope2) {
        if (scope2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(22);
        }
        JSExtractFunctionSettings.ParametersInfo parametersInfo = new JSExtractFunctionSettings.ParametersInfo();
        int i = -1;
        for (Map.Entry<JSNamedElement, Boolean> entry : scope2.usedVars.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            JSNamedElement variable = entry.getKey();
            ++i;
            parametersInfo.variables.add(variable);
            Collection types = scope2.inputVarTypes.get((Object)variable);
            if (types.isEmpty() || DialectDetector.isActionScript((PsiElement)variable)) continue;
            JSType type = JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource((PsiElement)variable, true), types);
            final LinkedHashSet<JSTypeGenericId> genericIds = new LinkedHashSet<JSTypeGenericId>();
            new JSRecursiveTypeVisitor(){

                @Override
                public void visitJSType(@NotNull JSType type) {
                    if (type == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type instanceof JSGenericParameterType) {
                        genericIds.add(((JSGenericParameterType)type).getGenericId());
                    }
                    super.visitJSType(type);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$1", "visitJSType"));
                }
            }.visitJSType(type);
            parametersInfo.variableOptions.put(variable, new JSExtractFunctionSettings.ParameterInfo(variable.getName(), true, JSExtractedFunctionSignatureInfoBuilder.getTypeString(variable, type), i, genericIds));
        }
        JSExtractFunctionSettings.ParametersInfo parametersInfo2 = parametersInfo;
        if (parametersInfo2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(23);
        }
        return parametersInfo2;
    }

    protected int getExtractFragmentStartOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionStart();
    }

    protected int getExtractFragmentEndOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionEnd();
    }

    public static boolean isPropertyContext(PsiElement parent) {
        return parent instanceof JSObjectLiteralExpression;
    }

    private static void fillScopeReturnTypes(@NotNull JSCodeFragment codeFragment, @NotNull Collection<JSReturnStatement> returnStatements, @NotNull List<IntroductionScope> introductionScopes) {
        String returnType;
        if (codeFragment == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(24);
        }
        if (returnStatements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(25);
        }
        if (introductionScopes == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(26);
        }
        if (codeFragment.getExpression() != null) {
            JSExpression expression = (JSExpression)codeFragment.getExpression().first;
            boolean isExpressionFragment = codeFragment.getExpression().second != null;
            returnType = expression.getParent() instanceof JSExpressionStatement && !isExpressionFragment ? VOID_TYPE_NAME : JSExtractFunctionHandler.getExpressionTypeText(expression);
        } else {
            List returnsWithExpression = ContainerUtil.filter(returnStatements, statement -> statement.getExpression() != null);
            returnType = returnsWithExpression.size() == 1 ? JSExtractFunctionHandler.getExpressionTypeText(((JSReturnStatement)returnsWithExpression.get(0)).getExpression()) : (returnsWithExpression.size() > 1 ? "Object" : null);
            for (IntroductionScope scope2 : introductionScopes) {
                int outputVarsSize = scope2.outputVars.size();
                String scopeReturnType = returnType;
                if (outputVarsSize == 1) {
                    JSNamedElement next = scope2.outputVars.iterator().next();
                    JSType type = next instanceof JSVariable ? ((JSVariable)next).getJSType() : null;
                    String string = scopeReturnType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
                    if (scopeReturnType == null) {
                        scopeReturnType = "*";
                    }
                } else if (outputVarsSize > 1) {
                    scopeReturnType = "Object";
                }
                scope2.returnType = scopeReturnType;
            }
        }
        for (IntroductionScope scope3 : introductionScopes) {
            if (scope3.returnType != null) continue;
            scope3.returnType = returnType == null ? VOID_TYPE_NAME : returnType;
        }
    }

    @Nullable
    private JSCodeFragment getCodeFragment(PsiFile file, int start, int end) {
        PsiElement statement = this.findStatement(file.findElementAt(start), start, end);
        PsiElement statement2 = this.findStatement(file.findElementAt(end > 0 ? end - 1 : end), start, end);
        return JSExtractFunctionUtil.getCodeFragment(statement, statement2, start, end);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Result doRefactoring(@NotNull ContextInfo contextInfo, @NotNull JSExtractFunctionSettings settings, PsiElement @NotNull [] occurrences) {
        boolean needReformat;
        List<JSElement> callElements;
        void var13_44;
        void var12_26;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(28);
        }
        if (occurrences == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(29);
        }
        JSExtractFunctionHandler.beforeInvoke(contextInfo);
        JSRefactoringUtil.registerRefactoringUndo(contextInfo.project, REFACTORING_ID);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        IntroductionScope introductionScope = settings.getIntroductionScope();
        contextInfo.editor.getSelectionModel().removeSelection();
        TextRange rangeInDocument = this.adjustTextRange(contextInfo);
        StringBuilder b = new StringBuilder(rangeInDocument.substring(contextInfo.editor.getDocument().getText()));
        ArrayList<Pair<TextRange, String>> replacements = new ArrayList<Pair<TextRange, String>>();
        boolean allPredAreOutputVarAssignment = JSExtractFunctionHandler.areAllPredAreOutputVarAssignment(contextInfo, introductionScope, replacements);
        JSExtractFunctionSettings.ParametersInfo parametersInfo = JSExtractFunctionHandler.getNotNullParametersInfo(settings);
        String semicolon = this.getStatementTerminator(contextInfo.getContextElement());
        for (Map.Entry<RangeMarker, JSNamedElement> entry : contextInfo.parameterReferences.entrySet()) {
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(entry.getValue());
            if (parameterInfo == null) continue;
            TextRange range = entry.getKey().getTextRange();
            boolean willBeReplacedByReturn = replacements.stream().anyMatch(pair -> ((TextRange)pair.first).contains(range));
            if (willBeReplacedByReturn) continue;
            replacements.add((Pair<TextRange, String>)Pair.create((Object)range, (Object)parameterInfo.name));
        }
        for (RangeMarker rangeMarker : contextInfo.continueStatementsToReplaceWithReturn) {
            int n = rangeMarker.getStartOffset();
            int rangeEnd = rangeMarker.getEndOffset();
            String toInsert = "return" + semicolon;
            replacements.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(n, rangeEnd), (Object)toInsert));
        }
        replacements.sort(Comparator.comparing(pair -> -((TextRange)pair.first).getStartOffset()));
        int lastReplacedOffset = Integer.MAX_VALUE;
        for (Pair pair2 : replacements) {
            if (((TextRange)pair2.first).getEndOffset() > lastReplacedOffset) {
                Logger.getInstance(JSExtractFunctionHandler.class).error("Replacements intersect");
            }
            b.replace(((TextRange)pair2.first).getStartOffset() - rangeInDocument.getStartOffset(), ((TextRange)pair2.first).getEndOffset() - rangeInDocument.getStartOffset(), (String)pair2.second);
            lastReplacedOffset = ((TextRange)pair2.first).getStartOffset();
        }
        String string = b.toString();
        String string2 = "";
        String callSuffix = "";
        Pair<JSExpression, TextRange> expressionDescriptor = contextInfo.myCodeFragment.getExpression();
        if (expressionDescriptor != null) {
            void var12_19;
            String string3;
            boolean exprIsVoid = VOID_TYPE_NAME.equals(introductionScope.returnType);
            if (expressionDescriptor.first instanceof JSXXmlLiteralExpressionImpl && expressionDescriptor.second != null) {
                String string4 = "<>" + (String)(StringUtil.contains((CharSequence)string, (CharSequence)"\n") ? "\n" + string + "\n" : string) + "</>";
            }
            if (!(string3 = (exprIsVoid ? "" : this.getReturnStatementPrefix()) + (String)var12_19).endsWith(semicolon)) {
                String string5 = string3 + semicolon;
            }
        } else {
            ArrayList<JSNamedElement> outputVars = new ArrayList<JSNamedElement>(introductionScope.outputVars);
            Iterator i = outputVars.iterator();
            while (i.hasNext()) {
                JSNamedElement var2 = (JSNamedElement)i.next();
                JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var2);
                if (parameterInfo == null || parameterInfo.used) continue;
                i.remove();
            }
            if (outputVars.size() == 1) {
                void var13_33;
                boolean createVar;
                JSType type;
                JSNamedElement var3 = (JSNamedElement)outputVars.get(0);
                JSType jSType = type = var3 instanceof JSVariable ? ((JSVariable)var3).getJSType() : null;
                if (!allPredAreOutputVarAssignment) {
                    String string6 = string + JSExtractFunctionHandler.getReturnText(semicolon, var3);
                }
                String string7 = ((createVar = JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo, (PsiElement)var3)) ? this.getVariableDeclarationPrefix(var3, contextInfo.holder) : "") + var3.getName();
                if (contextInfo.isActionScript() && createVar && type != null) {
                    String string8 = string7 + ":" + type.getTypeText();
                }
                String string9 = (String)var13_33 + " = ";
            } else if (outputVars.size() > 1) {
                JSVarStatement.VarKeyword commonVarKeyword;
                String string10 = string + JSExtractFunctionHandler.getReturnLiteralObjectText(contextInfo, outputVars, semicolon);
                if (DialectDetector.hasFeature(contextInfo.holder, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT) && ContainerUtil.and(outputVars, var -> JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo, (PsiElement)var)) && (commonVarKeyword = JSExtractFunctionHandler.getCommonKeywordForDestructuring(outputVars, contextInfo.holder)) != null) {
                    String string11 = this.getOutputDestructuringDeclarationPrefix(commonVarKeyword, outputVars);
                } else {
                    String string12 = this.getVariableDeclarationPrefix(null, contextInfo.holder) + RET_PREFIX + (contextInfo.isActionScript() ? ":Object" : "") + " = ";
                    callSuffix = this.getOutputVariablesInitialization(contextInfo, outputVars, semicolon);
                }
            }
        }
        if (contextInfo.hasReturnValue) {
            String string13 = (String)var13_37 + this.getReturnStatementPrefix();
        } else if (contextInfo.hasYieldValue) {
            String string14 = (String)var13_37 + "yield * ";
        }
        if (contextInfo.isAsync()) {
            void var13_40;
            String string15 = (String)var13_40 + "await ";
        }
        if (JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) || ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.getContextElement(), introductionScope.parent) != null) {
            void var13_42;
            String string16 = (String)var13_42 + "this.";
        }
        String introducedFunctionText = this.getSignatureGenerator().fun(settings, contextInfo);
        PsiElement fromText = this.createFunctionFromText(introductionScope, introducedFunctionText = this.addBodyToSignature(introducedFunctionText, (String)var12_26));
        if (fromText == null || JSExtractFunctionHandler.findExtractedNamedElement(fromText) == null) {
            return null;
        }
        Ref selectedElement = Ref.create();
        List<JSIntroducedExpressionUtil.Replacer> replacers = ContainerUtil.emptyList();
        if (contextInfo.isExpression && expressionDescriptor != null) {
            selectedElement.set((Object)((PsiElement)expressionDescriptor.first));
            replacers = settings.isReplaceAllOccurrences() ? ContainerUtil.mapNotNull((Object[])occurrences, expression -> expression instanceof JSExpression ? JSIntroducedExpressionUtil.createReplacer((Pair<? extends JSExpression, TextRange>)Pair.create((Object)((JSExpression)expression), null)) : null) : Collections.singletonList(JSIntroducedExpressionUtil.createReplacer(expressionDescriptor));
        }
        PsiElement functionAnchor = this.findFunctionAnchor(introductionScope.parent, contextInfo.getContextElement());
        JSExtractFunctionHandler.fixSemicolon(functionAnchor, contextInfo, fromText);
        PsiElement created = introductionScope.parent.addBefore(fromText, functionAnchor);
        if (contextInfo.ecmaL4 && created instanceof JSFunction) {
            PsiElement typeElement = ((JSFunction)created).getReturnTypeElement();
            String typeName = JSResolveUtil.getShortTypeName(introductionScope.returnType, true);
            if (typeElement != null && introductionScope.returnType.indexOf(46) != -1 && !introductionScope.returnType.equals(typeName)) {
                ImportUtils.doImport(typeElement, introductionScope.returnType, false);
            }
        }
        ArrayList<FormatFixer> formatFixers = new ArrayList<FormatFixer>();
        if (!(introductionScope.parent instanceof XmlBackedJSClass)) {
            formatFixers.add(FormatFixer.create(created, FormatFixer.Mode.ReformatExactRange));
        }
        String callArgs = JSExtractFunctionHandler.buildCallArguments(parametersInfo);
        String callString = this.createMethodCallStringAfterExtractMethod(contextInfo, settings, callArgs, (String)var13_44, introductionScope);
        if (contextInfo.isExpression) {
            callElements = ContainerUtil.mapNotNull(replacers, r -> {
                JSStatement callStatement = JSPsiElementFactory.createJSStatement(callString + semicolon, contextInfo.getContextElement());
                JSExpression newExpression = Objects.requireNonNull((JSExpression)PsiTreeUtil.findChildOfType((PsiElement)callStatement, JSExpression.class));
                newExpression = r.replaceExpression(newExpression);
                if (r.getOriginalExpression() == selectedElement.get()) {
                    selectedElement.set((Object)newExpression);
                }
                return newExpression;
            });
        } else {
            JSStatement callStatement = JSPsiElementFactory.createJSStatement(callString + semicolon, contextInfo.getContextElement());
            JSElement jSElement = (JSElement)JSExtractFunctionHandler.replaceStatements(Objects.requireNonNull(callStatement), contextInfo.myCodeFragment.getStatementElements());
            selectedElement.set((Object)jSElement);
            callElements = Collections.singletonList(jSElement);
        }
        if (callSuffix.length() > 0) {
            for (JSElement jSElement : callElements) {
                PsiElement callEpilogue = JSChangeUtil.createJSTreeFromTextWithContext(callSuffix, contextInfo.getContextElement()).getPsi();
                PsiElement last = callEpilogue.getNextSibling();
                while (last.getNextSibling() != null) {
                    last = last.getNextSibling();
                }
                jSElement.getParent().addRangeAfter(callEpilogue, last, (PsiElement)jSElement);
            }
        }
        boolean bl = needReformat = !contextInfo.isExpression && contextInfo.myCodeFragment.getStatementElements().size() > 1 || callSuffix.length() > 0;
        if (needReformat) {
            for (JSElement callElement : callElements) {
                formatFixers.add(FormatFixer.create((PsiElement)callElement, FormatFixer.Mode.Reformat));
            }
        }
        JSNamedElement jSNamedElement = JSExtractFunctionHandler.findExtractedNamedElement(created);
        List newOccurrences = ContainerUtil.mapNotNull(callElements, element -> {
            JSReferenceExpression referenceExpression = JSExtractFunctionHandler.findReferenceByName(settings.getMethodName(), element);
            if (element == selectedElement.get()) {
                selectedElement.set((Object)referenceExpression);
            }
            return referenceExpression;
        });
        if (jSNamedElement == null || newOccurrences.isEmpty()) {
            return null;
        }
        JSReferenceExpression selectedReference = (JSReferenceExpression)ObjectUtils.tryCast((Object)selectedElement.get(), JSReferenceExpression.class);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)jSNamedElement.getProject());
        SmartPsiElementPointer declarationPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jSNamedElement);
        SmartPsiElementPointer referencePointer = selectedReference != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)selectedReference) : null;
        List occurrencesPointers = ContainerUtil.mapNotNull((Collection)newOccurrences, expression -> smartPointerManager.createSmartPsiElementPointer((PsiElement)expression));
        FormatFixer.fixAll(formatFixers);
        PsiDocumentManager.getInstance((Project)contextInfo.project).commitAllDocuments();
        return new Result((SmartPsiElementPointer<? extends JSNamedElement>)declarationPointer, (SmartPsiElementPointer<? extends JSReferenceExpression>)referencePointer, occurrencesPointers);
    }

    private static void beforeInvoke(@NotNull ContextInfo contextInfo) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(30);
        }
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement(contextInfo.getContextElement());
        afterData.addElements(contextInfo.myCodeFragment.getStatementElements());
        ((RefactoringEventListener)contextInfo.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, afterData);
    }

    private static void afterInvoke(@NotNull ContextInfo contextInfo, @NotNull Result result2) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(32);
        }
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement((PsiElement)result2.getDeclaration());
        ((RefactoringEventListener)contextInfo.project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, afterData);
    }

    private static boolean areAllPredAreOutputVarAssignment(@NotNull ContextInfo contextInfo, @NotNull IntroductionScope introductionScope, @NotNull List<Pair<TextRange, String>> replacements) {
        List<PsiElement> statements;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(33);
        }
        if (introductionScope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(34);
        }
        if (replacements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(35);
        }
        if ((statements = contextInfo.myCodeFragment.getStatementElements()).isEmpty()) {
            return false;
        }
        JSExecutionScope executionScope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)statements.get(0), JSExecutionScope.class);
        if (executionScope == null) {
            return false;
        }
        JSControlFlowService.JSControlFlow controlFlow = JSControlFlowService.getService(contextInfo.project).getControlFlow(executionScope);
        boolean allPredAreOutputVarAssignment = false;
        ArrayList<JSAssignmentExpression> replaceWithReturn = new ArrayList<JSAssignmentExpression>();
        if (introductionScope.outputVars.size() == 1) {
            Instruction[] instructions = controlFlow.getInstructions();
            JSNamedElement jSNamedElement = (JSNamedElement)ContainerUtil.getFirstItem(introductionScope.outputVars);
            block0: for (Instruction instruction : instructions) {
                PsiElement element = instruction.getElement();
                if (element == null || !JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo, element)) continue;
                Collection allSucc = instruction.allSucc();
                for (Instruction succ : allSucc) {
                    JSExpression referenceExpression;
                    JSExpression lOperand;
                    PsiElement succElement = succ.getElement();
                    JSFunctionExitPoint throwStatement = (JSFunctionExitPoint)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSThrowStatement.class, JSThrowExpression.class});
                    if ((succElement != null || throwStatement != null && JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo, (PsiElement)throwStatement)) && (succElement == null || JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo, succElement))) continue;
                    allPredAreOutputVarAssignment = false;
                    if (!(element instanceof JSAssignmentExpression) || ((JSAssignmentExpression)element).getOperationSign() != JSTokenTypes.EQ || !((lOperand = ((JSAssignmentExpression)element).getLOperand()) instanceof JSDefinitionExpression) || !((referenceExpression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) || ((JSReferenceExpression)referenceExpression).getQualifier() != null || ((JSReferenceExpression)referenceExpression).resolve() != jSNamedElement) continue block0;
                    replaceWithReturn.add((JSAssignmentExpression)element);
                    allPredAreOutputVarAssignment = true;
                }
            }
        }
        if (allPredAreOutputVarAssignment) {
            for (JSAssignmentExpression jSAssignmentExpression : replaceWithReturn) {
                JSExpression lOperand = jSAssignmentExpression.getLOperand();
                JSExpression rOperand = jSAssignmentExpression.getROperand();
                if (lOperand == null || rOperand == null) continue;
                TextRange rangeToReplace = new TextRange(lOperand.getTextRange().getStartOffset(), rOperand.getTextRange().getStartOffset());
                replacements.add((Pair<TextRange, String>)Pair.create((Object)rangeToReplace, (Object)"return "));
            }
        } else {
            for (Map.Entry entry : introductionScope.usedVars.entrySet()) {
                entry.setValue(true);
            }
        }
        return allPredAreOutputVarAssignment;
    }

    private static void fixSemicolon(PsiElement functionAnchor, ContextInfo contextInfo, PsiElement functionToAdd) {
        PsiElement lastChild;
        JSAttributeList list;
        if (!contextInfo.isGenerator()) {
            return;
        }
        if (contextInfo.isAsync()) {
            return;
        }
        if (functionToAdd instanceof JSAttributeListOwner && (list = ((JSAttributeListOwner)functionToAdd).getAttributeList()) != null && (list.getExplicitAccessType() != null || list.hasModifier(JSAttributeList.ModifierType.READONLY))) {
            return;
        }
        PsiElement prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)functionAnchor);
        if (!(prevElement instanceof JSVarStatement)) {
            return;
        }
        JSInitializerOwner lastDeclaration = (JSInitializerOwner)ArrayUtil.getLastElement((Object[])((JSVarStatement)prevElement).getDeclarations());
        if (lastDeclaration != null && lastDeclaration.getInitializer() != null && (lastChild = lastDeclaration.getLastChild()) != null && PsiUtilCore.getElementType((PsiElement)lastChild) != JSTokenTypes.SEMICOLON) {
            lastDeclaration.addAfter(JSChangeUtil.createSemicolonPsiElement(lastChild, ";"), lastChild);
        }
    }

    private static boolean shouldPreserveExpression(JSExpression expression) {
        PsiElement parent = expression == null ? null : expression.getParent();
        return parent instanceof JSReturnStatement || parent instanceof JSYieldExpression;
    }

    @NotNull
    protected TextRange adjustTextRange(ContextInfo contextInfo) {
        Pair<JSExpression, TextRange> simplified;
        Pair<JSExpression, TextRange> expression = contextInfo.myCodeFragment.getExpression();
        if (expression != null && !JSExtractFunctionHandler.shouldPreserveExpression((JSExpression)expression.first) && (simplified = JSBaseIntroduceHandler.simplifyExpression(expression)) != expression) {
            TextRange simplifiedRange = ((JSExpression)simplified.getFirst()).getTextRange();
            if (simplified.getSecond() != null) {
                TextRange textRange = ((TextRange)simplified.getSecond()).shiftLeft(simplifiedRange.getStartOffset());
                if (textRange == null) {
                    JSExtractFunctionHandler.$$$reportNull$$$0(36);
                }
                return textRange;
            }
            TextRange textRange = simplifiedRange;
            if (textRange == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(37);
            }
            return textRange;
        }
        TextRange range = contextInfo.possibleRange;
        if (!DialectDetector.hasJSSyntax(contextInfo.getContextElement())) {
            TextRange textRange = range;
            if (textRange == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(38);
            }
            return textRange;
        }
        int startOffset = range.getStartOffset();
        String text = contextInfo.editor.getDocument().getText();
        int firstNonWhitespace = CharArrayUtil.shiftForward((CharSequence)text, (int)startOffset, (String)"\n\t ");
        int startOfFirstLine = CharArrayUtil.shiftBackward((CharSequence)text, (int)(firstNonWhitespace - 1), (String)"\t ") + 1;
        return new TextRange(startOfFirstLine, range.getEndOffset());
    }

    @NotNull
    private static String buildCallArguments(@NotNull JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        if (parametersInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(39);
        }
        Object callArgs = "";
        boolean referencesArguments = false;
        for (JSNamedElement var : JSExtractFunctionHandler.getOrderedParameters(parametersInfo)) {
            if (JSExtractFunctionHandler.isArgumentsReference(var)) {
                referencesArguments = true;
                continue;
            }
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
            if (parameterInfo != null && !parameterInfo.used) continue;
            if (((String)callArgs).length() > 0) {
                callArgs = (String)callArgs + ",";
            }
            callArgs = (String)callArgs + var.getName();
        }
        if (referencesArguments) {
            if (((String)callArgs).length() > 0) {
                callArgs = (String)callArgs + ",";
            }
            callArgs = (String)callArgs + "arguments";
        }
        String string = callArgs;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static PsiElement replaceStatements(@NotNull JSStatement callStatement, @NotNull List<? extends PsiElement> extractedElements) {
        if (callStatement == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(41);
        }
        if (extractedElements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(42);
        }
        assert (!extractedElements.isEmpty());
        PsiElement result2 = extractedElements.get(0).replace((PsiElement)callStatement);
        if (extractedElements.size() > 1) {
            PsiElement first = extractedElements.get(1);
            PsiElement last = extractedElements.get(extractedElements.size() - 1);
            first.getParent().deleteChildRange(first, last);
        }
        return result2;
    }

    @Nullable
    private static JSVarStatement.VarKeyword getCommonKeywordForDestructuring(@NotNull List<JSNamedElement> outputDeclarations, @Nullable DialectOptionHolder holder) {
        Set keywords;
        if (outputDeclarations == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(43);
        }
        if ((keywords = ContainerUtil.map2Set(outputDeclarations, element -> JSExtractFunctionHandler.getKeywordForDeclaration(element, holder))).size() == 1) {
            return (JSVarStatement.VarKeyword)((Object)keywords.iterator().next());
        }
        if (keywords.contains((Object)JSVarStatement.VarKeyword.VAR)) {
            return null;
        }
        return keywords.contains((Object)JSVarStatement.VarKeyword.LET) ? JSVarStatement.VarKeyword.LET : JSVarStatement.VarKeyword.CONST;
    }

    @NotNull
    private static JSVarStatement.VarKeyword getKeywordForDeclaration(@Nullable JSNamedElement variable, @Nullable DialectOptionHolder dialect) {
        JSVarStatement statement;
        if (variable == null) {
            JSVarStatement.VarKeyword varKeyword = dialect != null && dialect.hasFeature(JSLanguageFeature.LET_DEFINITIONS) ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.VAR;
            if (varKeyword == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(44);
            }
            return varKeyword;
        }
        if (variable instanceof JSVariable && (statement = ((JSVariable)variable).getStatement()) != null) {
            JSVarStatement.VarKeyword varKeyword = (JSVarStatement.VarKeyword)((Object)ObjectUtils.coalesce((Object)((Object)statement.getVarKeyword()), (Object)((Object)JSVarStatement.VarKeyword.VAR)));
            if (varKeyword == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(45);
            }
            return varKeyword;
        }
        JSVarStatement.VarKeyword varKeyword = JSVarStatement.VarKeyword.CONST;
        if (varKeyword == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(46);
        }
        return varKeyword;
    }

    private static boolean extractedRangeContainsDeclaration(@NotNull ContextInfo contextInfo, @NotNull PsiElement declaration) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(47);
        }
        if (declaration == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(48);
        }
        return JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo.possibleRange, declaration);
    }

    private static boolean extractedRangeContainsDeclaration(@NotNull TextRange extractedRange, @NotNull PsiElement declaration) {
        TextRange textRange;
        if (extractedRange == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(49);
        }
        if (declaration == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(50);
        }
        if ((textRange = declaration.getTextRange()) == null) {
            return false;
        }
        return extractedRange.contains(textRange);
    }

    private static String getReturnText(String semicolon, JSNamedElement var) {
        return "\nreturn " + var.getName() + semicolon;
    }

    private String getOutputDestructuringDeclarationPrefix(@NotNull JSVarStatement.VarKeyword commonVarKeyword, @NotNull List<JSNamedElement> outputVars) {
        if (commonVarKeyword == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(51);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(52);
        }
        String variables = StringUtil.join(outputVars, el -> el.getName(), (String)", ");
        return this.getVarKeywordText(commonVarKeyword) + "{ " + variables + " } = ";
    }

    @NotNull
    private String getOutputVariablesInitialization(@NotNull ContextInfo contextInfo, @NotNull List<JSNamedElement> outputVars, @NotNull String semicolon) {
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(53);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(54);
        }
        if (semicolon == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(55);
        }
        String join = StringUtil.join(outputVars, el -> {
            String varName = el.getName();
            boolean hasVariableDeclarationInExtractedText = JSExtractFunctionHandler.extractedRangeContainsDeclaration(contextInfo, (PsiElement)el);
            String varPrefix = hasVariableDeclarationInExtractedText ? this.getVariableDeclarationPrefix((JSNamedElement)el, contextInfo.holder) : "";
            return varPrefix + varName + " = __ret." + varName + semicolon;
        }, (String)"\n");
        String string = "\n" + join;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    private static String getReturnLiteralObjectText(@NotNull ContextInfo contextInfo, @NotNull List<JSNamedElement> outputVars, @NotNull String semicolon) {
        DialectOptionHolder holder;
        if (contextInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(57);
        }
        if (outputVars == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(58);
        }
        if (semicolon == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(59);
        }
        boolean isShorthandPropertyAllow = (holder = contextInfo.holder) != null && holder.hasFeature(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
        String string = "\nreturn {" + StringUtil.join(outputVars, el -> {
            String varName = el.getName();
            return isShorthandPropertyAllow ? varName : varName + ":" + varName;
        }, (String)", ") + "}" + semicolon;
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(60);
        }
        return string;
    }

    protected String createMethodCallStringAfterExtractMethod(ContextInfo contextInfo, JSExtractFunctionSettings settings, String callArgs, String callPrefix, IntroductionScope scope2) {
        boolean shouldProvideDirectThis;
        String methodName = settings.getMethodName();
        if (scope2.isClassContext() && !contextInfo.ecmaL4) {
            boolean isStaticCallFromInstanceContext = JSExtractFunctionHandler.possibleToExtractStaticFromInstance(contextInfo, scope2) && settings.makeStatic();
            String className = ((JSClass)scope2.getParent()).getName();
            String scopePrefix = isStaticCallFromInstanceContext ? className : "this";
            return callPrefix + scopePrefix + "." + methodName + "(" + callArgs + ")";
        }
        PsiElement parent = scope2.parent;
        boolean bl = shouldProvideDirectThis = ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.getContextElement(), parent) == null && !JSExtractFunctionHandler.isPropertyContext(parent);
        if (shouldProvideDirectThis && !contextInfo.isActionScript() && contextInfo.hasThisUsage) {
            return callPrefix + methodName + ".call(this" + (callArgs.isEmpty() ? "" : ", ") + callArgs + ")";
        }
        return callPrefix + methodName + "(" + callArgs + ")";
    }

    @Nullable
    protected PsiElement createFunctionFromText(IntroductionScope introductionScope, String introducedFunctionText) {
        PsiElement parent = introductionScope.getParent();
        if (introductionScope.isClassContext() && !DialectDetector.isActionScript(parent)) {
            return (PsiElement)JSChangeUtil.createClassMemberPsiFromTextWithContext(introducedFunctionText, parent, JSElement.class);
        }
        if (JSExtractFunctionHandler.isPropertyContext(parent)) {
            JSObjectLiteralExpression objectLiteralExpression = JSPsiElementFactory.createJSExpression("{" + introducedFunctionText + "}", parent, JSObjectLiteralExpression.class);
            return objectLiteralExpression.getFirstProperty();
        }
        ASTNode node = JSChangeUtil.createJSTreeFromTextWithContext(introducedFunctionText, parent);
        return node != null ? node.getPsi() : null;
    }

    protected String getStatementTerminator(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(61);
        }
        return JSCodeStyleSettings.getSemicolon(contextElement);
    }

    protected String getReturnStatementPrefix() {
        return "return ";
    }

    @NotNull
    protected ExtractedFunctionSignatureGenerator getSignatureGenerator() {
        return new ExtractedFunctionSignatureGenerator();
    }

    @NotNull
    protected String getVariableDeclarationPrefix(@Nullable JSNamedElement declaration, @Nullable DialectOptionHolder dialect) {
        JSVarStatement.VarKeyword keyword = JSExtractFunctionHandler.getKeywordForDeclaration(declaration, dialect);
        String string = this.getVarKeywordText(keyword);
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    protected String getVarKeywordText(@NotNull JSVarStatement.VarKeyword keyword) {
        if (keyword == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(63);
        }
        String string = keyword.getText() + " ";
        if (string == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(64);
        }
        return string;
    }

    protected String addBodyToSignature(String signature, String body2) {
        return signature + "{\n" + body2 + "\n}";
    }

    @Nullable
    private PsiElement findFunctionAnchor(PsiElement scope2, PsiElement startElement) {
        boolean placeAtScopeStart = startElement != null && JSCodeStyleSettings.isLocalDeclarationsAtScopeStart(startElement);
        PsiElement anchor = JSUtils.findFunctionAnchor(scope2, startElement, placeAtScopeStart);
        return this.needInsertAfter(scope2, anchor) ? PsiTreeUtil.skipWhitespacesForward((PsiElement)anchor) : JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
    }

    protected boolean needInsertAfter(@NotNull PsiElement parent, @Nullable PsiElement functionAnchor) {
        if (parent == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(65);
        }
        return parent instanceof JSClass || functionAnchor instanceof JSPackageStatement;
    }

    @ApiStatus.Internal
    public static boolean isArgumentsReference(JSNamedElement var) {
        return "arguments".equals(var.getName()) && !(var instanceof JSParameter);
    }

    private static String getExpressionElementPresentation(PsiElement element) {
        JSBlockStatement block;
        if (element instanceof JSFunctionExpression && (block = ((JSFunctionExpression)element).getBlock()) != null) {
            element = block;
        }
        String compactedText = element.getText().replaceAll("[\\n|\\r| ]+", " ");
        return "starting with " + compactedText.substring(0, Math.min(compactedText.length(), 30));
    }

    @Nullable
    protected IntroductionScope createPairWithPresentation(PsiElement parent) {
        Object presentation;
        if (parent == null) {
            return null;
        }
        FunctionDeclarationType forceDeclarationType = null;
        PsiElement element = parent;
        Class[] classes = (Class[])ArrayUtil.append((Object[])this.getScopeTypes(), JSFunction.class);
        while (element instanceof JSBlockStatement) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes);
        }
        if (element instanceof JSObjectLiteralExpression) {
            PsiElement objectParent = element.getParent();
            JSExpression assignedTo = null;
            if (objectParent instanceof JSAssignmentExpression) {
                assignedTo = ((JSAssignmentExpression)objectParent).getLOperand();
            } else if (objectParent instanceof JSVariable) {
                assignedTo = ((JSVariable)objectParent).getNameIdentifier();
            }
            presentation = "object " + (String)(assignedTo == null ? JSExtractFunctionHandler.getExpressionElementPresentation(element) : "assigned to " + assignedTo.getText());
            forceDeclarationType = FunctionDeclarationType.FUNCTION;
        } else if (element instanceof JSFile) {
            presentation = JavaScriptBundle.message("javascript.language.term.top.level", new Object[0]);
        } else if (element instanceof XmlTagChild) {
            presentation = JavaScriptBundle.message(element instanceof JSEmbeddedContent ? "javascript.language.term.top.level" : "javascript.language.term.xml.tag", new Object[0]);
            if (element instanceof XmlTag) {
                presentation = (String)presentation + " " + ((XmlTag)element).getName();
            }
        } else {
            presentation = new JSNamedElementPresenter(element).describeWithQualifiedName();
        }
        return new IntroductionScope(parent, (String)presentation, forceDeclarationType);
    }

    protected Class[] getScopeTypes() {
        return classTypes;
    }

    protected boolean acceptBlockStatementAsScope(JSBlockStatement blockStatement) {
        return false;
    }

    @Nullable
    public IntroductionScope findBase(@NotNull PsiElement at, boolean findAll) {
        PsiElement classFromContext;
        JSProperty containingProp;
        JSEmbeddedContent scriptTagAnchor;
        PsiElement decorator;
        if (at == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(66);
        }
        if ((decorator = PsiTreeUtil.getParentOfType((PsiElement)at, ES6Decorator.class)) != null) {
            IntroductionScope base = this.findBase(decorator, findAll);
            while (base != null && base.getParent() instanceof JSClass) {
                base = this.findBase(base.getParent(), findAll);
            }
            return base;
        }
        if (at.getContainingFile() instanceof XmlFile && PsiTreeUtil.getParentOfType((PsiElement)at, XmlAttributeValue.class) != null && (scriptTagAnchor = JSUtils.findScriptTagContent((XmlFile)at.getContainingFile())) != null) {
            return this.createPairWithPresentation(scriptTagAnchor);
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])this.getScopeTypes());
        if (JSPsiImplUtils.isEmbeddedExpressionContent(parent)) {
            return this.findBase(parent.getParent(), findAll);
        }
        if (parent instanceof JSObjectLiteralExpression && ((containingProp = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)at, JSProperty.class)) == null || containingProp.tryGetFunctionInitializer() == null)) {
            return this.findBase(parent.getParent(), findAll);
        }
        boolean stopOnNextParent = false;
        while (parent instanceof JSBlockStatement) {
            if (this.acceptBlockStatementAsScope((JSBlockStatement)parent) || stopOnNextParent) {
                return this.createPairWithPresentation(parent);
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSFunction) {
                if (findAll) {
                    return this.createPairWithPresentation(parent);
                }
                PsiElement ref2 = ExtractedFunctionSignatureGenerator.findClassRef(parent);
                if (ref2 != null) {
                    stopOnNextParent = true;
                    parent = grandParent;
                } else if (grandParent instanceof JSFunctionExpression && !ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)grandParent)) {
                    PsiElement grandParent2 = grandParent.getParent();
                    if (grandParent2 instanceof JSParenthesizedExpression) {
                        grandParent2 = grandParent2.getParent();
                    }
                    if (grandParent2 instanceof JSCallExpression) {
                        return this.createPairWithPresentation(parent);
                    }
                }
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])this.getScopeTypes());
        }
        if (parent instanceof JSFile && parent.getContext() != null && (classFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(parent)) != null) {
            parent = classFromContext;
        }
        if (at instanceof XmlBackedJSClass) {
            return null;
        }
        return this.createPairWithPresentation(parent);
    }

    public List<IntroductionScope> findBases(@NotNull PsiElement at, boolean hasPrivateRefs) {
        if (at == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(67);
        }
        ArrayList<IntroductionScope> scopes = new ArrayList<IntroductionScope>();
        IntroductionScope currentScope = this.findBase(at, true);
        boolean isInnerFunction = false;
        while (currentScope != null && !(currentScope.parent instanceof JSFile) && !(currentScope.parent instanceof XmlTagChild)) {
            PsiElement scopeGrandParent = currentScope.parent.getParent();
            if (scopeGrandParent instanceof JSFunction && !((JSFunction)scopeGrandParent).isArrowFunction() && !(scopeGrandParent instanceof ES6FunctionProperty) && JSResolveUtil.getClassOfContext(scopeGrandParent) == null) {
                isInnerFunction = true;
            }
            if (!(currentScope.parent instanceof JSClass) || !isInnerFunction) {
                scopes.add(currentScope);
            }
            if (hasPrivateRefs && currentScope.parent instanceof JSClass) {
                currentScope = null;
                break;
            }
            currentScope = this.findBase(currentScope.parent, true);
        }
        if (currentScope != null) {
            scopes.add(currentScope);
        }
        return scopes;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(68);
        }
        if (elements == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(69);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static JSExtractFunctionSettings.ParametersInfo getNotNullParametersInfo(JSExtractFunctionSettings settings) {
        JSExtractFunctionSettings.ParametersInfo parametersInfo = settings.getParametersInfo();
        if (parametersInfo != null) {
            JSExtractFunctionSettings.ParametersInfo parametersInfo2 = parametersInfo;
            if (parametersInfo2 == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(70);
            }
            return parametersInfo2;
        }
        return JSExtractFunctionHandler.createDefaultParametersInfo(settings.getIntroductionScope());
    }

    @NotNull
    public static List<JSNamedElement> getOrderedParameters(@NotNull JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        if (parametersInfo == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(71);
        }
        ArrayList<JSNamedElement> parameters = new ArrayList<JSNamedElement>(parametersInfo.variables);
        if (parametersInfo.variables.size() != parametersInfo.variableOptions.size()) {
            ArrayList<JSNamedElement> arrayList = parameters;
            if (arrayList == null) {
                JSExtractFunctionHandler.$$$reportNull$$$0(72);
            }
            return arrayList;
        }
        parameters.sort(Comparator.comparingInt(o -> parametersInfo.variableOptions.get((Object)o).index));
        ArrayList<JSNamedElement> arrayList = parameters;
        if (arrayList == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    private static String getExpressionTypeText(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        JSType type = JSResolveUtil.getExpressionJSType(expression);
        if (type == null) {
            type = JSAnyType.get((PsiElement)expression);
        }
        return type.getTypeText(JSType.TypeTextFormat.CODE);
    }

    @ApiStatus.Internal
    public static String @NotNull [] suggestNames(@NotNull JSCodeFragment codeFragment) {
        Pair<JSExpression, TextRange> expressionDescriptor;
        if (codeFragment == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(74);
        }
        if ((expressionDescriptor = codeFragment.getExpression()) != null) {
            List<String> candidates;
            JSExpression expression = (JSExpression)expressionDescriptor.getFirst();
            PsiElement useScope = PsiTreeUtil.getParentOfType((PsiElement)expression, JSExecutionScope.class);
            if (expression != null && useScope != null && !(candidates = JSNameSuggestionsUtil.generateVariableNamesFromExpression(expression, useScope, "get", Collections.emptyList(), JSNamedEntityKind.Accessor)).isEmpty()) {
                String[] stringArray = ArrayUtilRt.toStringArray(candidates);
                if (stringArray == null) {
                    JSExtractFunctionHandler.$$$reportNull$$$0(75);
                }
                return stringArray;
            }
        }
        String[] stringArray = new String[]{DEFAULT_EXTRACTED_NAME};
        if (stringArray == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(76);
        }
        return stringArray;
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement findConflictingElementInScope(@NotNull String name, PsiElement scope2, boolean isStatic, @Nullable PsiElement toIgnore) {
        if (name == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(77);
        }
        List<PsiElement> conflicts = JSRefactoringUtil.findExistingInScope(name, scope2, isStatic);
        return (PsiElement)ContainerUtil.find(conflicts, t -> t != toIgnore);
    }

    @Nullable
    private static JSReferenceExpression findReferenceByName(String name, JSElement element) {
        Ref result2 = new Ref();
        PsiTreeUtil.processElements((PsiElement)element, t -> {
            if (t instanceof JSReferenceExpression && StringUtil.equals((CharSequence)((JSReferenceExpression)t).getReferenceName(), (CharSequence)name)) {
                result2.set((Object)((JSReferenceExpression)t));
                return false;
            }
            return true;
        });
        return (JSReferenceExpression)result2.get();
    }

    @Nullable
    private static JSNamedElement findExtractedNamedElement(@Nullable PsiElement created) {
        if (created instanceof JSNamedElement) {
            return (JSNamedElement)created;
        }
        if (created instanceof JSVarStatement) {
            return ((JSVarStatement)created).getVariables()[0];
        }
        if (created instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)created).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                return ((JSAssignmentExpression)expression).getDefinitionExpression();
            }
            return (JSNamedElement)ObjectUtils.tryCast((Object)expression, JSNamedElement.class);
        }
        return null;
    }

    @ApiStatus.Internal
    public static boolean possibleToExtractStaticFromInstance(@NotNull JSSignatureContext context2, @NotNull IntroductionScope introductionScope) {
        if (context2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(78);
        }
        if (introductionScope == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(79);
        }
        return context2.getJSContext().isCompatibleWith(JSContext.STATIC) && !StringUtil.isEmpty((String)((JSClass)introductionScope.getParent()).getName());
    }

    @NotNull
    static FunctionDeclarationType getDefaultFunctionDeclarationType() {
        FunctionDeclarationType functionDeclarationType = PropertiesComponent.getInstance().getBoolean(DECLARE_AS_ARROW_FUNCTION_PROPERTY_KEY) ? FunctionDeclarationType.ARROW_FUNCTION : FunctionDeclarationType.FUNCTION;
        if (functionDeclarationType == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(80);
        }
        return functionDeclarationType;
    }

    static void saveFunctionDeclareType(@NotNull FunctionDeclarationType value) {
        if (value == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(81);
        }
        boolean asArrowFunction = value == FunctionDeclarationType.ARROW_FUNCTION;
        PropertiesComponent.getInstance().setValue(DECLARE_AS_ARROW_FUNCTION_PROPERTY_KEY, asArrowFunction);
    }

    @NlsContexts.Command
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"refactoring.extract.method.dialog.title");
    }

    public static JSExtractFunctionHandler forContext(@NotNull PsiElement context2) {
        RefactoringActionHandler handler;
        if (context2 == null) {
            JSExtractFunctionHandler.$$$reportNull$$$0(82);
        }
        Language dialect = DialectDetector.calculateJSLanguage(context2);
        RefactoringSupportProvider provider = (RefactoringSupportProvider)LanguageRefactoringSupport.getInstance().forLanguage(dialect);
        if (provider != null && (handler = provider.getExtractMethodHandler()) instanceof JSExtractFunctionHandler) {
            return (JSExtractFunctionHandler)handler;
        }
        return new JSExtractFunctionHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 36, 37, 38, 40, 44, 45, 46, 56, 60, 62, 64, 70, 72, 73, 75, 76, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelectionUI";
                break;
            }
            case 1: 
            case 21: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 47: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 15: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 10: 
            case 11: 
            case 24: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ci";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureGenerator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelectionUi";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 23: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 56: 
            case 60: 
            case 62: 
            case 64: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatements";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScopes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 39: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersInfo";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStatement";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedElements";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDeclarations";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedRange";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonVarKeyword";
                break;
            }
            case 52: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVars";
                break;
            }
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultParametersInfo";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTextRange";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCallArguments";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordForDeclaration";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariablesInitialization";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnLiteralObjectText";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDeclarationPrefix";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKeywordText";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullParametersInfo";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedParameters";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFunctionDeclarationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeWithSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performDialogOrInplaceRefactoringWithScope";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performDialogRefactoringWithScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldPerformInplaceRefactoring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasPrivateRefs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidFragment";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScope";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultParametersInfo";
                break;
            }
            case 23: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 56: 
            case 60: 
            case 62: 
            case 64: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 80: {
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fillScopeReturnTypes";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "beforeInvoke";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "afterInvoke";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "areAllPredAreOutputVarAssignment";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "buildCallArguments";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatements";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCommonKeywordForDestructuring";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "extractedRangeContainsDeclaration";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDestructuringDeclarationPrefix";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariablesInitialization";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getReturnLiteralObjectText";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getStatementTerminator";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getVarKeywordText";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "needInsertAfter";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findBase";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findBases";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedParameters";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "suggestNames";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findConflictingElementInScope";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "possibleToExtractStaticFromInstance";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "saveFunctionDeclareType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "forContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 36, 37, 38, 40, 44, 45, 46, 56, 60, 62, 64, 70, 72, 73, 75, 76, 80 -> new IllegalStateException(string);
        };
    }

    public static final class ContextInfo
    implements JSSignatureContext {
        @NotNull
        public final JSCodeFragment myCodeFragment;
        @NotNull
        public final TextRange possibleRange;
        private final List<RangeMarker> continueStatementsToReplaceWithReturn;
        private final Map<RangeMarker, JSNamedElement> parameterReferences;
        public final List<IntroductionScope> introductionScopes;
        @NotNull
        public final Project project;
        @NotNull
        public final PsiFile file;
        public final boolean ecmaL4;
        public final boolean typescript;
        @NotNull
        public final Editor editor;
        final boolean isExpression;
        final boolean hasReturnValue;
        final boolean hasYieldValue;
        boolean hasThisUsage;
        boolean hasSuperUsage;
        public boolean hasAwaitExpressions;
        private @NlsContexts.DialogMessage String myProblem;
        @Nullable
        public final DialectOptionHolder holder;

        private ContextInfo(@NotNull Editor editor, final @NotNull PsiFile file, @NotNull JSCodeFragment selectionCodeFragment, final @NotNull List<IntroductionScope> introductionScopes, @NotNull Set<JSReturnStatement> returnStatements, @NotNull Set<JSYieldExpression> yieldExpressions, @NotNull Set<JSContinueStatement> continueStatements) {
            if (editor == null) {
                ContextInfo.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ContextInfo.$$$reportNull$$$0(1);
            }
            if (selectionCodeFragment == null) {
                ContextInfo.$$$reportNull$$$0(2);
            }
            if (introductionScopes == null) {
                ContextInfo.$$$reportNull$$$0(3);
            }
            if (returnStatements == null) {
                ContextInfo.$$$reportNull$$$0(4);
            }
            if (yieldExpressions == null) {
                ContextInfo.$$$reportNull$$$0(5);
            }
            if (continueStatements == null) {
                ContextInfo.$$$reportNull$$$0(6);
            }
            this.parameterReferences = new LinkedHashMap<RangeMarker, JSNamedElement>();
            this.editor = editor;
            final Document document = editor.getDocument();
            this.possibleRange = selectionCodeFragment.getTextRange();
            this.file = file;
            this.project = file.getProject();
            this.myCodeFragment = selectionCodeFragment;
            this.isExpression = this.myCodeFragment.getExpression() != null;
            PsiElement contextElement = this.myCodeFragment.getContextElement();
            this.holder = DialectDetector.dialectOfElement(contextElement);
            this.ecmaL4 = this.holder != null && this.holder.isECMA4;
            this.typescript = this.holder != null && this.holder.isTypeScript;
            this.introductionScopes = introductionScopes;
            this.hasReturnValue = ContainerUtil.find(returnStatements, t -> t.getExpression() != null) != null;
            this.hasYieldValue = !yieldExpressions.isEmpty();
            this.continueStatementsToReplaceWithReturn = ContainerUtil.map(continueStatements, statement -> document.createRangeMarker(statement.getTextRange()));
            JSRecursiveElementVisitor elementVisitor = new JSRecursiveElementVisitor(){
                final Set<JSNamedElement> processed = new HashSet<JSNamedElement>();
                final FunctionVisitContext myFunctionVisitContext = new FunctionVisitContext();

                @Override
                public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!possibleRange.contains(node.getTextRange())) {
                        return;
                    }
                    super.visitJSReferenceExpression(node);
                    if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node)) {
                        this.handleResolveResult((PsiReference)node, JSResolveUtil.getExpressionJSType(node));
                    }
                }

                @Override
                public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitJSLiteralExpression(node);
                    if (!(node instanceof JSXXmlLiteralExpressionImpl) || !possibleRange.contains(node.getTextRange())) {
                        return;
                    }
                    JSXXmlLiteralExpressionImpl xmlLiteral = (JSXXmlLiteralExpressionImpl)node;
                    PsiReference topLevelReference = (PsiReference)ObjectUtils.coalesce((Object)JSXResolveUtil.getFirstQualifierReference((XmlTag)xmlLiteral), (Object)node.getReference());
                    if (topLevelReference == null) {
                        return;
                    }
                    this.handleResolveResult(topLevelReference, null);
                }

                @Override
                public void visitJSVariable(@NotNull JSVariable node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.visitJSVariable(node);
                    this.handleDeclaration(node);
                }

                @Override
                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (!possibleRange.contains(node.getTextRange())) {
                        return;
                    }
                    this.myFunctionVisitContext.enter(node);
                    super.visitJSFunctionExpression(node);
                    this.myFunctionVisitContext.exit(node);
                }

                @Override
                public void visitJSPrefixExpression(@NotNull JSPrefixExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (!possibleRange.contains(node.getTextRange())) {
                        return;
                    }
                    if (this.myFunctionVisitContext.getCurrent() == null && node.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD) {
                        hasAwaitExpressions = true;
                    }
                    super.visitJSPrefixExpression(node);
                }

                @Override
                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    this.handleDeclaration(node);
                    this.myFunctionVisitContext.enter(node);
                    super.visitJSFunctionDeclaration(node);
                    this.myFunctionVisitContext.exit(node);
                }

                @Override
                public void visitJSThisExpression(@NotNull JSThisExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (!possibleRange.contains(node.getTextRange())) {
                        return;
                    }
                    if (!this.myFunctionVisitContext.isNestedThisScope()) {
                        hasThisUsage = true;
                    }
                    super.visitJSThisExpression(node);
                }

                @Override
                public void visitJSSuperExpression(@NotNull JSSuperExpression superExpression) {
                    if (superExpression == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (!possibleRange.contains(superExpression.getTextRange())) {
                        return;
                    }
                    if (this.myFunctionVisitContext.getCurrent() == null) {
                        hasSuperUsage = true;
                    }
                    super.visitJSSuperExpression(superExpression);
                }

                private void handleResolveResult(@NotNull PsiReference node, @Nullable JSType type) {
                    PsiElement element;
                    if (node == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    if ((element = node.resolve()) instanceof JSNamedElement) {
                        JSNamedElement declaration = (JSNamedElement)element;
                        if (element.getContainingFile().equals(file)) {
                            this.handleReferenced(node, declaration, (JSType)(type != null && 1.isHackyType(type, element) ? null : type));
                            parameterReferences.put(document.createRangeMarker(node.getElement().getTextRange()), declaration);
                        }
                    }
                }

                private static boolean isHackyType(@NotNull JSType type, PsiElement element) {
                    if (type == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    if (type.getSourceElement() != element) {
                        return false;
                    }
                    return !(element instanceof JSTypeDeclarationOwner) || ((JSTypeDeclarationOwner)element).getTypeElement() == null;
                }

                private void handleReferenced(@NotNull PsiReference reference, @NotNull JSNamedElement declaration, @Nullable JSType type) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    if (declaration == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    if (JSResolveUtil.findParent((PsiElement)declaration) instanceof JSClass) {
                        return;
                    }
                    ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getReferenceAccess((PsiElement)declaration, reference);
                    PsiElement declarationScope = JSUseScopeProvider.getUseScopeElement(declaration);
                    for (IntroductionScope scope2 : introductionScopes) {
                        boolean hasReadAccess;
                        if (ContextInfo.reachableFromExtractScope(declarationScope, scope2) || JSExtractFunctionHandler.extractedRangeContainsDeclaration(possibleRange, (PsiElement)declaration)) continue;
                        Boolean includeInParameters = scope2.usedVars.get(declaration);
                        boolean bl = hasReadAccess = access == ReadWriteAccessDetector.Access.Read || access == ReadWriteAccessDetector.Access.ReadWrite;
                        if (includeInParameters == null) {
                            scope2.usedVars.put(declaration, hasReadAccess);
                        } else if (!includeInParameters.booleanValue() && hasReadAccess) {
                            scope2.usedVars.put(declaration, true);
                        }
                        if (type == null) continue;
                        scope2.inputVarTypes.putValue((Object)declaration, (Object)type);
                    }
                    this.handleDeclaration(declaration);
                }

                private void handleDeclaration(@NotNull JSNamedElement declaration) {
                    if (declaration == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    if (!this.processed.add(declaration)) {
                        return;
                    }
                    if (JSResolveUtil.findParent((PsiElement)declaration) instanceof JSClass) {
                        return;
                    }
                    boolean hasReadsOutOfBlock = false;
                    HashSet<IntroductionScope> hasWritesInBlock = new HashSet<IntroductionScope>();
                    if (JSExtractFunctionHandler.extractedRangeContainsDeclaration(possibleRange, (PsiElement)declaration)) {
                        hasWritesInBlock.addAll(introductionScopes);
                    }
                    PsiElement declarationScope = JSUseScopeProvider.getUseScopeElement(declaration);
                    HashSet<IntroductionScope> varIsReachableFrom = new HashSet<IntroductionScope>();
                    for (IntroductionScope scope2 : introductionScopes) {
                        if (!ContextInfo.reachableFromExtractScope(declarationScope, scope2)) continue;
                        varIsReachableFrom.add(scope2);
                    }
                    for (PsiReference ref2 : ReferencesSearch.search((PsiElement)declaration, (SearchScope)new LocalSearchScope((PsiElement)declaration.getContainingFile()))) {
                        TextRange textRange = ref2.getElement().getTextRange();
                        if (declaration instanceof JSFunction && JSExtractFunctionHandler.extractedRangeContainsDeclaration(possibleRange, (PsiElement)declaration) && !possibleRange.contains(textRange) && textRange.getEndOffset() <= declaration.getTextRange().getStartOffset()) {
                            myProblem = JavaScriptBundle.message("javascript.refactoring.extract.function.function.used.before.declaring", new Object[0]);
                            return;
                        }
                        ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref2.getElement());
                        if ((access != ReadWriteAccessDetector.Access.Write || JSResolveUtil.isSelfReference(ref2.getElement())) && (!possibleRange.contains(textRange) || declarationScope != null && this.isInsideLoop(ref2.getElement(), declarationScope))) {
                            hasReadsOutOfBlock = true;
                        }
                        if (access == ReadWriteAccessDetector.Access.Read || !possibleRange.contains(textRange)) continue;
                        for (IntroductionScope scope3 : introductionScopes) {
                            if (varIsReachableFrom.contains(scope3)) continue;
                            hasWritesInBlock.add(scope3);
                        }
                    }
                    if (hasReadsOutOfBlock) {
                        for (IntroductionScope scope2 : hasWritesInBlock) {
                            scope2.outputVars.add(declaration);
                        }
                    }
                }

                private boolean isInsideLoop(PsiElement element, PsiElement scope2) {
                    PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSLoopStatement.class, scope2.getClass()});
                    while (parent instanceof JSLoopStatement) {
                        if (!possibleRange.contains(parent.getTextRange())) {
                            return true;
                        }
                        if (parent == scope2) {
                            return false;
                        }
                        parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSLoopStatement.class, scope2.getClass()});
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "superExpression";
                            break;
                        }
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 10: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                        case 11: 
                        case 12: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "declaration";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSLiteralExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSVariable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSPrefixExpression";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSThisExpression";
                            break;
                        }
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSSuperExpression";
                            break;
                        }
                        case 8: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleResolveResult";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isHackyType";
                            break;
                        }
                        case 10: 
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleReferenced";
                            break;
                        }
                        case 12: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleDeclaration";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }

                static class FunctionVisitContext {
                    @NotNull
                    private final Deque<JSFunction> myFunctions = new ArrayDeque<JSFunction>();
                    @Nullable
                    private JSFunction topmostThisScopeFunction;

                    FunctionVisitContext() {
                    }

                    @Nullable
                    public JSFunction getCurrent() {
                        return this.myFunctions.peekFirst();
                    }

                    public boolean isNestedThisScope() {
                        return this.topmostThisScopeFunction != null;
                    }

                    public void enter(@NotNull JSFunction function) {
                        if (function == null) {
                            FunctionVisitContext.$$$reportNull$$$0(0);
                        }
                        this.myFunctions.push(function);
                        if (this.topmostThisScopeFunction == null && !function.isArrowFunction()) {
                            this.topmostThisScopeFunction = function;
                        }
                    }

                    public void exit(@NotNull JSFunction function) {
                        if (function == null) {
                            FunctionVisitContext.$$$reportNull$$$0(1);
                        }
                        this.myFunctions.pop();
                        if (this.topmostThisScopeFunction == function) {
                            this.topmostThisScopeFunction = null;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "function";
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo$1$FunctionVisitContext";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "enter";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "exit";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }
            };
            if (this.myCodeFragment.getExpression() != null) {
                ((JSExpression)this.myCodeFragment.getExpression().first).accept(elementVisitor);
            } else {
                for (PsiElement element : this.myCodeFragment.getStatementElements()) {
                    element.accept((PsiElementVisitor)elementVisitor);
                }
            }
            JSExtractFunctionHandler.fillScopeReturnTypes(this.myCodeFragment, returnStatements, introductionScopes);
        }

        private static boolean reachableFromExtractScope(@Nullable PsiElement declarationScope, @NotNull IntroductionScope scope2) {
            if (scope2 == null) {
                ContextInfo.$$$reportNull$$$0(7);
            }
            if (declarationScope == null) {
                return true;
            }
            PsiElement parent = scope2.getParent();
            if (parent == declarationScope || parent.getParent() == declarationScope) {
                return true;
            }
            return PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)declarationScope) == declarationScope;
        }

        @NlsContexts.DialogMessage
        public String getProblem() {
            return this.myProblem;
        }

        @Override
        public boolean isActionScript() {
            return this.ecmaL4;
        }

        @Override
        public boolean isTypeScript() {
            return this.typescript;
        }

        @Override
        public boolean isAsync() {
            return this.hasAwaitExpressions;
        }

        @Override
        public boolean isGenerator() {
            return this.hasYieldValue;
        }

        @Override
        @NotNull
        public JSContext getJSContext() {
            if (JSResolveUtil.calculateStaticFromContext(this.getContextElement())) {
                JSContext jSContext = JSContext.STATIC;
                if (jSContext == null) {
                    ContextInfo.$$$reportNull$$$0(8);
                }
                return jSContext;
            }
            if (this.hasSuperUsage || this.hasThisUsage) {
                JSContext jSContext = JSContext.INSTANCE;
                if (jSContext == null) {
                    ContextInfo.$$$reportNull$$$0(9);
                }
                return jSContext;
            }
            JSContext jSContext = JSContext.UNKNOWN;
            if (jSContext == null) {
                ContextInfo.$$$reportNull$$$0(10);
            }
            return jSContext;
        }

        @Override
        @NotNull
        public PsiElement getContextElement() {
            PsiElement psiElement = this.myCodeFragment.getContextElement();
            if (psiElement == null) {
                ContextInfo.$$$reportNull$$$0(11);
            }
            return psiElement;
        }

        @Override
        @NotNull
        public List<IntroductionScope> getIntroductionScopes() {
            List<IntroductionScope> list = this.introductionScopes;
            if (list == null) {
                ContextInfo.$$$reportNull$$$0(12);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionCodeFragment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "introductionScopes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatements";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yieldExpressions";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continueStatements";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$ContextInfo";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJSContext";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextElement";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIntroductionScopes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "reachableFromExtractScope";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    public static class IntroductionScope {
        @NotNull
        public final PsiElement parent;
        @NlsSafe
        public final String presentation;
        @Nullable
        public final FunctionDeclarationType forceDeclarationType;
        public final Map<JSNamedElement, Boolean> usedVars;
        public final MultiMap<JSNamedElement, JSType> inputVarTypes;
        public final Set<JSNamedElement> outputVars;
        public String returnType;

        public IntroductionScope(@NotNull PsiElement parent, @NlsSafe String presentation) {
            if (parent == null) {
                IntroductionScope.$$$reportNull$$$0(0);
            }
            this(parent, presentation, null);
        }

        public IntroductionScope(@NotNull PsiElement parent, @NlsSafe String presentation, @Nullable FunctionDeclarationType forceDeclarationType) {
            if (parent == null) {
                IntroductionScope.$$$reportNull$$$0(1);
            }
            this.usedVars = new LinkedHashMap<JSNamedElement, Boolean>();
            this.inputVarTypes = MultiMap.create();
            this.outputVars = new LinkedHashSet<JSNamedElement>();
            this.parent = parent;
            this.presentation = presentation;
            this.forceDeclarationType = forceDeclarationType;
        }

        public String toString() {
            return this.presentation;
        }

        public boolean isClassContext() {
            return this.parent instanceof JSClass;
        }

        public boolean isTopLevel() {
            return this.parent instanceof JSFile || this.parent instanceof JSEmbeddedContent;
        }

        @NotNull
        public PsiElement getParent() {
            PsiElement psiElement = this.parent;
            if (psiElement == null) {
                IntroductionScope.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$IntroductionScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$IntroductionScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class Result {
        @NotNull
        private final SmartPsiElementPointer<? extends JSNamedElement> myDeclaration;
        @Nullable
        private final SmartPsiElementPointer<? extends JSReferenceExpression> myExpression;
        @NotNull
        private final List<SmartPsiElementPointer<? extends JSReferenceExpression>> myOccurrences;

        public Result(@NotNull SmartPsiElementPointer<? extends JSNamedElement> declaration, @Nullable SmartPsiElementPointer<? extends JSReferenceExpression> expression, @NotNull List<SmartPsiElementPointer<? extends JSReferenceExpression>> occurrences) {
            if (declaration == null) {
                Result.$$$reportNull$$$0(0);
            }
            if (occurrences == null) {
                Result.$$$reportNull$$$0(1);
            }
            this.myDeclaration = declaration;
            this.myExpression = expression;
            this.myOccurrences = occurrences;
        }

        @Nullable
        public JSNamedElement getDeclaration() {
            return (JSNamedElement)this.myDeclaration.getElement();
        }

        @Nullable
        public JSReferenceExpression getExpression() {
            return this.myExpression != null ? (JSReferenceExpression)this.myExpression.getElement() : null;
        }

        @NotNull
        public List<? extends JSReferenceExpression> getOccurrences() {
            List list = ContainerUtil.mapNotNull(this.myOccurrences, SmartPsiElementPointer::getElement);
            if (list == null) {
                Result.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrences";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$Result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler$Result";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOccurrences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

