/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSFileElementType
extends IStubFileElementType<PsiFileStub<JSFile>> {
    private static final Key<JSFileElementType> TYPE = Key.create((String)"js.file.element.type");
    private static final int BASE_VERSION = 795;

    protected JSFileElementType(Language language) {
        super(language);
    }

    public static synchronized JSFileElementType create(Language language) {
        JSFileElementType type = new JSFileElementType(language);
        return (JSFileElementType)((Object)language.putUserDataIfAbsent(TYPE, (Object)type));
    }

    @NotNull
    protected Language getLanguageForParser(@NotNull PsiElement psi) {
        if (psi == null) {
            JSFileElementType.$$$reportNull$$$0(0);
        }
        JSLanguageDialect jSLanguageDialect = JSLanguageUtil.getLanguageForParser(psi);
        if (jSLanguageDialect == null) {
            JSFileElementType.$$$reportNull$$$0(1);
        }
        return jSLanguageDialect;
    }

    @NotNull
    public String getExternalId() {
        String string = this.getLanguage() + ":" + this;
        if (string == null) {
            JSFileElementType.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        return JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file);
    }

    public int getStubVersion() {
        return JSFileElementType.getVersion();
    }

    public static int getVersion() {
        return JavaScriptIndex.getVersion(795, 0);
    }

    public static int getVersion(int additionalVersion) {
        return JavaScriptIndex.getVersion(795, additionalVersion);
    }

    public StubBuilder getBuilder() {
        return new JSFileStubBuilder();
    }

    public void serialize(@NotNull PsiFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JSFileElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            JSFileElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getType().getLanguage().getID());
        JSFileCachedData cachedData = ((JSFileStubImpl)stub).getCachedData();
        if (cachedData == null) {
            JSFile file = (JSFile)((JSFileStubImpl)stub).getPsi();
            if (file instanceof JSFileBaseImpl) {
                cachedData = ((JSFileBaseImpl)file).getCachedData();
            } else {
                cachedData = new JSFileCachedData();
                if (file != null) {
                    cachedData.applyModuleStatus(file.getModuleStatus());
                    cachedData.setTestFileType(file.getTestFileType());
                    if (file.hasES6Syntax()) {
                        cachedData.setHasES6Syntax();
                    }
                    if (file.hasJSXSyntax()) {
                        cachedData.setHasJSXSyntax();
                    }
                    cachedData.setPragmaFlags(file.getPragmaFlags());
                }
            }
        }
        cachedData.serialize(dataStream);
        Set<String> referencedPaths = ((JSFileStubImpl)stub).getReferencedPaths();
        if (referencedPaths == null) {
            JSFile file = (JSFile)((JSFileStubImpl)stub).getPsi();
            referencedPaths = file != null ? file.getReferencedPaths() : Collections.emptySet();
        }
        JSFileCachedData.serializeStringSet(referencedPaths, dataStream);
    }

    @NotNull
    public PsiFileStub<JSFile> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSFileElementType.$$$reportNull$$$0(5);
        }
        String languageId = dataStream.readNameString();
        JSFileCachedData cachedData = JSFileCachedData.deserialize(dataStream);
        Set<String> referencedPaths = JSFileCachedData.deserializeStringSet(dataStream);
        return new JSFileStubImpl(Language.findLanguageByID((String)languageId), cachedData, referencedPaths);
    }

    public static synchronized JSFileElementType getByLanguage(Language language) {
        return (JSFileElementType)((Object)language.getUserData(TYPE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/JSFileElementType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/JSFileElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForParser";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

