/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddExplicitEnumValuesIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("javascript.fix.add.enum.values", new Object[0]);
        if (string == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.add.enum.values", new Object[0]);
        if (string == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(3);
        }
        TypeScriptEnum anEnum = TypeScriptAddExplicitEnumValuesIntention.findEnum(element);
        assert (anEnum != null);
        NumberFormat format = NumberFormat.Dec;
        for (JSField field : anEnum.getFields()) {
            assert (field instanceof TypeScriptEnumField);
            JSExpression initializer = field.getInitializer();
            if (initializer != null) {
                format = TypeScriptAddExplicitEnumValuesIntention.getNumberFormat(initializer);
                continue;
            }
            EnumConstantValue value = ((TypeScriptEnumField)field).getConstantValue();
            Double numericValue = value.getNumericValue();
            assert (numericValue != null);
            int i = (int)numericValue.doubleValue();
            String text = TypeScriptAddExplicitEnumValuesIntention.formatNumber(i, format);
            TypeScriptAddExplicitEnumValuesIntention.appendEnumValue(field, text);
        }
    }

    public static void appendEnumValue(@NotNull JSField field, @NotNull String text) {
        if (field == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(4);
        }
        if (text == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(5);
        }
        field.addBefore(JSChangeUtil.createTokenElement((PsiElement)field, JSTokenTypes.EQ, "="), null);
        field.addBefore((PsiElement)JSPsiElementFactory.createJSExpression(text, (PsiElement)field), null);
    }

    @NotNull
    public static NumberFormat getNumberFormat(JSExpression initializer) {
        JSLiteralExpression expression = (JSLiteralExpression)ObjectUtils.tryCast((Object)initializer, JSLiteralExpression.class);
        if (expression != null) {
            JSLiteralExpressionKind kind = expression.getExpressionKind(true);
            NumberFormat numberFormat = switch (kind) {
                case JSLiteralExpressionKind.HEX -> NumberFormat.Hex;
                case JSLiteralExpressionKind.OCT, JSLiteralExpressionKind.OBSOLETE_OCT -> NumberFormat.Oct;
                case JSLiteralExpressionKind.BIN -> NumberFormat.Bin;
                default -> NumberFormat.Dec;
            };
            if (numberFormat == null) {
                TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(6);
            }
            return numberFormat;
        }
        NumberFormat numberFormat = NumberFormat.Dec;
        if (numberFormat == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(7);
        }
        return numberFormat;
    }

    @NotNull
    public static String formatNumber(int i, NumberFormat format) {
        Object object = switch (format) {
            case NumberFormat.Hex -> "0x" + Integer.toHexString(i);
            case NumberFormat.Bin -> "0b" + Integer.toBinaryString(i);
            case NumberFormat.Oct -> "0o" + Integer.toOctalString(i);
            default -> String.valueOf(i);
        };
        if (object == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(9);
        }
        if (element == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(10);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        TypeScriptEnum anEnum = TypeScriptAddExplicitEnumValuesIntention.findEnum(element);
        if (anEnum == null) {
            return false;
        }
        boolean hasNonInitialized = false;
        for (JSField field : anEnum.getFields()) {
            JSExpression initializer = field.getInitializer();
            hasNonInitialized |= initializer == null;
            if (!(field instanceof TypeScriptEnumField)) {
                return false;
            }
            EnumConstantValue constantValue = ((TypeScriptEnumField)field).getConstantValue();
            if (constantValue.getStringValue() == null && constantValue.getNumericValue() != null) continue;
            return false;
        }
        return hasNonInitialized;
    }

    @Nullable
    static TypeScriptEnum findEnum(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAddExplicitEnumValuesIntention.$$$reportNull$$$0(11);
        }
        return (TypeScriptEnum)PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptEnum.class, (boolean)false, (Class[])new Class[]{JSBlockStatement.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddExplicitEnumValuesIntention";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddExplicitEnumValuesIntention";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNumber";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendEnumValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEnum";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static enum NumberFormat {
        Dec,
        Hex,
        Bin,
        Oct;

    }
}

