/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.checkers;

import com.intellij.lang.javascript.config.JSConfigIncludeBase;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptConfigIncludeBase
extends JSConfigIncludeBase {
    @Nullable
    protected final PathMatcher myExcludeMatchers;
    @NotNull
    private final Collection<VirtualFile> myTypeRoots;
    @NotNull
    private final Collection<String> myTypes;
    @NotNull
    private final Collection<String> myExcludePatterns;
    protected final boolean myExcludePatternsContainNodeModules;
    private final boolean myHasTypes;

    private static void resolveTypesForRoot(@NotNull Collection<String> typesNames, @NotNull VirtualFile root, @NotNull Set<String> visited, @NotNull List<VirtualFile> result2) {
        if (typesNames == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(0);
        }
        if (root == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(1);
        }
        if (visited == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(3);
        }
        if (!root.isValid() || typesNames.isEmpty()) {
            return;
        }
        TypeScriptNodeSearchProcessor processor = new TypeScriptNodeSearchProcessor(TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
        for (String type : typesNames) {
            VirtualFile typesCandidate;
            VirtualFile child;
            ProgressManager.checkCanceled();
            if (visited.contains(type) || (child = VfsUtilCore.findRelativeFile((String)type, (VirtualFile)root)) == null || !child.isDirectory() || (typesCandidate = JSExactFileReference.resolveForNpmPackages(child, (JSDirectorySearchProcessor)processor)) == null) continue;
            result2.add(typesCandidate);
            visited.add(type);
        }
    }

    @NotNull
    private static Collection<VirtualFile> calcTypeFiles(@NotNull Collection<VirtualFile> typeRoots, @NotNull Collection<String> typeNames, @NotNull VirtualFile configDirectory) {
        if (typeRoots == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(4);
        }
        if (typeNames == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(5);
        }
        if (configDirectory == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(6);
        }
        if (typeNames.isEmpty()) {
            return TypeScriptConfigIncludeBase.calcAllTypeFiles(typeRoots);
        }
        SmartList result2 = new SmartList();
        HashSet<String> visited = new HashSet<String>();
        for (VirtualFile virtualFile : typeRoots) {
            TypeScriptConfigIncludeBase.resolveTypesForRoot(typeNames, virtualFile, visited, (List<VirtualFile>)result2);
        }
        if (visited.size() == typeNames.size()) {
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptConfigIncludeBase.$$$reportNull$$$0(7);
            }
            return smartList;
        }
        VirtualFile nodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot(configDirectory, false);
        if (nodeModules != null) {
            TypeScriptConfigIncludeBase.resolveTypesForRoot(ContainerUtil.filter(typeNames, el -> !el.startsWith(".")), nodeModules, visited, (List<VirtualFile>)result2);
        }
        TypeScriptConfigIncludeBase.resolveTypesForRoot(ContainerUtil.filter(typeNames, el -> el.startsWith(".")), configDirectory, visited, (List<VirtualFile>)result2);
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    @NotNull
    private static Collection<VirtualFile> calcAllTypeFiles(@NotNull Collection<VirtualFile> typeRoots) {
        if (typeRoots == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(9);
        }
        SmartList result2 = new SmartList();
        for (VirtualFile root : typeRoots) {
            if (!root.isValid()) continue;
            for (VirtualFile candidate : root.getChildren()) {
                VirtualFile typesCandidate;
                ProgressManager.checkCanceled();
                if (!candidate.isDirectory() || (typesCandidate = JSExactFileReference.resolveForNpmPackages(candidate, (JSDirectorySearchProcessor)TypeScriptNodeSearchProcessor.TS_PROCESSOR)) == null) continue;
                result2.add(typesCandidate);
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    public TypeScriptConfigIncludeBase(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(11);
        }
        super(config);
        this.myHasTypes = config.getRawCompilerOption("types") != null;
        this.myTypes = config.getTypes();
        this.myTypeRoots = config.getTypeRoots();
        this.myExcludePatterns = config.getExcludePatterns();
        this.myExcludeMatchers = TypeScriptConfigUtil.getExcludeMatchers(config);
        this.myExcludePatternsContainNodeModules = TypeScriptConfigUtil.areExcludePatternsContainNodeModules(config);
    }

    public boolean isFromFilesList(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope getRootScope(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(13);
        }
        return this.getScope(project);
    }

    boolean isExcludedPath(@NotNull Path path2) {
        if (path2 == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(14);
        }
        return this.myExcludeMatchers != null && this.myExcludeMatchers.matches(path2);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAdditionalRootFiles(@NotNull Project project) {
        List types;
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(15);
        }
        Collection<Object> collection = types = this.myHasTypes && this.myTypes.isEmpty() ? Collections.emptyList() : TypeScriptConfigIncludeBase.calcTypeFiles(this.myTypeRoots, this.myTypes, this.myConfigDirectory);
        if (types.size() > 0) {
            HashSet<VirtualFile> newResult = new HashSet<VirtualFile>();
            types.stream().filter(VirtualFile::isValid).forEach(newResult::add);
            HashSet<VirtualFile> hashSet = newResult;
            if (hashSet == null) {
                TypeScriptConfigIncludeBase.$$$reportNull$$$0(16);
            }
            return hashSet;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    private GlobalSearchScope getScope(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigIncludeBase.$$$reportNull$$$0(18);
        }
        return new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)project)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                return TypeScriptConfigIncludeBase.this.accept(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase$1", "contains"));
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeScriptConfigIncludeBase base = (TypeScriptConfigIncludeBase)o;
        return this.myHasTypes == base.myHasTypes && this.myTypeRoots.equals(base.myTypeRoots) && this.myTypes.equals(base.myTypes) && this.myExcludePatterns.equals(base.myExcludePatterns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myTypeRoots, this.myTypes, this.myExcludePatterns, this.myHasTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigIncludeBase";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTypeFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAllTypeFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRootFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypesForRoot";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcTypeFiles";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcAllTypeFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFromFilesList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRootScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalRootFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 16, 17 -> new IllegalStateException(string);
        };
    }
}

