/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.AssignColorDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignColorAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AssignColorAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AssignColorAction.$$$reportNull$$$0(1);
        }
        DatabaseView view = (DatabaseView)e.getData(DatabaseView.DATABASE_VIEW_KEY);
        @NotNull DataContext dataContext = e.getDataContext();
        boolean enabled = view != null && !DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DatabaseView view;
        if (e == null) {
            AssignColorAction.$$$reportNull$$$0(2);
        }
        if ((view = (DatabaseView)e.getData(DatabaseView.DATABASE_VIEW_KEY)) == null) {
            return;
        }
        @NotNull DataContext dataContext = e.getDataContext();
        DataSourceNode dsn = DatabaseContextFun.getSelectionRelatedSingleDataSource(dataContext);
        if (dsn == null) {
            Messages.showErrorDialog((String)DatabaseBundle.message("dialog.message.selected.elements.are.not.from.single.data.source", new Object[0]), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
            return;
        }
        JBIterable<DbElement> selectedElements = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
        Project project = view.getProject();
        boolean projectDs = !dsn.rawDataSource.isGlobal();
        AssignColorDialog dialog = new AssignColorDialog(project, selectedElements.toSet(), false, projectDs);
        if (dialog.showAndGet()) {
            ((DatabaseColorManager.ColorChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseColorManager.COLOR_CHANGE_TOPIC)).onChanged();
        }
    }

    public static void updateOpenFileEditors(@NotNull Project project) {
        if (project == null) {
            AssignColorAction.$$$reportNull$$$0(3);
        }
        FileEditorManagerEx managerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        for (VirtualFile file : managerEx.getOpenFiles()) {
            managerEx.updateFilePresentation(file);
            if (!DbVFSUtils.isConsoleFile(file) && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsoleProviderCore.getValidConsole(project, file) == null) continue;
            AssignColorAction.updateFileEditors(managerEx, file);
        }
    }

    public static void updateFileEditors(@NotNull FileEditorManagerEx fileEditorManager, @NotNull VirtualFile file) {
        if (fileEditorManager == null) {
            AssignColorAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AssignColorAction.$$$reportNull$$$0(5);
        }
        Project project = fileEditorManager.getProject();
        for (FileEditor fileEditor : fileEditorManager.getEditors(file)) {
            if (fileEditor instanceof DatabaseTableFileEditor) {
                DatabaseTableFileEditor tableFileEditor = (DatabaseTableFileEditor)fileEditor;
                DatabaseEditorHelper.configureEditorHeader(project, file, tableFileEditor.getHeaderComponent());
                continue;
            }
            EditorEx editorEx = EditorUtil.getEditorEx((FileEditor)fileEditor);
            JComponent component = editorEx != null ? editorEx.getPermanentHeaderComponent() : fileEditor.getComponent();
            AssignColorAction.updateColors(project, file, component);
        }
    }

    public static void updateDatabaseToolwindow(@NotNull Project project) {
        if (project == null) {
            AssignColorAction.$$$reportNull$$$0(6);
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            List<Content> contents = console.getContents();
            for (Content content : contents) {
                AssignColorAction.updateColors(project, console.getVirtualFile(), content.getComponent());
            }
        }
    }

    private static void updateColors(@NotNull Project project, @NotNull VirtualFile file, @Nullable JComponent root) {
        if (project == null) {
            AssignColorAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AssignColorAction.$$$reportNull$$$0(8);
        }
        for (EditorHeaderComponent component : UIUtil.uiTraverser((Component)root).filter(EditorHeaderComponent.class)) {
            DatabaseEditorHelper.configureEditorHeader(project, file, (JComponent)component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/AssignColorAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/AssignColorAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateOpenFileEditors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateFileEditors";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabaseToolwindow";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    public static final class UpdateProjectColors
    implements DatabaseColorManager.ColorChangeListener {
        Project project;

        public UpdateProjectColors(Project project) {
            this.project = project;
        }

        @Override
        public void onChanged() {
            AssignColorAction.updateOpenFileEditors(this.project);
            AssignColorAction.updateDatabaseToolwindow(this.project);
        }
    }
}

