/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OpenConsoleAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean relatedToDS;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        DataContext dc = e.getDataContext();
        if (DatabaseContextFun.fromDatabaseTree(dc)) {
            relatedToDS = DatabaseContextFun.getSelectionRelatedDataSources(dc).stream().anyMatch(dsn -> dsn.rawDataSource instanceof LocalDataSource);
        } else {
            Project project = e.getProject();
            if (project == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            JBIterable<DbElement> elements = OpenConsoleAction.getElements(dc, project);
            relatedToDS = elements.filterMap(o -> DbImplUtilCore.getMaybeLocalDataSource(o.getDataSource())).isNotEmpty();
        }
        boolean visible = relatedToDS || e.isFromActionToolbar();
        presentation.setVisible(visible);
        presentation.setEnabled(relatedToDS);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JBIterable<DbElement> elements = OpenConsoleAction.getElements(e.getDataContext(), project);
        List namespaces2 = elements.filterMap(o -> (DbElement)JBIterable.generate((Object)o, p2 -> p2.getParent()).filter(p2 -> p2 instanceof DasNamespace || p2 instanceof DasDataSource).first()).unique().filter(o -> DbImplUtilCore.getMaybeLocalDataSource(o.getDataSource()) != null).toList();
        this.actionPerformedInner(e, namespaces2);
    }

    protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces2) {
        Project project;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(3);
        }
        if (namespaces2 == null) {
            OpenConsoleAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<PersistenceConsoleProvider.Runner> runners = OpenConsoleAction.getRunners(project, namespaces2);
        RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(DatabaseBundle.message("action.Jdbc.OpenConsole.consoles", new Object[0]), runners, (Editor)e.getData(CommonDataKeys.EDITOR), e);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull Project project, @NotNull List<DbElement> namespaces2) {
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(5);
        }
        if (namespaces2 == null) {
            OpenConsoleAction.$$$reportNull$$$0(6);
        }
        JBIterable namespacesIt = JBIterable.from(namespaces2);
        DbElement single = (DbElement)namespacesIt.single();
        Set allowedIds = namespacesIt.map(o -> o.getDataSource().getUniqueId()).toSet();
        ArrayList<PersistenceConsoleProvider.Runner> result2 = new ArrayList<PersistenceConsoleProvider.Runner>();
        PairConsumer consumer = (element, file) -> {
            DasNamespace namespace = (DasNamespace)ObjectUtils.tryCast((Object)element, DasNamespace.class);
            DatabaseEditorHelper.openConsoleForFile(project, element.getDataSource(), namespace, file);
        };
        for (JdbcConsole console : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (!allowedIds.contains(console.getDataSource().getUniqueId()) || !DbVFSUtils.isConsoleFile(console.getVirtualFile())) continue;
            result2.add(DatabaseRunners.createConsoleRunner(console, () -> consumer.consume((Object)single, (Object)console.getVirtualFile())));
        }
        if (single != null) {
            result2.addAll(DatabaseRunners.createDataSourceConsolesRunner(single.getDataSource(), (Consumer<? super VirtualFile>)((Consumer)file -> consumer.consume((Object)single, file))).getSubRunners());
        } else {
            namespacesIt.unique(o -> o.getDataSource()).map(o -> DatabaseRunners.createDataSourceConsolesRunner(o.getDataSource(), (Consumer<? super VirtualFile>)((Consumer)file -> consumer.consume(o, file)))).addAllTo(result2);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
        if (arrayList == null) {
            OpenConsoleAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static JBIterable<DbElement> getElements(@NotNull DataContext dc, @NotNull Project project) {
        if (dc == null) {
            OpenConsoleAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(9);
        }
        return DatabaseContextFun.fromDatabaseTree(dc) ? OpenConsoleAction.getSelectedElementsFromTree(dc, project) : OpenConsoleAction.getSelectedElements2(dc, project);
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElementsFromTree(@NotNull DataContext dc, @NotNull Project project) {
        JBIterable<DbElement> selectedDbElements;
        if (dc == null) {
            OpenConsoleAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(11);
        }
        return (selectedDbElements = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dc)).isNotEmpty() ? selectedDbElements : OpenConsoleAction.getSelectedElements2(dc, project);
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElements2(@NotNull DataContext dc, @NotNull Project project) {
        if (dc == null) {
            OpenConsoleAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(13);
        }
        JBIterable byPsi = JBIterable.of((Object[])((PsiElement[])dc.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filterMap(psi -> {
            if (psi instanceof DbElement) {
                return (DbElement)psi;
            }
            return null;
        });
        JBIterable byFile = JBIterable.of((Object[])((VirtualFile[])dc.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filterMap(file -> {
            if (file instanceof DatabaseElementVirtualFileImpl) {
                return ((DatabaseElementVirtualFileImpl)((Object)file)).findElement(project);
            }
            if (DbVFSUtils.isConsoleFile(file)) {
                return DbVFSUtils.getDataSource(project, file);
            }
            return null;
        });
        JBIterable jBIterable = byPsi.append((Iterable)byFile);
        if (jBIterable == null) {
            OpenConsoleAction.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements2";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedInner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElementsFromTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements2";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    public static class CreateNew
    extends OpenConsoleAction {
        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces2) {
            if (e == null) {
                CreateNew.$$$reportNull$$$0(0);
            }
            if (namespaces2 == null) {
                CreateNew.$$$reportNull$$$0(1);
            }
            for (DbElement namespace : namespaces2) {
                DatabaseEditorHelper.openConsoleFile(namespace, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespaces";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/OpenConsoleAction$CreateNew";
            objectArray[2] = "actionPerformedInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

