/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.BaseRefreshAction;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.basic.BasicAuxiliaryElement;
import com.intellij.database.model.basic.BasicAuxiliaryObject;
import com.intellij.database.model.basic.BasicDetailElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/actions/RefreshFragmentAction;", "Lcom/intellij/database/actions/BaseRefreshAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canWe", "", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "actionPerformed", "intellij.database.impl"})
public final class RefreshFragmentAction
extends BaseRefreshAction {
    public RefreshFragmentAction() {
        super(null);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        boolean weCan = this.canWe(dataContext);
        e.getPresentation().setEnabledAndVisible(weCan);
    }

    private final boolean canWe(DataContext dc) {
        List<DataSourceNode> dataSourceNodes = DatabaseContextFun.getSelectionRelatedDataSources(dc);
        for (DataSourceNode dsn : dataSourceNodes) {
            if (DBIntrospectorFeatures.supportsFragmentIntrospection(dsn.getDbms())) continue;
            return false;
        }
        boolean can = false;
        JBIterable<BasicElement> selectedElements = DatabaseContextFun.getSelectedElements(dc);
        for (BasicElement element : selectedElements) {
            BasicElement basicElement = element;
            if (basicElement instanceof BasicRoot || basicElement instanceof BasicNamespaceOwner || basicElement instanceof BasicNamespace) {
                return false;
            }
            if (basicElement instanceof BasicAuxiliaryObject) {
                can = true;
                continue;
            }
            if (basicElement instanceof BasicAuxiliaryElement) {
                can = can || ((BasicAuxiliaryElement)element).getParent() instanceof BasicAuxiliaryObject;
                continue;
            }
            if (basicElement instanceof BasicMajorObject || basicElement instanceof BasicMinorObject || basicElement instanceof BasicDetailElement) {
                can = true;
                continue;
            }
            if (!(basicElement instanceof BasicSourceAware)) continue;
            can = true;
        }
        return can;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JBIterable<BasicElement> elementsToRefresh = DatabaseContextFun.getSelectedElements(dataContext);
        RefreshActionsLogic.refreshSpecificFragments(project2, (Iterable)elementsToRefresh);
    }
}

