/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsoleUtil;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.audit.DatabaseSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.BaseLogView;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewController;
import com.intellij.database.run.session.LogViewOwner;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EdtNoGetDataProvider;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class DatabaseLogView<T extends LogViewOwner & DataRequest.OwnerEx>
extends BaseLogView<T>
implements Disposable {
    private static final String PROMPT = "> ";

    public DatabaseLogView(@NotNull LanguageConsoleView languageConsole, @NotNull T owner, @NotNull DatabaseServiceViewController<T, ?> controller, @NlsContexts.StatusText @NotNull String placeholder) {
        if (languageConsole == null) {
            DatabaseLogView.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DatabaseLogView.$$$reportNull$$$0(1);
        }
        if (controller == null) {
            DatabaseLogView.$$$reportNull$$$0(2);
        }
        if (placeholder == null) {
            DatabaseLogView.$$$reportNull$$$0(3);
        }
        super(languageConsole.getProject(), languageConsole, controller, owner, ((DataRequest.OwnerEx)owner).getMessageBus());
        languageConsole.setPrompt(PROMPT);
        this.getUi().getContentManager().addDataProvider((DataProvider)((EdtNoGetDataProvider)sink -> DataSink.uiDataSnapshot((DataSink)sink, (Object)owner)));
        this.getUi().getOptions().setTabPopupActions((ActionGroup)ActionManager.getInstance().getAction("Console.TabPopupGroup"));
        this.ensureContentInitialized();
        ConsoleViewImpl console = (ConsoleViewImpl)languageConsole;
        console.addLayerToPane((JComponent)new PlaceholderComponent(this, console, placeholder));
    }

    public boolean shouldActivateForOutput(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseLogView.$$$reportNull$$$0(4);
        }
        if (SessionsUtil.isInternalOwner(owner)) {
            return true;
        }
        return owner == this.getTarget() && this.shouldActivateForResult(owner);
    }

    public boolean shouldActivateForResult(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseLogView.$$$reportNull$$$0(5);
        }
        if (DatabaseSettings.getSettings().showOnlySelectedClientOutput) {
            VirtualFile virtualFile = ((DatabaseSessionClientWithFile)owner).getVirtualFile();
            FileEditorManager manager = FileEditorManager.getInstance((Project)this.getProject());
            FileEditor selectedEditor = manager.getSelectedEditor();
            return selectedEditor != null && virtualFile.equals(selectedEditor.getFile());
        }
        return true;
    }

    @Override
    protected void updatePrompt(@NotNull DataRequest.Context context) {
        SearchPath searchPath;
        if (context == null) {
            DatabaseLogView.$$$reportNull$$$0(6);
        }
        if ((searchPath = context.getSearchPath()) == null || searchPath.elements.isEmpty()) {
            this.getConsoleView().setPrompt(PROMPT);
            return;
        }
        String prompt = DbImplUtil.searchPathPresentation(searchPath.elements) + PROMPT;
        this.getConsoleView().setPrompt(StringUtil.shortenTextWithEllipsis((String)prompt, (int)35, (int)10));
    }

    @Override
    @NotNull
    protected SessionLogger createAuditor() {
        return new DatabaseSessionLogger(this);
    }

    @Override
    public void setTarget(@NotNull T target2, @NotNull DataBus.Consuming bus) {
        if (target2 == null) {
            DatabaseLogView.$$$reportNull$$$0(7);
        }
        if (bus == null) {
            DatabaseLogView.$$$reportNull$$$0(8);
        }
        try {
            ((DatabaseServiceViewController)this.getController()).setOwner(target2);
        }
        finally {
            super.setTarget(target2, bus);
        }
    }

    @Override
    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        boolean isRequestedQuery;
        String query;
        if (context == null) {
            DatabaseLogView.$$$reportNull$$$0(9);
        }
        boolean isNotEmpty = !StringUtil.isEmpty((String)(query = context.getQuery()));
        boolean isConsoleRequest = isNotEmpty && context.request instanceof ConsoleDataRequest;
        boolean bl = isRequestedQuery = isConsoleRequest && StringUtil.equalsIgnoreWhitespaces((CharSequence)query, (CharSequence)((ConsoleDataRequest)context.request).query);
        if (isRequestedQuery) {
            Object text = this.getDataSource().getDbms().isTransactSql() ? query : query + ";";
            ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getConsoleView(), (String)text);
        }
        super.addRequestToHistory(context);
    }

    @NotNull
    protected abstract LocalDataSource getDataSource();

    @Override
    protected void buildConsoleUi() {
        RunnerLayoutUi ui = this.getUi();
        ui.getDefaults().initTabDefaults(0, this.getController().id(), null);
        ui.getOptions().setMoveToGridActionEnabled(true).setMinimizeActionEnabled(false);
        if (ui instanceof RunnerLayoutUiImpl) {
            RunnerLayoutUiImpl impl = (RunnerLayoutUiImpl)ui;
            impl.setLeftToolbarVisible(false);
            impl.setContentToolbarBefore(false);
        }
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getConsoleView().getComponent(), (Object)"Center");
        String title = DatabaseBundle.message("jdbc.console.tab.title.console", new Object[0]);
        JComponent toFocus = this.getConsoleView().getHistoryViewer().getContentComponent();
        Content output = ui.createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        JdbcConsoleUtil.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getConsoleView());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getConsoleView().getComponent());
        this.getConsoleView().setConsoleEditorEnabled(false);
        output.setCloseable(false);
        ui.addContent(output, -1, PlaceInGrid.center, false);
    }

    @NotNull
    public List<AnAction> getActions() {
        if (!this.isValid()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                DatabaseLogView.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<AnAction> consoleActions = new ArrayList<AnAction>();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction specificActionGroup = actionManager.getAction("Console.Dialect.SpecificGroup");
        if (specificActionGroup != null) {
            consoleActions.add(specificActionGroup);
        }
        consoleActions.add((AnAction)Separator.create());
        consoleActions.add(ActionManager.getInstance().getAction("Console.Jdbc.Cancel"));
        consoleActions.add((AnAction)Separator.create());
        consoleActions.add(this.getUi().getOptions().getLayoutActions());
        for (AnAction action : consoleActions) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        ArrayList<AnAction> arrayList = consoleActions;
        if (arrayList == null) {
            DatabaseLogView.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    protected void onLineBreak(@NotNull LanguageConsoleView console) {
        String prompt;
        if (console == null) {
            DatabaseLogView.$$$reportNull$$$0(12);
        }
        String indent = StringUtil.repeat((String)" ", (int)((prompt = console.getPrompt()) == null ? 0 : prompt.length()));
        console.print(indent, ConsoleViewContentType.USER_INPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseLogView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseLogView";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldActivateForOutput";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldActivateForResult";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePrompt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onLineBreak";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }

    private static class PlaceholderComponent
    extends JPanel {
        private final ConsoleViewImpl myConsole;
        private final StatusText myStatusText;

        PlaceholderComponent(@NotNull Disposable parent, @NotNull ConsoleViewImpl console, @NlsContexts.StatusText @NotNull String text) {
            if (parent == null) {
                PlaceholderComponent.$$$reportNull$$$0(0);
            }
            if (console == null) {
                PlaceholderComponent.$$$reportNull$$$0(1);
            }
            if (text == null) {
                PlaceholderComponent.$$$reportNull$$$0(2);
            }
            final Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)parent, (Disposable)disposable);
            this.myConsole = console;
            this.myStatusText = new StatusText(this){

                protected boolean isStatusVisible() {
                    Editor editor2 = myConsole.getEditor();
                    return editor2 != null && editor2.getDocument().getTextLength() == 0;
                }
            };
            this.myStatusText.setText(text);
            Editor editor2 = this.myConsole.getEditor();
            if (editor2 != null) {
                editor2.getDocument().addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        UIUtil.invokeLaterIfNeeded(() -> {
                            Container parent = this.getParent();
                            if (parent != null) {
                                parent.remove(this);
                            }
                        });
                        Disposer.dispose((Disposable)disposable);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/session/DatabaseLogView$PlaceholderComponent$2", "documentChanged"));
                    }
                }, disposable);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)myConsole.getProject()).requestFocus((Component)myConsole, true));
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.myStatusText.paint((Component)this, g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/session/DatabaseLogView$PlaceholderComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class DatabaseServiceViewController<T extends LogViewOwner, V extends LogView<?>>
    implements LogViewController<V> {
        private T myOwner;

        protected DatabaseServiceViewController(@NotNull T owner) {
            if (owner == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(0);
            }
            this.myOwner = owner;
        }

        protected void setOwner(@NotNull T owner) {
            if (owner == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(1);
            }
            this.myOwner = owner;
        }

        @Override
        @NotNull
        public Promise<Void> show(@NotNull V view, boolean activate, boolean requestFocus, @Nullable LogView.OutputType outputType) {
            if (view == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(2);
            }
            view.ensureContentInitialized();
            EditorColorsUtil.updateNotInHierarchyComponentUIAndColors((Component)view.getContent().getComponent());
            Promise<Void> promise = this.selectNode(view.getProject(), this.myOwner, activate, requestFocus, outputType);
            if (promise == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(3);
            }
            return promise;
        }

        @NotNull
        protected abstract Promise<Void> selectNode(@NotNull Project var1, @NotNull T var2, boolean var3, boolean var4, @Nullable LogView.OutputType var5);

        @Override
        @NotNull
        public String id() {
            String string = DatabaseBundle.message("console.session.tab.title", new Object[0]);
            if (string == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseLogView$DatabaseServiceViewController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseLogView$DatabaseServiceViewController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "show";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOwner";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "show";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

