/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.BridgeDataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MultiPageModelImpl;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.TypedKey;
import com.intellij.database.run.audit.TxMarkerAuditor;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DataBusGridUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataBusGridDataHookUp
extends GridDataHookUpBase<GridRow, GridColumn>
implements DataRequest.OwnerEx,
TxMarkerAuditor.TxMarkerHolder {
    protected final DataAuditors.BusyCounter myBusyCounter;
    protected final DataGridListModel myModel;
    private final GridMutationModel myMutationModel;
    private final GridStorageAndModelUpdater myModelUpdater;
    protected final MultiPageModel<GridRow, GridColumn> myPageModel;
    protected final DataBusLoader myLoader;
    protected final MutationsStorage myStorage;
    protected final Map<GridDataRequest, GridRequestSource> myRequestSourceMap;
    private final BridgeDataBus myMessageBus;
    private final TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> myValuesEqual;
    protected final Map<String, Serializable> myDataProperties;

    protected DataBusGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual, @Nullable Function<GridModel<GridRow, GridColumn>, MutationsStorage> storageProvider) {
        if (project == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (valuesEqual == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(2);
        }
        super(project);
        this.myRequestSourceMap = new WeakHashMap<GridDataRequest, GridRequestSource>();
        this.myDataProperties = new HashMap<String, Serializable>();
        this.myMessageBus = new BridgeDataBus(this, messageBus.filterFor(this));
        this.myValuesEqual = valuesEqual;
        this.myBusyCounter = new DataAuditors.BusyCounter();
        this.myMessageBus.addAuditor(this.myBusyCounter);
        this.myModel = new DataGridListModel(this::valuesEqual);
        this.myMutationModel = new GridMutationModel((GridDataHookUp)this);
        this.myStorage = storageProvider == null ? null : storageProvider.apply((GridModel<GridRow, GridColumn>)this.myModel);
        this.myModelUpdater = new GridStorageAndModelUpdater((GridListModelBase)this.myModel, this.myMutationModel, this.myStorage);
        this.myPageModel = new MultiPageModelImpl((GridModel)this.myMutationModel, (DataGridSettings)DatabaseSettings.getSettings());
        this.myLoader = this.createLoader();
        this.myMessageBus.addAuditor(this.createAuditor());
        this.myMessageBus.addConsumer(DataBusGridUtil.createEDTSafeWrapper(this.myLoader, (Disposable)this));
    }

    private Boolean valuesEqual(Object v1, Object v2) {
        return (Boolean)this.myValuesEqual.fun(v1, v2, (Object)this);
    }

    protected void setDataBus(@NotNull DataBus.Consuming bus) {
        if (bus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(3);
        }
        this.myMessageBus.setDataBus(bus);
    }

    @NotNull
    protected DataAuditor createAuditor() {
        return new BusAuditor();
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(4);
        }
        return dataGridListModel;
    }

    @NotNull
    public GridMutationModel getMutationModel() {
        GridMutationModel gridMutationModel = this.myMutationModel;
        if (gridMutationModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(5);
        }
        return gridMutationModel;
    }

    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        MultiPageModel<GridRow, GridColumn> multiPageModel = this.myPageModel;
        if (multiPageModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(6);
        }
        return multiPageModel;
    }

    @NotNull
    public DataBusLoader getLoader() {
        DataBusLoader dataBusLoader = this.myLoader;
        if (dataBusLoader == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(7);
        }
        return dataBusLoader;
    }

    public int getBusyCount() {
        return this.myBusyCounter.getCount();
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        BridgeDataBus bridgeDataBus = this.myMessageBus;
        if (bridgeDataBus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(8);
        }
        return bridgeDataBus;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = DataRequest.NONE;
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(9);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(10);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @NlsSafe
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.notNullize((String)this.myLoader.getQueryText());
        if (string == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void dispose() {
    }

    public int getSubQueryIndex() {
        return this.myLoader.getSubQueryIndex();
    }

    public int getResultSetIndex() {
        return this.myLoader.getResultSetIndex();
    }

    @Nullable
    public String getQueryText() {
        return this.myLoader.getQueryText();
    }

    @Nullable
    public String getUnlimitedQueryText(boolean ordered) {
        return this.getQueryText();
    }

    private <T extends Serializable> void setDataProperty(@NotNull TypedKey<T> key2, @Nullable T value, boolean rewrite) {
        if (key2 == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(12);
        }
        if (rewrite || key2.get(this.myDataProperties) == null) {
            key2.put(this.myDataProperties, value);
        }
    }

    private <T extends Serializable> void resetDataProperty(@NotNull TypedKey<T> key2) {
        if (key2 == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(13);
        }
        key2.remove(this.myDataProperties);
    }

    @NotNull
    protected DataBusLoader createLoader() {
        return new DataBusLoader();
    }

    public void processRequest(@NotNull GridRequestSource source, @NotNull GridDataRequest request2, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(14);
        }
        if (request2 == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(15);
        }
        this.myRequestSourceMap.put(request2, source);
        request2.getPromise().onProcessed(aVoid -> this.onProcessed(source, request2, reloadPolicy));
        this.myMessageBus.getDataProducer().processRequest(request2);
    }

    protected void onProcessed(@NotNull GridRequestSource source, @NotNull GridDataRequest request2, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(16);
        }
        if (request2 == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(17);
        }
        boolean isSucceeded = request2.getPromise().isSucceeded();
        if (reloadPolicy == ReloadPolicy.WHEN_PROCESSED || reloadPolicy == ReloadPolicy.WHEN_DONE && isSucceeded) {
            this.myLoader.reloadCurrentPage(source);
        } else {
            this.requestFinished(source, isSucceeded, reloadPolicy);
        }
    }

    protected void requestFinished(@NotNull GridRequestSource source, boolean isSucceeded, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(18);
        }
        this.notifyRequestFinished(source, isSucceeded);
    }

    @Nullable
    public DbDataSource getDataSource() {
        return null;
    }

    @Nullable
    public Dbms getDbms() {
        DbDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return null;
        }
        return dataSource.getDbms();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.getDbms());
        if (databaseDialectEx == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(19);
        }
        return databaseDialectEx;
    }

    protected int getPageSizeForRequest(@NotNull GridRequestSource source) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(20);
        }
        return this.myPageModel.getPageSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 11, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDataBus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDataProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetDataProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onProcessed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "requestFinished";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPageSizeForRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 11, 19 -> new IllegalStateException(string);
        };
    }

    public class DataBusLoader
    implements DataConsumer,
    GridLoader {
        @Nullable
        private String myQueryText;
        private boolean myQueryInvalidated;
        private boolean myTotalRowCountInvalidated;
        private int mySubQueryIndex;
        private int myResultSetIndex;
        private int myRowsLoaded = -1;

        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(1);
            }
            DataBusGridDataHookUp.this.resetDataProperty(DmlHelper.Companion.getCOLUMNS_CHANGED_DURING_FETCH());
            DataBusGridDataHookUp.this.resetDataProperty(DmlHelper.Companion.getMULTIPLE_ROWS_WITH_THE_SAME_NUMBER());
            DataRequest.Context c2 = (DataRequest.Context)((Object)ObjectUtils.tryCast((Object)context, DataRequest.Context.class));
            boolean sameQuery = Objects.equals(this.myQueryText, c2 == null ? null : c2.getQuery());
            if (!sameQuery || this.myTotalRowCountInvalidated) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(0L, false);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageStart(firstRowNum);
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(firstRowNum - 1);
            this.myRowsLoaded = 0;
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(true);
            this.mySubQueryIndex = subQueryIndex;
            this.myResultSetIndex = resultSetIndex;
            this.setQueryText(c2 == null ? null : c2.getQuery());
            if (c2 != null) {
                DataBusGridDataHookUp.this.setCurrentTx(c2.txMarker);
            }
            columns = this.prepareColumns(columns);
            boolean sameColumns = this.sameColumnsAsInModel(columns);
            if (!sameQuery || !sameColumns) {
                DataBusGridDataHookUp.this.myModelUpdater.removeRows(0, DataBusGridDataHookUp.this.myMutationModel.getRowCount());
                DataBusGridDataHookUp.this.myModelUpdater.setColumns(Arrays.asList(columns));
            } else if (DataBusGridDataHookUp.this.myStorage != null) {
                DataBusGridDataHookUp.this.myStorage.clearColumns();
            }
            this.validateRowCount();
        }

        public void updateColumns(@NotNull GridDataRequest.Context context, GridColumn @NotNull [] columns) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(2);
            }
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(3);
            }
            GridColumn[] preparedColumns = this.prepareColumns(columns);
            boolean sameColumns = this.sameColumnsAsInModel(preparedColumns);
            DataBusGridDataHookUp.this.setDataProperty(DmlHelper.Companion.getCOLUMNS_CHANGED_DURING_FETCH(), !sameColumns, false);
            if (!sameColumns) {
                DataBusGridDataHookUp.this.myModelUpdater.setColumns(Arrays.asList(preparedColumns));
            }
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(4);
            }
            if (rows == null) {
                DataBusLoader.$$$reportNull$$$0(5);
            }
            if (rows.isEmpty()) {
                return;
            }
            if (this.myRowsLoaded == 0) {
                DataBusGridDataHookUp.this.myPageModel.setPageStart(rows.get(0).getRowNum());
            }
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(rows.get(rows.size() - 1).getRowNum());
            DataBusGridDataHookUp.this.myModelUpdater.setRows(this.myRowsLoaded, rows, new GridRequestSource(null));
            this.myRowsLoaded += rows.size();
            DataBusGridDataHookUp.this.setDataProperty(DmlHelper.Companion.getMULTIPLE_ROWS_WITH_THE_SAME_NUMBER(), this.myRowsLoaded > DataBusGridDataHookUp.this.myPageModel.getPageSize(), true);
        }

        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(6);
            }
            if (this.myRowsLoaded >= 0 && this.myRowsLoaded < DataBusGridDataHookUp.this.myMutationModel.getRowCount()) {
                int rowsToRemove = DataBusGridDataHookUp.this.myMutationModel.getRowCount() - this.myRowsLoaded;
                DataBusGridDataHookUp.this.myModelUpdater.removeRows(DataBusGridDataHookUp.this.myMutationModel.getRowCount() - rowsToRemove, rowsToRemove);
            }
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(false);
            DataRequest.Context c2 = (DataRequest.Context)((Object)ObjectUtils.tryCast((Object)context, DataRequest.Context.class));
            this.setTotalRowCount(c2 == null ? null : DataBusGridDataHookUp.this.myRequestSourceMap.get((Object)c2.request), total);
            DataBusGridDataHookUp.this.myMutationModel.afterLastRowAdded();
        }

        protected void setTotalRowCount(@Nullable GridRequestSource source, int total) {
            if ((long)total > DataBusGridDataHookUp.this.myPageModel.getTotalRowCount() || DataBusGridDataHookUp.this.myPageModel.getPageEnd() == total) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount((long)total, DataBusGridDataHookUp.this.myPageModel.getPageEnd() >= total);
            }
        }

        public void reloadCurrentPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(7);
            }
            this.reloadCurrentPage(source, null);
        }

        public void reloadCurrentPage(@NotNull GridRequestSource source, @Nullable ReloadPolicy reloadPolicy) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(8);
            }
            this.load(source, this.getCurrentPageOffset(), reloadPolicy);
        }

        private int getCurrentPageOffset() {
            return Math.max(0, DataBusGridDataHookUp.this.myPageModel.getPageStart() - 1);
        }

        public void loadNextPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(9);
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageEnd());
        }

        public void loadPreviousPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(10);
            }
            this.load(source, Math.max(0, DataBusGridDataHookUp.this.myPageModel.getPageStart() - DataBusGridDataHookUp.this.myPageModel.getPageSize() - 1));
        }

        public void loadLastPage(@NotNull GridRequestSource source) {
            int pageSize;
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(11);
            }
            this.load(source, -((pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize()) > 0 ? pageSize : 100) - 1);
        }

        public void loadFirstPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(12);
            }
            this.load(source, 0);
        }

        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(13);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        public void applyFilterAndSorting(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(14);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        public void updateIsTotalRowCountUpdateable() {
            this.updateQueryText();
        }

        protected void tablePrepared() {
        }

        @Nullable
        public String getQueryText() {
            return this.myQueryText;
        }

        public int getSubQueryIndex() {
            return this.mySubQueryIndex;
        }

        public int getResultSetIndex() {
            return this.myResultSetIndex;
        }

        public void invalidateQuery() {
            this.myQueryInvalidated = true;
        }

        public void load(@NotNull GridRequestSource source, int offset) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(15);
            }
            this.load(source, offset, null);
        }

        protected void load(@NotNull GridRequestSource source, int offset, @Nullable ReloadPolicy reloadPolicy) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(16);
            }
            this.tryApplyCurrentFilterText();
            this.tryApplyCurrentSorting();
            int queryOffset = this.updateQueryText(offset, source);
            if (this.myQueryText == null) {
                DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DataBusGridDataHookUp owner = DataBusGridDataHookUp.this;
            int resultOffset = queryOffset == 0 ? offset : 0;
            int pageSize = DataBusGridDataHookUp.this.getPageSizeForRequest(source);
            GridDataRequest r = DataRequest.newRequest(owner, this.myQueryText, resultOffset, queryOffset, pageSize, this.mySubQueryIndex, this.myResultSetIndex);
            DataBusGridDataHookUp.this.processRequest(source, r, reloadPolicy != null ? reloadPolicy : ReloadPolicy.DO_NOT_RELOAD);
        }

        private int updateQueryText(int offset, @Nullable GridRequestSource source) {
            if (!this.canUpdateQueryText()) {
                return 0;
            }
            boolean unlimited = GridUtilCore.isPageSizeUnlimited((int)DataBusGridDataHookUp.this.myPageModel.getPageSize());
            if (unlimited) {
                this.updateQueryText(QueryAttributes.unlimited(true), source);
                return 0;
            }
            if (this.canUseOffset()) {
                this.updateQueryText(QueryAttributes.limited(offset, DataBusGridDataHookUp.this.myPageModel.getPageSize() + 1, true), source);
                return offset;
            }
            this.updateQueryText(QueryAttributes.limited(0, offset + DataBusGridDataHookUp.this.myPageModel.getPageSize() + 1, true), source);
            return 0;
        }

        public void updateQueryText() {
            this.updateQueryText(this.getCurrentPageOffset(), null);
        }

        private void tryApplyCurrentFilterText() {
            GridFilteringModel model = DataBusGridDataHookUp.this.getFilteringModel();
            if (model == null) {
                return;
            }
            if (!model.isIgnoreCurrentText()) {
                model.applyCurrentText();
            } else {
                model.setIgnoreCurrentText(false);
            }
        }

        private void tryApplyCurrentSorting() {
            GridSortingModel model = DataBusGridDataHookUp.this.getSortingModel();
            if (model == null) {
                return;
            }
            model.apply();
        }

        public boolean canUseOffset() {
            return false;
        }

        protected boolean canUpdateQueryText() {
            return false;
        }

        protected final void updateQueryText(@NotNull QueryAttributes attributes, @Nullable GridRequestSource source) {
            if (attributes == null) {
                DataBusLoader.$$$reportNull$$$0(17);
            }
            if (this.canUpdateQueryText()) {
                this.setQueryText(this.createQueryText(attributes, source));
                this.queryTextUpdated();
            }
        }

        protected void queryTextUpdated() {
        }

        @Nullable
        protected String createQueryText(@NotNull QueryAttributes attributes, @Nullable GridRequestSource source) {
            if (attributes == null) {
                DataBusLoader.$$$reportNull$$$0(18);
            }
            return null;
        }

        protected GridColumn[] prepareColumns(GridColumn @NotNull [] columns) {
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(19);
            }
            return columns;
        }

        protected void setQueryText(@Nullable String query) {
            this.myQueryText = query;
            this.validateQuery();
        }

        protected void invalidateRowCount() {
            this.myTotalRowCountInvalidated = true;
        }

        protected boolean isQueryInvalidated() {
            return this.myQueryInvalidated;
        }

        protected boolean sameColumnsAsInModel(GridColumn[] columns) {
            if (columns.length != DataBusGridDataHookUp.this.myMutationModel.getColumnCount()) {
                return false;
            }
            for (int i2 = 0; i2 < columns.length; ++i2) {
                if (Comparing.equal((Object)columns[i2], (Object)DataBusGridDataHookUp.this.myMutationModel.getColumn(ModelIndex.forColumn((GridModel)DataBusGridDataHookUp.this.myMutationModel, (int)i2)))) continue;
                return false;
            }
            return true;
        }

        private void validateQuery() {
            this.myQueryInvalidated = false;
        }

        private void validateRowCount() {
            this.myTotalRowCountInvalidated = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColumns";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reloadCurrentPage";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadNextPage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadPreviousPage";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadLastPage";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFirstPage";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateTotalRowCount";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilterAndSorting";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateQueryText";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createQueryText";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareColumns";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class BusAuditor
    implements DataAuditor {
        protected BusAuditor() {
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
            GridRequestSource source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(0);
            }
            if (errorInfo == null) {
                BusAuditor.$$$reportNull$$$0(1);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get((Object)context.request)) != null) {
                DataBusGridDataHookUp.this.notifyRequestError(source, errorInfo);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
            GridRequestSource source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(2);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get((Object)context.request)) != null) {
                DataBusGridDataHookUp.this.notifyUpdateCountReceived(source, updateCount2);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, @NotNull DataAuditor.TxEvent event) {
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(3);
            }
            if (event == null) {
                BusAuditor.$$$reportNull$$$0(4);
            }
            if (!event.reverted || !this.reloadOnRollback()) {
                return;
            }
            int offset = DataBusGridDataHookUp.this.myPageModel.getPageStart() - 1;
            int pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize();
            DataBusGridDataHookUp.this.myLoader.updateQueryText(GridUtilCore.isPageSizeUnlimited((int)pageSize) ? QueryAttributes.unlimited(true) : QueryAttributes.limited(0, offset + pageSize + 1, true), null);
            String query = Objects.requireNonNull(DataBusGridDataHookUp.this.myLoader.getQueryText());
            int subQueryIdx = DataBusGridDataHookUp.this.myLoader.getSubQueryIndex();
            int resultSetIdx = DataBusGridDataHookUp.this.myLoader.getResultSetIndex();
            DataRequest.Constraints constraints = DataRequest.newConstraints(offset, pageSize, 0, subQueryIdx, resultSetIdx);
            GridDataRequest request2 = DataRequest.newRequest(DataBusGridDataHookUp.this, DataRequest.AUTO_COMMIT, query, constraints);
            request2.getPromise().onProcessed(aVoid -> DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW));
            DataBusGridDataHookUp.this.myMessageBus.getDataProducer().processRequest(request2);
        }

        protected boolean reloadOnRollback() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$BusAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ReloadPolicy {
        WHEN_DONE,
        WHEN_PROCESSED,
        DO_NOT_RELOAD;

    }

    public static final class QueryAttributes {
        private final Integer limit;
        private final Integer offset;
        private final boolean ordered;

        private QueryAttributes(@Nullable Integer offset, @Nullable Integer limit, boolean ordered) {
            this.offset = offset;
            this.limit = limit;
            this.ordered = ordered;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        @NotNull
        public OptionalInt offset() {
            OptionalInt optionalInt = this.offset == null ? OptionalInt.empty() : OptionalInt.of(this.offset);
            if (optionalInt == null) {
                QueryAttributes.$$$reportNull$$$0(0);
            }
            return optionalInt;
        }

        @NotNull
        public OptionalInt limit() {
            OptionalInt optionalInt = this.limit == null ? OptionalInt.empty() : OptionalInt.of(this.limit);
            if (optionalInt == null) {
                QueryAttributes.$$$reportNull$$$0(1);
            }
            return optionalInt;
        }

        @NotNull
        public static QueryAttributes unlimited(boolean ordered) {
            return new QueryAttributes(null, null, ordered);
        }

        @NotNull
        public static QueryAttributes limited(int offset, int limit, boolean order) {
            return new QueryAttributes(offset, limit, order);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp$QueryAttributes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "offset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "limit";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

