/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CharsetComponent
implements ImportComponent<Object, CsvPreviewComponent.CharsetInfo> {
    private final ComboBox<Charset> myBox;
    private final JPanel myPanel;
    private final CsvPreviewModel myModel;

    public CharsetComponent(@NotNull CsvPreviewModel model) {
        if (model == null) {
            CharsetComponent.$$$reportNull$$$0(0);
        }
        this.myModel = model;
        this.myBox = new ComboBox((Object[])CharsetToolkit.getAvailableCharsets());
        this.myBox.setSelectedItem((Object)model.getCharset());
        this.myPanel = this.createPanel();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CharsetComponent.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder, @NotNull ImportEditorContext context) {
        if (builder == null) {
            CharsetComponent.$$$reportNull$$$0(2);
        }
        if (context == null) {
            CharsetComponent.$$$reportNull$$$0(3);
        }
        this.myModel.acceptCharset();
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            CharsetComponent.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            CharsetComponent.$$$reportNull$$$0(5);
        }
        this.myBox.addActionListener(e -> listener2.changed(this, this.getCharsetInfo()));
    }

    @Override
    @NotNull
    public CompletionStage<CsvPreviewComponent.CharsetInfo> notifyChanged(@NotNull Object object) {
        if (object == null) {
            CharsetComponent.$$$reportNull$$$0(6);
        }
        CompletableFuture<CsvPreviewComponent.CharsetInfo> completableFuture = CompletableFuture.completedFuture(this.getCharsetInfo());
        if (completableFuture == null) {
            CharsetComponent.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            CharsetComponent.$$$reportNull$$$0(8);
        }
        return observer instanceof CsvPreviewComponent;
    }

    @NotNull
    private CsvPreviewComponent.CharsetInfo getCharsetInfo() {
        return new CsvPreviewComponent.CharsetInfo((Charset)this.myBox.getSelectedItem());
    }

    @NotNull
    private JPanel createPanel() {
        JPanel encodingPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        encodingPanel.add((Component)new JBLabel(DatabaseBundle.message("label.encoding", new Object[0])));
        encodingPanel.add((Component)this.myBox);
        JPanel jPanel = encodingPanel;
        if (jPanel == null) {
            CharsetComponent.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CharsetComponent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CharsetComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 9 -> new IllegalStateException(string);
        };
    }
}

