/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DialectUtils {
    public static final String ALIAS = "t";

    public static <T, M extends BasicModModel, R extends BasicModRoot> T withNewModel(Dbms dbms, Class<M> modelClass, Class<R> rootClass, Function<? super R, ? extends T> function) {
        M model = new ModelFactory(new MemoryTextStorage()).createModel(dbms, modelClass);
        Ref resultRef = Ref.create();
        model.modify(rootClass, root -> resultRef.set(function.fun(root)));
        return (T)resultRef.get();
    }

    public static <T extends BasicModNamedElement> T create(ModNamingFamily<? extends T> f, DasObject copy) {
        if (copy == null) {
            return DialectUtils.create(f, "");
        }
        T obj2 = f.createOrGet(copy.getName());
        obj2.setNameScripted(DbSqlUtilCore.isSqlObject(copy));
        obj2.setNameQuoted(DbSqlUtilCore.isQuoted(copy));
        return obj2;
    }

    public static <T extends BasicModNamedElement> T create(ModNamingFamily<? extends T> f, String name2) {
        T obj2 = f.createOrGet(name2);
        obj2.setNameScripted(true);
        obj2.setNameQuoted(false);
        return obj2;
    }

    public static DdlBuilder getDropSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasObject sequence, @Nullable Boolean cascade) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(0);
        }
        if (sequence == null) {
            DialectUtils.$$$reportNull$$$0(1);
        }
        builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (cascade != null) {
            builder.space().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static DdlBuilder getDropViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view, @Nullable Boolean cascade) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(2);
        }
        if (view == null) {
            DialectUtils.$$$reportNull$$$0(3);
        }
        builder.keyword("DROP").space().keyword("VIEW").space().qualifiedRef(view);
        if (cascade != null) {
            builder.space();
            builder.keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode, int dirPos, boolean inOutSeparate) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(4);
        }
        ArgumentDirection parameterType = parameter.getArgumentDirection();
        if (dirPos == 0) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, true);
        }
        if (longMode && StringUtil.isNotEmpty((String)parameter.getName())) {
            if (builder.getDialect().getDbms().isTransactSql()) {
                builder.plain(parameter.getName()).space();
            } else {
                builder.identifier(parameter, parameter.getName()).space();
            }
        }
        if (dirPos == 1) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, true);
        }
        builder.type(parameter);
        if (dirPos == 2) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, false);
        }
    }

    public static void sqlParameterDirection(@NotNull DdlBuilder builder, ArgumentDirection parameterType, boolean inOutSeparate, boolean space) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(5);
        }
        if (parameterType != ArgumentDirection.IN) {
            if (!space) {
                builder.space();
            }
            if (inOutSeparate && parameterType == ArgumentDirection.INOUT) {
                builder.keywords("IN", "OUT");
            } else {
                builder.keyword(parameterType.name());
            }
            if (space) {
                builder.space();
            }
        }
    }

    public static <E> Iterable<E> resolve(final @NotNull MultiRef<E> ref2) {
        if (ref2 == null) {
            DialectUtils.$$$reportNull$$$0(6);
        }
        return new Iterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    final MultiRef.It<E> it;
                    {
                        this.it = ref2.iterate();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public E next() {
                        this.it.next();
                        return this.it.resolve();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
    }

    public static DdlBuilder getCreateViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(7);
        }
        if (view == null) {
            DialectUtils.$$$reportNull$$$0(8);
        }
        if (definition == null) {
            DialectUtils.$$$reportNull$$$0(9);
        }
        builder.keywords("CREATE", "VIEW").space().qualifiedRef(view).space().keyword("AS").space().plain(definition);
        return builder;
    }

    @NotNull
    public static String sqlConcat(@NotNull List<String> statements2) {
        if (statements2 == null) {
            DialectUtils.$$$reportNull$$$0(10);
        }
        String string = StringUtil.join(statements2, (String)";\n") + (statements2.isEmpty() ? "" : ";");
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static void appendStringList(DdlBuilder builder, Iterable<String> columns) {
        DialectUtils.appendCommaSeparated(builder, ContainerUtil.map(columns, column2 -> b -> b.columnRef((String)column2)));
    }

    public static void appendCommaSeparated(DdlBuilder builder, Iterable<? extends Consumer<DdlBuilder>> values) {
        boolean first2 = true;
        for (Consumer<DdlBuilder> consumer : values) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            consumer.consume((Object)builder);
        }
    }

    public static DdlBuilder sqlDropProcedure(DdlBuilder builder, DasRoutine procedure, boolean ifExists) {
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type).space();
        if (ifExists) {
            builder.keywords("IF", "EXISTS").space();
        }
        return builder.qualifiedRef(procedure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DialectUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DialectUtils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlConcat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDropSequenceSQL";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDropViewSQL";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameterDirection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCreateViewSQL";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlConcat";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

