/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.DbmsOutputHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/OracleDbmsOutputHandler;", "Lcom/intellij/database/dialects/base/DbmsOutputHandler;", "<init>", "()V", "enable", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "buf", "", "disable", "processOutput", "consumer", "Lkotlin/Function1;", "", "Companion", "intellij.database.dialects.base.ex"})
public final class OracleDbmsOutputHandler
extends DbmsOutputHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    public static final String cmdEnable = "begin sys.dbms_output.enable(BUF); end;";
    @Deprecated
    @NotNull
    public static final String cmdDisable = "begin sys.dbms_output.disable; end;";
    @Deprecated
    @NotNull
    public static final String cmdGetLine = "begin sys.dbms_output.get_line(?, ?); end;";

    @Override
    public void enable(@NotNull DatabaseConnection connection2, int buf) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        this.execute(connection2, StringsKt.replace$default((String)cmdEnable, (String)"BUF", (String)String.valueOf(buf), (boolean)false, (int)4, null));
    }

    @Override
    public void disable(@NotNull DatabaseConnection connection2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        this.execute(connection2, cmdDisable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processOutput(@NotNull DatabaseConnection connection2, @NotNull Function1<? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        CallableStatementBasis basis = new StatementParameters().parameter(1, 12).parameter(2, 4).asCallBasis(cmdGetLine);
        ReusableSmartStatement<ParameterizedStatementDecoration> statement2 = SmartStatements.Companion.poweredBy(connection2).call(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).reuse(basis);
        AutoCloseable autoCloseable = statement2;
        Throwable throwable = null;
        try {
            int n;
            int status;
            ReusableSmartStatement call = (ReusableSmartStatement)autoCloseable;
            boolean bl = false;
            do {
                AutoCloseable autoCloseable2 = call.noisy().execute(StatementParameters.Companion.getEmpty(), StandardExecutionMode.GENERIC);
                Throwable throwable2 = null;
                try {
                    ClosableResultsProducer producer = (ClosableResultsProducer)autoCloseable2;
                    boolean bl2 = false;
                    Object object = producer.getParameterValue(1);
                    String string = object instanceof String ? (String)object : null;
                    if (string != null) {
                        consumer.invoke((Object)string);
                    }
                    Object object2 = producer.getParameterValue(2);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                    n = (Integer)object2;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
            } while ((status = n) == 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/base/OracleDbmsOutputHandler$Companion;", "", "<init>", "()V", "cmdEnable", "", "cmdDisable", "cmdGetLine", "intellij.database.dialects.base.ex"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

