/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;

public final class HiveDomains
extends BaseDomainRegistry {
    private static final int VARCHAR_MAX_LENGTH = 65535;
    private static final int CHAR_MAX_LENGTH = 255;
    private static final int DECIMAL_MAX_SCALE = 38;
    private static final int DECIMAL_MAX_PRECISION = 38;

    public HiveDomains() {
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases("int"));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, 1.4E-45f, 3.4028234663852886E38));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE).withAliases("double precision"));
        this.add(new Number2Domain("decimal", ConversionPoint.NUMBER, 38, 38, true).withAliases("numeric"));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, Integer.MAX_VALUE));
        this.add(new FractionDomain("timestamp with local time zone", ConversionPoint.TIMESTAMP, Integer.MAX_VALUE).withAliases("timestamplocaltz"));
        this.add(new SimpleDomain("date", ConversionPoint.DATE));
        this.add(new TextLikeDomain("interval_year_month", ConversionPoint.INTERVAL));
        this.add(new TextLikeDomain("interval_day_time", ConversionPoint.INTERVAL));
        this.add(new TextDomain("string", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 65535L, TextDomain.Length.mandatory(65535L, true)));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, TextDomain.Length.mandatory(255L, false)));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new BinaryDomain("binary", ConversionPoint.VARBINARY, Integer.MAX_VALUE));
        this.add(new SimpleDomain("array", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("struct", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("map", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
    }
}

