/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DatabaseTargetChooser;
import com.intellij.database.dbimport.ui.tree.DatabaseChooseByNamePanel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinIntrospectableArea;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.diff.DbDiffCheckOption;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.diff.DbMigrationAction;
import com.intellij.database.model.diff.SchemaDiffCustomization;
import com.intellij.database.model.diff.SchemaDiffRequest;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.migration.DbMigrationDialog;
import com.intellij.database.model.migration.DbMigrationOptions;
import com.intellij.database.model.migration.DbMigrationOptionsService;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.statistic.SchemaDiffUsagesCollector;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaDiffAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SchemaDiffAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SchemaDiffAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        BasicNode[] selected = DatabaseContextFun.getSelectedNodesArray(e.getDataContext());
        boolean enabled = project != null && (SchemaDiffAction.getElementsPair(project, selected) != null || SchemaDiffAction.getSingleElement(project, selected) != null || SchemaDiffAction.getFamiliesPair(selected) != null);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SchemaDiffAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        BasicNode[] selected = DatabaseContextFun.getSelectedNodesArray(e.getDataContext());
        Pair<DbElement, DbElement> elements = SchemaDiffAction.getElementsPair(project, selected);
        if (elements != null) {
            this.showDiff((DbElement)elements.first, (DbElement)elements.second);
            return;
        }
        DbElement element = SchemaDiffAction.getSingleElement(project, selected);
        if (element != null) {
            this.showDiffWithChooser(element);
            return;
        }
        Pair<Family<?>, Family<?>> families = SchemaDiffAction.getFamiliesPair(selected);
        if (families != null) {
            List<DbElement> fromRoots = SchemaDiffAction.getChildren(project, (Family)families.first);
            List<DbElement> toRoots = SchemaDiffAction.getChildren(project, (Family)families.second);
            SchemaDiffAction.showDiff2(fromRoots, toRoots);
        }
    }

    @NotNull
    private static List<DbElement> getChildren(Project project, Family<?> family) {
        List list = family.jbi().map(el -> SchemaDiffAction.getDbElement(project, el)).toList();
        if (list == null) {
            SchemaDiffAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static Pair<DbElement, DbElement> getElementsPair(@NotNull Project project, BasicNode @NotNull [] nodes2) {
        if (project == null) {
            SchemaDiffAction.$$$reportNull$$$0(4);
        }
        if (nodes2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(5);
        }
        if (nodes2.length != 2) {
            return null;
        }
        boolean bothModelElements = ContainerUtil.and((Object[])nodes2, (Condition)Conditions.instanceOf(BasicElement.class));
        boolean bothDataSources = ContainerUtil.and((Object[])nodes2, (Condition)Conditions.instanceOf(DataSourceNode.class));
        return bothModelElements || bothDataSources ? SchemaDiffAction.alignElements(SchemaDiffAction.getDbElement(project, nodes2[0]), SchemaDiffAction.getDbElement(project, nodes2[1])) : null;
    }

    @Nullable
    private static DbElement getSingleElement(@NotNull Project project, BasicNode @NotNull [] nodes2) {
        if (project == null) {
            SchemaDiffAction.$$$reportNull$$$0(6);
        }
        if (nodes2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(7);
        }
        if (nodes2.length != 1) {
            return null;
        }
        return nodes2[0] instanceof BasicElement ? SchemaDiffAction.getDbElement(project, nodes2[0]) : null;
    }

    @Nullable
    private static DbElement getDbElement(@NotNull Project project, @NotNull BasicNode from) {
        if (project == null) {
            SchemaDiffAction.$$$reportNull$$$0(8);
        }
        if (from == null) {
            SchemaDiffAction.$$$reportNull$$$0(9);
        }
        return (DbElement)((DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class)).wrap(from);
    }

    private static Pair<Family<?>, Family<?>> getFamiliesPair(BasicNode @NotNull [] nodes2) {
        if (nodes2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(10);
        }
        if (nodes2.length != 2) {
            return null;
        }
        Family first2 = (Family)ObjectUtils.tryCast((Object)nodes2[0], Family.class);
        Family second = (Family)ObjectUtils.tryCast((Object)nodes2[1], Family.class);
        if (first2 == null || second == null) {
            return null;
        }
        if (first2.getMetaObject().kind != second.getMetaObject().kind) {
            return null;
        }
        return Pair.create((Object)first2, (Object)second);
    }

    private void showDiffWithChooser(@NotNull DbElement single) {
        if (single == null) {
            SchemaDiffAction.$$$reportNull$$$0(11);
        }
        HashSet kinds = new HashSet();
        SchemaDiffAction.fillPossible(single, o -> kinds.add(o.getKind()));
        DbElement element = new DatabaseTargetChooser(single.getProject(), "", new DatabaseChooseByNamePanel.DatabaseChooseByNameContributor(kinds.toArray(new ObjectKind[0]))).choose(DatabaseBundle.message("compare.with", new Object[0]));
        if (element == null) {
            return;
        }
        Pair<DbElement, DbElement> aligned = SchemaDiffAction.alignElements(single, element);
        if (aligned == null) {
            return;
        }
        this.showDiff((DbElement)aligned.first, (DbElement)aligned.second);
    }

    public void showDiff(@NotNull DbElement from, @NotNull DbElement to) {
        if (from == null) {
            SchemaDiffAction.$$$reportNull$$$0(12);
        }
        if (to == null) {
            SchemaDiffAction.$$$reportNull$$$0(13);
        }
        SchemaDiffAction.showDiff2(Collections.singletonList(from), Collections.singletonList(to));
    }

    private static void showDiff2(@NotNull List<DbElement> from, @NotNull List<DbElement> to) {
        Couple<DbDiffElement> elements;
        if (from == null) {
            SchemaDiffAction.$$$reportNull$$$0(14);
        }
        if (to == null) {
            SchemaDiffAction.$$$reportNull$$$0(15);
        }
        DbElement f = (DbElement)ContainerUtil.getFirstItem(from);
        DbElement t = (DbElement)ContainerUtil.getFirstItem(to);
        if (f == null || t == null) {
            return;
        }
        SchemaDiffUsagesCollector.log(f.getDataSource(), t.getDataSource());
        DirDiffSettings settings = SchemaDiffAction.createSettings(f.getDataSource().getDbms(), t.getDataSource().getDbms());
        for (SchemaDiffCustomization customization : SchemaDiffCustomization.getEP().getExtensionList()) {
            customization.modifySettings(f.getProject(), f, t, settings);
        }
        Couple<DbDiffElement> couple = elements = from.size() == 1 && to.size() == 1 ? SchemaDiffAction.createElements(f, t, settings) : SchemaDiffAction.createElementsWithMultipleRoots(from, to, settings);
        if (elements == null) {
            String message = DatabaseBundle.message("dialog.message.schema.diff.error", new Object[0]);
            Messages.showErrorDialog((Project)f.getProject(), (String)message, (String)CommonBundle.getErrorTitle());
            return;
        }
        if (SchemaDiffAction.abortForLowIntrospectionLevel(elements)) {
            return;
        }
        if (Registry.is((String)"database.legacy.schema.diff")) {
            SchemaDiffRequest request2 = new SchemaDiffRequest((DbDiffElement)((Object)elements.first), (DbDiffElement)((Object)elements.second));
            DiffManager.getInstance().showDiff(f.getProject(), (DiffRequest)request2, DiffDialogHints.MODAL);
        } else {
            DbMigrationOptions migrationOptions = ((DbMigrationOptionsService)f.getProject().getService(DbMigrationOptionsService.class)).getOptions();
            new DbMigrationDialog(new DbMigrationRequest(elements, migrationOptions)).show();
        }
    }

    private static boolean abortForLowIntrospectionLevel(Couple<DbDiffElement> roots2) {
        LoaderContext first2 = SchemaDiffAction.createLoaderContext((DbDiffElement)((Object)roots2.first));
        LoaderContext second = SchemaDiffAction.createLoaderContext((DbDiffElement)((Object)roots2.second));
        if (first2 == null && second == null) {
            return false;
        }
        Project project = ((DbDiffElement)((Object)roots2.first)).getRoot().getProject();
        return DatabaseUiService.getInstance().confirmAndRunSync(project, DatabaseBundle.message("dialog.title.migration", new Object[0]), () -> SchemaDiffAction.performSyncTask(first2, second));
    }

    private static void performSyncTask(LoaderContext first2, LoaderContext second) {
        if (first2 != null && second != null && first2.getDataSource() == second.getDataSource()) {
            DataSourceUtil.performManualSyncTask(first2.merge(second));
        } else {
            if (first2 != null) {
                DataSourceUtil.performManualSyncTask(first2);
            }
            if (second != null) {
                DataSourceUtil.performManualSyncTask(second);
            }
        }
    }

    @Nullable
    private static LoaderContext createLoaderContext(DbDiffElement element) {
        return DetailsSyncHelper.of(element.getRoot().getDataSource()).check(element.getValue()).prepareContextIfIntrospectionIsNeeded();
    }

    @NotNull
    public static DirDiffSettings createSettings(@NotNull Dbms dbms1, @NotNull Dbms dbms2) {
        if (dbms1 == null) {
            SchemaDiffAction.$$$reportNull$$$0(16);
        }
        if (dbms2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(17);
        }
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.enableSyncActions = false;
        DefaultActionGroup options = new DefaultActionGroup(DatabaseBundle.message("action.options.text", new Object[0]), true);
        options.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        SchemaDiffAction.addActionOption(settings, "IGNORE_ORDER", DatabaseBundle.message("action.ignore.order.text", new Object[0]), "alt O", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_CASE", DatabaseBundle.message("action.ignore.case.text", new Object[0]), "alt C", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_IMPLICIT_OBJECTS", DatabaseBundle.message("action.ignore.implicit.objects.text", new Object[0]), "alt I", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_SOURCE_CODE", DatabaseBundle.message("action.ignore.source.code.text", new Object[0]), "alt S", options);
        ScriptGenerator sg1 = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms1);
        ScriptGenerator sg2 = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms2);
        if (sg1.isOptionSupported(ScriptingOptionStatic.IGNORE_OWNER) || sg2.isOptionSupported(ScriptingOptionStatic.IGNORE_OWNER)) {
            SchemaDiffAction.addActionOption(settings, "PG_IGNORE_OWNER", DatabaseBundle.message("action.ignore.owner.text", new Object[0]), "alt W", options);
        }
        if (sg1.isOptionSupported(ScriptingOptionStatic.IGNORE_DEFINER) || sg2.isOptionSupported(ScriptingOptionStatic.IGNORE_DEFINER)) {
            SchemaDiffAction.addActionOption(settings, "MYSQL_IGNORE_DEFINER", DatabaseBundle.message("action.ignore.definer.text", new Object[0]), "alt D", options);
        }
        settings.addExtraAction((AnAction)options);
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        DirDiffSettings dirDiffSettings = settings;
        if (dirDiffSettings == null) {
            SchemaDiffAction.$$$reportNull$$$0(18);
        }
        return dirDiffSettings;
    }

    private static void addActionOption(DirDiffSettings settings, String key2, @NlsActions.ActionText String text, String shortcut, DefaultActionGroup options) {
        settings.customSettings.put(key2, DbDiffCheckOption.getOption(key2));
        options.add((AnAction)new DbDiffCheckOption(key2, text, shortcut));
    }

    @Nullable
    public static Couple<DbDiffElement> createElements(DbElement e1, DbElement e2, DirDiffSettings settings) {
        BasicElement b1 = SchemaDiffAction.getElement(e1);
        BasicElement b2 = SchemaDiffAction.getElement(e2);
        if (b1 == null || b2 == null) {
            return null;
        }
        boolean stepUp = !DbDiffElement.isContainer(b1) && !DbDiffElement.isContainer(b2);
        DbDiffElement de1 = SchemaDiffAction.createElement(e1, settings, e2, stepUp);
        DbDiffElement de2 = SchemaDiffAction.createElement(e2, settings, e1, stepUp);
        return de1 != null && de2 != null ? Couple.of((Object)((Object)de1), (Object)((Object)de2)) : null;
    }

    @Nullable
    private static BasicElement getElement(DbElement e) {
        if (e instanceof DbDataSource) {
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)((DbDataSource)e).getModel(), BasicModel.class);
            return model == null ? null : model.getRoot();
        }
        return (BasicElement)ObjectUtils.tryCast((Object)e.getDelegate(), BasicElement.class);
    }

    @Nullable
    public static DbDiffElement createElement(DbElement element, DirDiffSettings settings, DbElement other, boolean stepUp) {
        BasicElement e = SchemaDiffAction.getElement(element);
        if (e == null) {
            return null;
        }
        BasicElement realRoot = !stepUp || e.getParent() == null ? e : e.getParent();
        DbDiffRoot root = new DbDiffRoot(element.getDataSource(), settings, DbImplUtilCore.getDbms(other), e);
        BasicModElement altElement = SchemaDiffAction.createAltElement(root.getAltModel(), realRoot);
        return altElement == null ? null : new DbDiffElement(root, realRoot, altElement);
    }

    @Nullable
    public static Couple<DbDiffElement> createElementsWithMultipleRoots(List<DbElement> fromRoots, List<DbElement> toRoots, DirDiffSettings settings) {
        DbElement fromE = fromRoots.get(0);
        DbElement toE = toRoots.get(0);
        DbElement fromRealParent = fromE.getParent();
        DbElement toRealParent = toE.getParent();
        if (fromRealParent == null || toRealParent == null) {
            return SchemaDiffAction.createElements(fromE, toE, settings);
        }
        Dbms fromDbms = DbImplUtilCore.getDbms(fromRealParent);
        Dbms toDbms = DbImplUtilCore.getDbms(toRealParent);
        DbDiffElement from = SchemaDiffAction.createElementWithMultipleRoots(settings, fromRealParent, fromRoots, toDbms);
        DbDiffElement to = SchemaDiffAction.createElementWithMultipleRoots(settings, toRealParent, toRoots, fromDbms);
        if (from == null || to == null) {
            return null;
        }
        return Couple.of((Object)((Object)from), (Object)((Object)to));
    }

    @Nullable
    public static DbDiffElement createElementWithMultipleRoots(DirDiffSettings settings, DbElement realRoot, List<DbElement> requestedElements, Dbms otherDbms) {
        BasicElement realRootBasicElement = SchemaDiffAction.getElement(realRoot);
        if (realRootBasicElement == null) {
            return null;
        }
        List requestedBasicElements = ContainerUtil.map(requestedElements, SchemaDiffAction::getElement);
        DbDiffRoot root = new DbDiffRoot(realRoot.getDataSource(), settings, otherDbms, requestedBasicElements);
        BasicModElement altElement = SchemaDiffAction.createAltElement(root.getAltModel(), realRootBasicElement);
        return altElement == null ? null : new DbDiffElement(root, realRootBasicElement, altElement);
    }

    public static BasicModElement createAltElement(@NotNull BasicModModel model, BasicElement e) {
        BasicMetaObject<?> meta;
        if (model == null) {
            SchemaDiffAction.$$$reportNull$$$0(19);
        }
        if ((meta = ((BasicMetaModel)model.getMetaModel()).findBestMetaObject(e.getMetaObject())) == null) {
            return null;
        }
        Ref res2 = Ref.create();
        model.modify(BasicModRoot.class, r -> {
            res2.set((Object)SchemaDiffAction.instantiate(r, meta));
            if (res2.isNull()) {
                BasicModMixinElement.dropChildren(r);
            }
        });
        return (BasicModElement)res2.get();
    }

    @Nullable
    private static BasicModElement instantiate(@NotNull BasicModElement o, @NotNull BasicMetaObject<?> meta) {
        if (o == null) {
            SchemaDiffAction.$$$reportNull$$$0(20);
        }
        if (meta == null) {
            SchemaDiffAction.$$$reportNull$$$0(21);
        }
        if (meta.kind == o.getKind()) {
            return o;
        }
        BasicMetaObject<?> p2 = meta.getParent();
        BasicModElement parent = p2 == null ? null : SchemaDiffAction.instantiate(o, p2);
        Family family = parent == null ? null : parent.familyOf(meta.kind);
        return family == null ? null : (BasicModElement)family.createNewOne();
    }

    @Nullable
    private static DbElement getSingleElement(AnActionEvent e) {
        PsiElement[] elements = (PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY);
        return elements != null && elements.length == 1 ? (DbElement)ObjectUtils.tryCast((Object)elements[0], DbElement.class) : null;
    }

    private static Couple<List<DbElement>> configuredMapping(DbDataSource dataSource) {
        String uniqueId = dataSource.getUniqueId();
        DdlMapping mapping = (DdlMapping)DdlMappingsManager.getInstance(dataSource.getProject()).iterateMappings().filter(m -> m.getScope() != null && (m.isDataSourceId(uniqueId) || m.isDdlDataSourceId(uniqueId))).single();
        if (mapping == null) {
            return null;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance(dataSource.getProject());
        DbDataSource lds = facade.findDataSource(mapping.getDataSourceId());
        DbDataSource sqlDs = facade.findDataSource(mapping.getDdlDataSourceId());
        if (lds == null || sqlDs == null) {
            return null;
        }
        return SchemaDiffAction.configuredMapping(lds, sqlDs, mapping.getScope());
    }

    @NotNull
    private static Couple<List<DbElement>> configuredMapping(DbDataSource lds, DbDataSource sqlDs, TreePattern scope2) {
        JBIterable ldsRoot = SchemaDiffAction.toSingle(DbImplUtilCore.getNamespaces(lds, scope2));
        JBIterable sqlRoot = SchemaDiffAction.toSingle(DbImplUtilCore.getNamespaces(sqlDs, null));
        int d = SchemaDiffAction.getDepth((BasicNamespace)ldsRoot.first()) - SchemaDiffAction.getDepth((BasicNamespace)sqlRoot.first());
        if (d < 0) {
            sqlRoot = sqlRoot.map(r -> SchemaDiffAction.offset(r, -d));
        } else if (d > 0) {
            ldsRoot = ldsRoot.map(r -> SchemaDiffAction.offset(r, d));
        }
        JBIterable dbSqlRoot = sqlRoot.filterMap(r -> sqlDs.findElement((DasObject)r));
        JBIterable dbLdsRoot = ldsRoot.filterMap(r -> lds.findElement((DasObject)r));
        if (dbSqlRoot.isEmpty() || dbLdsRoot.isEmpty()) {
            Couple couple = Couple.of(Collections.singletonList(sqlDs), Collections.singletonList(lds));
            if (couple == null) {
                SchemaDiffAction.$$$reportNull$$$0(22);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)dbSqlRoot.toList(), (Object)dbLdsRoot.toList());
        if (couple == null) {
            SchemaDiffAction.$$$reportNull$$$0(23);
        }
        return couple;
    }

    @Nullable
    private static BasicNamespace offset(BasicNamespace root1, int d) {
        return (BasicNamespace)ObjectUtils.tryCast((Object)DasUtil.dasParents(root1).get(d), BasicNamespace.class);
    }

    @NotNull
    private static JBIterable<BasicNamespace> toSingle(@NotNull JBIterable<BasicNamespace> nsp) {
        if (nsp == null) {
            SchemaDiffAction.$$$reportNull$$$0(24);
        }
        if (nsp.isEmpty()) {
            JBIterable<BasicNamespace> jBIterable = nsp;
            if (jBIterable == null) {
                SchemaDiffAction.$$$reportNull$$$0(25);
            }
            return jBIterable;
        }
        JBIterable<BasicNamespace> aligned = SchemaDiffAction.alignDepth(nsp);
        return SchemaDiffAction.toSingleParentAligned(aligned);
    }

    @NotNull
    private static JBIterable<BasicNamespace> alignDepth(@NotNull JBIterable<BasicNamespace> nsp) {
        if (nsp == null) {
            SchemaDiffAction.$$$reportNull$$$0(26);
        }
        int d = (Integer)nsp.map(n -> SchemaDiffAction.getDepth(n)).reduce(Math::min);
        JBIterable jBIterable = nsp.filterMap(n -> SchemaDiffAction.offset(n, SchemaDiffAction.getDepth(n) - d)).collect(new LinkedHashSet());
        if (jBIterable == null) {
            SchemaDiffAction.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    private static int getDepth(BasicNamespace n) {
        return DasUtil.dasParents(n).size();
    }

    @NotNull
    private static JBIterable<BasicNamespace> toSingleParentAligned(@NotNull JBIterable<BasicNamespace> nsp) {
        if (nsp == null) {
            SchemaDiffAction.$$$reportNull$$$0(28);
        }
        if (nsp.isEmpty()) {
            JBIterable<BasicNamespace> jBIterable = nsp;
            if (jBIterable == null) {
                SchemaDiffAction.$$$reportNull$$$0(29);
            }
            return jBIterable;
        }
        JBIterable parents = nsp.map(BasicMixinIntrospectableArea::getParent).filter(BasicNamespace.class).collect(new LinkedHashSet());
        if (parents.take(2).size() > 1) {
            return SchemaDiffAction.toSingleParentAligned((JBIterable<BasicNamespace>)parents);
        }
        JBIterable<BasicNamespace> jBIterable = nsp;
        if (jBIterable == null) {
            SchemaDiffAction.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @Nullable
    private static Pair<DbElement, DbElement> alignElements(@Nullable DbElement e1, @Nullable DbElement e2) {
        block5: {
            DbElement same;
            if (e1 == null || e2 == null) {
                return null;
            }
            HashMap possible1 = new HashMap();
            HashMap possible2 = new HashMap();
            e1 = SchemaDiffAction.fillPossible(e1, o -> possible1.put(o.getKind(), o));
            e2 = SchemaDiffAction.fillPossible(e2, o -> possible2.put(o.getKind(), o));
            while ((same = (DbElement)possible2.get(e1.getKind())) == null) {
                DbElement p2 = e1.getParent();
                if (p2 != null && possible1.containsKey(p2.getKind())) {
                    e1 = p2;
                    continue;
                }
                break block5;
            }
            e2 = same;
        }
        if (e1.getKind() != e2.getKind()) {
            return null;
        }
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        return Pair.create((Object)e1, (Object)e2);
    }

    private static DbElement fillPossible(@NotNull DbElement el, @NotNull Consumer<DbElement> consumer) {
        if (el == null) {
            SchemaDiffAction.$$$reportNull$$$0(31);
        }
        if (consumer == null) {
            SchemaDiffAction.$$$reportNull$$$0(32);
        }
        if (DasUtil.getParentOfKind(el, ObjectKind.SCHEMA, true) == null) {
            DbElement tmp = el;
            while (tmp != null) {
                consumer.accept(tmp);
                el = tmp;
                tmp = tmp.getKind() == ObjectKind.SCHEMA ? null : (DbElement)tmp.getDasChildren(null).single();
            }
            return el;
        }
        consumer.accept(el);
        return el;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 24, 26, 28, 31, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "configuredMapping";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toSingle";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "alignDepth";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toSingleParentAligned";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementsPair";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSingleElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDbElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFamiliesPair";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithChooser";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showDiff2";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createAltElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toSingle";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "alignDepth";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toSingleParentAligned";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fillPossible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 24, 26, 28, 31, 32 -> new IllegalArgumentException(string);
        };
    }

    public static class Configured
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                Configured.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement s;
            Couple<List<DbElement>> elements;
            if (e == null) {
                Configured.$$$reportNull$$$0(1);
            }
            DbElement f = (elements = Configured.getConfiguredElements(e)) == null ? null : (DbElement)ContainerUtil.getFirstItem((List)((List)elements.first));
            DbElement dbElement = s = elements == null ? null : (DbElement)ContainerUtil.getFirstItem((List)((List)elements.second));
            if (elements != null && f != null && s != null) {
                DbDataSource ds = (DbDataSource)ObjectUtils.tryCast((Object)SchemaDiffAction.getSingleElement(e), DbDataSource.class);
                DbDataSource other = (f.getDataSource() == ds ? s : f).getDataSource();
                if (other.getDelegate() instanceof LocalDataSource) {
                    e.getPresentation().setText(DatabaseBundle.message("action.apply.mapped.to.text", other.getName()));
                } else {
                    e.getPresentation().setText(DatabaseBundle.message("action.apply.mapped.from.text", other.getName()));
                }
            }
            e.getPresentation().setEnabledAndVisible(elements != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Couple<List<DbElement>> elements;
            if (e == null) {
                Configured.$$$reportNull$$$0(2);
            }
            if ((elements = Configured.getConfiguredElements(e)) != null) {
                SchemaDiffAction.showDiff2((List)elements.first, (List)elements.second);
            }
        }

        @Nullable
        private static Couple<List<DbElement>> getConfiguredElements(AnActionEvent e) {
            PsiElement[] elements = (PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY);
            if (elements == null) {
                return null;
            }
            if (elements.length == 1 && elements[0] instanceof DbDataSource) {
                return SchemaDiffAction.configuredMapping((DbDataSource)elements[0]);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/diff/SchemaDiffAction$Configured";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/diff/SchemaDiffAction$Configured";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

