/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.DynamicBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectCommentEditor;
import com.intellij.database.view.editors.TableNameComboBox;
import com.intellij.database.view.editors.TableNameForm;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ImportTableNameForm
implements TableNameForm {
    private JLabel myTableNameLabel;
    private JPanel myCommentHolder;
    private JPanel myCommentPanel;
    private JLabel myCommentLabel;
    private EditorTextField myCommentField;
    private JPanel myPanel;
    private TableNameComboBox myTableNameComboBox;
    private final DatabaseEditorContext myInitialContext;
    private DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final Project myProject;
    private TableEditorModel myModel;
    private final Disposable myDisposable;

    public ImportTableNameForm(@NotNull DatabaseEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel model, @NotNull Disposable disposable) {
        if (context == null) {
            ImportTableNameForm.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            ImportTableNameForm.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ImportTableNameForm.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            ImportTableNameForm.$$$reportNull$$$0(3);
        }
        this.myInitialContext = context;
        this.myCaps = caps;
        this.myProject = context.getProject();
        this.myModel = model;
        this.myDisposable = disposable;
        this.$$$setupUI$$$();
        new ExpandableEditorSupport(this.myCommentField);
        this.createCommentButton(context);
        this.myTableNameLabel.setLabelFor((Component)this.myTableNameComboBox.getEditorTextField());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ImportTableNameForm.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    public void applyCaps() {
        this.myCommentHolder.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentHolder.getComponent(0).setEnabled(this.myCaps.getComment().isAvailable());
        this.myCommentPanel.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentLabel.setVisible(this.myCaps.getComment().isSupported());
        this.myTableNameComboBox.getEditorTextField().setEnabled(this.myCaps.getRename().isAvailable());
    }

    @Override
    @NotNull
    public EditorTextField getTableNameField() {
        EditorTextField editorTextField2 = this.myTableNameComboBox.getEditorTextField();
        if (editorTextField2 == null) {
            ImportTableNameForm.$$$reportNull$$$0(5);
        }
        return editorTextField2;
    }

    @Override
    @NotNull
    public JComponent getTableNameComponent() {
        TableNameComboBox tableNameComboBox = this.myTableNameComboBox;
        if (tableNameComboBox == null) {
            ImportTableNameForm.$$$reportNull$$$0(6);
        }
        return tableNameComboBox;
    }

    @Override
    @NotNull
    public EditorTextField getCommentField() {
        EditorTextField editorTextField2 = this.myCommentField;
        if (editorTextField2 == null) {
            ImportTableNameForm.$$$reportNull$$$0(7);
        }
        return editorTextField2;
    }

    private void createUIComponents() {
        this.myTableNameComboBox = new TableNameComboBox(this.myProject, Objects.requireNonNull((ImportEditorContext)ObjectUtils.tryCast((Object)this.myInitialContext, ImportEditorContext.class)), this.myDisposable);
    }

    public void update(@NotNull ImportEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel model) {
        if (context == null) {
            ImportTableNameForm.$$$reportNull$$$0(8);
        }
        if (caps == null) {
            ImportTableNameForm.$$$reportNull$$$0(9);
        }
        if (model == null) {
            ImportTableNameForm.$$$reportNull$$$0(10);
        }
        this.myTableNameComboBox.update(context);
        if (this.myCaps != caps) {
            this.myCaps = caps;
            this.applyCaps();
        }
        if (this.myModel != model) {
            this.myModel = model;
            this.createCommentButton(context);
        }
    }

    private void createCommentButton(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportTableNameForm.$$$reportNull$$$0(11);
        }
        JButton commentBtn = DatabaseObjectCommentEditor.createButton(context, this.myModel, (JComponent)this.myTableNameComboBox.getEditorTextField());
        this.myCommentHolder.removeAll();
        this.myCommentHolder.add((Component)commentBtn, "Center");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        EditorTextField editorTextField2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 1, 1, 3, null, new Dimension(470, -1), null));
        this.myCommentHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "East");
        this.myCommentField = editorTextField2 = new EditorTextField();
        jPanel2.add((Component)editorTextField2, "Center");
        this.myCommentLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", ImportTableNameForm.class).getString("DatabaseTableEditor.comment"));
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTableNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", ImportTableNameForm.class).getString("DatabaseTableEditor.table"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(95, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TableNameComboBox tableNameComboBox = this.myTableNameComboBox;
        jPanel3.add((Component)((Object)tableNameComboBox), new GridConstraints(1, 1, 1, 1, 0, 1, 1, 3, null, new Dimension(470, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/ImportTableNameForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/ImportTableNameForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableNameField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableNameComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCommentButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

