/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.SqlRoutineIndex;
import com.intellij.sql.SqlRoutineIndexKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.IsImpure;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myRoutineAnalyzer", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "myDmlAnalyzer", "Lcom/intellij/sql/psi/SqlDmlStatement;", "myDdlAnalyzer", "Lcom/intellij/sql/psi/SqlDdlStatement;", "mySideEffectsProducingAnalyzer", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "DmlAnalyzer", "DdlAnalyzer", "SideEffectsProducingAnalyzer", "RoutineFlowAnalyzer", "intellij.database.sql.core.impl"})
public final class SqlGeneralExecutionFlowAnalyzer
implements ExecutionFlowAnalyzer<PsiElement> {
    @NotNull
    private final ExecutionFlowAnalyzer<SqlFunctionCallExpression> myRoutineAnalyzer;
    @NotNull
    private final ExecutionFlowAnalyzer<SqlDmlStatement> myDmlAnalyzer;
    @NotNull
    private final ExecutionFlowAnalyzer<SqlDdlStatement> myDdlAnalyzer;
    @NotNull
    private final ExecutionFlowAnalyzer<PsiElement> mySideEffectsProducingAnalyzer;

    public SqlGeneralExecutionFlowAnalyzer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myRoutineAnalyzer = new RoutineFlowAnalyzer(project);
        this.myDmlAnalyzer = new DmlAnalyzer();
        this.myDdlAnalyzer = new DdlAnalyzer();
        this.mySideEffectsProducingAnalyzer = new SideEffectsProducingAnalyzer();
    }

    @NotNull
    public ExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element) {
        ExecutionFlowAnalyzer.Flow flow;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.myRoutineAnalyzer.isAcceptable(element)) {
            ExecutionFlowAnalyzer.Flow flow2 = this.myRoutineAnalyzer.analyze((PsiElement)((SqlFunctionCallExpression)element));
            flow = flow2;
            Intrinsics.checkNotNullExpressionValue((Object)flow2, (String)"analyze(...)");
        } else if (this.myDdlAnalyzer.isAcceptable(element)) {
            ExecutionFlowAnalyzer.Flow flow3 = this.myDdlAnalyzer.analyze((PsiElement)((SqlDdlStatement)element));
            flow = flow3;
            Intrinsics.checkNotNullExpressionValue((Object)flow3, (String)"analyze(...)");
        } else if (this.myDmlAnalyzer.isAcceptable(element)) {
            ExecutionFlowAnalyzer.Flow flow4 = this.myDmlAnalyzer.analyze((PsiElement)((SqlDmlStatement)element));
            flow = flow4;
            Intrinsics.checkNotNullExpressionValue((Object)flow4, (String)"analyze(...)");
        } else if (this.mySideEffectsProducingAnalyzer.isAcceptable(element)) {
            ExecutionFlowAnalyzer.Flow flow5 = this.mySideEffectsProducingAnalyzer.analyze(element);
            flow = flow5;
            Intrinsics.checkNotNullExpressionValue((Object)flow5, (String)"analyze(...)");
        } else {
            ExecutionFlowAnalyzer.Flow flow6 = ExecutionFlowAnalyzer.UnknownFlow;
            flow = flow6;
            Intrinsics.checkNotNullExpressionValue((Object)flow6, (String)"UnknownFlow");
        }
        return flow;
    }

    public boolean isAcceptable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.myRoutineAnalyzer.isAcceptable(element) || this.myDdlAnalyzer.isAcceptable(element) || this.myDmlAnalyzer.isAcceptable(element) || this.mySideEffectsProducingAnalyzer.isAcceptable(element);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DdlAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlDdlStatement;", "<init>", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "Lcom/intellij/psi/PsiElement;", "DdlFlow", "intellij.database.sql.core.impl"})
    private static final class DdlAnalyzer
    implements ExecutionFlowAnalyzer<SqlDdlStatement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull SqlDdlStatement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)DdlFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return e instanceof SqlDdlStatement;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0002H\u0005\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DdlAnalyzer$DdlFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "<init>", "()V", "transform", "T", "", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.core.impl"})
        public static final class DdlFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final DdlFlow INSTANCE = new DdlFlow();

            private DdlFlow() {
                super(ThreeState.NO);
            }

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.ddl();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DmlAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlDmlStatement;", "<init>", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "Lcom/intellij/psi/PsiElement;", "DmlFlow", "intellij.database.sql.core.impl"})
    private static final class DmlAnalyzer
    implements ExecutionFlowAnalyzer<SqlDmlStatement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull SqlDmlStatement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)DmlFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return e instanceof SqlDmlStatement;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0002H\u0005\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DmlAnalyzer$DmlFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "<init>", "()V", "transform", "T", "", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.core.impl"})
        public static final class DmlFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final DmlFlow INSTANCE = new DmlFlow();

            private DmlFlow() {
                super(ThreeState.NO);
            }

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.dml();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\t\u001a'\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "invalidateCache", "", "myCachedValues", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/psi/DbRoutine;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "myProject", "analyze", "call", "isAcceptable", "value", "Lcom/intellij/psi/PsiElement;", "FlowEvaluator", "RoutineFlow", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlGeneralExecutionFlowAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlGeneralExecutionFlowAnalyzer.kt\ncom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
    private static final class RoutineFlowAnalyzer
    implements ExecutionFlowAnalyzer<SqlFunctionCallExpression> {
        private volatile boolean invalidateCache;
        @NotNull
        private final ConcurrentMap<DbRoutine, ExecutionFlowAnalyzer.Flow> myCachedValues;
        @NotNull
        private final Project myProject;

        public RoutineFlowAnalyzer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap(...)");
            this.myCachedValues = concurrentMap;
            this.myProject = project;
            project.getMessageBus().connect().subscribe(SqlRoutineIndex.Companion.getTopic(), (Object)new SqlRoutineIndex.SqlRoutineIndexListener(){

                @Override
                public void built() {
                    invalidateCache = true;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull SqlFunctionCallExpression call) {
            ExecutionFlowAnalyzer.Flow flow;
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Object object = call.getNameElement();
            if (object == null || (object = SqlRoutineIndexKt.dbResolve((SqlReferenceExpression)object)) == null) {
                ExecutionFlowAnalyzer.Flow flow2 = ExecutionFlowAnalyzer.UnknownFlow;
                Intrinsics.checkNotNullExpressionValue((Object)flow2, (String)"UnknownFlow");
                return flow2;
            }
            Object routines = object;
            if (routines.isEmpty()) {
                ExecutionFlowAnalyzer.Flow flow3 = ExecutionFlowAnalyzer.UnknownFlow;
                Intrinsics.checkNotNullExpressionValue((Object)flow3, (String)"UnknownFlow");
                return flow3;
            }
            LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource(((DbRoutine)CollectionsKt.first((List)routines)).getDataSource());
            if (localDataSource == null) {
                ExecutionFlowAnalyzer.Flow flow4 = ExecutionFlowAnalyzer.UnknownFlow;
                Intrinsics.checkNotNullExpressionValue((Object)flow4, (String)"UnknownFlow");
                return flow4;
            }
            LocalDataSource dataSource = localDataSource;
            RoutineFlowAnalyzer routineFlowAnalyzer = this;
            synchronized (routineFlowAnalyzer) {
                boolean bl = false;
                flow = new FlowEvaluator(this.myProject, (List<? extends DbRoutine>)routines, (SqlElement)call, dataSource).evaluate();
            }
            return flow;
        }

        public boolean isAcceptable(@NotNull PsiElement value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof SqlFunctionCallExpression;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00122\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$FlowEvaluator;", "", "project", "Lcom/intellij/openapi/project/Project;", "routines", "", "Lcom/intellij/database/psi/DbRoutine;", "context", "Lcom/intellij/sql/psi/SqlElement;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "<init>", "(Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/sql/psi/SqlElement;Lcom/intellij/database/dataSource/LocalDataSource;)V", "myDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "myVisited", "Lit/unimi/dsi/fastutil/objects/ReferenceOpenHashSet;", "evaluate", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "analyze", "analyzeRoutine", "routine", "analyzeValue", "value", "Lcom/intellij/sql/SqlRoutineIndex$Value;", "mergeFlows", "flows", "intellij.database.sql.core.impl"})
        @SourceDebugExtension(value={"SMAP\nSqlGeneralExecutionFlowAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlGeneralExecutionFlowAnalyzer.kt\ncom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$FlowEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1611#2,9:186\n1863#2:195\n1864#2:197\n1620#2:198\n1557#2:199\n1628#2,3:200\n1734#2,3:203\n1734#2,3:206\n1#3:196\n*S KotlinDebug\n*F\n+ 1 SqlGeneralExecutionFlowAnalyzer.kt\ncom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$FlowEvaluator\n*L\n125#1:186,9\n125#1:195\n125#1:197\n125#1:198\n141#1:199\n141#1:200,3\n165#1:203,3\n166#1:206,3\n125#1:196\n*E\n"})
        private final class FlowEvaluator {
            @NotNull
            private final Project project;
            @NotNull
            private final List<DbRoutine> routines;
            @NotNull
            private final SqlElement context;
            @NotNull
            private final SqlLanguageDialect myDialect;
            @NotNull
            private final ReferenceOpenHashSet<DbRoutine> myVisited;

            public FlowEvaluator(@NotNull Project project, @NotNull List<? extends DbRoutine> routines, @NotNull SqlElement context, LocalDataSource dataSource) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(routines, (String)"routines");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                this.project = project;
                this.routines = routines;
                this.context = context;
                SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(dataSource);
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
                this.myDialect = sqlLanguageDialect;
                this.myVisited = new ReferenceOpenHashSet();
            }

            @NotNull
            public final ExecutionFlowAnalyzer.Flow evaluate() {
                if (RoutineFlowAnalyzer.this.invalidateCache) {
                    RoutineFlowAnalyzer.this.myCachedValues.clear();
                    RoutineFlowAnalyzer.this.invalidateCache = false;
                }
                Object object = ReadAction.compute(() -> FlowEvaluator.evaluate$lambda$0(this));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                return (ExecutionFlowAnalyzer.Flow)object;
            }

            /*
             * WARNING - void declaration
             */
            private final ExecutionFlowAnalyzer.Flow analyze(List<? extends DbRoutine> routines) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = routines;
                FlowEvaluator flowEvaluator = this;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ExecutionFlowAnalyzer.Flow it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    DbRoutine it = (DbRoutine)element$iv$iv;
                    boolean bl2 = false;
                    if (this.analyzeRoutine(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return flowEvaluator.mergeFlows((List)destination$iv$iv);
            }

            /*
             * WARNING - void declaration
             */
            private final ExecutionFlowAnalyzer.Flow analyzeRoutine(DbRoutine routine2) {
                ExecutionFlowAnalyzer.Flow flow;
                ExecutionFlowAnalyzer.Flow cached;
                ExecutionFlowAnalyzer.Flow flow2 = cached = (ExecutionFlowAnalyzer.Flow)RoutineFlowAnalyzer.this.myCachedValues.get(routine2);
                if (flow2 != null) {
                    return flow2;
                }
                if (this.myVisited.contains((Object)routine2)) {
                    return null;
                }
                this.myVisited.add((Object)routine2);
                ObjectPath path = ObjectPaths.of(routine2, routine2.getDataSource().getModel());
                Object object = DbImplUtilCore.getMaybeLocalDataSource(routine2.getDataSource());
                if (object == null || (object = ((AbstractDataSource)object).getUniqueId()) == null) {
                    return null;
                }
                Object dataSource = object;
                Intrinsics.checkNotNull((Object)path);
                List<SqlRoutineIndex.Value> values = SqlRoutineIndexKt.getValues(new SqlRoutineIndex.IdentifiablePath((String)dataSource, path), this.project);
                if (values.isEmpty()) {
                    flow = RoutineFlow.PURE;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = values;
                    FlowEvaluator flowEvaluator = this;
                    boolean $i$f$map = false;
                    void var9_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        SqlRoutineIndex.Value value = (SqlRoutineIndex.Value)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.analyzeValue((SqlRoutineIndex.Value)it));
                    }
                    flow = flowEvaluator.mergeFlows((List)destination$iv$iv);
                }
                ExecutionFlowAnalyzer.Flow flow3 = flow;
                ((Map)RoutineFlowAnalyzer.this.myCachedValues).put(routine2, flow3);
                return flow3;
            }

            private final ExecutionFlowAnalyzer.Flow analyzeValue(SqlRoutineIndex.Value value) {
                if (!value.getPure()) {
                    return RoutineFlow.NOT_PURE;
                }
                if (value.getCalls().length == 0) {
                    return RoutineFlow.PURE;
                }
                for (SqlRoutineIndex.Call call : value.getCalls()) {
                    List<DbRoutine> resolved;
                    if (SqlRoutineIndexKt.dbResolve(call, (PsiElement)this.context, this.myDialect) == null) continue;
                    if (resolved.isEmpty()) {
                        return RoutineFlow.UNSURE;
                    }
                    ExecutionFlowAnalyzer.Flow result2 = this.analyze(resolved);
                    if (result2.isPure() != ThreeState.NO && result2.isPure() != ThreeState.UNSURE) continue;
                    return result2;
                }
                return RoutineFlow.PURE;
            }

            private final ExecutionFlowAnalyzer.Flow mergeFlows(List<? extends ExecutionFlowAnalyzer.Flow> flows) {
                ExecutionFlowAnalyzer.Flow flow;
                ExecutionFlowAnalyzer.Flow it;
                boolean bl;
                boolean $i$f$all;
                Iterable $this$all$iv;
                block8: {
                    $this$all$iv = flows;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (ExecutionFlowAnalyzer.Flow)element$iv;
                            boolean bl2 = false;
                            if (it.isPure() == ThreeState.YES) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    flow = RoutineFlow.PURE;
                } else {
                    boolean bl3;
                    block9: {
                        $this$all$iv = flows;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (ExecutionFlowAnalyzer.Flow)element$iv;
                                boolean bl4 = false;
                                if (it.isPure() == ThreeState.NO) continue;
                                bl3 = false;
                                break block9;
                            }
                            bl3 = true;
                        }
                    }
                    flow = bl3 ? (ExecutionFlowAnalyzer.Flow)RoutineFlow.NOT_PURE : (ExecutionFlowAnalyzer.Flow)RoutineFlow.UNSURE;
                }
                return flow;
            }

            private static final ExecutionFlowAnalyzer.Flow evaluate$lambda$0(FlowEvaluator this$0) {
                return this$0.analyze(this$0.routines);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0004H\u0016J'\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$RoutineFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "", "pure", "Lcom/intellij/util/ThreeState;", "<init>", "(Ljava/lang/String;ILcom/intellij/util/ThreeState;)V", "PURE", "NOT_PURE", "UNSURE", "isPure", "transform", "T", "", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.core.impl"})
        private static final class RoutineFlow
        extends Enum<RoutineFlow>
        implements ExecutionFlowAnalyzer.Flow {
            @NotNull
            private final ThreeState pure;
            public static final /* enum */ RoutineFlow PURE = new RoutineFlow(ThreeState.YES);
            public static final /* enum */ RoutineFlow NOT_PURE = new RoutineFlow(ThreeState.NO);
            public static final /* enum */ RoutineFlow UNSURE = new RoutineFlow(ThreeState.UNSURE);
            private static final /* synthetic */ RoutineFlow[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private RoutineFlow(ThreeState pure) {
                this.pure = pure;
            }

            @NotNull
            public ThreeState isPure() {
                return this.pure;
            }

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.routine();
            }

            public static RoutineFlow[] values() {
                return (RoutineFlow[])$VALUES.clone();
            }

            public static RoutineFlow valueOf(String value) {
                return Enum.valueOf(RoutineFlow.class, value);
            }

            @NotNull
            public static EnumEntries<RoutineFlow> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = routineFlowArray = new RoutineFlow[]{RoutineFlow.PURE, RoutineFlow.NOT_PURE, RoutineFlow.UNSURE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SideEffectsProducingAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "CommonFlow", "intellij.database.sql.core.impl"})
    private static final class SideEffectsProducingAnalyzer
    implements ExecutionFlowAnalyzer<PsiElement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)CommonFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IElementType type = PsiUtilBase.getElementType((PsiElement)e);
            return type instanceof IsImpure;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0002H\u0005\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SideEffectsProducingAnalyzer$CommonFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "<init>", "()V", "transform", "T", "", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.core.impl"})
        public static final class CommonFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final CommonFlow INSTANCE = new CommonFlow();

            private CommonFlow() {
                super(ThreeState.NO);
            }

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.common();
            }
        }
    }
}

